{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit SaveScre;
INTERFACE
Uses Dos,Crt,MemUse,Video,StrType,progVars,Memory,

MiscProc;


Procedure SaveVideotoMemory( WhatMem : Byte );
Procedure SaveDataToDisk( FileName : Byte; DataPointer : pMemData);
Procedure ReadDataFromDisk( FileName : Byte; Var Datapointer : pMemData );

IMPLEMENTATION

{ **************************************************************************
  In dieser Include-Datei sind die Typendeklarationen, Funktionen und Prozeduren
  aufgelistet, die mit der Sicherung von Daten des "gecapturten" Rechners
  zu tun haben
  ************************************************************************** }

Procedure SaveDataToDisk( FileName : Byte; DataPointer : pMemData);
{ ************************************************************************** }
{ Diese Prozedur speichert die kompletten Maschienendaten in eine temporrere
  Datei auf der Festplatte. Dabei zeigt "DataPointer" auf eine Struktur ber
  der Informationen ber die Daten. Dabei heisst :
  NIL -> Daten mssen durch die Prozedur selber erlangt werden.
  DataPointer^ + 0 Bytes = "1" -> in EMS
  DataPointer^ + 0 Bytes = "2" -> in XMS
  DataPointer^ + 0 Bytes = "3" -> im konventionellen Speicher.
  In allen drei letzteren Fllen sind weitere Informationen in der durch
  "DataPointer^" angegeben Struktur enthalten. }
{ ************************************************************************** }
Var
  ProcessContinue : TVideoProcess;
      HelpPointer : pByte;
      TempPointer : pByte;
            Tmppt : pMemData;
         TempFile : File;
Lauf1,Lauf2,Lauf3 : Word;
     BytestoWrite : Word;
         SwapByte : Byte;

Begin
 If FileName = 1 then Assign(TempFile,TempScrnFileName) else
 If FileName = 2 then Assign(TempFile,TempMenFileName);
 Rewrite(TempFile,1);

 If DataPointer = NIL then      { Die Daten auslesen und auf der Festplatte sichern ... }
  Begin
   GetMem(TempPointer,SizeOf(tInterruptedMachiene));
   With pInterruptedMachiene(Temppointer)^ do
    Begin
     VideoMode := GetVideoMode;
     If ((VideoMode = $13) and IsModifyedMode13) then VideoMode := $09;
     If IsVesaMode(VideoMode) then
      Begin
       OldWindow1 := GetWindow(1);
       OldWindow2 := GetWindow(2);
      End;

         CurWord := GetCurSorPos;
    OldScanStart := GetStartScanLine;
     OldScanStop := GetStopScanLine;

{}
     If IsTextMode then
      Begin
       GetVGARegistersForTextMode(ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning,CrtBytes);
       SetMaxTransMitSizeForMode(GetVideoMode);
       SavedBytes := GetMaxTransmitSize(GetVideoMode);
      End;
    End;

   BlockWrite(TempFile,Temppointer^,SizeOf(tInterruptedMachiene));
   FreeMem(TempPointer,SizeOf(tInterruptedMachiene));
    { Der Header wurde nun geschrieben. Jetzt kommen die Daten. }
   GetMem(TempPointer,1024);
   HelpPointer := Temppointer;                   { Zeiger auf ein Byte hinter den beginn der Daten erstellen }
   Inc(HelpPointer);

   For Lauf3 := 1 to 3 do
    Begin
     With ProcessContinue do                       { Die Struktur fr das Eintragen der Video-Verwaltung initialisieren }
      Begin
       ReturnBytes := 1023;
       VioMode := GetVideoMode;
       TransMitted := 0;
      End;
     Lauf1 := 1;
     While Lauf1 > 0 do
      Begin                                        { In 1024 Byte-Blcken den Bildschirm abspeichern }
       Lauf1 := GetProcs[Lauf3](@ProcessContinue,HelpPointer,BytesToWrite);
       TempPointer^ := Lauf3;                      { In Lauf3 ist der Typ des Inhaltes angegeben. }

       If (Lauf3 = 1) or (Lauf3 = 2) or ((Lauf3 = 3) and TransferCharset) then
        Begin
         BlockWrite(TempFile,TempPointer^,1024,Lauf2);     { Immer 1KB-Blcke schreiben }
        End;

      End;
    End;
   FreeMem(Temppointer,1024);
  End
 Else
  Begin
   Tmppt := DataPointer;
   Lauf1 := 0;
   While Tmppt <> NIL do
    Begin
     If tmppt^.Size > Lauf1 then Lauf1 := Tmppt^.Size; { Das grsste Element in der Kette ermitteln }
     Tmppt := Tmppt^.pNext;
    End;

   GetMem(TempPointer,Lauf1);                    { ... und den Speicher fr eben dieses Element belegen }
   Tmppt := DataPointer;

   While Tmppt <> NIL do
    Begin
     CopyUppertoRam[DataPointer^.MemType](TempPointer,Tmppt^.HandleForBoth,Tmppt^.Size);

     Case Tmppt^.DataType of
    DATATYPE_CHARSET,
    DATATYPE_PALETTE,
    DATATYPE_VIDEO   : Begin

                        If Tmppt^.Size mod 1023 = 0 then { Feststellen, wieviele Blcke ich denn nun brauche }
                         Lauf3 := Tmppt^.Size div 1023 else
                         Lauf3 := (Tmppt^.Size div 1023) + 1;
                         HelpPointer := TempPointer;
                         { Das erste Element bentigt eine kleine "Sonderbehandelung", da ein Byte vornagestellt werden mu }
                         { (Das spezial-Block-Info-byte), und dieses kann ich ja nicht einfach vor den Datenblock stellen, }
                         { Da ich ja diesen Speicher nicht explizit belegt habe, (We weiss was da ist ...) }

                         SwapByte := Tmppt^.DataType;
                         BlockWrite(TempFile,SwapByte,1); { Nun ein trauriges Byte schreiben ... }
                         BlockWrite(TempFile,HelpPointer^,1023);

                         Inc(HelpPointer,1022);
                         If Lauf2 <> Lauf3 - 1 then
                          Begin { Wenn nun noch Blcke brig sind ... }
                           For Lauf2 := 1 to Lauf3-1 do
                            Begin
                             SwapByte := HelpPointer^; { Hilfe ! Dieses Byte wird gleich gekillt ! }
                             HelpPointer^ := Tmppt^.Datatype; { Gleich schreibe ich einen 1024-Byte-Block }
                             BlockWrite(TempFile,HelpPointer^,1024); { Und wech ... (Ein KB geht schneller ...) }
                             HelpPointer^ := SwapByte;  { Das berschriebene Byte wiederherstellen }
                             Inc(HelpPointer,1023);
                            End;
                         End;
                       End;

       DATATYPE_MISC : Begin { Dieser Block kommt immer als erstes in einer Datei }
                        Seek(TempFile,0);        { Es kommt immer als erstes ... }
                        BlockWrite(TempFile,Temppointer^,Tmppt^.Size); { Und ganz herein ... }
                        { Dieser Block ist immer spezifiziert gross und steht immer an erster Stelle in der Datei }
                       End;
     End;
     Tmppt := Tmppt^.pNext;
    End;
   FreeMem(Temppointer,Lauf1);       { Das erste Element ist immer auch das grsste ... }
   KillMemBlocks(SavedVideoInMem);
  End;
 Close(TempFile);
 DataSavedToDisk := TRUE;
End;

Procedure ReadDataFromDisk( FileName : Byte; Var Datapointer : pMemData );
Var
 ProcessContinues : Array[1.. 3] of tVideoProcess;
     TempPointer : pByte;
     Helppointer : PByte;
        TempFile : File;
     Lauf1,Lauf2 : Word;
    BytestoWrite : Word;
           Tmppt : pMemData;
{ **************************************************************************
 Fehler :
 15.04.1996 : Fehler gefunden. Habe blderweise "REWRITE" anstatt "RESET"
              geschrieben. Lief natrlich nich.
 25.05.1996 : Fehler gefunden. Ich habe den Videomodus aus der Dateiinformation
              ausgelesen, nachdem ich den Speicher freigegeben und neu allokiert
              hatte. Naja. Wohl ein wenig scheisse.
  ************************************************************************** }
Begin
 If DataSavedToDisk = TRUE then
  Begin { Sind die Daten bereits auf die Festplatte gesichert ? }

   If FileName = 1 then Assign(TempFile,TempScrnFileName) else
   If FileName = 2 then Assign(TempFile,TempMenFileName);
   Reset(TempFile,1);


   GetMem(TempPointer,SizeOf(tInterruptedMachiene));

   With pInterruptedMachiene(Temppointer)^ do
    Begin
     BlockRead(TempFile,Temppointer^,SizeOf(tInterruptedMachiene),Lauf1);
     SetVideoMode(VideoMode,CLEAR);

     SetCurSorPos(CurWord);

     ModifyCursor(OldScanStart,OldScanStop);


     If IsVesaMode(VideoMode) then
      Begin
       OldWindow1 := GetWindow(1);
       OldWindow2 := GetWindow(2);
      End;

      For Lauf1 := 1 to 3 do
       Begin
        With ProcessContinues[Lauf1] do
         Begin
          ReturnBytes := 1023;
          VioMode := pInterruptedMachiene(Temppointer)^.VideoMode;
          TransMitted := 0;
         End;
       End;

     If IstextMode then
      Begin
       MAX_TRANSMIT[ProcessContinues[1].VioMode] := SavedBytes;
       SetVgaRegistersForTextMode(ModeControl,MiscOutReg,ClockingModeReg,HorizontalPelPanning,CrtBytes);
      End;
    End;

   FreeMem(TempPointer,SizeOf(tInterruptedMachiene));

   { Nun an das erste Datenbyte springen ... }
   Seek(TempFile,SizeOf(tInterruptedMachiene));

   GetMem(TempPointer,1024);

   HelpPointer := TempPointer;
   Inc(HelpPointer);
   {$I-}

   Repeat
    BlockRead(TempFile,Temppointer^,1024,Lauf1);

    If Lauf1 = 1024 then { Huch ! kein Fehler ! }
      PutProcs[TempPointer^](@ProcessContinues[TempPointer^],Helppointer);
   Until (Lauf1 <> 1024);

   FreeMem(Temppointer,1024);
   Close(TempFile);
   DataSavedToDisk := FALSE;
  End
 Else { Noch sind sie im Speicher ... (und von dort wieder zurcklesen) }
  Begin
   Tmppt := DataPointer;
   Lauf1 := 0;
   While Tmppt <> NIL do
    Begin
     If tmppt^.Size > Lauf1 then Lauf1 := Tmppt^.Size; { Das grsste Element in der Kette ermitteln }
     Tmppt := Tmppt^.pNext;
    End;

   Tmppt := DataPointer;
   GetMem(Temppointer,Lauf1);

   While Tmppt <> NIL do
    Begin
     COpyUpperToRam[DataPointer^.MemType](TempPointer,Tmppt^.HandleForBoth,Tmppt^.Size);

     Case Tmppt^.DataType of
          DATATYPE_MISC : Begin
                           With pInterruptedMachiene(Temppointer)^ do
                            Begin
                             SetVideoMode(VideoMode,CLEAR);
                             SetCurSorPos(CurWord);
                             ModifyCursor(OldScanStart,OldScanStop);
                             If IsTextMode then
                              Begin
                               MAX_TRANSMIT[ProcessContinues[1].VioMode] := SavedBytes;
                              SetVgaRegistersForTextMode(ModeControl,MiscOutReg,ClockingModeReg,HorizontalPelPanning,CrtBytes);
                              End;
                            End;
                           For Lauf2 := 1 to 3 do
                            With ProcessContinues[Lauf2] do
                             Begin
                              ReturnBytes := 1024;
                              VioMode := pInterruptedMachiene(Temppointer)^.VideoMode;
                              TransMitted := 0;
                             End;
                          End;
       DATATYPE_PALETTE,
         DATATYPE_VIDEO,
       DATATYPE_CHARSET : Begin
                           With ProcessContinues[Tmppt^.DataType] do
                            Begin
                             ReturnBytes := Tmppt^.Size;
                            End;
                           PutProcs[Tmppt^.DataType](@ProcessContinues[Tmppt^.DataType],TempPointer);
                          End;
                End;
     Tmppt := Tmppt^.pNext;
    End;
   FreeMeM(temppointer,Lauf1);
  End;
End;


Procedure SaveVideotoMemory( WhatMem : Byte );
Var
   Lauf3,  Lauf1 : Word;
           Lauf2 : LongInt;
     TempPointer : Pointer;                      { Zeiger auf die kopierten Daten }
       MyProcess : tVideoProcess;                { Der Video-Prozess }
    BytestoWrite : Word;
  TempMemPointer : pMemData;

Begin
 { ************************************************************************* }
 { In der oberen Zeile birgt sich velleicht bald eine Fehlerquelle.          }
 { Ich sollte noch darauf aufpassen, ob der Zeiger in "Saved..." auch "NIL" ist. }
 { Ist dem nicht so, so mu vorher aber SEHR gravierend etwas falschgelaufen }
 { sein, da der Inhalt nicht zurckgespeichert (auf die Platte) wurde ... }

 SavedVideoInMem := AppendMemItem(NIL);
 TempMemPointer := SavedVideoInMem;
 TempMemPointer^.MemType := WhatMem;
 TempMemPointer^.DataType := DATATYPE_MISC;
 TempMemPointer^.Size := SizeOf(tInterruptedMachiene);

 If GetUpperMem[WhatMem](TempMemPointer^.HandleForBoth,SizeOf(tInterruptedMachiene)) = 0 then
  Begin
   GetMem(TempPointer,SizeOf(tInterruptedMachiene));
   With pInterruptedMachiene(TempPointer)^ do
    Begin
     VideoMode := GetVideoMode;
     Delay(10);

     if IsVesaMode(VideoMode) then
      Begin
       OldWindow1 := GetWindow(1);
       OldWindow2 := GetWindow(2);
      End;

    OldScanStart := GetStartScanLine;
     OldScanStop := GetStopScanLine;
         CurWord := GetCurSorPos;

     If IsTextMode then
      Begin
       GetVGARegistersForTextMode(ModeControl, MiscOutReg,ClockingModeReg,HorizontalPelPanning,CrtBytes);
       SetMaxTransMitSizeForMode(GetVideoMode);
       SavedBytes := GetMaxTransmitSize(GetVideoMode);
      End;

    End;

   CopyRamToUpper[WhatMem](TempPointer,TempMemPointer^.HandleForBoth,SizeOf(tInterruptedMachiene));
   FreeMem(temppointer,SizeOf(tInterruptedMachiene));
  End;

 Lauf1 := Max_Transmit[GetVideoMode];            { Die Anazhl der zu sicherden Bytes ermitteln }
 Lauf2 := MaxAvail div 1024 * 1024;              { Die Anzahl der 1024-Byte-Blcke ermitteln, die ich max. im }
                                                 { Speicher haben kann. }
 GetMem(TempPointer,Lauf2);                      { Den Speicher belegen }

 For Lauf3 := 1 to 3 do
  Begin
   With MyProcess do
    Begin
     ReturnBytes := Lauf2;
         VioMode := GetVideoMode;
     Transmitted := 0;
    End;

   Lauf1 := 1;
   While Lauf1 > 0 do
    Begin
     TempMemPointer := AppendMemItem(TempMemPointer);

     Lauf1 := GetProcs[Lauf3](@MyProcess,TempPointer,BytestoWrite);

     TempMemPointer^.Size := BytestoWrite;
     TempMemPointer^.MemType := WhatMem;
     TempMemPointer^.DataType := Lauf3;

     If GetUpperMem[WhatMem](TempMemPointer^.HandleForBoth,BytestoWrite) = 0 Then
       CopyRamToUpper[WhatMem](TempPointer,TempMemPointer^.HandleForBoth,BytesToWrite);
    End;
  End;

 FreeMem(TempPointer,Lauf2);
   VideoIsToSave := TRUE;
 DataSavedToDisk := FAlSE;
End;



End.