{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
 {$F+}



PROCEDURE TimerInterruptForSpeechLab; Interrupt;
Var
 TempBuffer : Byte;
 Writing : Boolean;
 TempWord : Word;
Begin
 If (Snd_CurrentJob = SND_Playing) or (Snd_CurrentJob = SND_PlayRecord) then
  Begin
   If UsedBlock[CurrBlock] then
    Begin
     { Eine Dmpfung einbauen }
{     If (OldPlyByte - PlyBytePtr^) < -5 then PlyBytePtr^ := OldPlyByte + 5;
     If (OldPlyByte - PlyBytePtr^) > 5 then PlyBytePtr^ := OldPlyByte - 5; }


     WriteDirect(PlyBytePtr^);
     OldPlyByte := PlyBytePtr^;

     If Snd_CurrentJob = Snd_PlayRecord then
      Begin
       TempWord := ReadDirect;
       Inc(TempWord,PlyBytePtr^);
       PlyBytePtr^ := TempWord shr 1;
      End;

     IF PlyInBlockPosition = SizeData - 1 THEN                  { Datenblock abgespielt? (-1, da letztes Byte immer = 0) }
      Begin
       UsedBlock[CurrBlock] := FALSE;
       If CurrBlock = MaxBlock then CurrBlock := 1 else Inc(CurrBlock);
       PLyBytePtr := @PlayDataBlocks[CurrBlock]^[1];
       PlyInBlockPosition := 0;
      End
     ELSE                                        { nein }
      BEGIN
       Inc(PlyInBlockPosition);                  { Zhler erhhen }
       Inc(LongInt(PlyBytePtr));                 { nchstes Byte holen (auch korrekt mit Segmentbertrag !) }
      END;
    End
   else
    Begin
     If CurrBlock = MaxBlock then CurrBlock := 1 else Inc(CurrBlock);
     PlyBytePtr := @PlayDataBlocks[CurrBlock]^[1];
     WriteDirect(128)
    End;
  End;

 Port[$20] := $20;                              { Interruptroutine beenden }
 If TimerCount > 0 then
  Begin
   Dec(TimerCount);
  End
 Else
  Begin
   TimerCount := TimerCountFrom;
   asm
    pushf
    call [TimerToCall]
   End;
  End;
END;


Procedure StopLabData;
Var
 Lauf1 : Word;
Begin
 If Snd_CurrentJob <> SND_None then
  Begin
   { *** Den Verwaltungsapperat zurcksetzen ******************************* }
   Snd_CurrentJob := SND_IDle;
   SetOrigFreq;             { Original-Frequenz fr den Timer einstellen }
   SetIntVec($08, TimerOld);                 { alte Timer-Routine setzen }
   Speaker_Off;                                       { Lautsprecher aus }

   Case Snd_CurrDest Of
    DST_NETBROADCAST : Begin
                       End;
             DST_HDD : Begin
                       End;
   End;

   Snd_CurrDest := DST_NONE;
  End;
{ *** Und den reservierten Speicher wieder freigeben *********************** }
 For Lauf1 := 1 to 4 do FreeMem(RecordDataBlocks[Lauf1],SizeOf(tByteArray));
 For Lauf1 := 1 to 4 do FreeMem(PlayDataBlocks[Lauf1],SizeOf(tByteArray));
End;

PROCEDURE StartLabData(Destination : Byte);
Var
 Lauf1 : Word;
BEGIN
 If Snd_CurrentJob = SND_IDLE then
  Begin
   { *** Und den Speicher nicht vergessen ... ****************************** }
   TimerToCall := OldInterrupts^.OldInt08;
   OldPlyByte := SoundNullByte;
   For Lauf1 := 1 to 4 do
    Begin
     GetMem(RecordDataBlocks[Lauf1],SizeOf(tByteArray));
     GetMem(PlayDataBlocks[Lauf1],SizeOf(tByteArray));
     FillChar(PLayDataBlocks[Lauf1]^,SizeOf(tByteArray),SoundNullByte);
    End;

   { *** Je nach Ziel der bertragung unterschiedliche Initialisierung ***** }
   Case Destination Of
    DST_NETBROADCAST : Begin
                       End;
             DST_HDD : Begin
                       End;
   End;
   { *** Wichtige Variablen initialisieren ********************************* }
   Snd_CurrDest := Destination;
   PlyBytePtr := @PlayDataBlocks[1]^[1];
   RecBytePtr := @RecordDataBlocks[1]^[1];
   RecInBlockPosition := 0;
   PlyInBlockPosition := 0;
   CurrentRecBuffer := 1;

   { *** Den DSP und die Verwaltung initialisieren ************************* }
   InitDSP;                                       { DSP initialisieren }
   Speaker_On;                                        { Lautsprecher ein }
   TimerCountFrom := STD_SAMPLEFREQ div 18;  { 18 -> Alte Frequenz ... }
   TimerCount := TimerCountFrom;
   GetIntVec($08, TimerOld);             { alten Timer-Interrupt sichern }
   SetIntVec($08, @TimerInterruptForSpeechLab );              { Timer-Interrupt umlenken }
   SetTimerFreq(STD_SAMPLEFREQ);                 { Timer-Frequenz einstellen }
   { Nun den Faktor berechnen, mit dem der alte Interrupt aufgerufen werden soll. }
  End
 Else
  Begin
   MessageBox(10,3,60,3,'Das Sound-System ist bereits aktiv !');
   Readkey;
  End;
END;


Procedure StartClientSpeechLab;
Const
  DisplayedCharCounter : Byte = 0;               { Aktuelles buntes Zeichen }
          MenuPosition : Byte = 1;               { Die aktuelle Menposition }

              WINDOW_Y = 2;

             WINDOW_X2 = 75;
          MAXMENUITEMS = 5;

      WIND_GRANULARITY = 4;                      { Die Anzahl an "DataBlockSize"-Blcken, die bei einer Bettigung der tasten}
      WIND_DELAY       = 10000;

              OUTWIN_X = 10;
              OutWin_Y = 7;
             OutWin_X2 = 60;
             OutWin_Y2 = 13;


Var
{     CurrentRecLabFile : File; }
     CurrentPlyLabFile : File;
         FilePositions : Array[1..MaxBlock] of LongInt;

   CurrentFilePosition : LongInt;
   MaximalFilePosition : LongInt;

              TempLong : LongiNt;
                 Lauf1 : Word;
                 Lauf2 : Word;
               SaveJob : Word;
               OldSptr : Pointer;
{ ************************************************************************** }
           MaximalFree : LongInt;
        CurrentWritten : LongInt;
{ ************************************************************************** }
              Eingabe : Char;

     CurrentWINDDELAY : Word;


{ *** Die Script-File-Funktionen *** }
Type
       tScriptCommand = Record
                     Command : Word;
                       Param : LongInt;
                          Ok : Boolean;
                        End;


Var
        SpeechFileName : tStr50;
            ScriptFile : Text;                   { Die Datei mit dem Script }
            AwnserFile : Text;                   { Die Datei mit den Schler-Antworten }

          CurrentInput : tStr50;                 { Die Aktuelle Eingabe }

        CurrentCommand : tScriptCommand;



      OutWinX, OutWinY : Word;                   { Die Position in meinem Ausgabefenster }
             OldX,OldY : Word;
{   OldWinMin,OldWinMax : Word; }

Const
                      CMD_NONE = 0;              { Nichts machen. }

             CMD_SETSPEECHFILE = 1;
                      CMD_SYNC = 2;              { Mit Sprachausgabe synchronisieren. }
              CMD_DISPLAYStart = 3;
                CMD_DisplayEnd = 4;
              CMD_ClearDisplay = 5;
              CMD_OpenTextFile = 6;
             Cmd_CloseTextFile = 7;
               CMD_WriteAwnser = 8;

                      CMD_WAIT = 1;              { "Param"-Timer-Ticks warten }

                   MaxCommands = 8;
 CommandNames : Array[1..MaxCommands] of tStr20 =
                ('SetSpeechFile=',               { Sprachdatei setzen }
                 'SyncSpeech=',                  { Script mit Sprache synchronisieren }
                 'DisplayNextLines',             { Die folgenden Zeilen darstellen, bis }
                 'EndDisplayNextLines',          { kommt. }
                 'ClearDisplay',                 { Lscht das Ausgabefenster }
                 'OpenTextFile=',                { ffnet die Antworten-Datei }
                 'CloseTextFile',               { Schliet die Antworten-Datei }
                 'WriteAwnser=');                { Schreibt eine Antwort in die Datei }



const
 RETURN=#13;
var
            NumberCharsInput : integer; {how many letters so far}
           CursorPosition    : byte; {where cursor is starting with 1}
          startx,starty      : Byte; {screen position of first letter
                                      in CurrentInput}
                       tempx : Byte;


Procedure InitScript;
Begin
 Assign(ScriptFile,'LABDATA.SRP');
 Reset(ScriptFile);
 CurrentCommand.Command := 0;
 OutWinX := 1;
 OutWinY := 1;
End;


Function GetEntry( EntryName : tStr50 ) : tStr50;
Var
 TempString : tStr50;
 Found : Boolean;
Begin
 Found := False;
 Reset(ScriptFile);
 EntryName := '' + Upper(StripBoth(EntryName));
 While Not(Eof(ScriptFile)) And Not(Found) do
  Begin
   Readln(ScriptFile,TempString);
   TempString := Upper(StripBoth(tempString));
   If TempString[1] <> '#' then
    Begin
     If Pos(EntryName,TempString) = 1 then
      Begin
       Found := True;
       Delete(TempString,1,Length(EntryName)+1);
       GetEntry := TempString;
      End Else TempString := '';
    End;
  End;
End;

Procedure SetWriteDisplay;
Begin

 Window(OutWin_X+1,OutWin_Y+1,OutWin_X2+OutWin_X-1,OutWin_Y2+OutWin_Y-1);
 GotoXY(OutWinX,OutWinY);
 CurSorOn;
End;

Procedure SetNormalDisplay;
Begin
{ CurSorOff; }
 OutWinX := WhereX;
 OutWinY := WhereY;
 Window(1,1,80,25);
 GotoXY(OutWin_X+OutWinX,OutWin_Y+OutWinY);
 If CurrentCommand.Command <> CMD_WriteAwnser then CurSorOff;
End;


Procedure NextCommand;
{ ************************************************************************** }
{ ***    Aufgabe : Einlesen und ausfhren des aktuellen Kommandos.       *** }
{ ***              Danach einlesen des nchsten.                         *** }
{ ***    Einagbe :  ---                                                  *** }
{ ***    Ausgabe :  ---                                                  *** }
{ *** nderungen :  ---                                                  *** }
{ ***    22.11.96 ->                                                     *** }
{ ************************************************************************** }


Var
            Lauf1 : Word;
            Lauf2 : Word;
 WriteFollowLines : Boolean;
        CommandOK : Boolean;
       TempString : tStr50;

Begin
 If CurrentCommand.Command = CMD_NONE then
  Begin
   CommandOK := FALSE;
   WriteFollowLines := FALSE;
   While Not(Eof(ScriptFile)) and Not(CommandOk) do
    Begin
     Readln(ScriptFile,TempString);
     If Not(WriteFollowLines) then
      Begin
       TempString := Upper(StripBoth(tempString));
       If TempString[1] = '' then
        Begin { Aha ! Ein Kommando ! }
         Delete(TempString,1,1);                   { Das Kommando-Escape lschen. }
         For Lauf1 := 1 to MaxCommands do          { Herausfinden, welches Kommando gemeint ist. }
          If Pos(Upper(CommandNames[Lauf1]),TempString) = 1 then
           Begin
            Delete(TempString,1,Length(CommandNames[Lauf1]));
            Case Lauf1 of
    CMD_SETSPEECHFILE : Begin
                         SpeechFileName := TempString;
                         Assign(CurrentPlyLabFile,SpeechFileName);
                         Reset(CurrentPlyLabFile,1);
                         CommandOK := True;
                        End;
             CMD_SYNC : Begin
                         CurrentCommand.Command := CMD_SYNC;
                         Val(TempString,Currentcommand.Param,Lauf2);
                         CommandOK := True;
                        End;
     CMD_DISPLAYStart : Begin
                         WriteFollowLines := TRUE;
                         SetWriteDisplay;
                        End;
    CMD_ClearDisplay :  Begin                    { Schirm lschen }
                         SetWriteDisplay;
                         ClrScr;
                         SetNormalDisplay;
                         CommandOK := true;
                        End;
     CMD_OPenTextFile : Begin
                         Assign(AwnserFile,TempString);
                         Rewrite(AwnserFile);
                        End;
    CMD_CloseTextFile : Begin
                         Close(AwnserFile);
                        End;
      Cmd_WriteAwnser : Begin
                         CurrentCommand.Command := Cmd_WriteAwnser;
                         Val(TempString,Currentcommand.Param,Lauf2);
                         CurrentInput := '';
                         CurrentCommand.Ok := FALSE;
                         CommandOK := True;
                         SetWriteDisplay;
                          NumberCharsInput := 0;

                         CursorPosition:=1;
                         Startx:=WhereX;
                         Starty:=WhereY;
                         GotoXY(StartX,StartY);

                         SetNormalDisplay;

                        End;
            End;
          If CommandOK then Lauf1 := MaxCommands;
         End
       End Else
         Begin
         End;
      End
     Else
      begin
       if StripBoth(Upper(TempString)) <> Upper('EndDisplayNextLines') then
        Begin
         GotoXY(OutWinX, OutWinY);
         Writeln(TempString);
         OutWinX := WhereX;
         OutWinY := WhereY;
        End
       Else
        Begin
         WriteFollowLines := FALSE;
         SetNormalDisplay;
        End;
      End;
    End;

   If Eof(ScriptFile) then
    Begin { Das Script ist zuende ! }
    End;
  End
 Else
  Begin
   Case CurrentCommand.Command of
        CMD_SYNC : If CurrentFilePosition >= CurrentCommand.Param then
                    Begin
                     CurrentCommand.Command := Cmd_None;
                    End;
  Cmd_WriteAwnser : Begin
                     If CurrentCommand.OK = True then
                      Begin { Die Antwort schreiben }
                       Writeln(AwnserFile,CurrentInPut);
                       CurrentCommand.Command := CMD_nOne;
                       CurSorOff;
                      End;
                    End;

   End;
  End;
End;

Procedure ReadScriptFile( Filename : tStr50 );
Begin
 Assign(ScriptFile,FileName);
 Reset(ScriptFile);
 SpeechFileName := GetEntry('MAINFILE');
End;

Procedure SyncronizeFileToPosition( Position : LongInt );
{ ************************************************************************** }
{ ***    Aufgabe : Neusynchronisation der Script-Datei mit der           *** }
{ ***              aktiven Sprachdatei.                                  *** }
{ ***    Einagbe :  ---                                                  *** }
{ ***    Ausgabe :  ---                                                  *** }
{ *** nderungen :  ---                                                  *** }
{ ***    22.11.96 ->                                                     *** }
{ ************************************************************************** }

Begin
End;


Procedure ReadInputForAwnser( Eingabe : Char ) ;
Begin
 SetWriteDisplay;
 Case Eingabe of
   #0 : begin
         Eingabe:=Readkey;
         Case  Eingabe of
          #75 : If (CursorPosition > 1) then
                 Begin     {cursor_left}
                  GotoXY(WhereX-1,WhereY);
                  Dec(CursorPosition);
                 end;
          #77 : If ((CursorPosition <= NumberCharsInput) and (CursorPosition < 50)) then
                 begin {cursor_right}
                  GotoXY(WhereX+1,WhereY);
                  Inc(CursorPosition);
                 end;
          #83 : If ((CursorPosition <= NumberCharsInput)and (CurrentInput<>'')) then
                 begin { delete}
                  Dec(NumberCharsInput);
                  Delete(CurrentInput,CurSorPosition,1);
                  Tempx:=Wherex;
                  Gotoxy(startx,starty);
                  Write(CurrentInput);
                  Write(' ');
                  Gotoxy(Tempx,Wherey);
                 end;

         end;
        end;
  #13 : Begin
         CurrentCommand.Ok := True;
        End;
  #27 : begin
         CurrentCommand.Ok := True;
        End;
   #8 : If CursorPosition>1 then
         begin
          Tempx:=Wherex;
          Gotoxy(startx,starty);

          Delete(CurrentInput,CurSorPosition-1,1);
          Dec(CurSorPOsition);
          Dec(NumberCharsInput);

          Write(CurrentInput);
          Write(' ');
          GotoXY(TempX-1,WhereY);
         End;
#32..'~',#128..#165:
         Begin
          If (Cursorposition < 50) then
           Begin
            TempX := WhereX;
            GotoXY(StartX,StartY);
{            Insert(Eingabe,CurrentInput,CurSorPosition);}
            Write(CurrentInput);
            Inc(CurSorPosition);
            Inc(NumberCharsInput);
            GotoXY(TempX+1,WhereY);
           End;
         End;

       end{case Eingabe};
 SetNormalDisplay;
End;

  Procedure WriteNiceActiveationDisplay;
  Begin
   Inc(DisplayedCharCounter); If DisplayedCharCounter = 9 then DisplayedCharCounter := 1;
   GotoXY(71,3);
   Case DisplayedCharCounter of
      2 : Write('');
      4 : Write('/');
      6 : Write('');
      8 : Write('\');
   End;
  End;

Const
   Men_STOP = 1;
     Men_FB = 2;
   Men_PLay = 3;
    Men_FWD = 4;
    Men_Rec = 5;



  XPosition_CurrentPos = 18;
  YPosition_CurrentPos = 4;
  XPosition_MaximalPos = 29;
  YPosition_MaximalPos = 4;


  {$I SR_SUPPM}                                  { *** Die Support-Routinen fr das Men }

Begin

 If Snd_CurrentJob = SND_IDLE then
  Begin
   CurSorOff;
   For lauf1 := 1 to Maxblock do FilePositions[Lauf1] := $FFFFFFFF;
   GotoXY(1,1);
   OldSptr := Sptr;
   CurrentWindDelay := 0;
   SaveScreen;
   CurrentFilePosition := 0;
   PaintBoxShadow(5,2,WINDOW_X2,23);                      { Einen Kasten malen }
   GotoXY(15,3); Write('SPRACHLABOR (C) 1996 by Daniel von Dincklage');
   GotoXy(70,3); Write('(*)');
    GotoXY(7,4); Write('Position : ');

   {*** Das Fenster mit den Ausgaben ***}
   PaintBox(OUTWIN_X,OutWin_Y,OutWin_X2+OutWin_X,OutWin_Y2+OutWin_Y);

   MaximalFree := DiskFree(0);                  { Variablen initialisieren }
   CurrentWritten := 0;
   Eingabe := #255;



{   Assign(CurrentRecLabFile,'LABFILE.SPC');
   Rewrite(CurrentRecLabFile,1); }
   InitScript;
   NextCommand;

   MaximalFilePosition := FileSize(CurrentPlyLabFile);
   GOtoXY(XPosition_CurrentPos,YPosition_CurrentPos);
   Write(CurrentFilePosition:10,'/',MaximalFilePosition);

   StartLabData(DST_HDD);
   Snd_CurrDest := DST_HDD;
   PaintMenu;

   ClearKBDBuffer;                               { Den Tastatur-Puffer lschen, da sonst Probleme }

   Repeat
    If (Snd_CurrentJob = SND_Playing) or (Snd_CurrentJob = SND_PlayRecord) then
     Begin
      CurrentFilePosition := FilePos(CurrentPLyLabFile);

      For Lauf1 := 1 to MaxBlock do
       Begin
        If UsedBlock[Lauf1] = FALSE then
         BEgin
          If (CurrentFilePosition < MaximalFilePosition) then
           Begin
            If (FilePositions[Lauf1] <> $FFFFFFFF) and (Snd_CurrentJob = Snd_PlayRecord) then
             Begin
              CurrentFilePosition := FilePos(CurrentPlyLabFile);
              WriteNiceActiveationDisplay;                 { Diesen netten "tanzenden" Balken produzieren. }
              Seek(CurrentPlyLabFile,FilePositions[Lauf1]);
              BlockWrite(CurrentPlyLabFile,PlayDataBlocks[Lauf1]^[1],DataBlockSize);
              Seek(CurrentPlyLabFile,CurrentFilePosition); { Diese wurde ja schon vorhin gesichert }
              Inc(CurrentWritten,DataBlockSize);
             End;
            FilePositions[Lauf1] := FilePos(CurrentPlyLabFile);
            BlockRead(CurrentPlyLabFile,PlayDataBlocks[Lauf1]^[1],DataBlockSize);
            UsedBlock[Lauf1] := TRUE;
           End;

          OldX := WhereX;
          OldY := WhereY;
          GotoXY(XPosition_CurrentPos,YPosition_CurrentPos);
          Write(CurrentFilePosition:10);
          GotoXY(OldX,OldY);
          If CurrentFilePosition = MaximalFilePosition then StopRecordAndPLay; { Wenn das Ende erreicht ist, anhalten }
         End;
       End;
      NextCommand;
     End;


    If CurrentWINDDelay <> 0 then                { Dies hier wird verwendet, um eine Soundausgabe nach einiger Zeit zu starten}
     Begin
      Dec(CurrentWindDelay);
      IF CurrentWindDelay = 0 then
       Begin
        Snd_CurrentJob := SaveJob;
       End;
     End;

    If KeyPressed then
     Begin
      Eingabe := ReadKey;
      If CurrentCommand.Command = CMD_WriteAwnser then
       Begin
        ReadInputForAwnser( EIngabe)
       End
     else
      Case Eingabe of
       #0 : Begin                                  { Es ist ein "Escape-Code" }
             EIngabe := ReadKey;
             Case Eingabe of
                  #75 : Begin                      { Links }
                         If MenuPosition = 1 then MenuPosition := MaxMenuItems else Dec(MenuPosition);
                          PaintMenu;
                        End;
                  #77 : Begin                     { Rechts }
                         If MenuPosition = MaxMenuItems then MenuPosition := 1 else Inc(MenuPOsition);
                         PaintMenu;
                        End;

             End;
           End;
     #13 : Begin                                 { ENTER }
            Case MenuPosition of
          Men_STOP : StopRecordAndPlay;          { Menposition "STOP" aktiviert. }
            Men_FB : Begin                       { *** Menposition "Schneller Rcklauf" angewhlt }
                      CurrentFilePosition := FilePos(CurrentPlyLabFile);
                      If (CurrentFilePosition - WIND_GRANULARITY * DataBlockSize) >= 0 then
                       Begin
                        If CurrentWindDelay = 0 then
                         Begin
                          SaveJob := SND_CurrentJob;
                          Snd_CurrentJob := Snd_None;
                         End;

                        Seek(CurrentPLyLabFile,CurrentFilePosition - WIND_GRANULARITY * DataBlockSize );
                        CurrentFilePosition := FilePos(CurrentPlyLabFile);
                        { Jetzt ist gespult. Die Datenblcke neu einlesen lassen. }
                        For Lauf2 := 1 to 4 do UsedBlock[Lauf2] := FALSE;
                        GotoXY(XPosition_CurrentPos,YPosition_CurrentPos);
                        Write(CurrentFilePosition:10);
                        CurrentWindDelay := WIND_DELAY;
{                        Snd_currentJob := Lauf1; }
                       End;
                     End;
          Men_PLay : StartPlay;                  { *** Menposition "Abspielen" angewhlt }
           Men_FWD : Begin                       { *** Menposition "Schneller Vorlauf" angewhlt }
                      CurrentFilePosition := FilePos(CurrentPlyLabFile);
                      If (CurrentFilePosition + WIND_GRANULARITY * DataBlockSize) <= MaximalFilePOsition then
                       Begin
                        If CurrentWindDelay = 0 then
                         Begin
                          SaveJob := SND_CurrentJob;
                          Snd_CurrentJob := Snd_None;
                         End;
                        Seek(CurrentPLyLabFile,CurrentFilePosition + WIND_GRANULARITY * DataBlockSize );
                        CurrentFilePosition := FilePos(CurrentPlyLabFile);
                        { Jetzt ist gespult. Die Datenblcke neu einlesen lassen. }
                        For Lauf2 := 1 to 4 do UsedBlock[Lauf2] := FALSE;
                        GotoXY(XPosition_CurrentPos,YPosition_CurrentPos);
                        Write(CurrentFilePosition:10);
                        CurrentWindDelay := WIND_DELAY;
                       End;
                     End;
           Men_Rec : StartRecord;                { *** Menposition "Aufnahme" angewhlt }
            End;
           End;
     #27 : Begin                                 { RAUS HIER ! }
           End;
      End;
     End;
   Until Eingabe = #27;
   StopLabData;
{    Close(CurrentRecLabFile); }
   Close(CurrentPlyLabFile);
   RestoreScreen;
   Sptr := OldSptr;
  End
 Else
  Begin
   MessageBox(10,3,60,3,'Das Sound-System ist bereits aktiv !');
   Readkey;
  End;
End;
