{
    LanTsr 0.1   - A Remote-Control-Program for DOS-Systems
    Copyright (C) 1996, 1997, 1998 Daniel von Dincklage
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
Unit TControl;
INTERFACE
{$O+,F+}
{ **************************************************************************
 Diese Unit stellt die Funktionen fr das Hauptmen in der TSR-Umgebeng bereit.
    Version : 1.5
      Datum : 29.03.1996
Anmerkungen :
         *** SEHR WICHTIG *** SEHR WICHTIG *** SEHR WICHTIG *** SEHR WICHTIG ***
              Diese Unit bentigt zwei Dateien, in denen die Menstrukturen definiert
              sind. Ihre Namen sind in den typisierten Konstanten "MenuData"
              und "MenuHelp" gespeichert. In der mit "MenuData" bezeichneten
              Variabele ist der Dateiname der Datei mit der Menstruktur
              gespeichert, in "MenuHelp" die zugehrigen Hilfetexte, die in
              der anderen Hlfte des Schirmes dargestellt werden.
         *** SEHR WICHTIG *** SEHR WICHTIG *** SEHR WICHTIG *** SEHR WICHTIG ***
 nderungen : Das Men, das von der Unit bereitgestellt wird, ist nicht statisch.
              Es kann durch eine durch den Benutzer modifizierbaren Datei
              gendert werden, um z.B. "normalen" Benutzer Zugriff auf speizielle
              Optionen zu verweigern oder auch um Benutzern die Verwendung von
              dem Program zu erleichtern.
              Man knnte auch (sehr Praktisch!) eine Art "Debug"-Men mit ausliefern,
              das von dem Benutzer bei Problemen geladen werden kann, um dann
              mit speziellen Optionen sich Diagnosebotschaften ausgeben zu lassen.
  ************************************************************************** }
Uses     Dos,  { Die Dos-Unit einbinden, um z.B. die "Register"-Variabelen zu benutzen }
         CRT,  { Fr Keypressed und ReadKeys.ReadKey }
    String_P,  { tStr50-Funktionen und Prozeduren }
     StrType,
    MenuExec,  { Die Prozeduren, die Aktionskonstanten behandeln }
    ReadKeys,
    MiscProc,
     Screens,  { Prozeduren zum Schreiben auf den Bildschirm }
       Video;

Const
    VersionString = '1.0       ';                { Die Version des Programmes }
 SubVersionString = 'FREE *** Nicht Registriert !'; { Die Unterversionskennung (z.B. OEM-Version) (<- Schn wrs ! ...)}
        MYVERSION = 1;                           { Die Maximale Version, die an Mendaten eingelesen werden kann }

Const
{ Hier kommen die Menkontexte }
 con_MENUQUIT  = 1;                              { Kontext beenden (Raus aus dem aktuellen Men) }
 con_MenuCall  = 2;                              { Kontext springen (In ein anderes Men springen) }
 con_MenuAct   = 3;                              { Kontext Aktion, einen Wert ndern }
 con_MenuTag   = 4;                              { Kontext "Tagfeld", nicht anwhlbar, wird bersprungen }


Type
pMenuItem = ^tMenuItem;
    pMenu = ^tMenu;
    tMenu = Record
          Title : String[24];
         MenuID : Word;
   MenuElements : Word;
      MenuItems : pMenuItem;
   LastMenuItem : pMenuItem;
            End;


tMenuItem = Record
          pNext : pMenuItem;                     { Zeiger auf das nchste Submen }
          pPrev : pMenuItem;                     { Zeiger auf das vorhergehende Element }
         MenuID : Word;                          { Die ID des jeweiligen Mens }
     MenuAction : LongInt;                       { Die Aktion des Mens }
    MenuContext : Word;                          { Der Kontext (z.B. Untermen aufrufen, Quitten, Aktion .. }
       MenuText : String[24];                    { Der Bildschirmtext }
            End;
Const


        NOTHING = 0;
       FINISHED = 1;

{ Ab 100 kommen die Fehler }
{ Header-Fehler }
  HEADERCORRUPT = 100;                           { Kein Header/Falscher Header }
   WRONGVERSION = 101;                           { Falsche Version }
{ Menkennungsfehler }
MAINMENUCORRUPT = 102;                           { Falsche Hauptmenkennung }
MAINMENUMISSING = 103;                           { Das Hauptmen ist nicht da ! }
{ Start-Men-Optionen-Fehler }
 MENUSTARTWRONG = 104;                           { Fehler in der "START"-Kennung einer Menoption }
{ Fehler in einem Menpunkt }
MENUITEMPART0CORRUPT = 105;                      { Fehler in dem 0-Teil, dem "M????," }
MENUITEMPART1CORRUPT = 106;                      { Fehler in dem 1-Teil, bei Submenteilen der Zahl und dem ':"' }
 WRONGJUMPLABEL = 107;                           { Es gab einen Fehler bei der erkennung des Sprung-Zieles }
 WRONGACTIONNUM = 108;                           { Falsche Aktions-Nummer }


Procedure TsrMenu( Data, Help : tStr50 );
{ Diese Prozedur ruft das Hauptmen auf. Sie sollte die einzige Prozedur in dieser
  Unit sein, die nach aussen "durchgeschliffen" wird. }


IMPLEMENTATION


Procedure PaintMain;
{ Diese Prozedur zeichnet das Hauptfenster mit dem Balken }
Var
 Lauf1 : Word;
Begin
 TextColor(Black);
 TextBackGround(LightGray);

 ClrScr;

 ColorLo;
 PaintBox(1,1,79,24);

 For Lauf1 := 1 to 22 do
  Begin
   GotoXY(27,Lauf1+1);
   Write('');
  End;
 GotoXY(27,24); Write('');
 GotoXY(27,1); Write('');
 GotoXY(3,1); Write('< Version: ', VersionString,' >');
 GotoXY(75 - 2 - Length(Subversionstring),1);
 Write('<',SubversionString,'>');
End;

Function ReadMenu( MenuFile : tStr50; MenuID : Integer; Var MenuStartPt : pMenu ) : Word;
Var
       MyFile : Text;                            { Die Datei mit den Daten }
       TmpStr : tStr50;                          { In diesem tStr50 sind die Daten der aktuellen Zeile gespeichert }
      WorkStr : tStr50;                          { Ein tStr50, in dem Daten zwischengespeichert werden }
     TempWord : Word;                            { Word zum zwischenspeichern von Daten }
    ReadLines : LongInt;                         { Die Anzahl der bereits gelesenen Zeilen. }
        Tmppt : pMenuItem;                       { Nimmt vorbergehend ein Menpunkt auf }
  HeaderFound : Word;                            { Ist der Header gefunden ? (Beinhaltet dann die Version)}
     MainMenu : Word;                            { Die Nummer des Haputmens (Wird keins gefunden, wird 0 angenommen }
   CopingMenu : LongInt;                         { Die Nummer des gerade behandelten Mens }
     MenuRead : Word;
      ValCode : Integer;                         { Ergebnisvariabele fr VAL }

  Function AppendMenuItem : pMenuItem;
  Begin
   With MenuStartPt^ do
    Begin
     If (LastMenuItem = NIL) then                { Wenn noch kein Element eingetragen ist ... }
      Begin
       GetMem(MenuItems,SizeOf(tMenuItem));      { Es ist das erste in der Kette ... }
       FillChar(MenuItems^,SizeOf(tMenuItem),0);
       LastMenuItem := MenuItems;                { Und das letzte Element aktualisieren }
       MenuItems^.pPrev := NIL;
      End
     Else
      Begin
       GetMem(LastMenuItem^.pNext,SizeOf(tMenuItem)); { Speicher hinter dem letzten Item belegen }
   FillChar(LastMenuItem^.pNext^,Sizeof(tMenuItem),0);
             LastMenuItem^.pNext^.pPrev := LastMenuItem;
       LastMenuItem := LastMenuItem^.pNext;            { Und nun den Zeiger auf das letzte Element aktualisieren }
      End;
    End;
   AppendMenuItem := MenuStartPt^.LastMenuItem;
  End;

  Procedure DigestHeader;
  Begin
   Delete(TmpStr,1,Length('DVDMENUFILE:V'));     { Das lschen. Nun steht im tStr50 nur noch die Version. }
   Val(TmpStr,HeaderFound,ValCode);
   If ValCode <> 0 then                          { Ist ein Fehler aufgetreten ? }
    Begin
     MenuRead := HEADERCORRUPT;                  { Ja, Header nicht korrekt. Fehler signalisieren }
    End else
   If MyVersion < HeaderFound then               { Nein. Die Version steht bereits in "HeaderFound" aber noch zur Kontrolle !}
    Begin
     MenuRead := WRONGVERSION;
    End;
   TmpStr := '';
  End;

  Procedure DigestMainIDStamp;
  Begin
   If HeaderFound <> 0  then                      { Wenn noch kein Header da ist, Fehler ! }
    Begin
     Delete(TmpStr,1,Length('MAINMENU='));       { Das lschen. Nun steht im tStr50 nur noch die Version. }
     Val(TmpStr,MainMenu,ValCode);
     If ValCode <> 0 then                        { Fehler beim Umwandeln, Fehler ausgeben }
      Begin
       MenuRead := MAINMENUCORRUPT;
      End
     Else If (MenuID = -1) then                  { Wenn MenuID = -1, dann immer Hauptmen zurckgeben }
      Begin
       MenuID := MainMenu;
      End;
    End
   Else MenuRead := HEADERCORRUPT;
   TmpStr := '';
  End;

  Function ConvertStandardString( Var InString : tStr50 ) : tStr50;
  { "Filtert" einen "Standard-tStr50" aus einem tStr50 heraus, lscht diesen aus
    demselben und gibt den Standard-tStr50 zurck. }
  Var
       OutString : tStr50;                       { Temporrer tStr50 zum Arbeiten }
   StringKopiert : Boolean;                      { Ist der tStr50 fertig kopiert ? }
           Lauf1 : Word;                         { Eine Laufvariabele }
  Begin
   OutString := '';
   Lauf1 := Pos('"',InString);                   { Das erste Vorkommen mu das einleiten des Strings sein }
   Delete(InString,Lauf1,1);                     { Dieses Zeichen lschen. }
   StringKopiert := FALSE;
   While Not(StringKopiert) and Not(Lauf1 > Length(InString)) do
    Begin
     If InString[Lauf1] <> '"' then
      Begin
       OutString := OutString + InString[Lauf1]; { Das Zeichen kopieren }
       Delete(InString,Lauf1,1);                 { und aus dem Original-tStr50 lschen }
      End
     Else
      Begin                                      { Ein ". Nun feststellen, ob "" oder nicht ... }
       If Lauf1 = Length(InString) then StringKopiert := TRUE else { Ausnahme : Wenn das " letztes Zeichen ist, beenden ! }
        Begin
         If InString[Lauf1+1] = '"' then         { Ist das nchste Zeichen auch ein " ? }
          Begin                                  { JA ! Nun beide "" lschen im Zielstring ein " hinzufgen. }
           OutString := OutString + '"';
           Delete(InString,Lauf1,2);
          End
         else                                    { Nein. Das " lschen und beenden. }
          Begin
           Delete(InString,Lauf1,1);
           StringKopiert := TRUE;
          End;
        End;
      End;
    End;
   ConvertStandardString := OutString;
  End;

Begin
 GetMem(MenuStartPt,SizeOf(tMenu));
 FillChar(MenuStartPt^,SizeOf(tMenu),0);
    MenuRead := Nothing;                         { Die Variabelen Initalisieren }
   ReadLines := 0;
 HeaderFound := 0;
    MainMenu := 0;
  CopingMenu := -1;

 Assign(MyFile,MenuFile);
 Reset(MyFile);
 While Not(Eof(MyFile)) and (MenuRead = Nothing) do
  Begin
   Readln(MyFile,TmpStr);
   Inc(ReadLines);                               { Es ist eine neue Zeile eingelesen worden ... }
   TmpStr := StripBoth(TmpStr);                  { Fhrende und Folgende Leerzeichen lschen }
   If TmpStr[1] = '' then
    Begin { Die Zeile ist nur dann interessant, wenn ein Escape-Zeichen kommt }
     Delete(TmpStr,1,1);                         { Das Escape-Zeichen lschen. }
     If CopingMenu = -1 then                     { Bin ich grade in einer Menbehandelung ? }
      Begin
       If Pos('DVDMENUFILE:V',TmpStr) = 1 then   { Steht die Header-Kennung am Anfang }
        DigestHeader;                            { Den Header behandeln ! }
       If Pos('MAINMENU=',TmpStr) = 1 then
        DigestMainIDSTamp;
       If (Pos('M',TmpStr) = 1) and (Pos(',START',TmpStr) = 6) then { Da ist eine Men-Start-Kennung ! }
        Begin
         If HeaderFound <> 0 then                 { Wenn kein Header da ist, Fehler ! }
          Begin
           Delete(TmpStr,1,1);                   { Das erste Zeichen (das "M") lschen }
           Delete(TmpStr,5,Length(',START'));    { Das ",START" lschen }
           Val(TmpStr,CopingMenu,ValCode);       { Nun das ID von dem Men, das bearbeitet wird, kopieren }
           If ValCode <> 0 then
            Begin
             MenuRead := MENUSTARTWRONG;
            End;
          End
         Else MenuRead := HEADERCORRUPT;
        End;
      End
     Else IF (CopingMenu = MenuID) then          { Nur genauer analysieren, wenn es das gesuchte Men ist }
      Begin
       MenuStartPt^.MenuID := CopingMenu;
       Delete(TmpStr,1,1);                       { Wenn alles Korrekt ist, mu an Position 1 ein "M" stehen }
       WorkStr := Copy(TmpStr,1,4);              { Die ersten Vier Zeichen nun in einen anderen tStr50 kopieren }
       Delete(TmpStr,1,4);
       Val(WorkStr,TempWord,ValCode);            { Den Inhalt von WorkStr in TempWord bringen. }
       If (ValCode = 0) and (TempWord = CopingMenu) and
          (TmpStr[1] = ',') then                 { Nur wenn aktuelles Men und so ok ist, weitermachen }
        Begin
         Delete(TmpStr,1,1);                     { Das Komme lschen ... }
         If Pos('END',TmpStr) = 1 then
          Begin
           MenuRead := FINISHED;
          End Else
         If Pos('TITLE:',TmpStr) = 1 then        { Da ist ein Mentitel ! }
          Begin
           Delete(TmpStr,1,Length('TITLE:'));
           MenuStartPt^.Title := ConvertStandardString(TmpStr);
          End
         Else If Pos(':"',TmpStr) = 4 then       { Ist es etwa ein Subpunkt ? (gekennzeichnet durch drei Zahlen und ":"")}
          Begin
           WorkStr := Copy(TmpStr,1,3);          { Die ersten drei Zeichen aus dem TmpStr kopieren ... }
           Val(WorkStr,TempWord,ValCode);
           If ValCode = 0 then                   { Umwandelung erfolgreich ! (Es ist also ein schnder Menpunkt !) }
            Begin
             Inc(MenuStartPt^.MenuElements);
             Delete(TmpStr,1,4);                 { Die Zahl und den Doppelpunkt lschen }
             Tmppt := AppendMenuItem;            { Einen Menpunkt anhngen ! }
             With Tmppt^ do
              Begin
               MenuID := TempWord;               { Den Menidentifikator kopieren }
               MenuText := ConvertStandardString(TmpStr); { Den Text-tStr50 herausfiltern }
               If (TmpStr[1] = ',') then         { Geht es noch weiter ? }
                Begin
                 Delete(TmpStr,1,1);             { Das Komma entfernen }
                 If TmpStr[1] = 'M' then         { Eine Untermenverzweigung ! }
                  Begin
                   MenuContext := con_MenuCall;  { In dem Men herumspringen. }
                   Delete(TmpStr,1,1);           { Das "M" lschen }
                   Val(TmpStr,MenuAction,ValCode); { Die Sprungzahl "evaluieren" }
                   IF ValCode <> 0 then
                    Begin
                     MenuRead := WRONGJUMPLABEL; { Falsches Sprungziel }
                    End;
                  End
                 Else If TmpStr[1] = 'Q' then    { Q = Men beenden-Option }
                  Begin
                   MenuContext := con_MenuQuit;  { Den Kontext auf beenden setzen }
                  End
                 Else If TmpStr[1] = 'A' then    { A = Menaktion ausfhren }
                  Begin
                   MenuContext := con_MenuAct;   { Eine Aktion aufrufen ! }
                   Delete(TmpStr,1,1);           { Das "A" lschen. }
                   Val(TmpStr,MenuAction,ValCode);
                   If ValCode <> 0 then
                    Begin
                     MenuRead := WRONGACTIONNUM; { Falsche Aktionsnummer }
                    End;
                  End
                 Else If TmpStr[1] = 'X' then    { X = Menpunkt nur als "Tag"-Betrachten }
                  Begin
                   MenuContext := con_MenuTag;   { Dies soll nur ein "Tag"-Element sein ! }
                  End;
                End;
              End;
            End
           Else
            Begin
             MenuRead := MENUITEMPART1CORRUPT;   { Nun schnell den Fehler signalisieren }
            End;
          End;
        End
       Else
        Begin
         MenuRead := MENUITEMPART0CORRUPT;
        End;
      End
     Else
      Begin
       If (Pos('M',TmpStr) = 1) and (Pos(',END',TmpStr) = 6) then { Da ist eine Men-Ende-Kennung ! }
        CopingMenu := -1;                        { Men ist zuende, zurcksetzen }
      End;
    End;
  End;
 Close(MyFile);
 ReadMenu := MenuRead;
End;

Function StrFunc( Num : Word ) : tStr50;
Var
 TmpStr : tStr50;
Begin
 Str(Num,TmpStr);
 StrFunc := TmpStr;
End;


Procedure TsrMenu( Data, Help : tStr50 );
Const
         DividerX = 27;                          { Die X-Koordinate der "Trennzeile" }
 FirstDisplayLine = 2;                           { Die erste Zeile, in der Menoptionen dargestellt werden }
  LastDisplayLine = 23;                          { Die letzte Zeile, in der Menoptionen dargestellt werden }
         DisplayX = 3;                           { Die erste Spalte, in der die Menoptionen geschrieben werden }

{Var
 MenuPointer : pMenu; }

  Procedure PrintMenuItemHelp( Menu, Item : Word );
  Var
       MyFile : Text;
       TmpStr : tStr50;
      TmpStr2 : String[10];
    HelpWrote : Boolean;
  WritingHelp : Boolean;
      ValCode : Word;
 CurrentHelpM : Integer;
 CurrentHelpI : Integer;
       YCount : Word;
  Begin
   Assign(MyFile,Help);
   Reset(MyFile);
     HelpWrote := FALSE;
   WritingHelp := FALSE;

   For YCount := 2 to 23 do                      { Erstmal den Hilfeschirm lschen }
    Begin
     GotoXY(DividerX+1,YCount);
     Write('                                                   ');
    End;
   YCount := 2;

   GotoXY(1,1);
   While Not(HelpWrote) and Not(Eof(MyFile)) do
    Begin
     Readln(MyFile,TmpStr);

     If (Pos('',TmpStr) = 1) and (Pos(':',TmpStr) = 6) and (Pos(',',TmpStr) = 10) then
      Begin
       If WritingHelp then
        Begin
         WritingHelp := FALSE;
         If (CurrentHelpI = Item) and (CurrentHelpM = Menu) then HelpWrote := TRUE;
        End
       else
        Begin
         WritingHelp := TRUE;
         Delete(TmpStr,1,1);
         TmpStr2 := Copy(TmpStr,1,4);
         Delete(TmpStr,1,5);
         Val(TmpStr2,CurrentHelpM,ValCode);
         If ValCode = 0 then
          Begin
           TmpStr2 := Copy(TmpStr,1,3);
           Val(TmpStr2,CurrentHelpI,ValCode);
           If ValCode <> 0 then
            Begin
             CurrentHelpI := -1;
            End;
          End
         Else CurrentHelpM := -1;
        End;
      End
     Else If TmpStr[1] <> '#' then
      Begin If WritingHelp and (CurrentHelpI = Item) and (CurrentHelpM = Menu) then
       Begin
        GotoXY(DividerX+2,YCount);
        Write(TmpStr);
        Inc(YCount);
       End;
      End;
    End;

   Close(MyFile);
  End;

  Function GetNextMenuItems( Origin : pMenuItem ) : Word;
  { Liefert die Anzahl der Menpunkte zurck, die noch folgen }
  Var
   Lauf1 : Word;
  Begin
   Lauf1 := 0;
   While origin <> NIL do
    Begin
     Origin := Origin^.pNext;
     Inc(Lauf1);
    End;
   GetNextMenuItems := Lauf1;
  End;

  Procedure FreeMenu( Var MenuPointer : pMenu );
  Var
   Tmppt : pMenuItem;
  Tmppt2 : pMenuItem;
  Begin
  If MenuPointer^.LastMenuItem <> NIL then       { Velleicht kam Vorher ja ein Fehler. }
   Begin
    Tmppt2 := MenuPointer^.LastMenuItem^.pPrev;
     While Tmppt2 <> NIL do
      Begin
       Tmppt := Tmppt2^.pPrev;
       FreeMem(Tmppt2^.pNext,SizeOf(tMenuItem));
       Tmppt2 := Tmppt;
      End;
     FreeMem(MenuPointer^.MenuItems,SizeOf(tMenu));
    End;
   FreeMeM(MenuPointer,Sizeof(Tmenu));
   MenuPointer := NIL;
  End;

  Procedure WriteTitle( Var MenuPointer : pMenu );
  Var
   Lauf1 : Word;
  Begin
   GotoXY(3,1);                                  { Den Titel des Mens an der gegebenen Position darstellen }
   Write('<');
   For Lauf1 := 1 to 21 do Write(' ');
   Write('>');
   GotoXY(13-(Length(MenuPointer^.Title) div 2),1);
   Write(MenuPointer^.Title);
  End;

  Procedure MenuAction( MenuID : Integer );
  Var
 MenuPointer : pMenu;
       Lauf1 : Word;
     EndMenu : Boolean;
    pCurrent : pMenuItem;                        { Das Menelement, auf dem der Cursor steht }
  pDispStart : pMenuItem;                        { Das erste Menelement, das dargestellt wird }
 pDisplayEnd : pMenuItem;                        { Das letzte dargestellte Menuelement }
       Tmppt : pMenuItem;
     Eingabe : Char;                             { Das aktuell eingelesene Zeichen }

  Begin
   MenuPointer := NIL;
   Lauf1 := ReadMenu(Data,MenuID,MenuPointer); { Das Men einlesen und in der Struktur speichern }

   If Lauf1 = 1 then
    Begin
     CurSorOff;
     WriteTitle(MenuPointer);
     EndMenu := FALSE;
     pCurrent := MenuPointer^.MenuItems;           { Das erste Element ist selektiert }
   pDispStart := MenuPointer^.MenuItems;           { Beide sind die ersten Elemente }
     While Not(EndMenu) do                         { Warten, bis das Men fertig ist. }
      Begin
       TextColor(Yellow);
       TextBackGround(Blue);
       PrintMenuItemHelp(MenuPointer^.MenuID,pCurrent^.MenuID);
       GotoXY(DividerX,FirstDisplayLine);          { In der Koordinate (Trennzeile/Erste Menzeile) ein Pfeil nach oben malen.}
       If pDispStart^.pPrev <> NIL then            { Wenn vor dem ersten Element noch was kommt, ein Pfeil malen. }
         Write(#24) Else
         Write('');                               { Ansonsten einen Balken }
       Lauf1 := 0;
       Tmppt := pDispStart;
       While (Lauf1 <= LastDisplayLine - FirstDisplayLine) do { Fr alle darstellbaren Zeilen etwas schreiben ... }
        Begin
         GotoXY(DisplayX,FirstDisplayLine+Lauf1);  { Die Menoptionen Schreiben ... }

         If (Tmppt = pCurrent) then ColorHi        { Ist die aktuell darzustellende Option angewhlt ? }
                               else ColorLo;
         pDisplayEnd := Tmppt;                     { Das letzte Menelement festlegen }
         If Tmppt <> NIL then
          Begin
           Write(Tmppt^.MenuText);
           Tmppt := Tmppt^.pNExt;
          End
         Else
          begin
           Write('                       ');       { Wenn keine Option da ist, lieber eine Leerzeile schreiben. }
          End;
         Inc(Lauf1);
        End;

       TextColor(Yellow);
       TextBackGround(Blue);
       GotoXY(DividerX,LastDisplayLine);           { In der Koordinate (Trennzeile/Erste Menzeile) ein Pfeil nach oben malen.}
       If (pDisplayEnd^.pNext <> NIL) and (pDisplayEnd <> NIL) then{ Einen Pfeil malen. }
         Write(#25) Else
         Write('');                               { Ansonsten einen Balken }

       Eingabe := ReadKeys.ReadKey;
       Case Eingabe of
         #0, #224 : Begin  { Interessanterweise geht auch #224 als "Initial" ! }
               Eingabe := ReadKeys.ReadKey;
               Case Eingabe of
                #80 : Begin                        { Runter }
                       Tmppt := pCurrent;
                       Lauf1 := 0;
                       Repeat
                        Tmppt := Tmppt^.pNext;
                        Inc(Lauf1);
                       Until (Tmppt = NIL) or (Tmppt^.MenuContext <> con_MenuTag);

                       If Tmppt = NIL then Beep
                       Else
                        Begin
                         RepeaT
                          If pCurrent = pDisplayEnd then
                           Begin
                             pDispStart := pDispStart^.pNext;
                            pDisplayEnd := pDisplayEnd^.pNext;
                           End;
                          pCurrent := pCurrent^.pNext;
                          Dec(Lauf1);
                         Until Lauf1 = 0;
                        End;
                      End;
                #72 : Begin
                        Lauf1 := 0;
                       Tmppt := pCurrent;
                       Repeat
                        Tmppt := Tmppt^.pPrev;
                        Inc(Lauf1);
                       Until (Tmppt = NIL) or (Tmppt^.MenuContext <> con_MenuTag);

                       If Tmppt = NIL then Beep{ Ist da berhaupt ein nchstes Element ? }
                       Else
                        Begin
                         If pCurrent = pDispStart then
                          Repeat
                           pDispStart := pDispStart^.pPrev;
                           Dec(Lauf1);
                          Until Lauf1 = 0;
                         pCurrent := Tmppt;   { Das nchste Element wurde angewhlt }
                        End;
                      End;
               End;
              End;
        #13 : Begin { Ein Enter. Nun Aktionsabhngige Aktion aufrufen. }
               Case pCurrent^.MenuContext of
                con_MenuQuit : Begin
                                EndMenu := TRUE; { Kontext con_Menuquit -> Beenden des Mens }
                               End;
                con_MenuCall : Begin
                                MenuAction(pCurrent^.MenuAction);
                                WriteTitle(MenuPointer);
                               End;
                 con_MenuAct : Begin { Dies mu spter noch ausgfllt werden um die Aktionen spter auszufhren. }
                                ParseMenuExecution(pCurrent^.MenuAction);
                               End;
               End;
              End;
        #27 : Begin
               EndMenu := True;
              End;
       End;
      End;
    End
   Else
    Begin
     MessageBox(10,10,50,1,'Fehler beim Lesen des Mens ('+StrFunc(Lauf1)+')');
     CursorOff;
    End;
   FreeMenu(MenuPointer);
  End;

Begin
 PaintMain;
 MenuAction(-1);
End;

End.

