{$m,14000,64000,64000}
program box_of_stars;

uses crt,graph,dos;

const num=2000;{number of stars in box}
      xof=320;
      yof=200;
      zeye=-300;

var star:array[1..num] of record
                           x,y,z:real;
                          end;
    pcos,ncos,psin,nsin:real;
    c:char;
    page:byte;
    stat,size,h,v:integer;

{$i mouse.inc}

procedure rotx(dir:byte);
var y1,z1:real;
    i:integer;
begin
 if dir=1 then for i:=1 to num do
  begin
   y1:=pcos*star[i].y-psin*star[i].z;
   z1:=psin*star[i].y+pcos*star[i].z;
   star[i].y:=y1;
   star[i].z:=z1;
  end
 else for i:=1 to num do
  begin
   y1:=ncos*star[i].y-nsin*star[i].z;
   z1:=nsin*star[i].y+ncos*star[i].z;
   star[i].y:=y1;
   star[i].z:=z1;
  end;
end;

procedure roty(dir:byte);
var x1,z1:real;
    i:integer;
begin
 if dir=1 then for i:=1 to num do
  begin
   x1:=pcos*star[i].x-psin*star[i].z;
   z1:=psin*star[i].x+pcos*star[i].z;
   star[i].x:=x1;
   star[i].z:=z1;
  end
 else for i:=1 to num do
  begin
   x1:=ncos*star[i].x-nsin*star[i].z;
   z1:=nsin*star[i].x+ncos*star[i].z;
   star[i].x:=x1;
   star[i].z:=z1;
  end;
end;

procedure rotz(dir:byte);
var x1,y1:real;
    i:integer;
begin
 if dir=1 then for i:=1 to num do
  begin
   y1:=pcos*star[i].y-psin*star[i].x;
   x1:=psin*star[i].y+pcos*star[i].x;
   star[i].x:=x1;
   star[i].y:=y1;
  end
  else for i:=1 to num do
  begin
   y1:=ncos*star[i].y-nsin*star[i].x;
   x1:=nsin*star[i].y+ncos*star[i].x;
   star[i].x:=x1;
   star[i].y:=y1;
  end;
end;

procedure plotpixel(x,y,c:word);
begin
 mem[$a000:y*320+x]:=c
end;

procedure display_box;
var i,x,y:integer;
begin
 setactivepage(page);
 cleardevice;
 for i:=1 to num do
  begin
   X:=xof+round(star[i].x*(Zeye/(Zeye-star[i].z)));
   Y:=yof+round(star[i].y*(Zeye/(Zeye-star[i].z)));
   putpixel(x,y,trunc(8-star[i].z/(size div 5))+1);
  end;
 setvisualpage(page);
 page:=1-page;
end;

procedure init;
const col:array[1..15]of byte=(1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
var i,x,y,z:integer;
begin
 if not initmouse then
  begin
   writeln('No mouse installed...');
   writeln;
   halt;
  end;
 x:=9;
 y:=1;
 initgraph(x,y,'egavga.bgi');
 randomize;
 size:=80;
 for i:=1 to num do
  begin
   x:=random(size*2)-size;
   y:=random(size*2)-size;
   z:=random(size*2)-size;
   star[i].x:=x;
   star[i].y:=y;
   star[i].z:=z;
  end;
 for i:=1 to 15 do setrgbpalette(col[i],i*4,i*4,i*4);
 page:=1;
 setactivepage(page);
 display_box;
end;

procedure workout(r:integer);
begin
 pcos:=cos(r div 2*2*pi/360);
 ncos:=cos(-r div 2*2*pi/360);
 psin:=sin(r div 2*2*pi/360);
 nsin:=sin(-r div 2*2*pi/360);
end;

begin
 init;
 display_box;
 repeat
  if rclick then
   repeat
    mousemove(h,v);
    if h<0 then begin workout(-h);rotz(1);end;
    if h>0 then begin workout(h);rotz(0);end;
    if h<>0 then display_box;
   until rrelease;
   mousemove(h,v);
   if v<0 then begin workout(v);rotx(1);end;
   if v>0 then begin workout(-v);rotx(0);end;
   if h<0 then begin workout(h);roty(1);end;
   if h>0 then begin workout(-h);roty(0);end;
   if(v<>0)or(h<>0)then display_box;
 until lclick;
 closegraph;
end.