{$m,16000,0,655360}
program finbarrs_F;

uses crt,graph,fin{,sb,sysproc,playmods,errors_e};

const num=72;{number of pixels in box}
      zeye=-150;

var pixel:array[1..num] of record
                            x,y,z:real;
                           end;
    pcos,ncos,psin,nsin:real;
    c:char;
    page,mtype:byte;
    size,h,v,stat:integer;
    music:boolean;

{procedure module_init;
var mode,cf,min,max:word;
    data:miscdata;
    st:string;
begin
 dmasize:=16000;
 inithardware;
 if err_type>0 then
  begin
   writeln(error_msg(err_type));
   halt;
  end;
 load_module(paramstr(1));
 if err_type>0 then
  begin
   writeln(error_msg(err_type));
   halt;
  end;
 mode:=1;
 set_output_mode(mode,min,max);
 set_output_freq(44100,cf);
 set_ldi(true);
 get_module_status(data);
 set_ampl_num(trunc(42+(data[5]-3)*144/28));
 set_loop_mode(0);
 set_filter(true);
 set_iter_filtre(1);
 set_default_pan(42);
 set_fade_out_delay(1);
 set_master_volume(64);
end;}

procedure rotx(dir:byte);
var y1,z1:real;
    i:integer;
begin
 for i:=1 to num do
  begin
   if dir=1 then
    begin
     y1:=pcos*pixel[i].y-psin*pixel[i].z;
     z1:=psin*pixel[i].y+pcos*pixel[i].z;
    end
    else
    begin
     y1:=ncos*pixel[i].y-nsin*pixel[i].z;
     z1:=nsin*pixel[i].y+ncos*pixel[i].z;
    end;
   pixel[i].y:=y1;
   pixel[i].z:=z1;
  end;
end;

procedure roty(dir:byte);
var x1,z1:real;
    i:integer;
begin
 for i:=1 to num do
  begin
   if dir=1 then
    begin
     x1:=pcos*pixel[i].x-psin*pixel[i].z;
     z1:=psin*pixel[i].x+pcos*pixel[i].z;
    end
    else
    begin
     x1:=ncos*pixel[i].x-nsin*pixel[i].z;
     z1:=nsin*pixel[i].x+ncos*pixel[i].z;
    end;
   pixel[i].x:=x1;
   pixel[i].z:=z1;
  end;
end;

procedure rotz(dir:byte);
var x1,y1:real;
    i:integer;
begin
 for i:=1 to num do
  begin
   if dir=1 then
    begin
     y1:=pcos*pixel[i].y-psin*pixel[i].x;
     x1:=psin*pixel[i].y+pcos*pixel[i].x;
    end
    else
    begin
     y1:=ncos*pixel[i].y-nsin*pixel[i].x;
     x1:=nsin*pixel[i].y+ncos*pixel[i].x;
    end;
   pixel[i].x:=x1;
   pixel[i].y:=y1;
  end;
end;

procedure eyeview(x,y,z:real;var nx,ny:integer);
begin
 nX:=320+round(x*(Zeye/(Zeye-z)));
 nY:=200+round(y*(Zeye/(Zeye-z)));
 setcolor(trunc(8-z/(size div 5))+1);
end;

procedure display_box;
var i,x,y,x1,y1:integer;
begin
 setactivepage(page);
 delay(10);
 cleardevice;
 for i:=1 to 71 do
  begin
   if i in[1..21,23..35,37..53,55..71]then
    begin
     eyeview(pixel[i].x,pixel[i].y,pixel[i].z,x,y);
     eyeview(pixel[i+1].x,pixel[i+1].y,pixel[i+1].z,x1,y1);
     line(x,y,x1,y1);
    end;
  end;
 eyeview(pixel[22].x,pixel[22].y,pixel[22].z,x,y);
 eyeview(pixel[1].x,pixel[1].y,pixel[1].z,x1,y1);
 line(x,y,x1,y1);
 eyeview(pixel[36].x,pixel[36].y,pixel[36].z,x,y);
 eyeview(pixel[23].x,pixel[23].y,pixel[23].z,x1,y1);
 line(x,y,x1,y1);
 eyeview(pixel[54].x,pixel[54].y,pixel[54].z,x,y);
 eyeview(pixel[37].x,pixel[37].y,pixel[37].z,x1,y1);
 line(x,y,x1,y1);
 eyeview(pixel[72].x,pixel[72].y,pixel[72].z,x,y);
 eyeview(pixel[55].x,pixel[55].y,pixel[55].z,x1,y1);
 line(x,y,x1,y1);
 setvisualpage(page);
 page:=1-page;
end;

procedure init;
const col:array[1..15]of byte=(1,2,3,4,5,20,7,56,57,58,59,60,61,62,63);
var i,x,y,z:integer;
    f:text;
    st:string;
begin
 initmouse;
 x:=9;
 y:=1;
 initgraph(x,y,'egavga.bgi');
 {music:=false;
 if paramcount=1 then
  begin
   music:=true;
   module_init;
   start_module;
  end;}
 size:=50;
 assign(f,'F.dat');
 reset(f);
 for i:=1 to num do
  begin
   readln(f,pixel[i].x);
   readln(f,pixel[i].y);
   pixel[i].z:=0;
   readln(f);
  end;
 for i:=1 to 15 do setrgbpalette(col[i],i*4,i,i);
 page:=1;
 setactivepage(page);
 display_box;
end;

procedure workout(r:integer);
begin
 pcos:=cos(r div 2*2*pi/360);
 ncos:=cos(-r div 2*2*pi/360);
 psin:=sin(r div 2*2*pi/360);
 nsin:=sin(-r div 2*2*pi/360);
end;

begin
 init;
 display_box;
 repeat
 if rclick then
  repeat
   mousemove(h,v);
   if h<0 then begin workout(-h);rotz(1);end;
   if h>0 then begin workout(h);rotz(0);end;
   if h<>0 then display_box;
  until rrelease;
  mousemove(h,v);
  if v<0 then begin workout(v);rotx(1);end;
  if v>0 then begin workout(-v);rotx(0);end;
  if h<0 then begin workout(h);roty(1);end;
  if h>0 then begin workout(-h);roty(0);end;
  if(v<>0)or(h<>0)then display_box;
 until lclick;
 closegraph;
 {if music then
  begin
   stop_module;
   closehardware;
  end;}
end.