#ifndef __CONFIG__
#define __CONFIG__

/* Format:
 ?[!][(premise)]def_name	[text for prompting]

   This line from .in file is in .h file replaced with '#define def_name' if
answer for this config option is yes, or with '' if answer is no.
   If char '!' is after '?', then described function is inverted.
   Field 'premise' is comma separated list of def_names. If it's present,
then user is prompted only if all def_names in premise are defined.
If user is not prompted, the default answer is equal to answer 'No'.
Def_names in premise field may start with '!' which invert its meaning.
   If text field is not present, then def_name is defined, or undefined
by configure's build-in test.
*/

/*
?VERY_SLOW						Is your computer very slow (disables generating screen completely)
?(SVGALIB)SVGA_SPEEDUP			Draw every 1/50 sec only 1/refresh of screen
?SNAILMETER						Enable Snailmeter (shows how much is the emulator slower than original)
?(LINUX)REALTIME				Run atari800 as Linux realtime process
?(LINUX)LINUX_JOYSTICK			Enable LINUX Joystick
?(SVGALIB)JOYMOUSE				Support for Toshiba Joystick Mouse (Linux SVGALIB Only)
?(LINUX)VOXWARE					Enable Voxware Sound Support (Linux)
?!()NO_VOL_ONLY					Enable volume only sound (digitized sound effects)
?!(!NO_VOL_ONLY)NO_CONSOL_SOUND	Enable console sound (keyboard clicks)
?(!NO_VOL_ONLY)SERIO_SOUND		Enable serial in/out sound
?!NOSNDINTER					Enable Sound Interpolation
?()CLIP							Enable Sound Clipping
?()STEREO						Enable Stereo Sound
?MONITOR_BREAK					Enable BREAK command in monitor (slows CPU a little bit)
?MONITOR_HINTS					Enable hints in disassembler (addresses get human readable labels)
?MONITOR_ASSEMBLER				Enable assembler in monitor (you can enter ASM insns directly)
?(!X11)BUFFERED_LOG				Buffer debug output (until the graphics mode switches back to text mode)
?(!X11)SET_LED					Emulate disk LED diode
?!(SET_LED)NO_LED_ON_SCREEN		Display LED on screen
?CRASH_MENU						Show crash menu after CIM instruction
?ZLIB_CAPABLE					Enable compressed state files (you'll need ZLIB for this)
?(ALLEGRO)NEW_ALLEGRO312		Update source for newer Allegro lib v3.12
?(SVGALIB)USE_CURSORBLOCK		Use cursor keys/Ctrl for keyboard joystick
?UNALIGNED_LONG_OK
?ATARI800_BIG_ENDIAN
?ATARI800_64_BIT
*/

#define POKEY_UPDATE
/*#define NO_VOL_ONLY*/			/* It mustn't be defined */
#define STEREO
#define SIGNED_SAMPLES
/*#define CLIP*/

#define BUFFERED_LOG
#define UNALIGNED_LONG_OK
#define ZLIB_CAPABLE
#define NO_GOTO

#define MONITOR_ASSEMBLER
#define MONITOR_HINTS

#define SET_LED

#endif
