/****************************************************************************
File    : globals.c
/*
@(#) #SY# Atari800Win
@(#) #IS# Shared C-core attributes definitions
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 01.10.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "WinConfig.h"
#include <stdio.h>
#include "sio.h"
#include "sound_win.h"
#include "registry.h"
#include "globals.h"


LPCSTR DEFAULT_A8K          = "keyboard.a8k";
LPCSTR DEFAULT_A8S          = "atarisav.a8s";
LPCSTR DEFAULT_ACT          = "palette\\default.act";
LPCSTR DEFAULT_OSA          = "\\atariosa.rom";
LPCSTR DEFAULT_OSB          = "\\atariosb.rom";
LPCSTR DEFAULT_OXL          = "\\atarixl.rom";
LPCSTR DEFAULT_O52          = "\\5200.rom";
LPCSTR DEFAULT_BAS          = "\\ataribas.rom";

HWND   g_hMainWnd           = NULL;
HWND   g_hViewWnd           = NULL;
int    g_nStartX            = 0;
int    g_nStartY            = 0;
long   g_nSleepThreshold    = 0;
int    g_nJoyRepeat         = 0;
int    g_nJoySkip           = 0;
int    g_nSoundRate         = 44100;
int    g_nSoundVol          = 0;
int    g_nSkipUpdateDefault = POKEY_UPDATE_DIVISOR_DEFAULT;
int    g_nUseVolumeOnly     = 0;
int    g_nShowCursor        = 80;
int    g_nTestVal           = 0;
int    g_nMouseMode         = MOUSE_OFF;
int    g_nMouseButtons      = 0;
int    g_nMouseX            = 0;
int    g_nMouseY            = 0;
int    g_nPenOffsetX        = 0;
int    g_nPenOffsetY        = 0;
int    g_nMousePort         = 0;
int    g_nMouseSpeed        = 5;
int    g_nPaddleRange       = 228;
int    g_nJoystickInertia   = 5;
int    g_nStretchedRate     = 2;
int    g_nSpeedPercent      = 100;

RECT   g_rcViewBounds       = { 0, 0 };

ULONG  g_ulScreenMode       = DISPLAY_MODE_DEFAULT;
ULONG  g_ulModesAvail       = 0L;
ULONG  g_ulMiscStates       = MS_STICK_RELEASE;
ULONG  g_ulDontShowFlags    = 0L;
ULONG  g_ulAtariHWNextTime  = 0L;
ULONG  g_ulDeltaT           = 0L;
ULONG  g_ulJoystickSelects  = 0x7f7f7ffc;
ULONG  g_ulSoundState       = SOUND_MMSOUND | SOUND_CUSTOM_RATE;
ULONG  g_ulAtariState       = ATARI_UNINITIALIZED;
ULONG  g_ulFileAssociations = 0L;

LPBITMAPINFO g_lpbmi        = NULL;	/* Bitmap info for our screen bitmap */

int   g_argc                = 0;
char *g_argv          [ 32 ];
char  g_szCmdLine     [ 2048 ];

char *g_apszDriveRegID[ MAX_DRIVES ] =
{
	REG_DRIVE1,
	REG_DRIVE2,
	REG_DRIVE3,
	REG_DRIVE4,
	REG_DRIVE5,
	REG_DRIVE6,
	REG_DRIVE7,
	REG_DRIVE8
};

char  g_szCurrentRom  [ MAX_PATH ];
char  g_szOtherRom    [ MAX_PATH ];
char  g_szTemplateFile[ MAX_PATH ];
char  g_szTemplateDesc[ MAX_PATH ];
char  g_szPaletteFile [ MAX_PATH ];
int   g_nKBTable      [ 256 ];		/* Number of virtual key codes */

PALETTEENTRY g_pe     [ 256 ];
