/****************************************************************************
File    : FileAssociationsDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CFileAssociationsDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 21.09.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "FileAssociationsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_FILEASSOCIATIONS_FIRST		IDC_FILEASSOCIATIONS_ATR
#define IDC_FILEASSOCIATIONS_LAST		IDC_FILEASSOCIATIONS_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg Dialog

BEGIN_MESSAGE_MAP(CFileAssociationsDlg, CDialog)
	//{{AFX_MSG_MAP(CFileAssociationsDlg)
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_SELECTALL, OnSelectAll)
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_REMOVEALL, OnRemoveAll)
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_AUTOREG, OnAutoReg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_OK, OnOK)
	ON_BN_CLICKED(IDC_FILEASSOCIATIONS_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CFileAssociationsDlg::CFileAssociationsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CFileAssociationsDlg::
CFileAssociationsDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CFileAssociationsDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CFileAssociationsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CFileAssociationsDlg::CFileAssociationsDlg */

/*========================================================
Method   : CFileAssociationsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CFileAssociationsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CFileAssociationsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg implementation

/*========================================================
Method   : CFileAssociationsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
SetDlgState()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_FILEASSOCIATIONS_AUTOREG );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulMiscStates & MS_AUTO_REG_FILES) != 0 );

	for( int i = 0; i < g_nFileExtInfoNo; i++ )
	{
		if( m_ulFileAssociations & g_aFileExtInfo[ i ].dwRegFlag )
		{
			pButton = (CButton*)GetDlgItem( g_aFileExtInfo[ i ].dwData );
			ASSERT(pButton);
			pButton->SetCheck( 1 );
		}
	}
} /* #OF# CFileAssociationsDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg message handlers

/*========================================================
Method   : CFileAssociationsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CFileAssociationsDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	/* Always modify file associations */
	if( !GetHomeDirectory( m_szHomeDir ) )
		GetCurrentDirectory( MAX_PATH, m_szHomeDir );

	m_ulFileAssociations = ReadRegFileExt( m_szHomeDir, g_szCmdLine );
	m_ulMiscStates       = g_ulMiscStates;

	/* The global variable is only a not important shadow, update it now */
	if( m_ulFileAssociations != g_ulFileAssociations )
	{
		g_ulFileAssociations = m_ulFileAssociations;
		WriteRegDWORD( NULL, REG_FILE_ASSOCIATIONS, g_ulFileAssociations );
	}
	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CFileAssociationsDlg::OnInitDialog */

/*========================================================
Method   : CFileAssociationsDlg::OnSelectAll
=========================================================*/
/* #FN#
   Sets all the check-boxes to 'checked' state */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
OnSelectAll() 
{
	CButton *pButton = NULL;
	for( int i = 0; i < g_nFileExtInfoNo; i++ )
	{
		pButton = (CButton*)GetDlgItem( g_aFileExtInfo[ i ].dwData );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
} /* #OF# CFileAssociationsDlg::OnSelectAll */

/*========================================================
Method   : CFileAssociationsDlg::OnRemoveAll
=========================================================*/
/* #FN#
   Sets all the check-boxes to 'unchecked' state */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
OnRemoveAll() 
{
	CButton *pButton = NULL;
	for( int i = 0; i < g_nFileExtInfoNo; i++ )
	{
		pButton = (CButton*)GetDlgItem( g_aFileExtInfo[ i ].dwData );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
	}
} /* #OF# CFileAssociationsDlg::OnRemoveAll */

/*========================================================
Method   : CFileAssociationsDlg::OnAutoReg
=========================================================*/
/* #FN#
   The "Register automatically" check-box notification handler */
void
CFileAssociationsDlg::
OnAutoReg()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_FILEASSOCIATIONS_AUTOREG );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_AUTO_REG_FILES;
	else
		m_ulMiscStates &= ~MS_AUTO_REG_FILES;
} /* #OF# CFileAssociationsDlg::OnAutoReg */

/*========================================================
Method   : CFileAssociationsDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CFileAssociationsDlg::
OnOK() 
{
	CButton *pButton = NULL;
	for( int i = 0; i < g_nFileExtInfoNo; i++ )
	{
		pButton = (CButton*)GetDlgItem( g_aFileExtInfo[ i ].dwData );
		ASSERT(pButton);
		if( pButton->GetCheck() )
			m_ulFileAssociations |= g_aFileExtInfo[ i ].dwRegFlag;
		else
			m_ulFileAssociations &= ~g_aFileExtInfo[ i ].dwRegFlag;
	}
	/* Write dialog status only if necessary */
	if( m_ulFileAssociations != g_ulFileAssociations )
	{
		g_ulFileAssociations = m_ulFileAssociations;
		WriteRegDWORD( NULL, REG_FILE_ASSOCIATIONS, g_ulFileAssociations );

		WriteRegFileExt( g_ulFileAssociations, m_szHomeDir, g_szCmdLine );
	}
	if( m_ulMiscStates != g_ulMiscStates )
	{
		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );
	}	
	CDialog::OnOK();
} /* #OF# CFileAssociationsDlg::OnOK */

BOOL
CFileAssociationsDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_FILEASSOCIATIONS,
				  IDC_FILEASSOCIATIONS_FIRST, IDC_FILEASSOCIATIONS_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
