/****************************************************************************
File    : FileSmallDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CFileSmallDlg implementation file
@(#) #BY# Tomasz Szymankowski, Richard Lawrence
@(#) #LM# 04.07.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "FileSmallDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CFileSmallDlg dialog

BEGIN_MESSAGE_MAP(CFileSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CFileSmallDlg)
	ON_NOTIFY(TVN_ITEMEXPANDING, IDC_FILESELECTOR_SMALL_TREE, OnItemExpanding)
	ON_WM_SIZE()
	ON_NOTIFY(NM_DBLCLK, IDC_FILESELECTOR_SMALL_TREE, OnDblclkTree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CFileSmallDlg::
CFileSmallDlg( LPCSTR pszTitle,     /*=NULL*/
			   LPCSTR pszStateFile, /*=NULL*/
			   BOOL   bFoldersOnly, /*=FALSE*/
			   CWnd  *pParent       /*=NULL*/ )
	: CDialog( CFileSmallDlg::IDD, pParent ),
	  m_strDlgTitle( pszTitle ),
	  m_strSelectedFile( pszStateFile ),
	  m_bFoldersOnly( bFoldersOnly )
{
	//{{AFX_DATA_INIT(CFileSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void
CFileSmallDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CFileSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CFileSmallDlg message handlers

BOOL
CFileSmallDlg::
OnInitDialog()
{
	CRect rcDlg, rcCtrl;
	CWnd *pCtrl;

	CString	strDrive     = "?:\\";
	DWORD	dwDriveList  = ::GetLogicalDrives();
	int     nPos         = 0;

	TV_ITEM			tvRoot;
	TV_INSERTSTRUCT tvInstruct;
	HIMAGELIST      hImageList;
	SHFILEINFO		sfi;

	CDialog::OnInitDialog();
	
	m_pDriveTree = (CTreeCtrl *)GetDlgItem( IDC_FILESELECTOR_SMALL_TREE );
	ASSERT(m_pDriveTree);

	/* Attach system image-list (16x16) */
	if( hImageList = (HIMAGELIST)SHGetFileInfo( "C:\\",
		0, &sfi, sizeof(SHFILEINFO), SHGFI_SYSICONINDEX | SHGFI_SMALLICON ) )
	{
		m_pDriveTree->SendMessage( TVM_SETIMAGELIST, (WPARAM)TVSIL_NORMAL, (LPARAM)hImageList );
	}

	tvRoot.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_CHILDREN;

	while( dwDriveList )
	{
		if( dwDriveList & 1 )
		{
			strDrive.SetAt( 0, 0x41 + nPos );
			SHGetFileInfo( strDrive, 0, &sfi, sizeof(sfi), SHGFI_SYSICONINDEX );

			tvRoot.pszText   = (LPSTR)(LPCTSTR)strDrive;
			tvRoot.cChildren = strDrive.GetAt( 0 ) < 'C' ? 1 : (CheckButtonState( strDrive ) ? 1 : 0);
			tvRoot.iImage    = tvRoot.iSelectedImage = sfi.iIcon;

			tvInstruct.hParent		= TVI_ROOT;
			tvInstruct.hInsertAfter	= TVI_LAST;
			tvInstruct.item			= tvRoot;

			m_pDriveTree->InsertItem( &tvInstruct );
		}
		dwDriveList >>= 1;
		nPos++;
	}

	/* Get data for repositioning routine */
	GetClientRect( rcDlg );

	pCtrl = GetDlgItem( IDC_FILESELECTOR_SMALL_TREE );
	if( pCtrl )
	{
		pCtrl->GetWindowRect( rcCtrl );
		ScreenToClient( rcCtrl );
		m_nTreeYSub = rcDlg.bottom - rcCtrl.bottom + rcCtrl.top;
		m_nTreeXSub = rcDlg.right - rcCtrl.right + rcCtrl.left;
	}
	pCtrl = GetDlgItem( IDOK );
	if( pCtrl )
	{
		pCtrl->GetWindowRect( rcCtrl );
		ScreenToClient( rcCtrl );
		m_nOkYSub = rcDlg.bottom - rcCtrl.top;
		m_nOkXSub = rcDlg.right - rcCtrl.left;
	}
	pCtrl = GetDlgItem( IDCANCEL );
	if( pCtrl )
	{
		pCtrl->GetWindowRect( rcCtrl );
		ScreenToClient( rcCtrl );
		m_nCancelYSub = rcDlg.bottom - rcCtrl.top;
		m_nCancelXSub = rcDlg.right - rcCtrl.left;
	}
	/* The dialog template is very small because dialog's size
	   could be resized before showing on the screen in other way.
       That's why we have to enlarge dialog window size here. */
	SetWindowPos( NULL, 0, 0, rcDlg.Width() + 100, rcDlg.Height() + 100, SWP_NOMOVE );

	if( m_strDlgTitle.IsEmpty() )
		m_strDlgTitle = m_bFoldersOnly ? "Select folder" : "Select file";
	SetWindowText( m_strDlgTitle );

	SetNodeFromPath( m_strSelectedFile );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CFileSmallDlg::
OnSize( UINT nType,
		int  cx,
		int  cy )
{
	CDialog::OnSize( nType, cx, cy );

	CWnd *pCtrl = GetDlgItem( IDC_FILESELECTOR_SMALL_TREE );
	if( pCtrl )
	{
		pCtrl->SetWindowPos( NULL,
			0, 0,
			cx - m_nTreeXSub,
			cy - m_nTreeYSub,
			SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );
	}
	pCtrl = GetDlgItem( IDOK );
	if( pCtrl )
	{
		pCtrl->SetWindowPos( NULL,
			cx - m_nOkXSub,
			cy - m_nOkYSub,
			0, 0,
			SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	}
	pCtrl = GetDlgItem( IDCANCEL );
	if( pCtrl )
	{
		pCtrl->SetWindowPos( NULL,
			cx - m_nCancelXSub,
			cy - m_nCancelYSub,
			0, 0,
			SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOCOPYBITS );
	}
}

static
int
CALLBACK
TreeViewCompareProc( LPARAM lParam1,
					 LPARAM lParam2,
					 LPARAM lParamSort )
{
	if( lParam1 && !lParam2 )
		return -1;
	if( !lParam1 && lParam2 )
		return  1;
	return 0;
}

void
CFileSmallDlg::
OnItemExpanding( NMHDR   *pNMHDR,
				 LRESULT *pResult )
{
	NM_TREEVIEW *pNMTreeView = (NM_TREEVIEW *)pNMHDR;

	HTREEITEM hExpItem = pNMTreeView->itemNew.hItem;
	CString   strPath  = GetPathFromNode( hExpItem );

	*pResult = 0;

	if( TVE_EXPAND == pNMTreeView->action )
	{
		DeleteFirstChild( hExpItem );
		if( AddDirectories( hExpItem, strPath ) != 0 )
		{
			/* Sort the items in the tree view control */
			/* First we have to sort all items in alphabetical order */
			m_pDriveTree->SortChildren( hExpItem );
			/* Then we want to move folders onto the top of the tree */
			if( !m_bFoldersOnly )
			{
				TV_SORTCB tvscb;
				tvscb.hParent     = hExpItem;
				tvscb.lParam      = 0;
				tvscb.lpfnCompare = TreeViewCompareProc;

				m_pDriveTree->SortChildrenCB( &tvscb );
			}
		}
		else
			*pResult = 1;
	}
	else
	{
		DeleteAllChildren( hExpItem );
		/* Show "plus" button */
		m_pDriveTree->InsertItem( "", NULL, NULL, hExpItem );
	}
}

CString
CFileSmallDlg::
GetPathFromNode( HTREEITEM hItem )
{
	CString strResult = m_pDriveTree->GetItemText( hItem );
	HTREEITEM hParent;

	while( NULL != (hParent = m_pDriveTree->GetParentItem( hItem )) )
	{
		CString strPath = m_pDriveTree->GetItemText( hParent );
		if( strPath.Right( 1 ) != "\\" )
			strPath += "\\";
		strResult = strPath + strResult;
		hItem = hParent;
	}
	return strResult;
}

HTREEITEM
CFileSmallDlg::
SetNodeFromPath( CString& strPath )
{
	char szNode[ MAX_PATH ];
	char szPath[ MAX_PATH ];

	HTREEITEM hResult = m_pDriveTree->GetNextItem( NULL, TVGN_ROOT );
	int i = 0, j = 0;

	while( hResult )
	{
		for( j = 0; i < strPath.GetLength() && strPath.GetAt( i ) != '\\'; i++, j++ )
			szPath[ i ] = szNode[ j ] = strPath.GetAt( i );

		szPath[ i++ ] = '\\';
		szNode[ j ] = '\0';
		/* Add ending backslash to drive name */
		if( strlen( szNode ) == 2 && szNode[ 1 ] == ':' )
			strcat( szNode, "\\" );

		while( hResult )
		{
			if( (m_pDriveTree->GetItemText( hResult )).CompareNoCase( szNode ) == 0 )
			{
				m_pDriveTree->SelectItem( hResult );
				if( m_pDriveTree->Expand( hResult, TVE_EXPAND ) )
				{
					hResult = m_pDriveTree->GetNextItem( hResult, TVGN_CHILD );
					break;
				}
				else
					hResult = NULL;
			}
			else
				hResult = m_pDriveTree->GetNextItem( hResult, TVGN_NEXT );
		}
	}
	return hResult;
}

void
CFileSmallDlg::
DeleteFirstChild( HTREEITEM hParent )
{
	HTREEITEM hItem;
	if( NULL != (hItem = m_pDriveTree->GetChildItem( hParent )) )
		m_pDriveTree->DeleteItem( hItem );
}

void
CFileSmallDlg::
DeleteAllChildren( HTREEITEM hParent )
{
	HTREEITEM hItem;
	HTREEITEM hNextItem;

	if( NULL == (hItem = m_pDriveTree->GetChildItem( hParent )) )
		return;
	do
	{
		hNextItem = m_pDriveTree->GetNextSiblingItem( hItem );
		m_pDriveTree->DeleteItem( hItem );
		hItem = hNextItem;
	}
	while( hItem );
}

BOOL
CFileSmallDlg::
CheckButtonState( CString &strPath )
{
	CString strPattern = strPath;

	WIN32_FIND_DATA fileData;
	HANDLE hFile;

	if( strPattern.Right( 1 ) != "\\" )
		strPattern += "\\";
	strPattern += "*.*";

	hFile = ::FindFirstFile( (LPCSTR)strPattern, &fileData );

	while( INVALID_HANDLE_VALUE != hFile )
	{
		if( !(fileData.dwFileAttributes & (FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM)) &&
			(!m_bFoldersOnly || (m_bFoldersOnly && fileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) &&
			*fileData.cFileName != '.' )
		{
			::FindClose( hFile );
			return TRUE;
		}
		/* Try to find a next file */
		if( !::FindNextFile( hFile, &fileData ) )//&& (GetLastError() == ERROR_NO_MORE_FILES) )
		{
			::FindClose( hFile );
			hFile = INVALID_HANDLE_VALUE; /* Ending the loop */
		}
	}
	return FALSE;
}

int
CFileSmallDlg::
AddDirectories( HTREEITEM hItem,
				CString   &strPath )
{
	CString strPattern = strPath;

	int	 nCount    =  0;
	int  nDefItem  = -1;
	int  nOpenItem = -1;
	BOOL bFolder;

	TV_ITEM			tvItem;
	TV_INSERTSTRUCT tvInstruct;
	SHFILEINFO		sfi;

	WIN32_FIND_DATA fileData;
	HANDLE hFile;

	if( strPattern.Right( 1 ) != "\\" )
		strPattern += "\\";
	strPattern += "*.*";
	
	if( (hFile = ::FindFirstFile( (LPCSTR)strPattern, &fileData )) == INVALID_HANDLE_VALUE )
		return 0;

	do 
	{
		bFolder = fileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY;

		if( !(fileData.dwFileAttributes & (FILE_ATTRIBUTE_HIDDEN | FILE_ATTRIBUTE_SYSTEM)) &&
			(!m_bFoldersOnly || (m_bFoldersOnly && bFolder)) &&
			*fileData.cFileName != '.' )
		{
			CString	strNewPath = strPath;
			if( strNewPath.Right( 1 ) != "\\" )
				strNewPath += "\\";
			strNewPath += (LPCSTR)&fileData.cFileName;

			tvItem.mask = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;
			if( bFolder )
			{
				tvItem.cChildren = CheckButtonState( strNewPath ) ? 1 : 0;
				tvItem.mask     |= TVIF_CHILDREN;

				SHGetFileInfo( strNewPath, 0, &sfi, sizeof(SHFILEINFO), SHGFI_SYSICONINDEX | SHGFI_OPENICON );
				nOpenItem = sfi.iIcon;
			}
			SHGetFileInfo( strNewPath, 0, &sfi, sizeof(SHFILEINFO), SHGFI_SYSICONINDEX );
			nDefItem = sfi.iIcon;

			tvItem.pszText        = fileData.cFileName;
			tvItem.iImage         = nDefItem;
			tvItem.iSelectedImage = bFolder ? nOpenItem : nDefItem;
			tvItem.lParam         = bFolder; /* We need this for sorting the items */

			tvInstruct.hParent		= hItem;
			tvInstruct.hInsertAfter	= TVI_LAST;
			tvInstruct.item			= tvItem;

			m_pDriveTree->InsertItem( &tvInstruct );
			nCount++;
		}
	}
	while( ::FindNextFile( hFile, &fileData ) );

	::FindClose( hFile );
	return nCount;
}

CString
CFileSmallDlg::
GetPathName( void )
{
	return m_strSelectedFile;
}

void
CFileSmallDlg::
OnDblclkTree( NMHDR   *pNMHDR,
			  LRESULT *pResult )
{
	if( !m_bFoldersOnly )
	{
		HTREEITEM hDblItem = m_pDriveTree->GetSelectedItem();
		if( !m_pDriveTree->GetItemData( hDblItem ) ) /* If the 'file' item was double-clicked */
			OnOK();
		*pResult = 1;
	}	
	*pResult = 0;
}

void
CFileSmallDlg::
OnOK()
{
	HTREEITEM hItem = m_pDriveTree->GetSelectedItem();

	if( hItem )
		m_strSelectedFile = GetPathFromNode( hItem );

	CDialog::OnOK();
}
