/****************************************************************************
File    : GraphicsAdvDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CGraphicsAdvDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 17.09.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "GraphicsDlg.h"
#include "Helpers.h"
#include "GraphicsAdvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IDC_GRAPHICSADV_FIRST		IDC_GRAPHICSADV_PRIMARY
#define IDC_GRAPHICSADV_LAST		IDC_GRAPHICSADV_CANCEL


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsAdvDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsAdvDlg)
	ON_BN_CLICKED(IDC_GRAPHICSADV_PRIMARY, OnPrimary)
	ON_BN_CLICKED(IDC_GRAPHICSADV_WAITVBL, OnWaitVbl)
	ON_BN_CLICKED(IDC_GRAPHICSADV_FLIP, OnFlip)
	ON_BN_CLICKED(IDC_GRAPHICSADV_SYNCBLIT, OnSyncBlit)
	ON_BN_CLICKED(IDC_GRAPHICSADV_LOCALMEM, OnLocalMem)
	ON_CBN_SELCHANGE(IDC_GRAPHICSADV_BLITEFFECTS, OnSelchangeBlitEffects)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_GRAPHICSADV_OK, OnOK)
	ON_BN_CLICKED(IDC_GRAPHICSADV_CANCEL, CDialog::OnCancel)
END_MESSAGE_MAP()

/*========================================================
Method   : CGraphicsAdvDlg::CGraphicsAdvDlg
=========================================================*/
/* #FN#
   Standard constructor */
CGraphicsAdvDlg::
CGraphicsAdvDlg( ULONG *pScreenMode /*=NULL*/, /* #IN# Pointer to screen mode flags */
				 CWnd  *pParent /*=NULL*/      /* #IN# Pointer to the parent window */ )
	: CDialog( CGraphicsAdvDlg::IDD, pParent ),
	  m_ulScreenMode( 0L )
{
	//{{AFX_DATA_INIT(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	if( m_pScreenMode = pScreenMode )
		m_ulScreenMode = *m_pScreenMode;
} /* #OF# CGraphicsAdvDlg::CGraphicsAdvDlg */

/*========================================================
Method   : CGraphicsAdvDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
CGraphicsAdvDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CGraphicsAdvDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg implementation

/*========================================================
Method   : CGraphicsAdvDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
SetDlgState()
{
	CComboBox *pCombo  = NULL;
	ULONG      ulIndex = (m_ulScreenMode >> 28) & 0x0f; 

	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDVBL_WAIT) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDBLT_WAIT) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_LOCALMEM );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_VIDEOMEM) != 0 );

	pButton->EnableWindow( !(m_ulScreenMode & SM_OPTN_FLIP_BUFFERS) );

	CheckRadioButton( IDC_GRAPHICSADV_PRIMARY, IDC_GRAPHICSADV_FLIP,
		m_ulScreenMode & SM_OPTN_FLIP_BUFFERS ?
		IDC_GRAPHICSADV_FLIP : IDC_GRAPHICSADV_PRIMARY );
	
	pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_BLITEFFECTS );
	ASSERT(pCombo);
	for( int i = 0; i < BLIT_EFFECTS_NO; i++ )
		if( ulIndex & (1 << i) )
		{
			pCombo->SetCurSel( i + 1 );
			break;
		}
	if( i == BLIT_EFFECTS_NO )
		pCombo->SetCurSel( 0 );
} /* #OF# CGraphicsAdvDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg message handlers

/*========================================================
Method   : CGraphicsAdvDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CGraphicsAdvDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	/* Unfortunately, the context help is available only in windowed modes */
	if( g_ulScreenMode & SM_MODE_WIND )
		SetWindowLong( GetSafeHwnd(), GWL_EXSTYLE, WS_EX_CONTEXTHELP | GetWindowLong( GetSafeHwnd(), GWL_EXSTYLE ) );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CGraphicsAdvDlg::OnInitDialog */

/*========================================================
Method   : CGraphicsAdvDlg::OnPrimary
=========================================================*/
/* #FN#
   Turns the Flipped Buffers off */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnPrimary()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_LOCALMEM );
	ASSERT(pButton);
	pButton->EnableWindow( TRUE );

	m_ulScreenMode &= ~SM_OPTN_FLIP_BUFFERS;
} /* #OF# CGraphicsAdvDlg::OnPrimary */

/*========================================================
Method   : CGraphicsAdvDlg::OnFlip
=========================================================*/
/* #FN#
   Turns the Flipped Buffers on */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnFlip()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_LOCALMEM );
	ASSERT(pButton);
	pButton->EnableWindow( FALSE );

	m_ulScreenMode |= SM_OPTN_FLIP_BUFFERS;
} /* #OF# CGraphicsAdvDlg::OnFlip */

/*========================================================
Method   : CGraphicsAdvDlg::OnWaitVbl
=========================================================*/
/* #FN#
   Turns on/off the Wait for VBI flag */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnWaitVbl()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);

	int nCheckState = pButton->GetCheck();
	if( nCheckState && !(g_ulDontShowFlags & DONT_SHOW_VBLWAIT_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg dlgWarning;

		LoadString( NULL, IDS_WARNING_VBL_WAIT, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_VBLWAIT_WARN;
		dlgWarning.m_bCancel     = FALSE;
		dlgWarning.DoModal();
	}
	if( nCheckState )
		m_ulScreenMode |= SM_OPTN_DDVBL_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDVBL_WAIT;
} /* #OF# CGraphicsAdvDlg::OnWaitVbl */

/*========================================================
Method   : CGraphicsAdvDlg::OnSyncBlit
=========================================================*/
/* #FN#
   Turns on/off the Synchronous Blits flag */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSyncBlit()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_DDBLT_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDBLT_WAIT;
} /* #OF# CGraphicsAdvDlg::OnSyncBlit */

/*========================================================
Method   : CGraphicsAdvDlg::OnLocalMem
=========================================================*/
/* #FN#
   Turns on/off AGP memory for DDraw offscreen surfaces */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnLocalMem()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_LOCALMEM );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_USE_VIDEOMEM;
	else
		m_ulScreenMode &= ~SM_OPTN_USE_VIDEOMEM;
} /* #OF# CGraphicsAdvDlg::OnLocalMem */

void
CGraphicsAdvDlg::
OnSelchangeBlitEffects()
{
	DWORD dwSMFxFlags[ BLIT_EFFECTS_NO ] = {
		SM_DDFX_MIRRORLEFTRIGHT,
		SM_DDFX_MIRRORUPDOWN,
		SM_DDFX_NOTEARING };

	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_GRAPHICSADV_BLITEFFECTS );
	ASSERT(pCombo);
	int nSelection = pCombo->GetCurSel();

	if( CB_ERR == nSelection )
		return;

	m_ulScreenMode &= ~SM_DDFX_MASK;
	if( nSelection > 0 )
	{
		m_ulScreenMode |= dwSMFxFlags[ nSelection - 1 ];
	}
}

/*========================================================
Method   : CGraphicsAdvDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnOK()
{
	if( m_ulScreenMode != *m_pScreenMode )
	{
		*m_pScreenMode = m_ulScreenMode;
	}
	CDialog::OnOK();
} /* #OF# CGraphicsAdvDlg::OnOK */

BOOL
CGraphicsAdvDlg::
OnHelpInfo( HELPINFO *pHelpInfo )
{
	if( g_ulScreenMode & SM_MODE_WIND )
		HelpInfo( pHelpInfo,
				  GetSafeHwnd(),
				  IDD_GRAPHICSADV,
				  IDC_GRAPHICSADV_FIRST, IDC_GRAPHICSADV_LAST );

	return TRUE; //CDialog::OnHelpInfo(pHelpInfo);
}
