/****************************************************************************
File    : WarningDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CWarningDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 26.06.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CWarningDlg dialog

BEGIN_MESSAGE_MAP(CWarningDlg, CDialog)
	//{{AFX_MSG_MAP(CWarningDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CWarningDlg::CWarningDlg
=========================================================*/
/* #FN#
   Standard constructor */
CWarningDlg::
CWarningDlg( CWnd* pParent /*=NULL*/ /* #IN# Pointer to the parent window */ )
	: CDialog( CWarningDlg::IDD, pParent ),
	  m_bCancel( TRUE )
{
	//{{AFX_DATA_INIT(CWarningDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CWarningDlg::CWarningDlg */

/*========================================================
Method   : CWarningDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CWarningDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CWarningDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CWarningDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CWarningDlg message handlers

/*========================================================
Method   : CWarningDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CWarningDlg::
OnInitDialog()
{
	CButton *pCancel;

	CDialog::OnInitDialog();

	if( m_strWarnText.IsEmpty() )
		m_strWarnText = "This was supposed to be a warning";

	SetDlgItemText( IDC_WARNING_TEXT, m_strWarnText );

	pCancel = (CButton *)GetDlgItem( IDCANCEL );
	pCancel->EnableWindow( m_bCancel );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CWarningDlg::OnInitDialog */

/*========================================================
Method   : CWarningDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CWarningDlg::
OnOK()
{
	CButton *pButton;
	
	pButton = (CButton *)GetDlgItem( IDC_WARNING_NOSHOW );
	if( pButton->GetCheck() )
	{
		g_ulDontShowFlags |= m_ulWarnBit;
		WriteRegDWORD( NULL, REG_DONT_SHOW, g_ulDontShowFlags );
	}
	CDialog::OnOK();
} /* #OF# CWarningDlg::OnOK */
