/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// CFileSmallDlg.cpp : implementation file
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "FileSmallDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileSmallDlg dialog


CFileSmallDlg::CFileSmallDlg(LPCTSTR pszStateFile, CWnd* pParent /*=NULL*/)
	: CDialog(CFileSmallDlg::IDD, pParent),
	  selectedFile( pszStateFile )
{
	//{{AFX_DATA_INIT(CFileSmallDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CFileSmallDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileSmallDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileSmallDlg, CDialog)
	//{{AFX_MSG_MAP(CFileSmallDlg)
	ON_NOTIFY(TVN_ITEMEXPANDING, IDC_FILESELECTOR_SMALL_TREE, OnItemExpanding)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileSmallDlg message handlers

BOOL CFileSmallDlg::OnInitDialog()
{
	CString	strDrive = "?:\\";
	int nPos = 0, nDrivesAdded = 0;
	DWORD	dwDriveList = ::GetLogicalDrives();
	TV_ITEM	Item;
	HTREEITEM  hItem;

	CDialog::OnInitDialog();
	
	pDrive = (CTreeCtrl *)GetDlgItem( IDC_FILESELECTOR_SMALL_TREE );
	if( !pDrive )
		return FALSE;

	Item.mask = TVIF_CHILDREN;
	Item.cChildren = 1;
	while( dwDriveList )
	{
		if( dwDriveList & 1 )
		{
			strDrive.SetAt( 0, 0x41 + nPos );
			hItem = pDrive->InsertItem( strDrive, TVI_ROOT, TVI_LAST );
			pDrive->InsertItem( "", NULL, NULL, hItem );
		}
		dwDriveList >>= 1;
		nPos++;
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileSmallDlg::OnItemExpanding(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	HTREEITEM hItem = pNMTreeView->itemNew.hItem;
	CString tmpStr = GetPathFromNode( hItem );

	*pResult = FALSE;

	if( pNMTreeView->action == TVE_EXPAND )
	{
		DeleteFirstChild( hItem );
		if( AddDirectories( hItem, tmpStr)==0 )
			*pResult = TRUE;
		else
			pDrive->SortChildren( hItem );
	}
	else
	{
		DeleteAllChildren( hItem );
		if( pDrive->GetParentItem( hItem )==NULL )
			pDrive->InsertItem( "", NULL, NULL, hItem );
		else
			SetButtonState( hItem, tmpStr );
	}
}

CString	CFileSmallDlg::GetPathFromNode( HTREEITEM hItem )
{
	CString strResult = pDrive->GetItemText( hItem );

	HTREEITEM hParent;

	while( (hParent = pDrive->GetParentItem( hItem ))!=NULL )
	{
		CString tmpStr = pDrive->GetItemText( hParent );
		if( tmpStr.Right(1)!="\\")
			tmpStr+="\\";
		strResult = tmpStr + strResult;
		hItem = hParent;
	}
	return strResult;
}

void	CFileSmallDlg::DeleteFirstChild( HTREEITEM hParent )
{
	HTREEITEM	hItem;
	if( (hItem = pDrive->GetChildItem( hParent))!=NULL )
		pDrive->DeleteItem( hItem );
}

void	CFileSmallDlg::DeleteAllChildren( HTREEITEM hParent )
{
	HTREEITEM	hItem;
	if( (hItem = pDrive->GetChildItem( hParent))==NULL )
		return;

	do
	{
		HTREEITEM hNextItem = pDrive->GetNextSiblingItem( hItem );
		pDrive->DeleteItem( hItem );
		hItem = hNextItem;
	} while( hItem != NULL );
}

BOOL	CFileSmallDlg::SetButtonState( HTREEITEM hItem, CString &strPath )
{
	HANDLE	hFind;
	WIN32_FIND_DATA	fd;
	CString	 tmpStr = strPath;

	if( tmpStr.Right(1)!="\\" )
		tmpStr+="\\";
	tmpStr+="*.*";

	if( (hFind = ::FindFirstFile( (LPCSTR)tmpStr, &fd)) == INVALID_HANDLE_VALUE )
	{
		::FindClose( hFind );
		return FALSE;
	}

	::FindClose( hFind );
	if( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
	{
		pDrive->InsertItem( "", NULL, NULL, hItem );
		return TRUE;
	}

	return FALSE;
}

int	CFileSmallDlg::AddDirectories( HTREEITEM hItem, CString &strPath )
{
	HANDLE	hFind;
	WIN32_FIND_DATA	fd;
	HTREEITEM	hNewItem;
	int	nCount = 0;
	CString	 tmpStr = strPath;

	if( tmpStr.Right(1)!="\\" )
		tmpStr+="\\";
	tmpStr+="*.*";
	
	if( (hFind = ::FindFirstFile( (LPCSTR)tmpStr, &fd)) == INVALID_HANDLE_VALUE )
	{
		if( pDrive->GetParentItem( hItem )==NULL )
			pDrive->InsertItem( "", NULL, NULL, hItem );
		return 0;
	}

	do 
	{
		if( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
		{
			CString strCmp = (LPCSTR) &fd.cFileName;
			if( strCmp!="." && strCmp !=".." )
			{
				hNewItem = pDrive->InsertItem( (LPCSTR)&fd.cFileName, NULL, NULL, hItem );
				CString	strNewPath = strPath;
				if( strNewPath.Right(1) != "\\" )
					strNewPath += "\\";

				strNewPath += (LPCSTR) &fd.cFileName;
				SetButtonState( hNewItem, strNewPath );
			}
		}
		else
		{
			pDrive->InsertItem( (LPCSTR)&fd.cFileName, NULL, NULL, hItem );
		}
		nCount++;
	} while( ::FindNextFile( hFind, &fd ));

	::FindClose( hFind );
	return nCount;
}

void CFileSmallDlg::OnOK() 
{
	HTREEITEM	hItem = pDrive->GetSelectedItem();

	CDialog::OnOK();
	
	if( hItem )
		selectedFile = GetPathFromNode( hItem );
}

CString CFileSmallDlg::GetPathName( void )
{
	return selectedFile;
}
