/****************************************************************************
File    : GraphicsDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CGraphicsDlg implementation file
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 16.04.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "GraphicsAdvDlg.h"
#include "GraphicsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CGraphicsDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsDlg)
	ON_BN_CLICKED(IDC_GRAPHICS_320X200CLIP, OnMode320x200Clip)
	ON_BN_CLICKED(IDC_GRAPHICS_320X240PARTCLIP, OnMode320x240PartClip)
	ON_BN_CLICKED(IDC_GRAPHICS_512X384, OnMode512x384)
	ON_BN_CLICKED(IDC_GRAPHICS_640X400CLIP, OnMode640x400Clip)
	ON_BN_CLICKED(IDC_GRAPHICS_640X480PARTCLIP, OnMode640x480PartClip)
	ON_BN_CLICKED(IDC_GRAPHICS_800X600, OnMode800x600)
	ON_BN_CLICKED(IDC_GRAPHICS_1024X768, OnMode1024x768)
	ON_BN_CLICKED(IDC_GRAPHICS_384X240WINDOWED, On384x240Windowed)
	ON_BN_CLICKED(IDC_GRAPHICS_768X480WINDOWED, On768x480Windowed)
	ON_BN_CLICKED(IDC_GRAPHICS_NODIRECTDRAW, OnNodirectDraw)
	ON_BN_CLICKED(IDC_GRAPHICS_SHOWSCANLINES, OnShowScanlines)
	ON_BN_CLICKED(IDC_GRAPHICS_ADVSETTING, OnAdvSetting)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CGraphicsDlg::CGraphicsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CGraphicsDlg::
CGraphicsDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CGraphicsDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CGraphicsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CGraphicsDlg::CGraphicsDlg */

/*========================================================
Method   : CGraphicsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CGraphicsDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CGraphicsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CFileAssociationsDlg implementation

/*========================================================
Method   : CGraphicsDlg::SetButtonState
=========================================================*/
/* #FN#
   Sets pointed radio button state */
BOOL
/* #AS#
   Always TRUE */
CGraphicsDlg::
SetButtonState( ULONG ulButtonID, /* #IN# Button resource ID */
			    ULONG ulModeFlag, /* #IN# Available modes    */
				ULONG ulFResFlag  /* #IN# DirectDraw flags   */ )
{
	CButton *pButton = (CButton *)GetDlgItem( ulButtonID );
	ASSERT(pButton);
	pButton->EnableWindow( (g_ulModesAvail & ulModeFlag) != 0 );
	pButton->SetCheck( m_ulScreenMode & ulFResFlag && m_ulScreenMode & SM_MODE_FULL );

	return TRUE;
} /* #OF# CGraphicsDlg::SetButtonState */

/*========================================================
Method   : CGraphicsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets dialog state and graphics mode description */
void
/* #AS#
   Nothing */
CGraphicsDlg::
SetDlgState()
{
	char szMessage[ LOADSTRING_STRING_SIZE ];
	CStatic *pIconDisp = (CStatic *)GetDlgItem( IDC_GRAPHICS_ICON );
	HANDLE	 hIcon     = NULL;
	CButton *pButton   = NULL;

	memset( szMessage, 0, LOADSTRING_STRING_SIZE );
	
	pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_NODIRECTDRAW );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_GDI) != 0 );

	SetButtonState( IDC_GRAPHICS_1024X768,        MODE_1024_768, SM_FRES_1024_768 );
	SetButtonState( IDC_GRAPHICS_800X600,         MODE_800_600,  SM_FRES_800_600  );
	SetButtonState( IDC_GRAPHICS_640X480PARTCLIP, MODE_640_480,  SM_FRES_640_480  );
	SetButtonState( IDC_GRAPHICS_640X400CLIP,     MODE_640_400,  SM_FRES_640_400  );
	SetButtonState( IDC_GRAPHICS_512X384,         MODE_512_384,  SM_FRES_512_384  );
	SetButtonState( IDC_GRAPHICS_320X240PARTCLIP, MODE_320_240,  SM_FRES_320_240  );
	SetButtonState( IDC_GRAPHICS_320X200CLIP,     MODE_320_200,  SM_FRES_320_200  );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_SHOWSCANLINES );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_SHOW_SCANLINES) != 0 );

	if( m_ulScreenMode & SM_MODE_WIND )
	{
		/* Windowed modes are always full overscan */
		hIcon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );

		/* Fill in appropriate description */
		if( m_ulScreenMode & SM_OPTN_USE_GDI )
			LoadString( NULL, IDS_MODE_NODIRECTDRAW_DESC, szMessage, LOADSTRING_STRING_SIZE );
		else
			LoadString( NULL, IDS_MODE_DIRECTDRAW_WINDOWED, szMessage, LOADSTRING_STRING_SIZE );

		pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_384X240WINDOWED );
		ASSERT(pButton);
		pButton->SetCheck( (m_ulScreenMode & SM_WRES_NORMAL) != 0 );

		pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_768X480WINDOWED );
		ASSERT(pButton);
		pButton->SetCheck( (m_ulScreenMode & SM_WRES_STRETCH) != 0 );
	}
	else
	{
		pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_384X240WINDOWED );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
	
		pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_768X480WINDOWED );
		ASSERT(pButton);
		pButton->SetCheck( 0 );

		/* The default full overscan icon */
		hIcon = AfxGetApp()->LoadIcon( IDI_FULL_OVERSCAN );

		/* Load the appropriate overscan icon indicator, description,
		   and check the right button */
		if( m_ulScreenMode & SM_FRES_320_200 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			LoadString( NULL, IDS_MODE_320_200_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
		if( m_ulScreenMode & SM_FRES_320_240 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			LoadString( NULL, IDS_MODE_320_240_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
		if( m_ulScreenMode & SM_FRES_512_384 )
		{
			LoadString( NULL, IDS_MODE_512_384_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
		if( m_ulScreenMode & SM_FRES_640_400 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_NO_OVERSCAN );
			LoadString( NULL, IDS_MODE_640_400_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
		if( m_ulScreenMode & SM_FRES_640_480 )
		{
			hIcon = AfxGetApp()->LoadIcon( IDI_VERT_OVERSCAN );
			LoadString( NULL, IDS_MODE_640_480_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
		if( m_ulScreenMode & SM_FRES_800_600 )
		{
			LoadString( NULL, IDS_MODE_800_600_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
		if( m_ulScreenMode & SM_FRES_1024_768 )
		{
			LoadString( NULL, IDS_MODE_1024_768_DESC, szMessage, LOADSTRING_STRING_SIZE );
		}
	}
	SetDlgItemText( IDC_GRAPHICS_DESCRIPTION, szMessage );

	if( hIcon && pIconDisp )
		pIconDisp->SetIcon( (HICON)hIcon );
} /* #OF# CGraphicsDlg::SetDlgState */

/*========================================================
Method   : CGraphicsDlg::SetFullMode
=========================================================*/
/* #FN#
   Sets virtual machine to full mode graphics */
void
/* #AS#
   Nothing */
CGraphicsDlg::
SetFullMode( ULONG ulFullModeRes /* #IN# Display resolution */ )
{
	m_ulScreenMode &= ~(SM_FRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= ulFullModeRes | SM_MODE_FULL;

	SetDlgState();
} /* #OF# CGraphicsDlg::SetFullMode */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsDlg message handlers

/*========================================================
Method   : CGraphicsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CGraphicsDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	m_ulScreenMode = g_ulScreenMode;

	SetDlgState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CGraphicsDlg::OnInitDialog */

/*========================================================
Method   : CGraphicsDlg::OnMode320x200Clip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 320x200 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode320x200Clip() 
{
	/* There is a strange problem with messages routing during the dialog
	   navigation using keyboard. That's equally strange solving: */
	static BOOL bWarning = FALSE;
	if( bWarning )
		return;

	if( !(g_ulDontShowFlags & DONT_SHOW_MENU_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		bWarning = TRUE;
		LoadString( NULL, IDS_WARNING_NO_MENU, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_MENU_WARN;
		dlgWarning.m_bCancel     = FALSE;
		dlgWarning.DoModal();
	}
	SetFullMode( SM_FRES_320_200 );

	bWarning = FALSE;
} /* #OF# CGraphicsDlg::OnMode320x200Clip */


/*========================================================
Method   : CGraphicsDlg::OnMode320x240Partclip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 320x240 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode320x240PartClip()
{
	SetFullMode( SM_FRES_320_240 );
} /* #OF# CGraphicsDlg::OnMode320x240Partclip */

/*========================================================
Method   : CGraphicsDlg::OnMode512x384
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 512x384 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode512x384()
{
	SetFullMode( SM_FRES_512_384 );
} /* #OF# CGraphicsDlg::OnMode512x384 */

/*========================================================
Method   : CGraphicsDlg::OnMode640x400Clip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 640x400 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode640x400Clip()
{
	/* There is a strange problem with messages routing during the dialog
	   navigation using keyboard. That's strange solving: */
	static BOOL bWarning = FALSE;
	if( bWarning )
		return;

	if( !(g_ulDontShowFlags & DONT_SHOW_MENU_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		bWarning = TRUE;
		LoadString( NULL, IDS_WARNING_NO_MENU, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_MENU_WARN;
		dlgWarning.m_bCancel     = FALSE;
		dlgWarning.DoModal();
	}
	SetFullMode( SM_FRES_640_400 );

	bWarning = FALSE;
} /* #OF# CGraphicsDlg::OnMode640x400Clip */

/*========================================================
Method   : CGraphicsDlg::OnMode640x480PartClip
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 640x480 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode640x480PartClip()
{
	SetFullMode( SM_FRES_640_480 );
} /* #OF# CGraphicsDlg::OnMode640x480PartClip */

/*========================================================
Method   : CGraphicsDlg::OnMode800x600
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 800x600 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode800x600()
{
	SetFullMode( SM_FRES_800_600 );
} /* #OF# CGraphicsDlg::OnMode800x600 */

/*========================================================
Method   : CGraphicsDlg::OnMode1024x768
=========================================================*/
/* #FN#
   Sets DirectDraw full mode 1024x768 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnMode1024x768()
{
	SetFullMode( SM_FRES_1024_768 );
} /* #OF# CGraphicsDlg::OnMode1024x768 */

/*========================================================
Method   : CGraphicsDlg::On384x240Windowed
=========================================================*/
/* #FN#
   Sets DirectDraw windowed mode 384x240 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
On384x240Windowed() 
{
	m_ulScreenMode &= ~(SM_WRES_MASK | SM_MODE_MASK);
	m_ulScreenMode |= SM_WRES_NORMAL | SM_MODE_WIND;

	SetDlgState();
} /* #OF# CGraphicsDlg::On384x240Windowed */

/*========================================================
Method   : CGraphicsDlg::On768x480Windowed
=========================================================*/
/* #FN#
   Sets DirectDraw windowed mode 768x480 */
void
/* #AS#
   Nothing */
CGraphicsDlg::
On768x480Windowed() 
{
	/* There is a strange problem with messages routing during the dialog
	   navigation using keyboard. That's strange solving: */
	static BOOL bWarning = FALSE;
	if( bWarning )
		return;

	int nResult = IDOK;
	if( !(g_ulDontShowFlags & DONT_SHOW_GRAPHICS_WARN) )
	{
		CWarningDlg dlgWarning;
		char szMessage[ LOADSTRING_STRING_SIZE ];

		bWarning = TRUE;
		LoadString( NULL, IDS_WARNING_GRAPHICS_WINDOW, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_GRAPHICS_WARN;
		nResult = dlgWarning.DoModal();
	}
	if( nResult == IDOK )
	{
		m_ulScreenMode &= ~(SM_WRES_MASK | SM_MODE_MASK);
		m_ulScreenMode |= SM_WRES_STRETCH | SM_MODE_WIND;
	}
	SetDlgState();

	bWarning = FALSE;
} /* #OF# CGraphicsDlg::On768x480Windowed */

/*========================================================
Method   : CGraphicsDlg::OnNodirectDraw
=========================================================*/
/* #FN#
   Turns on/off DirectDraw windowed mode */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnNodirectDraw()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_NODIRECTDRAW );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_USE_GDI;
	else
		m_ulScreenMode &= ~SM_OPTN_USE_GDI;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnNodirectDraw */

/*========================================================
Method   : CGraphicsDlg::OnShowScanlines
=========================================================*/
/* #FN#
   Turns on/off scan lines */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnShowScanlines() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICS_SHOWSCANLINES );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_SHOW_SCANLINES;
	else
		m_ulScreenMode &= ~SM_OPTN_SHOW_SCANLINES;

	SetDlgState();
} /* #OF# CGraphicsDlg::OnShowScanlines */

/*========================================================
Method   : CGraphicsDlg::OnAdvSetting
=========================================================*/
/* #FN#
   Displays "Advanced Graphics Options" dialog box */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnAdvSetting()
{
	CGraphicsAdvDlg dlgGraphicsAdv( &m_ulScreenMode, this );

	dlgGraphicsAdv.DoModal();
} /* #OF# CGraphicsDlg::OnAdvSetting */

/*========================================================
Method   : CGraphicsDlg::OnOK
=========================================================*/
/* #FN#
   Handles the pressing OK button event */
void
/* #AS#
   Nothing */
CGraphicsDlg::
OnOK() 
{
	if( m_ulScreenMode != g_ulScreenMode )
	{
		ULONG ulSavedMode = g_ulScreenMode;

		g_ulScreenMode = m_ulScreenMode;

		if( !InitialiseScreen( FALSE ) )
		{
			g_ulScreenMode = ulSavedMode;
			InitialiseScreen( FALSE );
		}
		WriteRegDWORD( NULL, REG_DDRAW_MODE, g_ulScreenMode );
	}
	CDialog::OnOK();
} /* #OF# CGraphicsDlg::OnOK */
