// PaletteDlg.cpp : implementation file
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "PaletteDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define PAL_ENTRIES_NO	256
#define PAL_BARS_NO		2
#define BAR_ENTRIES_NO	PAL_ENTRIES_NO / PAL_BARS_NO

/* Note: afxData.cxBorder and afxData.cyBorder aren't used anymore */
#define CX_BORDER   2
#define CY_BORDER   2

/////////////////////////////////////////////////////////////////////////////
// CPaletteDlg dialog


CPaletteDlg::
CPaletteDlg( CWnd *pParent /*=NULL*/ )
: CDialog( (g_ulScreenMode & SM_MODE_FULL ? IDD_PALETTE_SMALL : CPaletteDlg::IDD), pParent)
{
	//{{AFX_DATA_INIT(CPaletteDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CPaletteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPaletteDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPaletteDlg, CDialog)
	//{{AFX_MSG_MAP(CPaletteDlg)
	ON_BN_CLICKED(IDC_PALETTE_BROWSE, OnBrowse)
	ON_EN_KILLFOCUS(IDC_PALETTE_EDIT, OnKillfocusEdit)
	ON_BN_CLICKED(IDC_PALETTE_LOAD, OnLoad)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPaletteDlg message handlers

BOOL
CPaletteDlg::
OnInitDialog()
{
	CButton *pButton = NULL;

	CDialog::OnInitDialog();
	
	m_bSmallMode = g_ulScreenMode & SM_MODE_FULL;

	m_ulMiscStates = g_ulMiscStates;
	strncpy( m_szPaletteFile, g_szPaletteFile, MAX_PATH );
	
	SetDlgItemText( IDC_PALETTE_EDIT, m_szPaletteFile );

	pButton = (CButton *)GetDlgItem( IDC_PALETTE_LOAD );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulMiscStates & MS_USE_PALETTE) != 0 );

	if( !m_bSmallMode )
	{
		CWnd *pStatic = GetDlgItem( IDC_PALETTE_STATIC1 );
		ASSERT(pStatic);
		pStatic->GetWindowRect( m_rcPalBar1 ); ScreenToClient( m_rcPalBar1 );
		pStatic->SetWindowPos( NULL, 0, 0, (g_bLargeFonts ? 256 : 128) + 2 * CX_BORDER, m_rcPalBar1.Height(),
			SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );
		m_rcPalBar1.DeflateRect( CX_BORDER, CY_BORDER );

		pStatic = GetDlgItem( IDC_PALETTE_STATIC2 );
		ASSERT(pStatic);
		pStatic->GetWindowRect( m_rcPalBar2 ); ScreenToClient( m_rcPalBar2 );
		pStatic->SetWindowPos( NULL, 0, 0, (g_bLargeFonts ? 256 : 128) + 2 * CX_BORDER, m_rcPalBar2.Height(),
			SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );
		m_rcPalBar2.DeflateRect( CX_BORDER, CY_BORDER );
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CPaletteDlg::
OnLoad()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_PALETTE_LOAD );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_USE_PALETTE;
	else
		m_ulMiscStates &= ~MS_USE_PALETTE;
}

/*========================================================
Method   : CPaletteDlg::OnBrowsePalette
=========================================================*/
/* #FN#
   Allows to select palette file using FileDialog window */
void
/* #AS#
   Nothing */
CPaletteDlg::
OnBrowse()
{
	if( PickFileName( TRUE, m_szPaletteFile, "Load Atari palette file",
					  PF_ACT_FILTER, "act", PF_LOAD_FLAGS ) &&
		*m_szPaletteFile != '\0' )
	{
		SetDlgItemText( IDC_PALETTE_EDIT, m_szPaletteFile );
		OnKillfocusEdit();
	}
}

void
CPaletteDlg::
OnKillfocusEdit()
{
	GetDlgItemText( IDC_PALETTE_EDIT, m_szPaletteFile, MAX_PATH );

	if( *m_szPaletteFile != '\0' )
	{
		if( !read_palette( m_szPaletteFile ) )
			MessageBox( "Read external palette operation failed.", "Atari800Win", MB_ICONEXCLAMATION | MB_OK );

		/* Palette bar is drawn in windowed modes only */
		if( !m_bSmallMode )
		{
			/* Refresh the main emulator window */
			AfxGetMainWnd()->Invalidate();
			/* Redraw palette bar */
			CDC *pDC = GetDC();
			PaintPalette( pDC );
			ReleaseDC( pDC );
			/* This makes the changes visible */
			Invalidate();
		}
	}
}

void
CPaletteDlg::
OnOK()
{
	if( m_ulMiscStates != g_ulMiscStates )
	{
		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );
	}	
	/* Windows NT doesn't like empty strings in Registry */
	if( *m_szPaletteFile == '\0' )
		strcpy( m_szPaletteFile, DEFAULT_ACT );

	if( _stricmp( g_szPaletteFile, m_szPaletteFile ) != 0 )
	{
		strncpy( g_szPaletteFile, m_szPaletteFile, MAX_PATH );
		WriteRegString( NULL, REG_EXT_PALETTE, g_szPaletteFile );
	}
	/* Apply the changes now if in small mode */
	if( m_bSmallMode )
	{
		UseAtariPalette();
		InitialiseScreen( TRUE ); /* Force initialization */
	}
	CDialog::OnOK();
}

void
CPaletteDlg::
OnCancel()
{
	if( _stricmp( g_szPaletteFile, m_szPaletteFile ) != 0 )
	{
		strncpy( m_szPaletteFile, g_szPaletteFile, MAX_PATH );
		SetDlgItemText( IDC_PALETTE_EDIT, g_szPaletteFile );
		/* Restore old palette if still available */
		OnKillfocusEdit();
	}
	CDialog::OnCancel();
}

void
CPaletteDlg::
OnPaint() 
{
	CPaintDC dc( this ); /* Device context for painting */

	if( !m_bSmallMode )
		PaintPalette( &dc );
}

BOOL
CPaletteDlg::
PaintPalette( CDC *pDC )
{
	CPalette     palPalette;
	CPalette    *pOldPalette;
	CBrush      *pBrush;
	CBrush      *pOldBrush;
	int          nWidth = (g_bLargeFonts ? 2 : 1);
	int          nHeight;
	HANDLE       hLogPal;    /* Handle to a logical palette */
	LPLOGPALETTE lpPal;      /* Pointer to a logical palette */
	BOOL         bResult;

	/* Allocate memory block for logical palette */
	hLogPal = ::GlobalAlloc( GHND/*LPTR*/, sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * PAL_ENTRIES_NO );
	/* If not enough memory, clean up and return NULL */
	if( !hLogPal )
		return FALSE;

	lpPal = (LPLOGPALETTE)::GlobalLock( (HGLOBAL)hLogPal );
	/* Init palette header info */
	lpPal->palVersion    = 0x300;
	lpPal->palNumEntries = (WORD)PAL_ENTRIES_NO;

	/* Copy entries */
	CopyMemory( lpPal->palPalEntry, g_pe, sizeof(PALETTEENTRY) * PAL_ENTRIES_NO );
	UseAtariPalette();

	/* Create palette */
	bResult = (BOOL)(palPalette.CreatePalette( lpPal ));

	::GlobalUnlock( (HGLOBAL) hLogPal );
	::GlobalFree( (HGLOBAL) hLogPal );

	if( bResult )
	{
		CRect *aprcPalBars[ PAL_BARS_NO ] = { &m_rcPalBar1, &m_rcPalBar2 };
		CRect *pPalBar;

		/* Select and realize palette */
		pOldPalette = pDC->SelectPalette( &palPalette, TRUE );
		pDC->RealizePalette();

		for( int i = 0; i < PAL_BARS_NO; i++ ) /* Two Palette bars */
		{
			pPalBar = aprcPalBars[ i ];

			nHeight = pPalBar->Height();
//			pDC->IntersectClipRect( pPalBar );

			/* Draw each stripe */
			for( int j = 0; j < BAR_ENTRIES_NO; j++ )
			{
				pBrush = new CBrush;
				/* A palette-relative pBrush is used for drawing */
				if( TRUE == pBrush->CreateSolidBrush( PALETTEINDEX( j + (i * BAR_ENTRIES_NO) ) ) )
				{
					/* Setup pBrush */
					pOldBrush = pDC->SelectObject( pBrush );
					pBrush->UnrealizeObject();

					/* Draw stripe */
					pDC->PatBlt( pPalBar->left + j * nWidth, pPalBar->top, nWidth, nHeight, PATCOPY );
					pDC->SelectObject( pOldBrush );
				}
				delete pBrush;
			}
		}
		/* Back to old palette */
		pDC->SelectPalette( pOldPalette, TRUE );
		pDC->RealizePalette();
	}
	return bResult;
}
