/****************************************************************************
File    : SettingsDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CSettingsDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 30.04.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "SettingsDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg dialog

BEGIN_MESSAGE_MAP(CSettingsDlg, CDialog)
	//{{AFX_MSG_MAP(CSettingsDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SETTINGS_REFRESHSPIN, OnDeltaposRefreshSpin)
	ON_EN_KILLFOCUS(IDC_SETTINGS_REFRESHRATE, OnKillfocusRefreshRate)
	ON_BN_CLICKED(IDC_SETTINGS_FULLSPEED, OnFullSpeed)
	ON_BN_CLICKED(IDC_SETTINGS_C000RAM, OnC000Ram)
	ON_BN_CLICKED(IDC_SETTINGS_ENABLEROM, OnEnableRom)
	ON_BN_CLICKED(IDC_SETTINGS_ENABLESIO, OnEnableSio)
	ON_BN_CLICKED(IDC_SETTINGS_NEWBINLOAD, OnNewBinload)
	ON_BN_CLICKED(IDC_SETTINGS_HOLDOPTION, OnHoldOption)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CSettingsDlg::CSettingsDlg
=========================================================*/
/* #FN#
   Standard constructor */
CSettingsDlg::
CSettingsDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
	: CDialog( CSettingsDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CSettingsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CSettingsDlg::CSettingsDlg */

/*========================================================
Method   : CSettingsDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CSettingsDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CSettingsDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CSettingsDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg implementation

/*========================================================
Method   : CSettingsDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CSettingsDlg::
SetDlgState()
{
	char     szDigits[ 64 ];
	CButton	*pButton = NULL;

	/* Set up check buttons states */
	if( m_ulMiscStates & MS_FULL_SPEED )
	{
		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_FULLSPEED );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}

	if( m_nEnableC000Ram )
	{
		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_C000RAM );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}

	pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLEROM );
	ASSERT(pButton);
	if( m_nEnableRomPatches )
	{
		pButton->SetCheck( 1 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
		ASSERT(pButton);
		pButton->EnableWindow( TRUE );

		if( m_nEnableSIOPatch )
			pButton->SetCheck( 1 );
	}
	else /* ROM patch == FALSE automatically disables SIO_PATCH */
	{
		pButton->SetCheck( 0 );

		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
		ASSERT(pButton);
		pButton->SetCheck( 0 );
		pButton->EnableWindow( FALSE );
		m_nEnableSIOPatch = 0; /* turn off SIO patch */
	}

	if( m_nUseNewBinload )
	{
		pButton = (CButton *)GetDlgItem( IDC_SETTINGS_NEWBINLOAD );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
#ifndef USE_NEW_BINLOAD
	GetDlgItem( IDC_NEW_BINLOAD )->EnableWindow( FALSE );
#endif

	if( m_nHoldOption )
	{
		pButton = (CButton*)GetDlgItem( IDC_SETTINGS_HOLDOPTION );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}

	itoa( m_nRefreshRate, szDigits, 10 );
	SetDlgItemText( IDC_SETTINGS_REFRESHRATE, szDigits );

} /* #OF# CSettingsDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CSettingsDlg message handlers

/*========================================================
Method   : CSettingsDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CSettingsDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_nEnableRomPatches = enable_rom_patches;
	m_nEnableSIOPatch   = enable_sio_patch;
	m_nEnableC000Ram    = enable_c000_ram;
	m_nUseNewBinload    = use_new_binload;
	m_nHoldOption       = hold_option;
	m_nRefreshRate      = refresh_rate;
	m_ulMiscStates      = g_ulMiscStates;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CSettingsDlg::OnInitDialog */

/*========================================================
Method   : CSettingsDlg::OnFullSpeed
=========================================================*/
/* #FN#
	Sets the state of object regarding to Full Speed checkbox */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnFullSpeed() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_FULLSPEED );
	ASSERT(pButton);
	if( pButton->GetCheck() )
		m_ulMiscStates |= MS_FULL_SPEED;
	else
		m_ulMiscStates &= ~MS_FULL_SPEED;
} /* #OF# CSettingsDlg::OnFullSpeed */

/*========================================================
Method   : CSettingsDlg::OnC000Ram
=========================================================*/
/* #FN#
	Sets the state of object regarding to Enable C000 RAM checkbox */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnC000Ram() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_C000RAM );
	m_nEnableC000Ram = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnC000Ram */

/*========================================================
Method   : CSettingsDlg::OnEnableRom
=========================================================*/
/* #FN#
	Sets the state of object regarding to Enable ROM Patches checkbox */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnEnableRom() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLEROM );
	m_nEnableRomPatches = pButton->GetCheck();

	SetDlgState();
} /* #OF# CSettingsDlg::OnEnableRom */

/*========================================================
Method   : CSettingsDlg::OnEnableSio
=========================================================*/
/* #FN#
	Sets the state of object regarding to Enable SIO Patch checkbox */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnEnableSio() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_ENABLESIO );
	m_nEnableSIOPatch = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnEnableSio */

/*========================================================
Method   : CSettingsDlg::OnNewBinload
=========================================================*/
/* #FN#
	Sets the state of object regarding to Use New Binload checkbox */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnNewBinload() 
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_NEWBINLOAD );
	m_nUseNewBinload = pButton->GetCheck();
} /* #OF# CSettingsDlg::OnNewBinload */

void
CSettingsDlg::
OnHoldOption()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_SETTINGS_HOLDOPTION );
	m_nHoldOption = pButton->GetCheck();
}

/*========================================================
Method   : CSettingsDlg::OnDeltaposRefreshSpin
=========================================================*/
/* #FN#
	Sets the state of object regarding to Refresh spin */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnDeltaposRefreshSpin( NMHDR   *pNMHDR, /* #IN#  */
					   LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;
	char       szDigits[ 64 ];

	m_nRefreshRate -= pNMUpDown->iDelta;
	if( m_nRefreshRate < 1 )
		m_nRefreshRate = 1;
	if( m_nRefreshRate > 99 )
		m_nRefreshRate = 99;

	itoa( m_nRefreshRate, szDigits, 10 );
	SetDlgItemText( IDC_SETTINGS_REFRESHRATE, szDigits );

	test_val = 0;
	*pResult = 0;
} /* #OF# CSettingsDlg::OnDeltaposRefreshSpin */

/*========================================================
Method   : CSettingsDlg::OnKillfocusRefreshRate
=========================================================*/
/* #FN#
	Sets the state of object regarding to Refresh spin */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnKillfocusRefreshRate() 
{
	char szDigits[ 64 ];
	int  iTemp;

	GetDlgItemText( IDC_SETTINGS_REFRESHRATE, szDigits, 64 );
	iTemp = atoi( szDigits );

	if( iTemp < 1 || iTemp > 99 )
	{
		itoa( m_nRefreshRate, szDigits, 10 );
		SetDlgItemText( IDC_SETTINGS_REFRESHRATE, szDigits );
	}
	else
		m_nRefreshRate = iTemp;
} /* #OF# CSettingsDlg::OnKillfocusRefreshRate */

/*========================================================
Method   : CSettingsDlg::OnOK
=========================================================*/
/* #FN#
   Handles the pressing OK button event */
void
/* #AS#
   Nothing */
CSettingsDlg::
OnOK() 
{
	BOOL bReboot = FALSE;

	if( g_ulAtariState & ATARI_LOAD_FAILED )
		bReboot = TRUE;

	if( m_nEnableC000Ram != enable_c000_ram )
	{
		enable_c000_ram = m_nEnableC000Ram;
		WriteRegDWORD( NULL, REG_ENABLE_C000_RAM, enable_c000_ram );
		bReboot = TRUE;
	}
	if( m_nEnableRomPatches != enable_rom_patches )
	{
		enable_rom_patches = m_nEnableRomPatches;
		WriteRegDWORD( NULL, REG_ENABLE_ROM_PATCH, enable_rom_patches );
		bReboot = TRUE;
	}
	if( m_nEnableSIOPatch != enable_sio_patch )
	{
		enable_sio_patch = (m_nEnableSIOPatch && enable_rom_patches ? 1 : 0);
		if( enable_sio_patch )
			SetSIOEsc();
		else
			RestoreSIO();
		WriteRegDWORD( NULL, REG_ENABLE_SIO_PATCH, enable_sio_patch );
	}
	if( m_nUseNewBinload != use_new_binload )
	{
		use_new_binload = m_nUseNewBinload;
		WriteRegDWORD( NULL, REG_USE_NEW_BINLOAD, use_new_binload );
		bReboot = TRUE;
	}
	if( m_nHoldOption != hold_option )
	{
		hold_option = m_nHoldOption;
		WriteRegDWORD( NULL, REG_HOLD_OPTION, hold_option );
		bReboot = TRUE;
	}
	if( m_nRefreshRate != refresh_rate )
	{
		refresh_rate = m_nRefreshRate;
		WriteRegDWORD( NULL, REG_REFRESH_RATE, refresh_rate );
	}

	if( m_ulMiscStates != g_ulMiscStates )
	{
		BOOL bFullSpeed = g_ulMiscStates & MS_FULL_SPEED;

		g_ulMiscStates = m_ulMiscStates;
		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );

		if( !bFullSpeed && g_ulMiscStates & MS_FULL_SPEED )
			ClearSound( FALSE );
		else if(
			bFullSpeed && !(g_ulMiscStates & MS_FULL_SPEED) )
			RestartSound();
	}

	/* If the Atari load failed, we just reset g_hWnd to NULL and the
	   Atari will be rebooted when the screen is refreshed in OnDraw */
	if( bReboot )
	{
		Atari_ReInit();
		AfxGetMainWnd()->Invalidate();
	}
	CDialog::OnOK();
} /* #OF# CSettingsDlg::OnOK */
