/* platform-independent drawing LED on screen */

#include "config.h"

#if defined(SET_LED) && !defined(NO_LED_ON_SCREEN)

#include "diskled.h"
#include "antic.h"	/* for atari_screen */

static int LEDstatus = 0;

static unsigned char DiskLED[]= {
172,172,172,172,172,
172,172,000,172,172,
172,000,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,172,172,172,
		
172,172,172,172,172,
172,000,000,172,172,
172,172,172,000,172,
172,172,000,172,172,
172,000,172,172,172,
172,000,000,000,172,
172,172,172,172,172,
		
172,172,172,172,172,
172,000,000,172,172,
172,172,172,000,172,
172,172,000,172,172,
172,172,172,000,172,
172,000,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,172,000,172,
172,172,000,000,172,
172,000,172,000,172,
172,000,000,000,172,
172,172,172,000,172,
172,172,172,172,172,

172,172,172,172,172,
172,000,000,000,172,
172,000,172,172,172,
172,000,000,000,172,
172,172,172,000,172,
172,000,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,000,172,172,
172,000,172,172,172,
172,000,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,000,000,000,172,
172,172,172,000,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,
172,172,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,

172,172,172,172,172,		
172,172,000,172,172,
172,000,172,000,172,
172,000,172,000,172,
172,000,172,000,172,
172,172,000,172,172,
172,172,172,172,172,	/* End of read LEDs	*/

053,053,053,053,053,	/* Start of write LEDs */
053,053,000,053,053,
053,000,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,053,053,
053,053,053,000,053,
053,053,000,053,053,
053,000,053,053,053,
053,000,000,000,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,053,053,
053,053,053,000,053,
053,053,000,053,053,
053,053,053,000,053,
053,000,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,053,000,053,
053,053,000,000,053,
053,000,053,000,053,
053,000,000,000,053,
053,053,053,000,053,
053,053,053,053,053,


053,053,053,053,053,
053,000,000,000,053,
053,000,053,053,053,
053,000,000,000,053,
053,053,053,000,053,
053,000,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,053,053,
053,000,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,000,000,000,053,
053,053,053,000,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,000,053,000,053,
053,053,000,053,053,
053,053,053,053,053,

053,053,053,053,053,
053,053,000,053,053,
053,000,053,000,053,
053,000,053,000,053,
053,000,053,000,053,
053,053,000,053,053,	
053,053,053,053,053	/* End of write LEDs	*/
};

void Atari_Set_LED(int how)
{
	LEDstatus = how;
}

void Draw_LED(UBYTE *scrn)
{
	if (LEDstatus) {
		UBYTE *shape = DiskLED + (LEDstatus - 1) * DISKLED_FONT_CHARSIZE;
		int x,y;
		if(!scrn)
			scrn = (UBYTE *)atari_screen
				   + (ATARI_HEIGHT - DISKLED_FONT_HEIGHT) * ATARI_WIDTH
				   + 352 - DISKLED_FONT_WIDTH;
		for (y = 0; y < DISKLED_FONT_HEIGHT; y++) {
			for( x = 0; x < DISKLED_FONT_WIDTH; x++)
				*scrn++ = *shape++;
			scrn += ATARI_WIDTH - DISKLED_FONT_WIDTH;
		}
	}
}

#endif
