/****************************************************************************
File    : atari800.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Shared Atari800 methods and objects declarations
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 27.04.2000
*/

#ifndef __ATARI800_H__
#define __ATARI800_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Atari800 exports we are using in the Win project */

#include "atari.h"
#include "antic.h"
#include "cpu.h"
#include "sio.h"
#include "pokeysnd.h"
#include "pokey.h"
#include "ui.h"
#include "statesav.h"
#include "binload.h"
#include "log.h"
#include "diskled.h"
#include "colours.h"
#include "ataripcx.h"
/* Since these header files consist static members, it isn't good idea including them here */

/* There is the definition of pointer to Atari_DisplayScreen function */
/* #include "platform.h" */
#include "rt-config.h"
#include "monitor.h"

/* I didn't find any header files for these exports */

extern int cart_type;
extern int rom_inserted;
extern int stereo_enabled;
extern int test_val;
extern int pil_on;
extern int SHIFT_KEY;
extern int KEYPRESSED;

extern char       current_rom [];
extern UBYTE      memory      [];
extern UBYTE      atari_basic [];
extern UnitStatus drive_status[];

int  main             ( int argc, char **argv );    /* main of Atari800 */
void RestoreSIO       ( void );
void SetSIOEsc        ( void );
void DisablePILL      ( void );
void Clear_Temp_Files ( void );
int  ReadAtariExe     ( char *filename );
BOOL dcmtoatr         ( FILE *fin, FILE *fout, char *input, char *output );

/* Windows pieces in Atari800 sources */

void WinAtari800_Hardware( void );


#ifdef __cplusplus
}
#endif

#endif /*__ATARI800_H__*/
