/****************************************************************************
File    : MainFrame.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Interface of the CMainFrame class
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 09.05.2000
*/

#ifndef __MAINFRAME_H__
#define __MAINFRAME_H__

#if _MSC_VER >= 1000
#pragma once
#endif //_MSC_VER >= 1000


/////////////////////////////////////////////////////////////////////////////
// CMainFrame window

class CMainFrame : public CFrameWnd
{
// Construction/destruction
protected:
	// Create from serialization only
	DECLARE_DYNCREATE(CMainFrame)
	CMainFrame();
	virtual ~CMainFrame();

// Interface: operations
public:

// Interface: attributes
public:

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// Implementation: operations
private:
	void DriveInsert ( int nDriveNum );
	void SaveState   ( int nSaveRom );
	void SaveSnapshot( int nInterlace );

// Implementation: overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainFrame)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void ActivateFrame(int nCmdShow = -1);
	//}}AFX_VIRTUAL

// Implementation: attributes
protected:
	// Control bar embedded members
	CToolBar   m_wndToolBar;
	CStatusBar m_wndStatusBar;

private:
	CString    m_strStateName;
	CString    m_strSoundName;
	CString    m_strSnapshotName;

// Generated message map functions
protected:
	//{{AFX_MSG(CMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnFileLoadExecutable();
	afx_msg void OnFileAttachDiskImageDrive1();
	afx_msg void OnFileAttachDiskImageDrive2();
	afx_msg void OnFileAttachDiskImageDrive3();
	afx_msg void OnFileAttachDiskImageDrive4();
	afx_msg void OnFileAttachDiskImageDrive5();
	afx_msg void OnFileAttachDiskImageDrive6();
	afx_msg void OnFileAttachDiskImageDrive7();
	afx_msg void OnFileAttachDiskImageDrive8();
	afx_msg void OnFileAttachCartridgeImage();
	afx_msg void OnFileDiskDrives();
	afx_msg void OnFileRomImages();
	afx_msg void OnFileHardDisks();
	afx_msg void OnFileReadState();
	afx_msg void OnFileSaveStateNormal();
	afx_msg void OnFileSaveStateVerbose();
	afx_msg void OnAtariMachineType();
	afx_msg void OnAtariMachineType800osa();
	afx_msg void OnAtariMachineType800osb();
	afx_msg void OnAtariMachineType800xl();
	afx_msg void OnAtariMachineType130xe();
	afx_msg void OnAtariMachineType320xeCompy();
	afx_msg void OnAtariMachineType320xeRambo();
	afx_msg void OnAtariMachineType5200();
	afx_msg void OnAtariVideoSystem();
	afx_msg void OnAtariVideoSystemNtsc();
	afx_msg void OnAtariVideoSystemPal();
	afx_msg void OnAtariSettings();
	afx_msg void OnAtariSioPatch();
	afx_msg void OnAtariFullSpeed();
	afx_msg void OnAtariPause();
	afx_msg void OnAtariKeyboard();
	afx_msg void OnAtariJoysticks();
	afx_msg void OnAtariWarmstart();
	afx_msg void OnAtariColdstart();
	afx_msg void OnGraphicsOptions();
	afx_msg void OnGraphicsGdiForWindows();
	afx_msg void OnGraphicsScanlines();
	afx_msg void OnGraphicsArtifacting();
	afx_msg void OnGraphicsArtifactingNone();
	afx_msg void OnGraphicsArtifactingBluebrown1();
	afx_msg void OnGraphicsArtifactingBluebrown2();
	afx_msg void OnGraphicsArtifactingGtia();
	afx_msg void OnGraphicsArtifactingCtia();
	afx_msg void OnGraphicsPalette();
	afx_msg void OnGraphicsSaveScreenshotNormal();
	afx_msg void OnGraphicsSaveScreenshotInterlaced();
	afx_msg void OnGraphicsPerformanceTest();
	afx_msg void OnSoundOptions();
	afx_msg void OnSoundDigitizedEffects();
	afx_msg void OnSoundStereo();
	afx_msg void OnSoundMute();
	afx_msg void OnSoundSaveSound();
	afx_msg void OnSoundPerformanceTest();
	afx_msg void OnMiscFileAssociations();
	afx_msg void OnMiscConvertDcmToAtr();
	afx_msg void OnMiscClearAllSettings();
	afx_msg void OnMiscRestartEmulation();
	afx_msg void OnMiscViewLogFile();
	afx_msg void OnMiscMonitor();
	afx_msg void OnInitMenu(CMenu* pMenu);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnClose();
	afx_msg void OnUpdateAtariMachineType(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAtariVideoSystem(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAtariSioPatch(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAtariFullSpeed(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAtariPause(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGraphicsGdiForWindows(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGraphicsScanlines(CCmdUI* pCmdUI);
	afx_msg void OnUpdateGraphicsArtifacting(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSoundDigitizedEffects(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSoundStereo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSoundMute(CCmdUI* pCmdUI);
	afx_msg void OnUpdateSoundSaveSound(CCmdUI* pCmdUI);
	afx_msg void OnFileTurnDisk();
	afx_msg void OnUpdateFileTurnDisk(CCmdUI* pCmdUI);
	afx_msg void OnDropFiles(HDROP hDropInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif //__MAINFRAME_H__
