/****************************************************************************
File    : input_win.h
/*
@(#) #SY# Atari800Win
@(#) #IS# Input public methods and objects prototypes
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 13.04.2000
*/

#ifndef __INPUT_WIN_H__
#define __INPUT_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Const declarations */

#define MAX_INPUT_DEVICES		8
#define MAX_ATARI_JOYPORTS		4
#define NUM_KBJOY_DEVICES		4
#define NUM_KBJOY_KEYS			10
#define INPUT_DEV_NAMELEN		32

#define NUMPAD_JOYSTICK			-4
#define CURSOR_JOYSTICK			-3
#define KEYS_A_JOYSTICK			-2
#define KEYS_B_JOYSTICK			-1
/* There are found input devs	(0, ..., MAX_INPUT_DEVICES - 1) */
#define NO_JOYSTICK				127

#define TIMER_READ_JOYSTICK		6969

/* Warning: See special keys codes in atari.h file! */
#define SPECIAL_HANDLER_MASK	0xf000
#define AKEY_OPTIONDWN			0xffe1
#define AKEY_SELECTDWN			0xffe2
#define AKEY_STARTDWN			0xffe3
#define AKEY_OPTIONUP			0xffe7
#define AKEY_SELECTUP			0xffe8
#define AKEY_STARTUP			0xffe9
#define AKEY_MONITOR			0xffea

#define KEYSET_NW				0
#define KEYSET_NORTH			1
#define KEYSET_NE				2
#define KEYSET_EAST				3
#define KEYSET_SE				4
#define KEYSET_SOUTH			5
#define KEYSET_SW				6
#define KEYSET_WEST				7
#define KEYSET_CENTRE			8
#define KEYSET_FIRE				9

/* Exported methods */

int  InitialiseInput  ( void );
void ResetInput       ( void );
void ClearInput       ( void );
int  ReadJoystickInput( int nStickNum, BOOL bButton );
BOOL ToggleKeyDown    ( WPARAM wp, LPARAM lp );
BOOL ToggleKeyUp      ( WPARAM wp, LPARAM lp );
void ResetKeys        ( void );

/* Exported globals */

extern HINSTANCE g_hDInput;
extern int       g_nCurrentKey;
extern int       g_nCurrentVK;
extern int       g_nNewKey;
extern int       g_nNewVK;
extern int       g_nNumDIDevs;
extern BOOL      g_bKBJoystick;
extern int       CTRL_KEY;

extern int       g_anSelectedInputDevice[];
extern char      g_acInputDevNames      [][ INPUT_DEV_NAMELEN ];
extern WORD      g_anKeyset             [][ NUM_KBJOY_KEYS ];
extern BYTE      g_anExtendedKeyTab     [];

#ifdef __cplusplus
}
#endif

#endif /*__INPUT_WIN_H__*/
