/****************************************************************************
File    : GraphicsAdvDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CGraphicsAdvDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 16.04.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "WarningDlg.h"
#include "GraphicsDlg.h"
#include "GraphicsAdvDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg dialog

BEGIN_MESSAGE_MAP(CGraphicsAdvDlg, CDialog)
	//{{AFX_MSG_MAP(CGraphicsAdvDlg)
	ON_BN_CLICKED(IDC_GRAPHICSADV_PRIMARY, OnPrimary)
	ON_BN_CLICKED(IDC_GRAPHICSADV_WAITVBL, OnWaitVbl)
	ON_BN_CLICKED(IDC_GRAPHICSADV_FLIP, OnFlip)
	ON_BN_CLICKED(IDC_GRAPHICSADV_SYNCBLIT, OnSyncBlit)
	ON_BN_CLICKED(IDC_GRAPHICSADV_LOCALMEM, OnLocalMem)
	ON_BN_CLICKED(IDC_GRAPHICSADV_HIDECURSOR, OnHideCursor)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CGraphicsAdvDlg::CGraphicsAdvDlg
=========================================================*/
/* #FN#
   Standard constructor */
CGraphicsAdvDlg::
CGraphicsAdvDlg( ULONG *pScreenMode /*=NULL*/, /* #IN# Pointer to screen mode flags */
				 CWnd  *pParent /*=NULL*/      /* #IN# Pointer to parent window */ )
	: CDialog( CGraphicsAdvDlg::IDD, pParent ),
	  m_ulScreenMode( 0L )
{
	//{{AFX_DATA_INIT(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	if( m_pScreenMode = pScreenMode )
		m_ulScreenMode = *m_pScreenMode;
} /* #OF# CGraphicsAdvDlg::CGraphicsAdvDlg */

/*========================================================
Method   : CGraphicsAdvDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
CGraphicsAdvDlg::
DoDataExchange( CDataExchange *pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CGraphicsAdvDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CGraphicsAdvDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CGraphicsAdvDlg message handlers

/*========================================================
Method   : CGraphicsAdvDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CGraphicsAdvDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDVBL_WAIT) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_DDBLT_WAIT) != 0 );

	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_LOCALMEM );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_USE_VIDEOMEM) != 0 );

#ifndef WIN_USE_FLIP_BUFFER
	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_FLIP );
	ASSERT(pButton);
	pButton->EnableWindow( FALSE );

	m_ulScreenMode &= ~SM_OPTN_FLIP_BUFFERS;
#endif /*WIN_USE_FLIP_BUFFER*/

	CheckRadioButton( IDC_GRAPHICSADV_PRIMARY, IDC_GRAPHICSADV_FLIP,
		m_ulScreenMode & SM_OPTN_FLIP_BUFFERS ?
		IDC_GRAPHICSADV_FLIP : IDC_GRAPHICSADV_PRIMARY );
	
	pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_HIDECURSOR );
	ASSERT(pButton);
	pButton->SetCheck( (m_ulScreenMode & SM_OPTN_HIDE_CURSOR) != 0 );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CGraphicsAdvDlg::OnInitDialog */

void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnPrimary()
{
	m_ulScreenMode &= ~SM_OPTN_FLIP_BUFFERS;
}

void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnFlip()
{
	m_ulScreenMode |= SM_OPTN_FLIP_BUFFERS;
}

/*========================================================
Method   : CGraphicsAdvDlg::OnWaitVbl
=========================================================*/
/* #FN#
   Turns on/off sync with monitor */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnWaitVbl()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_WAITVBL );
	ASSERT(pButton);

	int nCheckState = pButton->GetCheck();
	if( nCheckState && !(g_ulDontShowFlags & DONT_SHOW_VBLWAIT_WARN) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg dlgWarning;

		LoadString( NULL, IDS_WARNING_VBL_WAIT, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = DONT_SHOW_VBLWAIT_WARN;
		dlgWarning.m_bCancel     = FALSE;
		dlgWarning.DoModal();
	}
	if( nCheckState )
		m_ulScreenMode |= SM_OPTN_DDVBL_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDVBL_WAIT;
} /* #OF# CGraphicsAdvDlg::OnWaitVbl */

void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnSyncBlit()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_SYNCBLIT );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_DDBLT_WAIT;
	else
		m_ulScreenMode &= ~SM_OPTN_DDBLT_WAIT;
}

/*========================================================
Method   : CGraphicsAdvDlg::OnLocalMem
=========================================================*/
/* #FN#
   Turns on/off AGP memory for DDraw offscreen surfaces */
void
/* #AS#
   Nothing */
CGraphicsAdvDlg::
OnLocalMem()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_LOCALMEM );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_USE_VIDEOMEM;
	else
		m_ulScreenMode &= ~SM_OPTN_USE_VIDEOMEM;
} /* #OF# CGraphicsAdvDlg::OnLocalMem */

void
CGraphicsAdvDlg::
OnHideCursor()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_GRAPHICSADV_HIDECURSOR );
	ASSERT(pButton);

	if( pButton->GetCheck() )
		m_ulScreenMode |= SM_OPTN_HIDE_CURSOR;
	else
		m_ulScreenMode &= ~SM_OPTN_HIDE_CURSOR;
}

void
CGraphicsAdvDlg::
OnOK()
{
	if( m_ulScreenMode != *m_pScreenMode )
	{
		*m_pScreenMode = m_ulScreenMode;
	}
	CDialog::OnOK();
}
