/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// HarddiskDlg.cpp : implementation file
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "FileSmallDlg.h"
#include "HarddiskDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CHarddiskDlg dialog


CHarddiskDlg::CHarddiskDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHarddiskDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHarddiskDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CHarddiskDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHarddiskDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHarddiskDlg, CDialog)
	//{{AFX_MSG_MAP(CHarddiskDlg)
	ON_BN_CLICKED(IDC_HARDISK_HD1, OnHd1)
	ON_BN_CLICKED(IDC_HARDISK_HD2, OnHd2)
	ON_BN_CLICKED(IDC_HARDISK_HD3, OnHd3)
	ON_BN_CLICKED(IDC_HARDISK_HD4, OnHd4)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD1, OnKillfocusHd1Edit)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD2, OnKillfocusHd2Edit)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD3, OnKillfocusHd3Edit)
	ON_EN_KILLFOCUS(IDC_HARDISK_EDITHD4, OnKillfocusHd4Edit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardDisk message handlers

BOOL CHarddiskDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetDlgItemText( IDC_HARDISK_EDITHD1, atari_h1_dir );
	SetDlgItemText( IDC_HARDISK_EDITHD2, atari_h2_dir );
	SetDlgItemText( IDC_HARDISK_EDITHD3, atari_h3_dir );
	SetDlgItemText( IDC_HARDISK_EDITHD4, atari_h4_dir );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHarddiskDlg::SetToDrive( char *drivestring , int item )
{
	CString	name = "";
	int	result;

	CFileSmallDlg fileDlg;
	if( (result = fileDlg.DoModal()) == IDOK )
		name = fileDlg.GetPathName();	
	if( result )
	{
		strcpy( drivestring, name );
		if( drivestring[ strlen(drivestring) - 1 ] == '\\' )
			drivestring[ strlen(drivestring) - 1 ] = 0;
		SetDlgItemText( item, drivestring );
	}
}

void CHarddiskDlg::OnHd1() 
{
	SetToDrive( atari_h1_dir, IDC_HARDISK_EDITHD1 );
}

void CHarddiskDlg::OnHd2() 
{
	SetToDrive( atari_h2_dir, IDC_HARDISK_EDITHD2 );
}

void CHarddiskDlg::OnHd3() 
{
	SetToDrive( atari_h3_dir, IDC_HARDISK_EDITHD3 );
}

void CHarddiskDlg::OnHd4() 
{
	SetToDrive( atari_h4_dir, IDC_HARDISK_EDITHD4 );
}

void CHarddiskDlg::OnKillfocusHd1Edit() 
{
	GetDlgItemText( IDC_HARDISK_EDITHD1, atari_h1_dir, MAX_PATH );
}

void CHarddiskDlg::OnKillfocusHd2Edit() 
{
	GetDlgItemText( IDC_HARDISK_EDITHD2, atari_h2_dir, MAX_PATH );
}

void CHarddiskDlg::OnKillfocusHd3Edit() 
{
	GetDlgItemText( IDC_HARDISK_EDITHD3, atari_h3_dir, MAX_PATH );
}

void CHarddiskDlg::OnKillfocusHd4Edit() 
{
	GetDlgItemText( IDC_HARDISK_EDITHD4, atari_h4_dir, MAX_PATH );
}

void CHarddiskDlg::OnOK() 
{
	CDialog::OnOK();

	if( atari_h1_dir[ 0 ] == 0 )
		strcpy( atari_h1_dir, "." );
	if( atari_h2_dir[ 0 ] == 0 )
		strcpy( atari_h2_dir, "." );
	if( atari_h3_dir[ 0 ] == 0 )
		strcpy( atari_h3_dir, "." );
	if( atari_h4_dir[ 0 ] == 0 )
		strcpy( atari_h4_dir, "." );

	WriteRegString( NULL, REG_HD1, atari_h1_dir );
	WriteRegString( NULL, REG_HD2, atari_h2_dir );
	WriteRegString( NULL, REG_HD3, atari_h3_dir );
	WriteRegString( NULL, REG_HD4, atari_h4_dir );
}
