/****************************************************************************
File    : RomImagesDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CRomImagesDlg implementation file
@(#) #BY# Tomasz Szymankowski, Richard Lawrence
@(#) #LM# 12.05.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "RomImagesDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define ROM_TYPE_NUMBER		5
#define ROM_OSA_TYPE		0
#define ROM_OSB_TYPE		1
#define ROM_XLXE_TYPE		2
#define ROM_5200_TYPE		3
#define ROM_BASIC_TYPE		4

#define CS_DETTACHED		0
#define CS_ATTACHED			1
#define CS_USE_BASIC		2

/////////////////////////////////////////////////////////////////////////////
// Static objects

const static unsigned int s_anWarnBits[ ROM_TYPE_NUMBER ] =
{
	DONT_SHOW_OSA_WARN,
	DONT_SHOW_OSB_WARN,
	DONT_SHOW_XL_WARN,
	DONT_SHOW_5200_WARN,
	DONT_SHOW_BASIC_WARN
};

const static unsigned long s_alFileCRC[ ROM_TYPE_NUMBER ] =
{
	0L,
	3252116993L,
	3764596111L,
	3182898204L,
	2190982779L
};

const static char *s_apszOpenPrompts[ ROM_TYPE_NUMBER ] =
{
	"Select the ROM for Atari 800 OS-A",
	"Select the ROM for Atari 800 OS-B",
	"Select the ROM for Atari XL/XE",
	"Select the ROM for Atari 5200",
	"Select ROM for BASIC cart"
};

const static int s_anEditCtrls_Large[ ROM_TYPE_NUMBER ] =
{
	IDC_ROMIMAGES_EDITOSA,
	IDC_ROMIMAGES_EDITOSB,
	IDC_ROMIMAGES_EDITXLXE,
	IDC_ROMIMAGES_EDIT5200,
	IDC_ROMIMAGES_EDITBASIC
};

const static int s_anEditCtrls_Small[ ROM_TYPE_NUMBER ] =
{
	IDC_ROMIMAGES_EDITOSROM,
	IDC_ROMIMAGES_EDITOSROM,
	IDC_ROMIMAGES_EDITOSROM,
	IDC_ROMIMAGES_EDITOSROM,
	IDC_ROMIMAGES_EDITBASIC
};

static char *s_apszRomNames[ ROM_TYPE_NUMBER ] =
{
	atari_osa_filename,
	atari_osb_filename,
	atari_xlxe_filename,
	atari_5200_filename,
	atari_basic_filename
};

static char s_acNewRomNames[ ROM_TYPE_NUMBER ][ MAX_PATH ];


/////////////////////////////////////////////////////////////////////////////
// CRomImagesDlg dialog

BEGIN_MESSAGE_MAP(CRomImagesDlg, CDialog)
	//{{AFX_MSG_MAP(CRomImagesDlg)
	ON_BN_CLICKED(IDC_ROMIMAGES_OSA, OnOsa)
	ON_BN_CLICKED(IDC_ROMIMAGES_OSB, OnOsb)
	ON_BN_CLICKED(IDC_ROMIMAGES_XLXE, OnXlxe)
	ON_BN_CLICKED(IDC_ROMIMAGES_5200, On5200)
	ON_BN_CLICKED(IDC_ROMIMAGES_BASIC, OnBasic)
	ON_BN_CLICKED(IDC_ROMIMAGES_CARTRIDGE, OnCartridge)
	ON_BN_CLICKED(IDC_ROMIMAGES_OSROM, OnOsRom)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITOSA, OnKillfocusEditOsa)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITOSB, OnKillfocusEditOsb)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITXLXE, OnKillfocusEditXlxe)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDIT5200, OnKillfocusEdit5200)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITBASIC, OnKillfocusEditBasic)
	ON_EN_KILLFOCUS(IDC_ROMIMAGES_EDITOSROM, OnKillfocusEditOsRom)
	ON_CBN_SELCHANGE(IDC_ROMIMAGES_MACHINETYPE, OnSelchangeMachineType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/*========================================================
Method   : CRomImagesDlg::CRomImagesDlg
=========================================================*/
/* #FN#
   Standard constructor */
CRomImagesDlg::
CRomImagesDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to parent window */ )
: CDialog( (g_ulScreenMode & SM_ATTR_SMALL_DLG ? IDD_ROMIMAGES_SMALL : CRomImagesDlg::IDD), pParent )
{
	//{{AFX_DATA_INIT(CRomImagesDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CRomImagesDlg::CRomImagesDlg */

/*========================================================
Method   : CRomImagesDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CRomImagesDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CRomImagesDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CRomImagesDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CRomImagesDlg implementation

/*========================================================
Method   : CRomImagesDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CRomImagesDlg::
SetDlgState()
{
	BOOL       bBasicActive = _stricmp( current_rom, atari_basic_filename ) == 0;
	BOOL       bBasicExists = strcmp( atari_basic_filename, "None" ) != 0;
	CComboBox *pCartState   = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_CARTRIDGESTATE );

	ASSERT(pCartState);

	m_nCartState = CS_DETTACHED;
	pCartState->ResetContent();

	pCartState->AddString( "Dettached" );
	pCartState->AddString( "Attached" );

	if( m_bSmallMode )
	{
		CComboBox *pOsRomType = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
		int        nType      = 0;
		ASSERT(pOsRomType);
		/* Get default system OS type */
		switch( default_system )
		{
			case 1:
				nType = 0;
				break;
			case 2:
				nType = 1;
				break;
			case 3:
			case 4:
			case 5:
				nType = 2;
				break;
			case 6:
				nType = 3;
				break;
		}
		pOsRomType->SetCurSel( nType );
		SetDlgItemText( m_pEditCtrls[ nType ], &s_acNewRomNames[ nType ][ 0 ] );
		SetDlgItemText( m_pEditCtrls[ ROM_BASIC_TYPE ], &s_acNewRomNames[ ROM_BASIC_TYPE ][ 0 ] );
	}
	else
		/* Set OS ROM and BASIC path edit windows */
		for( int i = 0; i < ROM_TYPE_NUMBER; i++ )
			SetDlgItemText( m_pEditCtrls[ i ], &s_acNewRomNames[ i ][ 0 ] );

	/* Set cartridge path edit window */
	ReadRegBinary( NULL, REG_OTHER_ROM, m_szCartridge, MAX_PATH, FALSE );
	SetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, m_szCartridge );

	/* The BASIC cartridge is used (800 OS-A/B) */
	if( default_system == 1/*800 OS-A*/ || default_system == 2/*800 OS-B*/ )
	{
		pCartState->AddString( "Use BASIC" );
		if( cart_type != NO_CART &&
			/* There is other ROM or (BASIC is the current ROM and OPTION button is not holded) */
			(strcmp( m_szCartridge, "None" ) != 0 ||
			(bBasicExists && bBasicActive /*&& !hold_option*/)) )
		{
			m_nCartState = (bBasicExists && bBasicActive) ? CS_USE_BASIC : CS_ATTACHED;
		}
	}
	else /* (XL/XE/5200) */
	{
		if( cart_type != NO_CART &&
			/* There is other ROM and BASIC is not the current ROM */
			strcmp( m_szCartridge, "None" ) != 0 &&
			bBasicExists && !bBasicActive )
		{
			m_nCartState = CS_ATTACHED;
		}
	}
	/* Set appropriate combo item */
	pCartState->SetCurSel( m_nCartState );
} /* #OF# CRomImagesDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CRomImagesDlg message handlers

/*========================================================
Method   : CRomImagesDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CRomImagesDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	m_bSmallMode = g_ulScreenMode & SM_ATTR_SMALL_DLG;

	/* Set the appropriate controls ids when in small mode */
	if( m_bSmallMode )
		m_pEditCtrls = s_anEditCtrls_Small; /* One edit for all OS */
	else
		m_pEditCtrls = s_anEditCtrls_Large;

	/* Backup ROM paths */
	for( int i = 0; i < ROM_TYPE_NUMBER; i++ )
		strncpy( &s_acNewRomNames[ i ][ 0 ], s_apszRomNames[ i ], MAX_PATH );

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CRomImagesDlg::OnInitDialog */

/*========================================================
Method   : CRomImagesDlg::OnSelchangeMachineType
=========================================================*/
/* #FN#
	Sets the state of object regarding to Machine Type combo */
void
/* #AS#
   Nothing */
CRomImagesDlg::
OnSelchangeMachineType()
{
	CComboBox *pComboBox = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
	ASSERT(pComboBox);
	int nType = pComboBox->GetCurSel();

	SetDlgItemText( m_pEditCtrls[ nType ], &s_acNewRomNames[ nType ][ 0 ] );
} /* #OF# CHardwareDlg::OnSelchangeMachineType */

/*========================================================
Method   : CRomImagesDlg::KillfocusRomEdit
=========================================================*/
/* #FN#
	Sets the specific ROM image */
void
/* #AS#
   Nothing */
CRomImagesDlg::
KillfocusEditRom( int nType )
{
	char  szRomPath[ MAX_PATH ];
	ULONG ulCRC;
	int   nCFOut;
	int   nResult = IDOK;

	ASSERT(nType < ROM_TYPE_NUMBER);

	GetDlgItemText( m_pEditCtrls[ nType ], szRomPath, MAX_PATH );
	/* If the names are equal then exit */
	if( _stricmp( &s_acNewRomNames[ nType ][ 0 ], szRomPath ) == 0 )
		return;

	ulCRC = CheckFile( szRomPath, &nCFOut );
	if( ulCRC && !nCFOut && (ulCRC != s_alFileCRC[ nType ]) &&
		!(g_ulDontShowFlags & s_anWarnBits[ nType ]) )
	{
		char szMessage[ LOADSTRING_STRING_SIZE ];
		CWarningDlg	dlgWarning;

		LoadString( NULL, IDS_WARNING_ROM_CORRUPT, szMessage, LOADSTRING_STRING_SIZE );
		dlgWarning.m_strWarnText = szMessage;
		dlgWarning.m_ulWarnBit   = s_anWarnBits[ nType ];
		nResult = dlgWarning.DoModal();
	}
	if( IDOK == nResult )
		strcpy( &s_acNewRomNames[ nType ][ 0 ], szRomPath );

	/* Apply changes to dialog window */
	SetDlgItemText( m_pEditCtrls[ nType ], &s_acNewRomNames[ nType ][ 0 ] );
} /* #OF# CRomImagesDlg::OnKillfocusRomEdit */

/*========================================================
Method   : CRomImagesDlg::OnRomfile
=========================================================*/
/* #FN#
   Allows to select ROM image using FileDialog window */
void
/* #AS#
   Nothing */
CRomImagesDlg::
BrowseRomFile( int nType )
{
	CString strRomName = "";

	GetDlgItemText( m_pEditCtrls[ nType ], strRomName.GetBuffer( MAX_PATH ), MAX_PATH );
	strRomName.ReleaseBuffer();

	if( PickFileName( TRUE, strRomName, s_apszOpenPrompts[ nType ],
					  PF_ROM_FILTER, "rom", PF_LOAD_FLAGS ) &&
		!strRomName.IsEmpty() )
	{
		SetDlgItemText( m_pEditCtrls[ nType ], (LPSTR)(LPCSTR)strRomName );
		KillfocusEditRom( nType );
	}
} /* #OF# CRomImagesDlg::OnRomfile */

void
CRomImagesDlg::
OnOsa() 
{
	BrowseRomFile( ROM_OSA_TYPE );
}

void
CRomImagesDlg::
OnOsb() 
{
	BrowseRomFile( ROM_OSB_TYPE );
}

void
CRomImagesDlg::
OnXlxe() 
{
	BrowseRomFile( ROM_XLXE_TYPE );
}

void
CRomImagesDlg::
On5200()
{
	BrowseRomFile( ROM_5200_TYPE );
}

void
CRomImagesDlg::
OnBasic() 
{
	BrowseRomFile( ROM_BASIC_TYPE );
}

void
CRomImagesDlg::
OnCartridge()
{
	char szCartridge[ MAX_PATH ];

	GetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, szCartridge, MAX_PATH );
	if( PickCartridge( szCartridge ) )
		SetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, szCartridge );
}

void
CRomImagesDlg::
OnOsRom() 
{
	CComboBox *pComboBox = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
	ASSERT(pComboBox);
	BrowseRomFile( pComboBox->GetCurSel() );
}

void
CRomImagesDlg::
OnKillfocusEditOsa() 
{
	KillfocusEditRom( ROM_OSA_TYPE );
}

void
CRomImagesDlg::
OnKillfocusEditOsb()
{
	KillfocusEditRom( ROM_OSB_TYPE );
}

void
CRomImagesDlg::
OnKillfocusEditXlxe()
{
	KillfocusEditRom( ROM_XLXE_TYPE );
}

void
CRomImagesDlg::
OnKillfocusEdit5200()
{
	KillfocusEditRom( ROM_5200_TYPE );
}

void
CRomImagesDlg::
OnKillfocusEditBasic()
{
	KillfocusEditRom( ROM_BASIC_TYPE );
}

void
CRomImagesDlg::
OnKillfocusEditOsRom()
{
	CComboBox *pComboBox = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_MACHINETYPE );
	ASSERT(pComboBox);
	KillfocusEditRom( pComboBox->GetCurSel() );
}

/*========================================================
Method   : CRomImagesDlg::OnOK
=========================================================*/
/* #FN#
   Handles the pressing OK button event */
void
/* #AS#
   Nothing */
CRomImagesDlg::
OnOK() 
{
	char       szNewCart[ MAX_PATH ];
	int        nNewCartState;
	CWnd      *pWnd      = GetFocus();
	int        nCtrlID   = pWnd ? pWnd->GetDlgCtrlID() : 0;
	BOOL       bSaveOS   = FALSE;
	BOOL       bReboot   = FALSE;
	CComboBox *pComboBox = (CComboBox*)GetDlgItem( IDC_ROMIMAGES_CARTRIDGESTATE );

	ASSERT(pComboBox);
	/* Get cartridge state the user was set */
	if( (nNewCartState = pComboBox->GetCurSel()) == CB_ERR )
	{
		pComboBox->SetCurSel( CS_DETTACHED );
		nNewCartState = CS_DETTACHED;
	}
	if( m_bSmallMode )
	{
		if( IDC_ROMIMAGES_EDITOSROM == nCtrlID )
			OnKillfocusEditOsRom();
		else
		if( IDC_ROMIMAGES_EDITBASIC == nCtrlID )
			KillfocusEditRom( ROM_BASIC_TYPE );
	}
	/* Check if OS ROMs were changed */
	for( int i = 0; i < ROM_TYPE_NUMBER; i++ )
	{
		/* Receive the edit contents again. A user could use 'Enter' or 'Alt-O'
		   and then all changes made in the last edited control would be lost */
		if( !m_bSmallMode && m_pEditCtrls[ i ] == nCtrlID )
			KillfocusEditRom( i );

		if( s_acNewRomNames[ i ][ 0 ] == '\0' )
			strcpy( &s_acNewRomNames[ i ][ 0 ], "None" );
		if( _stricmp( s_apszRomNames[ i ], &s_acNewRomNames[ i ][ 0 ] ) != 0 )
		{
			/* The function "strncpy" has given strange effects here */
			strcpy( s_apszRomNames[ i ], &s_acNewRomNames[ i ][ 0 ] );
			if( ROM_BASIC_TYPE == i )
			{
				if( CS_USE_BASIC == nNewCartState )
					bReboot = TRUE;
				WriteRegString( NULL, REG_BASIC_ROM, atari_basic_filename );
			}
			else
				bSaveOS = TRUE;
		}
	}
	/* Check if cartridge ROM was changed */
	GetDlgItemText( IDC_ROMIMAGES_EDITCARTRIDGE, szNewCart, MAX_PATH );
	if( *szNewCart == '\0' )
		strcpy( szNewCart, "None" );
	if( _stricmp( szNewCart, m_szCartridge ) )
	{
		if( CS_ATTACHED == nNewCartState )
		{
			strcpy( current_rom, szNewCart );
			bReboot = TRUE;
		}
		strcpy( m_szCartridge, szNewCart );
		WriteRegString( NULL, REG_OTHER_ROM, m_szCartridge );
	}

	if( nNewCartState != m_nCartState || bReboot )
	{
		bReboot = TRUE;
		if( CS_USE_BASIC == nNewCartState )
		{
			if( rom_inserted )
				Remove_ROM();
			/* strcpy will be called within Insert_ROM function */
			/* strcpy( current_rom, atari_basic_filename ); */
			if( !Insert_8K_ROM( atari_basic_filename ) )
			{
				LoadString( NULL, IDS_ERROR_LOADING_ROM, g_tszErrorString, LOADSTRING_STRING_SIZE );
				if( strcmp( atari_basic_filename, "None" ) != 0 )
					strcat( g_tszErrorString, atari_basic_filename );
				MessageBox( g_tszErrorString, "Atari800Win", MB_ICONSTOP | MB_OK );

				strcpy( current_rom, "None" );
				cart_type = NO_CART;
			}
		}
		if( CS_ATTACHED == nNewCartState )
		{
			AttachCartridge( m_szCartridge );
		}
		if( CS_DETTACHED == nNewCartState )
		{
			strcpy( current_rom, "None" );
			cart_type = NO_CART;
		}
		WriteRegString( NULL, REG_CURRENT_ROM, current_rom );
		WriteRegDWORD ( NULL, REG_CART_TYPE, cart_type );
	}

	if( bSaveOS )
	{
		WriteRegString( NULL, REG_OSA_ROM,  atari_osa_filename  );
		WriteRegString( NULL, REG_OSB_ROM,  atari_osb_filename  );
		WriteRegString( NULL, REG_XLXE_ROM, atari_xlxe_filename );
		WriteRegString( NULL, REG_5200_ROM, atari_5200_filename );
		/* If ROM was changed for active system */
//		if( ... )
//			bReboot = TRUE;
	}
	if( g_ulAtariState & ATARI_LOAD_FAILED )
		bReboot = TRUE;
	/* If the Atari load failed, we just reset g_hWnd to NULL and the
	   Atari will be rebooted when the screen is refreshed in OnDraw */
	if( bReboot )
		RestartEmulation();

	CDialog::OnOK();
} /* #OF# CRomImagesDlg::OnOK */
