/****************************************************************************
File    : misc_win.h
/*
@(#) #SY# Atari800Win
@(#) #IS# MiscWin public methods and objects prototypes
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 04.07.2000
*/

#ifndef __MISC_WIN_H__
#define __MISC_WIN_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Const declarations */

#define IAF_BIN_IMAGE	0x01
#define IAF_DSK_IMAGE	0x02
#define IAF_CRT_IMAGE	0x04
#define IAF_ROM_IMAGE	0x08
#define IAF_A8S_IMAGE	0x10
#define IAF_ATARI_FILE	0xff

/* Exported methods */

BOOL TestRomPaths       ( LPSTR pszStartPath );
void DescribeAtariSystem( void );
void Toggle_FullSpeed   ( void );
void Toggle_Pause       ( void );
void Toggle_SIOPatch    ( void );
void UseAtariPalette    ( void );
int  LaunchMonitor      ( void );
int  zlib_capable       ( void );
int  Atari_Exit         ( int  );
void ShowMousePointer   ( void );
void StartAtariTimer    ( void );
int	 FindCartType       ( LPCSTR pszFileName, BOOL bAutoDetect );
BOOL IsAtariFile        ( LPCSTR pszFileName, UINT *pFileType );
BOOL IsCompressedFile   ( LPCSTR pszFileName );
BOOL RunAtariExe        ( LPSTR  pszFileName );
BOOL GetHomeDirectory   ( LPSTR  pszHomeDir );
void GetFolderPath      ( LPSTR  pszFileName );

/* Exported globals */

extern char g_szSystemText[];

#ifdef __cplusplus
}
#endif

#endif /*__MISC_WIN_H__*/
