/****************************************************************************
File    : Atari800Win.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# Defines the class behaviors for the application.
@(#) #BY# Richard Lawrence, Tomasz Szymankowski
@(#) #LM# 01.07.2000
*/

/*
Copyright (c) 1998 Richard Lawrence, Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Atari800WinDoc.h"
#include "Atari800WinView.h"
#include "MainFrame.h"
#include "Helpers.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CWnd *pStatusBar;

static LONG  s_nHWLoopCounter = 0;
static INT   s_nCmdIndex;
static ULONG s_ulStartMeasure;

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp

BEGIN_MESSAGE_MAP(CAtari800WinApp, CWinApp)
	//{{AFX_MSG_MAP(CAtari800WinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

void
CAtari800WinCommandLineInfo::
ParseParam( const char *pszParam, BOOL bFlag, BOOL bLast )
{
	LPSTR pszTmpParam = (LPSTR)pszParam;

	/* It would be nice to remember the long form of the file name... */
	if( strchr( pszTmpParam, '\\' ) )
	{
		WIN32_FIND_DATA fileData;
		HANDLE hFile = ::FindFirstFile( pszTmpParam, &fileData );

		if( INVALID_HANDLE_VALUE != hFile )
		{
			char szLongPath[ MAX_PATH ];

			::FindClose( hFile );
			::GetCurrentDirectory( MAX_PATH, szLongPath );
			strcat( szLongPath, "\\" );
			strcat( szLongPath, fileData.cFileName );
			/* Test what we have got, please */
			if( INVALID_HANDLE_VALUE != (hFile = ::FindFirstFile( szLongPath, &fileData )) )
			{
				::FindClose( hFile );
				/* OK, it seems to be correct */
				pszTmpParam = szLongPath;
			}
		}
	}
	g_argv[ g_argc ] = &g_szCmdLine[ s_nCmdIndex ];
	g_argc++;
	if( bFlag )
		g_szCmdLine[ s_nCmdIndex++ ] = '-';
	strcpy( &g_szCmdLine[ s_nCmdIndex ], pszTmpParam );
	s_nCmdIndex += strlen( &g_szCmdLine[ s_nCmdIndex ] ) + 1;

//	CCommandLineInfo::ParseParam( pszParam, bFlag, bLast );
}

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp construction

CAtari800WinApp::
CAtari800WinApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CAtari800WinApp object

CAtari800WinApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp initialization

BOOL
CAtari800WinApp::
InitInstance()
{
	char szHomeDir[ MAX_PATH ];

	/* Standard initialization
	   If you are not using these features and wish to reduce the size
	   of your final executable, you should remove from the following
	   the specific initialization routines you do not need. */

//	SetPriorityClass( GetCurrentProcess(), REALTIME_PRIORITY_CLASS );

#ifdef _AFXDLL
	Enable3dControls();			/* Call this when using MFC in a shared DLL */
#else
	Enable3dControlsStatic();	/* Call this when linking to MFC statically */
#endif

	/* Register the application's document templates. Document templates
	   serve as the connection between documents, frame windows and views. */

	CSingleDocTemplate *pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CAtari800WinDoc),
		RUNTIME_CLASS(CMainFrame),       /* main SDI frame window */
		RUNTIME_CLASS(CAtari800WinView));
	AddDocTemplate(pDocTemplate);

	g_argc = 1;
	g_argv[ 0 ] = g_szCmdLine;
	strcpy( g_szCmdLine, this->m_pszAppName );
	s_nCmdIndex = strlen( g_szCmdLine ) + 1;

	/* Parse command line for standard shell commands, DDE, file open */
	CAtari800WinCommandLineInfo cmdInfo;
	ParseCommandLine( cmdInfo );

	/* Dispatch commands specified on the command line */
	if( !ProcessShellCommand( cmdInfo ) )
		return FALSE;

	/* The one and only window has been initialized, so show and update it */
	m_pMainWnd->ShowWindow( SW_SHOW );
	m_pMainWnd->UpdateWindow();

	s_ulStartMeasure = timeGetTime();

	/* For a variety of reasons it's better to set the current working
	   directory to where Atari800Win (the executable) is located */
	if( GetHomeDirectory( szHomeDir ) )
		SetCurrentDirectory( szHomeDir );

	return TRUE;
}

int
CAtari800WinApp::
ExitInstance() 
{
	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BOOL CAboutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	char	message[LOADSTRING_STRING_SIZE];
	
	LoadString( NULL, IDS_COPYRIGHT, message, LOADSTRING_STRING_SIZE );
	SetDlgItemText( IDC_ABOUT_COPYRIGHT, message );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CAtari800WinApp::OnAppAbout()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinApp commands

BOOL
CAtari800WinApp::
OnIdle( LONG lCount )
{
	if( !(g_ulAtariState & (ATARI_PAUSED | ATARI_NOFOCUS)) )
	{
		if( ++s_nHWLoopCounter == 128 )
		{
			/* Full time for PAL would be 1280ms, for NTSC 1067ms */
			static const ULONG ulTimes[ 3 ] = { 0, 2560, 2134 };

			ULONG ulTotalTime = timeGetTime() - s_ulStartMeasure;
			ULONG ulSpeed;
			char  szSpeed[ 128 ];
			
			if( ulTotalTime == 0 )
				ulTotalTime = 1;

			ulSpeed = ulTimes[ default_tv_mode ] * 100 / ulTotalTime + 5;
			if( !(g_ulMiscStates & MS_FULL_SPEED) && ulSpeed > 100 )
				ulSpeed = 100;

			sprintf( szSpeed, "Speed: %d%% ", ulSpeed );
			if( g_ulScreenMode & SM_MODE_FULL )
				strcat( szSpeed, g_szSystemText );

			if( !(g_ulScreenMode & SM_ATTR_NO_MENU) )
				pStatusBar->SetWindowText( szSpeed );

			s_ulStartMeasure = timeGetTime();
			s_nHWLoopCounter = 0;
		}

		if( g_ulAtariState & ATARI_RUNNING )
		{
			if( g_ulScreenMode & SM_MODE_FULL && g_ulScreenMode & SM_OPTN_HIDE_CURSOR &&
				g_nShowCursor > -1 && --g_nShowCursor == 0 )
			{
				ShowCursor( FALSE ); /* Hide the mouse cursor */
			}
			WinAtari800_Hardware();  /* Do the emulation work */
		}
		return TRUE;
	}
	return FALSE;
}
