/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// Atari800WinView.cpp : implementation of the CAtari800WinView class
//

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Atari800WinDoc.h"
#include "Helpers.h"
#include "ErrorLogDlg.h"
#include "Atari800WinView.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static ULONG s_unLostTime;

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView

IMPLEMENT_DYNCREATE(CAtari800WinView, CView)

BEGIN_MESSAGE_MAP(CAtari800WinView, CView)
	//{{AFX_MSG_MAP(CAtari800WinView)
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView construction/destruction

CAtari800WinView::CAtari800WinView()
{
	// TODO: add construction code here
}

CAtari800WinView::~CAtari800WinView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView drawing

void
CAtari800WinView::
OnDraw( CDC *pDC )
{
	RECT rc;
	if( g_ulAtariState & ATARI_LOAD_FAILED )
	{
		if( g_ulAtariState & ATARI_LOAD_WARNING )
		{
			char szFailed[ 512 + LOADSTRING_STRING_SIZE ];
			int  nResult;

#ifdef WIN_USE_FLIP_BUFFER
			/* Get surface for GDI if necessary */
			FlipToGDI();
#endif
			ShowMousePointer();

			LoadString( NULL, IDS_BOOT_ERROR, szFailed, LOADSTRING_STRING_SIZE );
			nResult = MessageBox( szFailed, "Atari800Win", MB_ICONWARNING | MB_YESNO );
			g_ulAtariState &= ~ATARI_LOAD_WARNING;
			if( nResult == IDYES )
			{
				CErrorLogDlg dlgErrorLog;
				dlgErrorLog.DoModal();
			}
		}
		GetClientRect( &rc );
		pDC->PatBlt( rc.left, rc.top, rc.right, rc.bottom, BLACKNESS );

		DescribeAtariSystem();
		return;
	}

	if( !(g_ulAtariState & ATARI_CLOSING) )
	{
		if( !g_hWnd )
		{
			StartAtariMachine();
			return;
		}
		if( g_ulAtariState & (ATARI_PAUSED | ATARI_NOFOCUS) )
		{
			if( atari_screen )
			{
				if( g_ulScreenMode & SM_MODE_FULL )
					return;
				/* Redraw display using GDI */
				RedrawScreen( pDC->m_hDC );
			}
			else
			{
				GetClientRect( &rc );
				pDC->PatBlt( rc.left, rc.top, rc.right, rc.bottom, BLACKNESS );
			}
			return;
		}
	}
	if( g_ulAtariState & ATARI_CRASHED )
	{
		GetClientRect( &rc );
		pDC->PatBlt( rc.left, rc.top, rc.right, rc.bottom, BLACKNESS );

		DescribeAtariSystem();
	}
}

void
CAtari800WinView::
StartAtariMachine()
{
	g_hWnd      = GetSafeHwnd();
	g_hScreenDC = ::GetDC( g_hWnd );
	
	g_hMainWnd  = AfxGetMainWnd()->GetSafeHwnd();
	g_hDInput   = AfxGetInstanceHandle();

	if( InitialiseScreen( FALSE ) &&
		InitialiseSound() &&
		InitialiseInput() )
	{
		::InvalidateRect( g_hMainWnd, NULL, FALSE );
		g_ulAtariState &= ~(ATARI_LOAD_FAILED | ATARI_PAUSED);// | ATARI_NOFOCUS);
		g_ulAtariState |= ATARI_RUNNING;
		/* Right before we actually start the Atari, we write out a boot
		   failure message to the registry. During _normal_ closing of
		   windows we clear the "failure" mark in the WM_CLOSE handler.
		   This way if the Atari causes the Windows program to crash it's
		   easy to tell by testing for boot failure upon reading the
		   value from the registry initially*/
		g_ulMiscStates |= MS_LAST_BOOT_FAILED;

		WriteRegDWORD( NULL, REG_MISC_STATES, g_ulMiscStates );
	}
	else
	{
		g_ulAtariState |= ATARI_LOAD_FAILED | ATARI_PAUSED;
		Invalidate();
	}
	DescribeAtariSystem();
}

void
CAtari800WinView::
OnKillFocus( CWnd *pNewWnd )
{
	if( g_ulAtariState & ATARI_RUNNING )
	{
		g_ulAtariState |= ATARI_NOFOCUS;
		s_unLostTime = timeGetTime();
		ClearSound( FALSE );
		ResetKeys();
		DescribeAtariSystem();
	}
	CView::OnKillFocus( pNewWnd );
}

void
CAtari800WinView::
OnSetFocus( CWnd *pOldWnd )
{
#ifdef WIN_USE_PERF_COUNTER
	LARGE_INTEGER lnTime;
	ULONG	      ulTimerLastVal = g_ulAtariHWNexttime;
#endif /*WIN_USE_PERF_COUNTER*/

	if( g_ulAtariState & ATARI_LOAD_FAILED )
		return;

	if( g_ulAtariState & ATARI_CRASHED )
	{
		DescribeAtariSystem();
		return;
	}
	g_ulAtariState &= ~ATARI_NOFOCUS;
	RestartSound();

#ifdef WIN_USE_PERF_COUNTER
	QueryPerformanceCounter( &lnTime );
	g_ulAtariHWNexttime = lnTime.LowPart + g_ulDeltaT;
	g_bTimerRollover    = (BOOL)(ulTimerLastVal > g_ulAtariHWNexttime);
#else /*WIN_USE_PERF_COUNTER*/
	g_ulAtariHWNexttime = timeGetTime() + g_ulDeltaT;
#endif /*WIN_USE_PERF_COUNTER*/

	DescribeAtariSystem();

	CView::OnSetFocus( pOldWnd );
}

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView diagnostics

#ifdef _DEBUG
void CAtari800WinView::AssertValid() const
{
	CView::AssertValid();
}

void CAtari800WinView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAtari800WinDoc* CAtari800WinView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAtari800WinDoc)));
	return (CAtari800WinDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAtari800WinView message handlers

BOOL
CAtari800WinView::
OnEraseBkgnd( CDC *pDC )
{
	//Don't need to erase...I always have something that covers the whole window
	return TRUE;
}

void
CAtari800WinView::
OnDestroy() 
{
	g_ulAtariState = ATARI_UNINITIALIZED | ATARI_PAUSED | ATARI_CLOSING;
	/* Clear last boot failed message so on reboot we don't think we crashed */
	g_ulMiscStates &= ~MS_LAST_BOOT_FAILED;
	WriteRegDWORD( NULL, REG_ENABLE_SIO_PATCH, enable_sio_patch );
	WriteRegDWORD( NULL, REG_MISC_STATES,      g_ulMiscStates   );

	Atari_Exit( 0 );

	if( g_hScreenDC && g_hWnd )
		::ReleaseDC( g_hWnd, g_hScreenDC );
	g_hScreenDC = NULL;
	g_hWnd = NULL;

	CView::OnDestroy();
}

void
CAtari800WinView::
OnPrint( CDC        *pDC,
		 CPrintInfo *pInfo )
{
	int xRes, nMult;
	int nWidth, nHeight;

	/* Make backup of original values */
	nWidth  = g_lpbmi->bmiHeader.biWidth;
	nHeight = g_lpbmi->bmiHeader.biHeight;

	g_lpbmi->bmiHeader.biWidth  = ATARI_WIDTH;//ATARI_VIS_WIDTH;
	g_lpbmi->bmiHeader.biHeight = -ATARI_HEIGHT;

	/* Find the largest integral multiple of width on the page */
	xRes  = pDC->GetDeviceCaps( HORZRES );
	nMult = xRes / ATARI_WIDTH;//ATARI_VIS_WIDTH;
	/* And stretch the original DIB to that size */
	StretchDIBits( pDC->m_hDC, 0, 0, ATARI_WIDTH * nMult, ATARI_HEIGHT * nMult,
					0, 0, ATARI_WIDTH, ATARI_HEIGHT,
					atari_screen, g_lpbmi, DIB_RGB_COLORS, SRCCOPY );
//	StretchDIBits( pDC->m_hDC, 0, 0, ATARI_VIS_WIDTH * nMult, ATARI_HEIGHT * nMult,
//				   ATARI_HORZ_CLIP, 0, ATARI_VIS_WIDTH, ATARI_HEIGHT,
//				   (UBYTE *)atari_screen, g_lpbmi, DIB_RGB_COLORS, SRCCOPY );

	/* Restore original values */
	g_lpbmi->bmiHeader.biWidth  = nWidth;
	g_lpbmi->bmiHeader.biHeight = nHeight;

//	CView::OnPrint(pDC, pInfo);
}

BOOL
CAtari800WinView::
OnPreparePrinting( CPrintInfo *pInfo )
{
	return DoPreparePrinting( pInfo );
}

void
CAtari800WinView::
OnInitialUpdate()
{
	CView::OnInitialUpdate();
	
	AfxGetMainWnd()->SetWindowPos( &wndNoTopMost, 0, 0, 
		ATARI_VIS_WIDTH + GetSystemMetrics( SM_CXDLGFRAME ) * 2 + GetSystemMetrics( SM_CXEDGE ) * 2,
		ATARI_HEIGHT + GetSystemMetrics( SM_CYMENU ) + g_nStatusSize + GetSystemMetrics( SM_CYDLGFRAME ) * 2 +
		GetSystemMetrics( SM_CYCAPTION ) + GetSystemMetrics( SM_CYEDGE ) * 2,
		SWP_NOMOVE | SWP_SHOWWINDOW );
}

void
CAtari800WinView::
OnMouseMove( UINT nFlags, CPoint point )
{
	ShowMousePointer();

	CView::OnMouseMove( nFlags, point );
}
