/****************************************************************************
File    : ErrorLogDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CErrorLogDlg implementation file
@(#) #BY# Tomasz Szymankowski, Richard Lawrence
@(#) #LM# 01.07.2000
*/

/*
Copyright (c) 1998 Richard Lawrence

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "ErrorLogDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CErrorLogDlg dialog

BEGIN_MESSAGE_MAP(CErrorLogDlg, CDialog)
	//{{AFX_MSG_MAP(CErrorLogDlg)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CErrorLogDlg::CErrorLogDlg( CWnd *pParent /*=NULL*/ )
	: CDialog( CErrorLogDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CErrorLogDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void
CErrorLogDlg::
DoDataExchange( CDataExchange* pDX )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CErrorLogDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
// CErrorLogDlg message handlers

BOOL
CErrorLogDlg::
OnInitDialog() 
{
	CDialog::OnInitDialog();

	CRect rcDlg, rcCtrl;
	CWnd *pCtrl;

	GetClientRect( rcDlg );

	pCtrl = GetDlgItem( IDC_ERRORLOG_EDIT );
	if( pCtrl )
	{
		pCtrl->GetWindowRect( rcCtrl );
		ScreenToClient( rcCtrl );
		m_nEditYSub = rcDlg.bottom - rcCtrl.bottom + rcCtrl.top;
		m_nEditXSub = rcDlg.right - rcCtrl.right + rcCtrl.left;
	}
	pCtrl = GetDlgItem( IDOK );
	if( pCtrl )
	{
		pCtrl->GetWindowRect( rcCtrl );
		ScreenToClient( rcCtrl );
		m_nButnYSub = rcDlg.bottom - rcCtrl.top;
		m_nButnXSub = rcDlg.right - rcCtrl.left;
	}
	/* The dialog template is very small because dialog's size
	   could be resized before showing on the screen in other way.
       That's why we have to enlarge dialog window size here. */
	SetWindowPos( NULL, 0, 0, rcDlg.Width() + 150, rcDlg.Height() + 100, SWP_NOMOVE );
	
	SetDlgItemText( IDC_ERRORLOG_EDIT, (const char *)memory_log );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void
CErrorLogDlg::
OnSize( UINT nType,
		int  cx,
		int  cy )
{
	CDialog::OnSize( nType, cx, cy );

	CWnd *pCtrl = GetDlgItem( IDC_ERRORLOG_EDIT );
	if( pCtrl )
	{
		pCtrl->SetWindowPos( NULL,
			0, 0,
			cx - m_nEditXSub,
			cy - m_nEditYSub,
			SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );
	}
	pCtrl = GetDlgItem( IDOK );
	if( pCtrl )
	{
		pCtrl->SetWindowPos( NULL,
			cx - m_nButnXSub,
			cy - m_nButnYSub,
			0, 0,
			SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE );
	}
}
