/****************************************************************************
File    : NewDiskImageDlg.cpp
/*
@(#) #SY# Atari800Win
@(#) #IS# CNewDiskImageDlg implementation file
@(#) #BY# Tomasz Szymankowski
@(#) #LM# 30.06.2000
*/

/*
Copyright (c) 2000 Tomasz Szymankowski

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version. This program is 
distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. You should have received a copy of the GNU
General Public License along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "StdAfx.h"
#include "Atari800Win.h"
#include "Helpers.h"
#include "WarningDlg.h"
#include "NewDiskImageDlg.h"

//#include "core.h"			// AtariWin core

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IMAGE_FORMATS_NO		4
#define MAX_SECTORS_NO		65535

/////////////////////////////////////////////////////////////////////////////
// CNewDiskImageDlg dialog

BEGIN_MESSAGE_MAP(CNewDiskImageDlg, CDialog)
	//{{AFX_MSG_MAP(CNewDiskImageDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_NEWDISKIMAGE_SECTORSPIN, OnDeltaposSectorSpin)
	ON_EN_KILLFOCUS(IDC_NEWDISKIMAGE_SECTORS, OnKillfocusSectors)
	ON_BN_CLICKED(IDC_NEWDISKIMAGE_90K, OnNewDiskImage90k)
	ON_BN_CLICKED(IDC_NEWDISKIMAGE_130K, OnNewDiskImage130k)
	ON_BN_CLICKED(IDC_NEWDISKIMAGE_180K, OnNewDiskImage180k)
	ON_BN_CLICKED(IDC_NEWDISKIMAGE_ATTACHDISK_CHECK, OnAttachDiskCheck)
	ON_BN_CLICKED(IDC_NEWDISKIMAGE_OTHER, OnNewDiskImageOther)
	ON_CBN_SELCHANGE(IDC_NEWDISKIMAGE_ATTACHDISK_COMBO, OnSelchangeAttachDiskCombo)
	ON_CBN_SELCHANGE(IDC_NEWDISKIMAGE_BYTESPERSECTOR, OnSelchangeBytesPerSector)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
//	ON_BN_CLICKED(IDC_NEWDISKIMAGE_C000RAM, OnC000Ram)

/*========================================================
Method   : CNewDiskImageDlg::CNewDiskImageDlg
=========================================================*/
/* #FN#
   Standard constructor */
CNewDiskImageDlg::
CNewDiskImageDlg( CWnd *pParent /*=NULL*/ /* #IN# Pointer to the parent window */ )
	: CDialog( CNewDiskImageDlg::IDD, pParent )
{
	//{{AFX_DATA_INIT(CNewDiskImageDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
} /* #OF# CNewDiskImageDlg::CNewDiskImageDlg */

/*========================================================
Method   : CNewDiskImageDlg::DoDataExchange
=========================================================*/
/* #FN#
   Dynamic Data Exchange (not using) */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
DoDataExchange( CDataExchange *pDX /* #IN# Pointer to CDataExchange object */ )
{
	CDialog::DoDataExchange( pDX );
	//{{AFX_DATA_MAP(CNewDiskImageDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
} /* #OF# CNewDiskImageDlg::DoDataExchange */


/////////////////////////////////////////////////////////////////////////////
// CNewDiskImageDlg implementation

/*========================================================
Method   : CNewDiskImageDlg::SetDlgState
=========================================================*/
/* #FN#
   Sets up the state of the dialog controls */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
SetDlgState()
{
	CComboBox *pCombo1 = (CComboBox *)GetDlgItem( IDC_NEWDISKIMAGE_BYTESINBOOT );
	CComboBox *pCombo2 = (CComboBox *)GetDlgItem( IDC_NEWDISKIMAGE_BYTESPERSECTOR );
	CWnd      *pWindow = GetDlgItem( IDC_NEWDISKIMAGE_SECTORS );

	BOOL abEnabled[][ IMAGE_FORMATS_NO ] =
	{
		{ FALSE, FALSE, TRUE,  TRUE },
		{ FALSE, FALSE, FALSE, TRUE },
		{ FALSE, FALSE, FALSE, TRUE }
	};

	UINT anContent[][ IMAGE_FORMATS_NO ] =
	{
		{ 0/*128*/,  0/*128*/, 0/*128*/ },
		{ 0/*128*/,  0/*128*/, 1/*256*/ },
		{ 720,       1040,     720      }
	};

	ASSERT(pCombo1 && pCombo2 && pWindow);

	CheckRadioButton( IDC_NEWDISKIMAGE_90K, IDC_NEWDISKIMAGE_OTHER,
					  IDC_NEWDISKIMAGE_90K + m_nFormat );

	/* Set up activity of the controls */
	pCombo1->EnableWindow( abEnabled[ 0 ][ m_nFormat ] );
	pCombo2->EnableWindow( abEnabled[ 1 ][ m_nFormat ] );
	pWindow->EnableWindow( abEnabled[ 2 ][ m_nFormat ] );
	/* There is the spin not enabled/disabled yet */
	pWindow = GetDlgItem( IDC_NEWDISKIMAGE_SECTORSPIN );
	ASSERT(pWindow);
	pWindow->EnableWindow( abEnabled[ 2 ][ m_nFormat ] );

	/* Set up parameters */
	if( IMAGE_FORMATS_NO - 1 > m_nFormat )
	{
		pCombo1->SetCurSel( anContent[ 0 ][ m_nFormat ] );
		pCombo2->SetCurSel( anContent[ 1 ][ m_nFormat ] );

		m_unSectors = anContent[ 2 ][ m_nFormat ];
		SetDlgItemInt( IDC_NEWDISKIMAGE_SECTORS, m_unSectors, FALSE );
	}
	else
	{
		int nSelect = pCombo2->GetCurSel();
		if( CB_ERR != nSelect )
		{
			/* Verify state of Bytes In Boot combo */
			pCombo1->SetCurSel( 0 /*nSelect*/ ); /* Always suggest 128 */
			pCombo1->EnableWindow( (BOOL)nSelect );
		}
	}
	/* Set up "attach to drive" group */
	pCombo1 = (CComboBox *)GetDlgItem( IDC_NEWDISKIMAGE_ATTACHDISK_COMBO );
	ASSERT(pCombo1);
	pCombo1->SetCurSel( m_nDriveNumber );
	pCombo1->EnableWindow( m_bAttachDrive );

	if( m_bAttachDrive )
	{
		CButton *pButton = (CButton *)GetDlgItem( IDC_NEWDISKIMAGE_ATTACHDISK_CHECK );
		ASSERT(pButton);
		pButton->SetCheck( 1 );
	}
} /* #OF# CNewDiskImageDlg::SetDlgState */


/////////////////////////////////////////////////////////////////////////////
// CNewDiskImageDlg message handlers

/*========================================================
Method   : CNewDiskImageDlg::OnInitDialog
=========================================================*/
/* #FN#
   Performs special processing when the dialog box is initialized */
BOOL
/* #AS#
   TRUE unless you set the focus to a control */
CNewDiskImageDlg::
OnInitDialog()
{
	CDialog::OnInitDialog();

	strcpy( m_szImageName, "Empty" );
	m_nFormat      = 0;
	m_nDriveNumber = 1;
	m_bAttachDrive = TRUE;

	SetDlgState();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
} /* #OF# CNewDiskImageDlg::OnInitDialog */

/*========================================================
Method   : CNewDiskImageDlg::OnDeltaposSectorSpin
=========================================================*/
/* #FN#
	Sets the state of object regarding to Number of Sectors spin */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnDeltaposSectorSpin( NMHDR   *pNMHDR, /* #IN#  */
					  LRESULT *pResult /* #OUT# */ )
{
	NM_UPDOWN *pNMUpDown = (NM_UPDOWN*)pNMHDR;

	m_unSectors -= pNMUpDown->iDelta;
	if( m_unSectors < 1 )
		m_unSectors = 1;
	if( m_unSectors > MAX_SECTORS_NO )
		m_unSectors = MAX_SECTORS_NO;

	SetDlgItemInt( IDC_NEWDISKIMAGE_SECTORS, m_unSectors, FALSE );

	*pResult = 0;
} /* #OF# CNewDiskImageDlg::OnDeltaposSectorSpin */

/*========================================================
Method   : CNewDiskImageDlg::OnKillfocusSectors
=========================================================*/
/* #FN#
	Sets the state of object regarding to Number of Sectors spin */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnKillfocusSectors()
{
	BOOL bTrans;
	UINT unSectors = GetDlgItemInt( IDC_NEWDISKIMAGE_SECTORS, &bTrans, FALSE );

	if( bTrans )
	{
		m_unSectors = unSectors;
		if( m_unSectors < 1 )
			m_unSectors = 1;
		if( m_unSectors > MAX_SECTORS_NO )
			m_unSectors = MAX_SECTORS_NO;
	}
	if( !bTrans || unSectors < 1 || unSectors > MAX_SECTORS_NO )
		SetDlgItemInt( IDC_NEWDISKIMAGE_SECTORS, m_unSectors, FALSE );
} /* #OF# CNewDiskImageDlg::OnKillfocusSectors */

/*========================================================
Method   : CNewDiskImageDlg::OnNewDiskImage90k
=========================================================*/
/* #FN#
	Sets the state of object regarding to checked radiobutton */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnNewDiskImage90k() 
{
	m_nFormat = 0;
	SetDlgState();
} /* #OF# CNewDiskImageDlg::OnNewDiskImage90k */

/*========================================================
Method   : CNewDiskImageDlg::OnNewDiskImage130k
=========================================================*/
/* #FN#
	Sets the state of object regarding to checked radiobutton */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnNewDiskImage130k() 
{
	m_nFormat = 1;
	SetDlgState();
} /* #OF# CNewDiskImageDlg::OnNewDiskImage130k */

/*========================================================
Method   : CNewDiskImageDlg::OnNewDiskImage180k
=========================================================*/
/* #FN#
	Sets the state of object regarding to checked radiobutton */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnNewDiskImage180k() 
{
	m_nFormat = 2;
	SetDlgState();
} /* #OF# CNewDiskImageDlg::OnNewDiskImage180k */

/*========================================================
Method   : CNewDiskImageDlg::OnNewDiskImageOther
=========================================================*/
/* #FN#
	Sets the state of object regarding to checked radiobutton */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnNewDiskImageOther()
{
	m_nFormat = 3;
	SetDlgState();
} /* #OF# CNewDiskImageDlg::OnNewDiskImageOther */

/*========================================================
Method   : CNewDiskImageDlg::OnSelchangeBytesPerSector
=========================================================*/
/* #FN#
	Sets the state of object regarding to Bytes Per Sector combo */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnSelchangeBytesPerSector()
{
	SetDlgState();
} /* #OF# CNewDiskImageDlg::OnSelchangeBytesPerSector */

/*========================================================
Method   : CNewDiskImageDlg::OnAttachDiskCheck
=========================================================*/
/* #FN#
	Sets the state of object regarding to Attach To Drive checkbox */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnAttachDiskCheck()
{
	CButton *pButton = (CButton *)GetDlgItem( IDC_NEWDISKIMAGE_ATTACHDISK_CHECK );
	CWnd    *pCombo  = GetDlgItem( IDC_NEWDISKIMAGE_ATTACHDISK_COMBO );
	ASSERT(pButton && pCombo);

	pCombo->EnableWindow( m_bAttachDrive = pButton->GetCheck() );
} /* #OF# CNewDiskImageDlg::OnAttachDiskCheck */

/*========================================================
Method   : CNewDiskImageDlg::OnSelchangeAttachDiskCombo
=========================================================*/
/* #FN#
	Sets the state of object regarding to changing Drive Number combo */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnSelchangeAttachDiskCombo() 
{
	CComboBox *pCombo = (CComboBox *)GetDlgItem( IDC_NEWDISKIMAGE_ATTACHDISK_COMBO );
	ASSERT(pCombo != NULL);
	m_nDriveNumber = pCombo->GetCurSel();
} /* #OF# CNewDiskImageDlg::OnSelchangeAttachDiskCombo */

/*========================================================
Method   : CNewDiskImageDlg::OnOK
=========================================================*/
/* #FN#
   Called when the user clicks the OK button */
void
/* #AS#
   Nothing */
CNewDiskImageDlg::
OnOK() 
{
	if( PickFileName( FALSE, m_szImageName, "Format and name of disk image file to save",
					  "ATR disk image (*.atr)|*.atr|XFD disk image (*.xfd)|*.xfd||",
					  "atr", PF_SAVE_FLAGS, FALSE ) &&
		m_szImageName != '\0' )
	{
		CComboBox *pCombo = NULL;

		UINT  unBytesInBootSec;
		UINT  unBytesPerSector;
		UINT  unSectors;
		UINT  unImageLen;
		BOOL  bTrans;
		FILE *pfImage = NULL;
		char  szPostfix[ 5 ];

		/* Receive the parameters */
		pCombo = (CComboBox *)GetDlgItem( IDC_NEWDISKIMAGE_BYTESINBOOT );
		ASSERT(pCombo);	
		unBytesInBootSec = (pCombo->GetCurSel() + 1) * 128;

		pCombo = (CComboBox *)GetDlgItem( IDC_NEWDISKIMAGE_BYTESPERSECTOR );
		ASSERT(pCombo);	
		unBytesPerSector = (pCombo->GetCurSel() + 1) * 128;

		unSectors = GetDlgItemInt( IDC_NEWDISKIMAGE_SECTORS, &bTrans, FALSE );
		if( !bTrans )
		{
			Aprint( "Error while receiving content of dialog controls" );
			return;
		}
		/* Image length divided by 16 */
		unImageLen = ((unSectors - 3) * unBytesPerSector + 3 * unBytesInBootSec) / 16;

		/* Open the image file */
		if( NULL == (pfImage = fopen( m_szImageName, "wb" )) )
		{
			char szError[ MAX_PATH + 32 ];
			sprintf( szError, "Can't open image file %s.", m_szImageName );
			MessageBox( szError, "Atari800Win", MB_ICONEXCLAMATION | MB_OK );
			return;
		}

		strncpy( szPostfix, &m_szImageName[ strlen( m_szImageName ) - 4 ], 5 );
		if( _stricmp( szPostfix, ".atr" ) == 0 )
		{
			/* There is the definition of ATR_Header structure in atari.h */
			struct ATR_Header atrHeader;

			ZeroMemory( &atrHeader, sizeof(ATR_Header) );
			atrHeader.magic1       = MAGIC1;
			atrHeader.magic2       = MAGIC2;
			atrHeader.secsizelo    =  unBytesPerSector   & 0x00ff;
			atrHeader.secsizehi    = (unBytesPerSector   & 0xff00) >> 8;
			atrHeader.seccountlo   =  LOWORD(unImageLen) & 0x00ff;
			atrHeader.seccounthi   = (LOWORD(unImageLen) & 0xff00) >> 8;
			atrHeader.hiseccountlo =  HIWORD(unImageLen) & 0x00ff;
			atrHeader.hiseccounthi = (HIWORD(unImageLen) & 0xff00) >> 8;

			fwrite( &atrHeader, sizeof(ATR_Header), 1, pfImage );
		}
		/* Build an empty body of the image */
		for( int i = 0; i < (int)unImageLen; i++ )
			fwrite( "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000", 16, 1, pfImage );
		/* Close the image file */
		fflush( pfImage );
		fclose( pfImage );
	}
	CDialog::OnOK();
} /* #OF# CNewDiskImageDlg::OnOK */
