/*	TESTMENU - A SAMPLE MENU-BAR PROGRAM
   	------------------------------------
   	By
   	Steve Ollett, 07-Jan-2001.
	(If only I'd have learned this 10 years ago!!!)

	Important Note:
	---------------
	When compiling this code, all files (including RSC file, RSC header
	& Project File must be in the same directory as the C code.	*/
   
/* INCLUDE FILES */
#include <stdlib.h>
#include <aes.h>

/* #include <stdio.h> */
/* #include <vdi.h>   */

#include "testmenu.h"

	
OBJECT *menu_ptr;						/* Menu Pointer Variable 	*/
int finished=0;							/* Program Status Variables */
int checked;							/* Menu Item Status 		*/
int dimmed=1;

void initialise(void)
{
	if (appl_init())
		exit(EXIT_FAILURE);
	if(!rsrc_load("TESTMENU.RSC"))
	{
		form_alert(1,"[1][Resource File Error][ Quit ]");
		exit(EXIT_FAILURE);
	}	
	rsrc_gaddr(R_TREE,menu1,&menu_ptr);
	menu_bar(menu_ptr,1);	

	graf_mouse(ARROW,NULL);
}


void handle_menu(int title,int item)
{

	switch (item)
	{
		case mabout:
			form_alert(1,"[0][| TESTMENU Version 1.0  |   (Lattice C 5.60)  | |S. Ollett, 07-Jan-2001  ][ OK ]");
			break;
	
		case mopen:
			form_alert(1,"[0][|Call Your File/Window  |Open Procedure Here  ][ OK ]");
			break; 		
	
		case mclose:
			form_alert(1,"[0][|Call Your File/Window  |Close Procedure Here ][ OK ]");
			break;

		case mquit:
			finished=1;
			break;

		case mcheckme:
			checked^=1;
			menu_icheck(menu_ptr,mcheckme,checked);
			break;
	
		case mdimme:
			dimmed^=1;
			menu_ienable(menu_ptr,mdimme,dimmed);
			break;	

		case mnotes:
			form_alert(1,"[0][Updates Will Include:| |a) Window Handling|b) Menu Keyboard Shortcuts  ][ OK ]");
			break;

	}
	menu_tnormal(menu_ptr,title,1);
}

void handle_events(void)
{
	short mbuff[8];

	for (; !finished;)
	{
		evnt_mesag(mbuff);
		if (mbuff[0]==MN_SELECTED)
		{
			wind_update(BEG_UPDATE);
			handle_menu(mbuff[3],mbuff[4]);
			wind_update(END_UPDATE);
		}
	}
}


void deinitialise(void)
{
	menu_bar(menu_ptr,0);	/* Turn OFF menu 				*/
	rsrc_free();			/* Free RSC Memory				*/
	appl_exit();			/* EXIT AES						*/
}


int main(void)
{
	initialise();			/* Load RSC File, etc.			*/
	handle_events();		/* Select Menu Options, etc.	*/
	deinitialise();			/* Close Down Program			*/
	return EXIT_SUCCESS;
}


