* FX 4.5 - listing w assemblerze 
* Spectrum Display (50 Hz)
* (opr. na podstawie procedury Muttera Frdrica przez spk (NRG))

start
        lea.l   spu_display(pc),a0      ; adres procedury przerwania do A0
        lea.l   oldvec(pc),a2           ; miejsce na stary wektor
        movea.l vblvec,a1               ; wektor przerwania VBL do A1
        cmpa.l  a0,a1                   ; porwnanie wektorw
        beq     deinstal                ; jeli rwne to powrt do normy

instal
        move.l  a1,(a2)+                ; zapamitanie starego wektora
        move.l  8(sp),(a2)+             ; zapamitanie adresu obrazka 
        move.l  a0,vblvec               ; ustawienie nowego wektora VBL
        rts

deinstal
        move.l   (a2),vblvec            ; przywrcenie starego wektora VBL
        rts

spu_display                             ; procedura obsugi przerwania VBL
        move.w  sr,-(sp)                ; zapamitanie starego rejestru SR
        ori.w   #$0700,sr               ; zablokowanie przerwa
        lea.l   $FFFF8240,a4            ; adres palety kolorw do A4
        lea.l   $FFFF8209,a5            ; adres LSB licznika pamici obrazu
        lea.l   start_sync(pc),a6       ; adres opznienia do A6
        move.l  picadr(pc),a3           ; adres obrazka do A3
        move.l  a3,d0
        ror.l   #8,d0                   ; przepisanie go do rejestrw 
        move.b  d0,$FFFF8203
        ror.l   #8,d0
        move.b  d0,$FFFF8201
        adda.l  #32000,a3               ; ustalenie adresu palety kolorw
        move.w  #198,d7                 ; procedura obsuguje 199 linii
        moveq.l #0,d0                   ; zerowanie rejestru D0
wait
        tst.b   (a5)                    ; sprawdzenie, czy SHIFTER zacz 
        beq     wait                    ; pobiera dane
        move.b  (a5),d0                 ; jeli tak, synchronizowanie ptli
        adda.l  d0,a6                   ; zmiana momentu wejcia
        jmp     (a6)                    ; skok w ptle wywietlajc
start_sync
        REPT 81                         ; 81 rozkazw NOP (opnienie)
        nop
        ENDR
nextline                                ; pocztek linii
        nop                             ; nop (dla 50 Hz)
        lea.l   (a4),a0                 ; adres palety do rejestrw A0-A2
        lea.l   (a4),a1
        lea.l   (a4),a2

        move.l  (a3)+,(a0)+             ; Paleta nr 1
        move.l  (a3)+,(a0)+
        move.l  (a3)+,(a0)+
        move.l  (a3)+,(a0)+
        move.l  (a3)+,(a0)+
        move.l  (a3)+,(a0)+
        move.l  (a3)+,(a0)+
        move.l  (a3)+,(a0)+

        move.l  (a3)+,(a1)+             ; Paleta nr 2
        move.l  (a3)+,(a1)+
        move.l  (a3)+,(a1)+
        move.l  (a3)+,(a1)+
        move.l  (a3)+,(a1)+
        move.l  (a3)+,(a1)+
        move.l  (a3)+,(a1)+
        move.l  (a3)+,(a1)+

        move.l  (a3)+,(a2)+             ; Paleta nr 3
        move.l  (a3)+,(a2)+
        move.l  (a3)+,(a2)+
        move.l  (a3)+,(a2)+
        move.l  (a3)+,(a2)+
        move.l  (a3)+,(a2)+
        move.l  (a3)+,(a2)+
        move.l  (a3)+,(a2)+
        nop
        dbra    d7,nextline
        move    (sp)+,sr                ; odtworzenie starego SR
skok
        jmp     $00000000

oldvec=skok+2
picadr
        ds.l    1

vblvec=$4ce
