
//-------------------------------------------------------------------
//
//	TIPANM INIT by Tebe/Madteam (28.08.2008)
//
//-------------------------------------------------------------------

ndlist	= $380


	org $c000

grb	.ds $1000


	org $d800

dl1	.ds $300
lcol	.ds $80
hcol	.ds $80

dl2	.ds $300
lrle	.ds $80
hrle	.ds $80

gr9	.ds $1000
gra	;	.ds $1000

//-------------------------------------------------------------------

	.zpvar w, r, p, h, q .word = $80


	.extrn tip9, tipA, tipB, tipLen		.word
	.extrn TIPANM.column, TIPANM.colRle	.word

	.public	tipanm_init, gr9, gra, grb, dl1, dl2, lcol, hcol, lrle, hrle


	.reloc


_dl1	dta a(dl1)
_dl2	dta a(dl2)

_9	dta a(tip9)
_a	dta a(tipA)
_b	dta a(tipB)

_gr9	dta a(gr9)
_gra	dta a(gra)
_grb	dta a(grb)

_column	dta a(TIPANM.column)
_colRle	dta a(TIPANM.colRle)

_tipLen	dta a(tipLen)


tipanm_init
	lda:cmp:req 20

	sei
	mva #0 $d40e
	sta $d400

	mva #$fe $d301


* ---	CLEAR MEM

	ldx #16
	ldy #0
	tya
clr0	sta gr9,y
clr1	sta gra,y
clr2	sta grb,y
	iny
	bne clr0

	inc clr0+2
	inc clr1+2
	inc clr2+2
	dex
	bne clr0


* ---	COPY TIP

	cpw _tipLen #4000+1
	scc
	mwa #4000 _tipLen

	COPY_TIP _9	_gr9+1
	COPY_TIP _A	_gra+1
	COPY_TIP _B	_grb+1


* ---	CREATE DLIST

	jsr mktipdl


* ---	LCOL, HCOL precalculation

	mwa _column	w
	mwa _colRle	r

	ldy #1			; +1

tabCol	mva w	lcol,y
	mva w+1	hcol,y

	mva r	lrle,y
	mva r+1	hrle,y

	adw w #16

	adw r #14

	iny
	bpl tabCol


* ---	REPLACE DLIST

	ldy #$1f
dl	mva newDL,y ndlist,y
	dey
	bpl dl

	mwa #ndlist 560


	lda:rne $d40b

	mva #$ff $d301

	mva #$40 $d40e
	cli

	rts


newDL	dta d'ppp'
	dta $42,a($bc40)
	:23 dta 2
	dta $41,a(ndlist)



.proc	COPY_TIP (.word yx .byte a) .reg

	.var length	.word

	stx src+1
	sty src+2

	sta dst+2
	mva #0 dst+1

	adw src+1 _tipLen length

	#while .word src+1 < length

src	lda $ffff
dst	sta $ff00

	inw src+1
	inw dst+1

	#end

	rts

.endp		


//-------------------------------------------------------------------


MKTIPDL	lda #$70
	:2 sta dl1+#
	:2 sta dl2+#

	lda #$20+$80
	sta dl1+2
	sta dl2+2

	mwa _gr9 h
	mwa _gra p
	mwa _grb q

	adw _dl1 #3 w
	adw _dl2 #3 r

	ldx #50

mkt1	ldy #0
	lda #$4f
	sta (w),y
	sta (r),y
	iny
	lda q
	sta (w),y
	sta (r),y
	iny
	lda q+1
	sta (w),y
	sta (r),y
	iny

	lda #$4f
	sta (w),y
	sta (r),y
	iny
	mva h (w),y
	mva p (r),y
	iny
	mva h+1 (w),y
	mva p+1 (r),y
	iny

	adw h #$28
	adw p #$28
	adw q #$28

	lda #$4f
	sta (w),y
	sta (r),y
	iny
	lda q
	sta (w),y
	sta (r),y
	iny
	lda q+1
	sta (w),y
	sta (r),y
	iny

	lda #$4f
	sta (w),y
	sta (r),y
	iny
	mva p (w),y
	mva h (r),y
	iny
	mva p+1 (w),y
	mva h+1 (r),y
	iny

	adw h #$28
	adw p #$28
	adw q #$28

	dex
	beq mkt11

	adw w #12
	adw r #12

	jmp mkt1

mkt11	tya
	sub #6
	tay

	lda #$41
	sta (w),y
	sta (r),y
	iny

	mva _dl1 (r),y
	mva _dl2 (w),y
	iny
	mva _dl1+1 (r),y
	mva _dl2+1 (w),y
	rts
