/********************************************************************
 FILENAME: DOOM.H
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

 Copyright (c) 1994 by Jake Hill:
 If you use any part of this code in your own project, please credit
 me in your documentation and source code.  Thanks.
********************************************************************/

#ifndef DOOM_H
#define DOOM_H

typedef struct
        {
           char signature[4];
           unsigned long num_entries;
           unsigned long foffset;
        } WAD_Header;

typedef struct
        {
           unsigned long foffset;
           unsigned long size;
           char name[8];
        } Directory_Entry;

typedef struct
        {
           short x;
           short y;
        } vertex;

typedef struct
        {
           short from, to;
           short flags, special, tag;
           short side[2];
        } line;

typedef struct
        {
           short tm_xoffset, tm_yoffset;
           char upper_tx[8];
           char lower_tx[8];
           char main_tx[8];
           short sector;
        } side;

typedef struct
        {
           short floor_ht;
           short ceiling_ht;
           char  floor_tx[8];
           char  ceiling_tx[8];
           short light;
           short type;
           short trigger;
        } sector;

typedef struct
        {
           short from, to;
           unsigned short angle;
           short line;
           short line_side;
           short line_offset;
        } seg;
typedef seg segment;

typedef struct
        {
           short num_segs;
           short first_seg;
        } ssector;

typedef struct
        {
           short x, y;
           short dx, dy;
           short ry2,ry1,rx1,rx2;
           short ly2,ly1,lx1,lx2;
           unsigned short right,left;
        } node;

typedef struct
        {
           short x, y;
           unsigned short angle;
           short thing_type;
           short attributes;
        } thing;

typedef struct
        {
           short x_origin, y_origin;
           short columns, rows;
           short *blockpointers;
        } blockmap_header;

typedef short blockmap;

//****************************************************************
// Additional structures created by me.
//****************************************************************

typedef struct
        {
           char type;
           char opaque;
           long y1, y2;
           long dy1, dy2;
        } wall;
        
typedef struct
        {
           short hight;
           short start, end;
        } floor_run;

typedef struct
        {
           short tex_num;
           short top, bottom;
        } wall_run;

#endif
