/********************************************************************
 FILENAME: KEYBOARD.HPP
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

********************************************************************/

#ifndef KEYBOARD_HPP
#define KEYBOARD_HPP

#define PR_RIGHT      77
#define PR_LEFT       75
#define PR_UP         72
#define PR_DOWN       80

#define PR_CTRL       29
#define PR_ALT        56
#define PR_LSHF       42
#define PR_RSHF       54

#define RL_RIGHT     205
#define RL_LEFT      203
#define RL_UP        200
#define RL_DOWN      208

#define RL_CTRL       157
#define RL_ALT        184
#define RL_LSHF       170
#define RL_RSHF       182

#define FLAG_UP        0x80
#define FLAG_DOWN      0x40
#define FLAG_LEFT      0x20
#define FLAG_RIGHT     0x10

#define FLAG_ALT       0x08
#define FLAG_CTRL      0x04
#define FLAG_LSHF      0x02
#define FLAG_RSHF      0x01

#define FLAG_SHIFT     0x03
#define FLAG_SLEFT     0x28
#define FLAG_SRIGHT    0x18

#define NFLAG_UP        0x7F
#define NFLAG_DOWN      0xBF
#define NFLAG_LEFT      0xDF
#define NFLAG_RIGHT     0xEF

#define NFLAG_ALT       0xF7
#define NFLAG_CTRL      0xFB
#define NFLAG_LSHF      0xFD
#define NFLAG_RSHF      0xFE

#define KEY_PLUS        78
#define KEY_MINUS       74

extern short key;
extern short key_flags;
extern short key_inst;

void SetKeyboardInt(void);
void ResetKeyboardInt(void);

#endif
