/********************************************************************
 FILENAME: VIEW.HPP
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

 Copyright (c) 1994 by Jake Hill:
 If you use any part of this code in your own project, please credit
 me in your documentation and source code.  Thanks.
********************************************************************/

#ifndef VIEW_HPP
#define VIEW_HPP

#include "DOOM.H"

class View
{
   private:

// Each array is dynamically allocated based on info in the WAD file.
      seg             *Seg_Array;
      side            *Side_Array;
      line            *Line_Array;
      node            *Node_Array;
      node           **PNode_Array;
      sector          *Sector_Array;
      vertex          *Vertex_Array;
      ssector         *SSector_Array;
      blockmap        *Blockmap_Array;
      blockmap_header *Blockmap_Header;

// A temp variable - probably a better way of doing this.
      wall     Wall;

// Player's X,Y location and Height.
      short Px,Py,Ph;
// The angle the player is facing.
      unsigned short Pangle;
// The angle made by the left side of the player's view cone.
      unsigned short LeftAngle;

// The sine & cosine of the angle the player is facing.
      long CosPangle, SinPangle;

// The node number of the Root Node in the BSP.
      short MaxNode;
// The height of the floor and ceiling currently being drawn.
      short floor_ht, ceiling_ht;

   public:

// Constructor & Destructor.
// Located in the file VIEW.CPP
      View(void);
     ~View(void);

// These functions do all of the rendering.
// They are all found in the file VIEW.CPP.
      void DrawView(void);
      void DrawNode(short);
      void DrawSSector(short);

      void LoadSeg(short);
      inline void DrawSegs(void);
      void AddWall(short,short,short,short,short, short);

      void AddFloorUp(short,short,short);
      void AddFloorDown(short,short,short);
      void EndFloorUp(short,short,short);
      void EndFloorDown(short,short,short);


// Utility functions.
// These functions are located in the file VIEW_UT.CPP.
      char OnRight(short);
      char OnRight(short,short);
      char  LeftSideInCone(short);
      char  RightSideInCone(short);

      void SetView(short,short,short,unsigned short);
      void GetView(short*,short*,short*,unsigned short*);
      void Close(void);

// Wad File Access functions.
// These functions are located in the file VIEW_IO.CPP.
      void OpenWad(char*, long);
      void LoadThings( Directory_Entry*, int);
      void LoadSegs( Directory_Entry*, int);
      void LoadSides( Directory_Entry*, int);
      void LoadLines( Directory_Entry*, int);
      void LoadNodes( Directory_Entry*, int);
      void LoadSectors( Directory_Entry*, int);
      void LoadVertexes( Directory_Entry*, int);
      void LoadSSectors( Directory_Entry*, int);
      void LoadBlockmap( Directory_Entry*, int);
};

#endif
