/* Defines for externe DSP-Modules */

#include <aes.h>

typedef unsigned int HDIALOG;

#define DSP1_0 8388607L
#define DSP0_5 4194304L

#define TRUE 1
#define FALSE 0


/*----------------------------------------------------
Send info about module to DigiTape:
void dtm_init(	Module_info *dtm_info,
								void *rsc, Rsc_info *rsc_info )
-----------------------------------------------------*/
#define dtm_init(dtm_info, rsc, rsc_info)\
		(*(glob->mh.sys->_dtm_init))(dtm_info, rsc, rsc_info)


/*------------------------------------------------------
Send info about sliders:
int	dtm_init_poti(void *vglob, int potinr,
									int type, int parent, int slider, int value)
--------------------------------------------------------*/
#define dtm_init_poti(vglob, potinr, type, parent, slider, value)\
		(*(glob->mh.sys->_dtm_init_poti))(vglob, potinr, type, parent, slider, value)


/*---------------------------------------------------------
get value from the logarithm table:
	value: 0 to 256
	return: 0 to 1 in DSP format (0 to DSP1_0)
long *log_tab_entry( int wert )
-----------------------------------------------------------*/
#define log_tab_entry(w) (*(glob->mh.sys->_log_tab_entry))(w)


/*---------------------------------------------------------
get value (0...max) from RSC slider:
	normalised to max (maximum 24 Bit )

	flag vertikal: TRUE if slider 0-position is  down Position
long get_rsc_pegel( int f_size, int s_size, int s_posi, long max,
										int vertikal )
-----------------------------------------------------------*/
#define get_rsc_pegel( f_s, s_s, s_p, max, vert )\
		(*(glob->mh.sys->_get_rsc_pegel))( f_s, s_s, s_p, max, vert )


/*----------------------------------------------------------
sets volume for one line (depending on Pan):
	button:  TRUE if line is on
  vol:     0 ... 255
	line_nr: wich line 
void set_line_volume( int button, int vol, int line_nr )
-----------------------------------------------------------*/
#define set_line_volume( button, vol, line_nr )\
		(*(glob->mh.sys->_set_line_volume))( button, vol, line_nr )


/*----------------------------------------------------------
sets panorama for one line (depending on volume):
	button:  TRUE if line is on
  pan:     0 ... 255
	line_nr: wich line 
void set_line_panorama( int button, int pan, int line_nr )
-----------------------------------------------------------*/
#define set_line_panorama( button, pan, line_nr )\
		(*(glob->mh.sys->_set_line_panorama))( button, pan, line_nr )


/*---------------------------------------------------------
change ob_state:
	if mask == 0 just ask
	set: 			-1 toggle, FALSE clear, TRUE set
  hdialog:	dialog handle
	item:			object index
	return:		old state
int DialogState(HDIALOG hdialog, int item, int set, int maske)
---------------------------------------------------------*/
#define DialogState(hd, item, set, maske)\
		(*(glob->mh.sys->_DialogState))(hd, item, set, maske)


/*---------------------------------------------------------
change ob_flags 
	if mask == 0 just ask
	set: 			-1 toggle, FALSE clear, TRUE set
  hdialog:	dialog handle
	item:			object index
	return:		old ob_flags
int DialogFlags(HDIALOG hdialog, int item, int set, int maske)
---------------------------------------------------------*/
#define DialogFlags(hd, item, set, maske)\
		(*(glob->mh.sys->_DialogFlags))(hd, item, set, maske)


/*---------------------------------------------------------
Like 'printf' for GEM-objects:
return: see printf
int DialogPrintf(HDIALOG hdialog, int item, LPSTR format, ...)
---------------------------------------------------------*/
#define	DialogPrintf (*(glob->mh.sys->_DialogPrintf))


/*---------------------------------------------------------
draw object
void draw_object( OBJECT *obj, int item )
---------------------------------------------------------*/
#define draw_object( obj, item )\
		(*(glob->mh.sys->_draw_object))( obj, item )


/*---------------------------------------------------------
like in GEM
---------------------------------------------------------*/
#define object_find( baum, anf_obj, tiefe, x, y )\
		(*(glob->mh.sys->_object_find))( baum, anf_obj, tiefe, x, y )


/*---------------------------------------------------------
set variable 'var' with size 'size' in DSP-Memory ('memtype': 'X' or 'Y')
void dm_setvar(int memtype, int var, long *value, int size)
---------------------------------------------------------*/
#define dm_setvar( memtype, var, value, size)\
		(*(glob->mh.sys->_dm_setvar))( memtype, var, value, size)


/*---------------------------------------------------------
reserve space for  variable  with size 'size' in DSP-Memory
('memtype': 'X' or 'Y')
return: address, 0 == error
int dm_defvar(int typ, int adrsize, int size)
---------------------------------------------------------*/
#define dm_defvar(typ, adrsize, size)\
		(*(glob->mh.sys->_dm_defvar))(typ, adrsize, size)


/*---------------------------------------------------------
link module 'modul' to DSP
adresses and constants can be set with 
following parameters i.e. ADDER_QUELLE, 0x3c, ...
last parameter has to be < 0
return: module handle or error (<0)
int cdecl dm_load(void *vmodul, ...)
---------------------------------------------------------*/
#define dm_load (*(glob->mh.sys->_dm_load))


/*---------------------------------------------------------
set block in DSP memory to value 'val'
'memtyp': 'X' oder 'Y'
void dsp_setblock( int memtyp, int adr, long val, int size)
---------------------------------------------------------*/
#define dsp_setblock( memtyp, adr, wert, size )\
		(*(glob->mh.sys->_dsp_setblock))( memtyp, adr, wert, size )

