*=======================================================*
*	BSP-Descent: latest update 23/02/96		*
*=======================================================*
*	Descend BSP tree, generating sectors & walls.	*
*=======================================================*

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Descend Binary Space Partitioning Tree		*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
	txtlong
*-------------------------------------------------------*
descend_bsp:
*-------------------------------------------------------*
*	Place start & terminator on heap and descend	*
*-------------------------------------------------------*
	move.l		sp,bsp_return
	lea		display_struct,a6
	push.w		#terminator
	push.w		maxnode
	bra		next_node
*-------------------------------------------------------*
*	Thread returns here when tree is exhausted	*
*-------------------------------------------------------*
finish_tree:
*-------------------------------------------------------*
	move.l		bsp_return,sp
	rts

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	[node] = [sector] -> draw this node		*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
	txtlong
*-------------------------------------------------------*
ssector_node:
*-------------------------------------------------------*
*	Stop drawing when [width] columns are filled	*
*-------------------------------------------------------*
	tst.w		columns
	beq.s		finish_tree
*-------------------------------------------------------*
*	Stop drawing when last node has been popped	*
*-------------------------------------------------------*
	not.w		d0
	beq.s		finish_tree
	eor.w		#$7FFF,d0
	move.w		d0,ourssector		

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Render ssector into run-buffer			*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
build_ssector:
*-------------------------------------------------------*
*	Locate [segs] for this [ssector]		*
*-------------------------------------------------------*
	move.l		display_ssectors(a6),a0
	moveq		#0,d4
	move.w		ssec_first(a0,d0.w*4),d4
	moveq		#0,d3
	move.w		ssec_segments(a0,d0.w*4),d3
*-------------------------------------------------------*
*	Locate [linedef] & [sidedef] for first [seg]	*
*-------------------------------------------------------*
	move.l		d4,d0
	move.l		display_segs(a6),a2
	add.l		d0,d0
	add.l		d4,d0
	lsl.l		#2,d0
	add.l		d0,a2				; a+(d*12)
	moveq		#0,d0
	move.w		seg_linedef(a2),d0
	moveq		#0,d2
	move.w		seg_sidedef(a2),d2
*-------------------------------------------------------*
*	Locate right [sidedef] for this [linedef]	*
*-------------------------------------------------------*
	move.l		d0,d1
	move.l		display_linedefs(a6),a0
	lsl.l		#3,d0
	sub.l		d1,d0
	add.l		d0,d0
	add.l		d0,a0				; a+(d*14)
	moveq		#0,d1
	move.w		linedef_right(a0,d2.w*2),d1 
*-------------------------------------------------------*
*	Locate [sector] for this [sidedef]		*
*-------------------------------------------------------*
	move.l		d1,d0 
	move.l		display_sidedefs(a6),a0
	lsl.l		#4,d0 
	sub.l		d1,d0				; a+(d*30)
	move.w		sidedef_sector(a0,d0.l*2),d1	
*-------------------------------------------------------*
*	Set up floor & ceiling heights for this sector	*
*-------------------------------------------------------*
	move.l		d1,d0
	add.l		d0,d0
	move.l		d0,d2
	lsl.l		#3,d0
	move.l		display_sectors(a6),a0
	sub.l		d2,d0
	sub.l		d1,d0				; a+(d*26)
	add.l		d0,d0
	add.l		d0,a0
	move.l		a0,this_sector
	move.w		sector_floorht(a0),floor_ht
	move.w		sector_ceilht(a0),ceiling_ht
	move.w		sector_ctns(a0),ceiling_texture
	move.w		sector_ftns(a0),floor_texture
*-------------------------------------------------------*
*	Are we in this sector?				*
*-------------------------------------------------------*
	tst.b		first_ssector
	beq.s		.skip
	clr.b		first_ssector
*-------------------------------------------------------*
*	Set viewcone to (sector_height+player_height)	*
*-------------------------------------------------------*
	move.w		floor_ht,d0
	add.w		#player_height,d0
	add.w		pho,d0
	move.w		d0,ph
*-------------------------------------------------------*
*	Set up segment-heap for loop			*
*-------------------------------------------------------*
.skip:	move.l		d4,d2
	move.w		d2,display_segbase(a6)
	move.w		d3,display_segnum(a6)
	ble		next_node
*-------------------------------------------------------*
	move.w		ph,d1
	sub.w		ceiling_ht,d1 
	swap		d1
	clr.w		d1
	move.l		d1,ceiling_y
	move.w		ph,d1
	sub.w		floor_ht,d1 
	swap		d1
	clr.w		d1
	move.l		d1,floor_y
*-------------------------------------------------------*
*	Process simple lighting effects (temporary!)	*
*-------------------------------------------------------*
	bsr		process_lighting
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Render segments surrounding this ssector	*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
segment_loop:
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Hidden surface removal stage #1			*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Is viewer on left or right side of this line?	*
*-------------------------------------------------------*
*	((y2-y1)*(x1-Px))) => (((x2-x1)*(y1-Py)) ?	*
*-------------------------------------------------------*
	move.l		display_vertices(a6),a0
	moveq		#0,d0
	moveq		#0,d1
	move.w		linedef_from(a2),d0
	move.w		linedef_to(a2),d1
	move.w		vtx_x(a0,d0.l*4),d5
	move.w		vtx_x(a0,d1.l*4),d6
	move.w		vtx_y(a0,d0.l*4),d0
	move.w		vtx_y(a0,d1.l*4),d1
	sub.w		d5,d6			; x2-x1
	sub.w		d0,d1			; y2-y1
	sub.w		display_px(a6),d5	; x1-px
	sub.w		display_py(a6),d0	; y1-py
	muls.w		d6,d0			; (x2-x1)*(y1-Py)
	muls.w		d5,d1			; (x1-px)*(y2-y1)
	cmp.l		d0,d1
	bpl		invisible
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Segment is visible				*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
	pea		(a2)
*-------------------------------------------------------*
	moveq		#0,d0
	move.w		display_segbase(a6),d0
	move.l		d0,d1
	move.l		display_segs(a6),a5
	add.l		d0,d0
	add.l		d1,d0
	lsl.l		#2,d0
	add.l		d0,a5			; a+(d*12)
*-------------------------------------------------------*
*	Locate segment vertices				*
*-------------------------------------------------------*
	move.w		seg_bam(a5),umag
	move.w		seg_distance(a5),uoff
	move.l		display_vertices(a6),a0
	moveq		#0,d0
	move.w		seg_from(a5),d0
	move.l		a0,a1
	moveq		#0,d1
	move.w		seg_to(a5),d1 
	lsl.l		#2,d0
	lsl.l		#2,d1
	add.l		d0,a0			; a+(d*4)
	add.l		d1,a1			; a+(d*4)
*-------------------------------------------------------*
*	Fetch X1,Y1 / X2,Y2 & centre around viewpoint	*
*-------------------------------------------------------*
	move.w		display_px(a6),d1
	move.w		display_py(a6),d7
	move.w		vtx_x(a0),d4
	move.w		vtx_y(a0),d5
	move.w		vtx_x(a1),d6
	move.w		vtx_y(a1),d2
	sub.w		d1,d4		; dx1
	sub.w		d7,d5		; dy1
	sub.w		d1,d6		; dx2
	sub.w		d7,d2		; dy2
*-------------------------------------------------------*
*	Rotate X & Y into canonical VX & VZ		*
*-------------------------------------------------------*
	move.w		display_sina(a6),d0
	move.w		display_cosa(a6),d7
*-------------------------------------------------------*
*	x1 = (dx1)*sin(a) + (dy1)*cos(a)		*
*	z1 = (dx1)*cos(a) - (dy1)*sin(a)		*
*-------------------------------------------------------*
	move.w		d4,d3
	move.w		d5,d1
	muls.w		d7,d4
	muls.w		d0,d5
	muls.w		d0,d3
	muls.w		d7,d1
	sub.l		d5,d4
	add.l		d1,d3
*-------------------------------------------------------*
*	x2 = (dx2)*sin(a) + (dy2)*cos(a)		*
*	z2 = (dx2)*cos(a) - (dy2)*sin(a)		*
*-------------------------------------------------------*
	move.w		d6,d5
	move.w		d2,d1
	muls.w		d7,d6
	muls.w		d0,d2
	muls.w		d0,d5
	muls.w		d7,d1
	sub.l		d2,d6
	add.l		d1,d5
*-------------------------------------------------------*
*	Renormalize output from matrix			*
*-------------------------------------------------------*
	lsl.l		#2,d3		; x1
	lsl.l		#2,d4		; z1
	lsl.l		#2,d5		; x2
	lsl.l		#2,d6		; z2
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Z-clipping of walls				*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
	lea		addwall_struct,a2
	move.l		d6,addwall_rz1(a2)
	move.l		d4,addwall_rz2(a2)
*-------------------------------------------------------*
	moveq		#ZMIN,d0
	swap		d0
*-------------------------------------------------------*
*	Check for intersection with viewplane		*
*-------------------------------------------------------*
	cmp.l		d0,d4
	bgt.s		.vis1
*-------------------------------------------------------*
*	Skip segment if both points are behind viewer	*
*-------------------------------------------------------*
	cmp.l		d0,d6
	ble		end_segment
*-------------------------------------------------------*
*	Case #1 - clip X1,Z1 against ZMIN		*
*-------------------------------------------------------*
	sub.l		d4,d0		; (cz-z1)
	move.l		d5,d1
	sub.l		d3,d1		; (x2-x1)
	muls.l		d0,d2:d1	; (x2-x1)*(cz-z1)
	move.l		d6,d0
	sub.l		d4,d0		; (z2-z1)
	divs.l		d0,d2:d1	; ((x2-x1)*(cz-z1))/(z2-z1)
	add.l		d1,d3		; (((x2-x1)*(cz-z1))/(z2-z1))+x1
	moveq		#ZMIN,d4
	swap		d4		; z1 = cz
	bra.s		.vis2
*-------------------------------------------------------*
*	Draw segment if both points are in view		*
*-------------------------------------------------------*
.vis1:	cmp.l		d0,d6
	bgt.s		.vis2
*-------------------------------------------------------*
*	Case #2 - clip X2,Z2 against ZMIN		*
*-------------------------------------------------------*
	sub.l		d6,d0		; (cz-z2)
	move.l		d3,d1
	sub.l		d5,d1		; (x1-x2)
	muls.l		d0,d2:d1	; (x1-x2)*(cz-z2)
	move.l		d4,d0
	sub.l		d6,d0		; (z1-z2)
	divs.l		d0,d2:d1	; ((x1-x2)*(cz-z2))/(z1-z2)
	add.l		d1,d5		; (((x1-x2)*(cz-z2))/(z1-z2))+x2
	moveq		#ZMIN,d6
	swap		d6		; z2 = cz
*-------------------------------------------------------*
*	Project points into 2D viewspace		*
*-------------------------------------------------------*
.vis2:	moveq		#0,d1
	move.w		display_hscale(a6),d1
	swap		d1
	muls.l		d1,d0:d3
	divs.l		d4,d0:d3
	muls.l		d1,d0:d5
	divs.l		d6,d0:d5
	move.l		d1,d0
	add.l		d0,d0
*-------------------------------------------------------*
*	Centre screen coordinates & check bounds	*
*-------------------------------------------------------*
	neg.l		d5
	add.l		d1,d5
	ble		end_segment
	move.l		d5,d7
	cmp.l		d0,d7
	bmi.s		.i2in
	move.l		d0,d7	
.i2in:	neg.l		d3
	add.l		d1,d3
	move.l		d3,d1
	bpl.s		.i1in
	moveq		#0,d1
.i1in:	cmp.l		d0,d3
	bpl		end_segment
*-------------------------------------------------------*
*	Check size (i2-i1)				*
*-------------------------------------------------------*
	swap		d1
	swap		d7
	move.w		d7,d0
	sub.w		d1,d0
	ble		end_segment
*-------------------------------------------------------*
*	Discard fully occluded walls			*
*-------------------------------------------------------*
	lea		DSPHostStat.w,a2
	lea		DSPHost16.w,a0
	moveq		#scan_command,d0
	dspwaitwrite	(a2)
	move.w		d0,(a0)				; occlusion check command
	dspwaitwrite	(a2)
	move.w		d1,(a0)				; wall i1
	dspwaitwrite	(a2)
	move.w		d7,(a0)				; wall i2
	dspwaitread	(a2)
	tst.w		(a0)				; result (visible y/n)
	beq		end_segment
*-------------------------------------------------------*
*	Write coordinates into addwall struct		*
*-------------------------------------------------------*
.draw:	lea		addwall_struct,a2
	move.l		d3,addwall_i1(a2)
	move.l		d4,addwall_z1(a2)
	move.l		d5,addwall_i2(a2)
	move.l		d6,addwall_z2(a2)
*-------------------------------------------------------*
*	Look up linedef for this seg			*
*-------------------------------------------------------*
	moveq		#0,d1
	move.w		seg_linedef(a5),d1
	move.l		d1,d0 
	move.l		display_linedefs(a6),a0
	lsl.l		#3,d0 
	sub.l		d1,d0
	add.l		d0,d0
	add.l		d0,a0
	move.l		a0,a1
*-------------------------------------------------------*
*	Determine one or two-sided linedef		*
*-------------------------------------------------------*
	moveq		#attrib_twosided,d0
	and.w		linedef_attrib(a0),d0
	move.b		d0,twosided_flag
*-------------------------------------------------------*
*	Determine which sidedef is facing us		*
*-------------------------------------------------------*
	move.w		seg_sidedef(a5),d0
	moveq		#0,d5
	move.w		linedef_right(a0,d0.l*2),d5	; visible sidedef
	bchg		#0,d0
	moveq		#0,d6
	move.w		linedef_right(a0,d0.l*2),d6	; invisible sidedef
*-------------------------------------------------------*
*	Look up sidedef for visible side of linedef	*
*-------------------------------------------------------*
	move.l		d5,d0
	move.l		d0,d1
	move.l		display_sidedefs(a6),a3
	lsl.l		#4,d0
	sub.l		d1,d0
	add.l		d0,d0
	add.l		d0,a3				; a+(d*30)
*-------------------------------------------------------*
*	(a6) pointer to addwall structure		*
*-------------------------------------------------------*
	lea		addwall_struct,a6
*-------------------------------------------------------*
*	Check for main wall texture			*
*-------------------------------------------------------*
	tst.w		sidedef_mtns(a3) 
	bmi.s		sector_window
*-------------------------------------------------------*
*	Valid texture indicates a solid sector wall	*
*-------------------------------------------------------*
sector_wall:	
*-------------------------------------------------------*
	move.b		twosided_flag,addwall_opaque(a6)
	move.w		ph,d0
	move.w		d0,d1
	sub.w		ceiling_ht,d1
	move.w		d0,d2
	sub.w		floor_ht,d2
	cmp.w		d1,d2
	bmi		end_segment
	move.w		d1,addwall_y1(a6)
	move.w		d2,addwall_y2(a6)
	move.b		#WALL_TYPE,addwall_type(a6)
	bsr		add_wall_segment
	bra		end_segment
*-------------------------------------------------------*
sector_window:
*-------------------------------------------------------*
	move.b		#0,addwall_opaque(a6)
*-------------------------------------------------------*
*	Locate [sector] on opposite side of [linedef]	*
*-------------------------------------------------------*
	move.l		d6,d0
	move.l		Side_Array,a4
	move.l		d0,d1
	lsl.l		#4,d0
	sub.l		d1,d0
	move.w		sidedef_sector(a4,d0.l*2),a0	; a+(d*30)
	lea		(a0,a0.l*2),a2
	move.l		Sector_Array,a1
	move.l		a2,d0 
	lsl.l		#2,d0
	add.l		a0,d0
	lea		(a1,d0.l*2),a4			; a+(d*26)
*-------------------------------------------------------*
*	Check for lower wall texture			*
*-------------------------------------------------------*
	move.w		floor_ht,d1 
	cmp.w		#-1,sidedef_ltns(a3) 
	beq.s		lower_floor
	bpl.s		lower_wall
	move.w		#1000,d1
	move.w		d1,d2
	bra.s		lower_sky
*-------------------------------------------------------*
*	Valid texture indicates a solid lower wall	*
*-------------------------------------------------------*
lower_wall:
*-------------------------------------------------------*
	move.w		sector_floorht(a4),d1
	cmp.w		ceiling_ht,d1
	bmi.s		lower_floor
	move.w		ceiling_ht,d1
*-------------------------------------------------------*
lower_floor:
*-------------------------------------------------------*
	move.w		floor_ht,d2 
	neg.w		d1
	neg.w		d2
*-------------------------------------------------------*
lower_sky:
*-------------------------------------------------------*
	add.w		ph,d1
	add.w		ph,d2
	cmp.w		d1,d2
	bpl.s		.fix
	move.w		d2,d1
.fix:	move.w		d1,addwall_y1(a6)
	move.w		d2,addwall_y2(a6)
	move.b		#LOWER_TYPE,addwall_type(a6)
	bsr		add_wall_segment 
	tst.w		columns
	beq.s		end_segment		 
*-------------------------------------------------------*
*	Check for upper wall texture			*
*-------------------------------------------------------*
	move.w		ceiling_ht,d2 
	cmp.w		#-1,sidedef_utns(a3) 
	beq.s		upper_ceiling
	bpl.s		upper_wall
	move.w		#-1000,d1
	move.w		d1,d2
	bra.s		upper_sky
*-------------------------------------------------------*
*	Valid texture indicates a solid upper wall	*
*-------------------------------------------------------*
upper_wall:
*-------------------------------------------------------*
	move.w		sector_ceilht(a4),d2
	cmp.w		floor_ht,d2
	bpl.s		upper_ceiling
	move.w		floor_ht,d2
*-------------------------------------------------------*
upper_ceiling:
*-------------------------------------------------------*
	move.w		ceiling_ht,d1 
	neg.w		d1
	neg.w		d2
*-------------------------------------------------------*
upper_sky:
*-------------------------------------------------------*
	add.w		ph,d1
	add.w		ph,d2
	cmp.w		d1,d2
	bpl.s		.fix
	move.w		d1,d2
.fix:	move.w		d1,addwall_y1(a6)
	move.w		d2,addwall_y2(a6)
	move.b		#UPPER_TYPE,addwall_type(a6)
	bsr		add_wall_segment 
*-------------------------------------------------------*
end_segment:
*-------------------------------------------------------*
	pop.l		a2
*-------------------------------------------------------*
*	Proceed to next segment				*
*-------------------------------------------------------*
invisible:
*-------------------------------------------------------*
	lea		display_struct,a6
	lea		seg_len(a2),a2
	addq.w		#1,display_segbase(a6)
	subq.w		#1,display_segnum(a6)
	beq		end_ssector
	tst.w		columns
	bne		segment_loop
*-------------------------------------------------------*
end_ssector:
*-------------------------------------------------------*
	bsr		get_ssector
*-------------------------------------------------------*
*	Fetch next node from heap and descend again	*
*-------------------------------------------------------*
next_node:
*-------------------------------------------------------*
	move.w		(sp)+,d0
	bmi		ssector_node

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	[node] /= [sector] -> descend again		*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
dividing_node:
*-------------------------------------------------------*
	move.l		display_nodes(a6),a1	
	move.l		(a1,d0.w*4),a1
*-------------------------------------------------------*
*	Inverse descent rules for left side of tree	*
*-------------------------------------------------------*
*	(dy*(x1-Px))) => ((dx*(y1-Py)) ?		*
*-------------------------------------------------------*
	move.w		node_dx(a1),d2
	move.w		node_x(a1),d0
	move.w		node_dy(a1),d3
	move.w		node_y(a1),d1
	add.w		d2,d0			; x2 = (x1+dx)
	sub.w		display_px(a6),d0	; (x2-px)
	add.w		d3,d1			; y2 = (y1+dy)
	sub.w		display_py(a6),d1	; (xy-py)
	muls.w		d2,d1			; (y2-py) * dx
	muls.w		d3,d0			; (x2-px) * dy
	cmp.l		d0,d1 
	bmi.s		node_leftside
*-------------------------------------------------------*
*	Viewer is on right side of node divider		*
*-------------------------------------------------------*
node_rightside:
*-------------------------------------------------------*
	lea		node_lvtx(a1),a0
	bsr.s		nodeincone
	beq.s		.noln
	move.w		node_left(a1),-(sp)
.noln:	lea		node_rvtx(a1),a0
	bsr.s		nodeincone
	beq.s		next_node
	move.w		node_right(a1),-(sp) 
	bra.s		next_node
*-------------------------------------------------------*
*	Viewer is on left side of node divider		*
*-------------------------------------------------------*
node_leftside:
*-------------------------------------------------------*
	lea		node_rvtx(a1),a0
	bsr.s		nodeincone
	beq.s		.noln
	move.w		node_right(a1),-(sp) 
.noln:	lea		node_lvtx(a1),a0
	bsr.s		nodeincone
	beq.s		next_node
	move.w		node_left(a1),-(sp)
	bra.s		next_node

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Determine visibility of a child node.		*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Only exposed nodes are dealt with.		*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*

*-------------------------------------------------------*
*	Check #1 -> Octal node elimination		* 
*-------------------------------------------------------*
*	All nodes are checked against the 3 octal	*
*	segments immediately in front of viewcone.	*
*	Nodes from 5 of all 8 octants are discarded.	*
*-------------------------------------------------------*
*	Check #2 -> Canonical volume intersection	* 
*-------------------------------------------------------*
*	The remaining nodes are fully intersected	*
*	with the projected canonical view volume.	*
*	Any nodes outside the viewcone are discarded.	*
*-------------------------------------------------------*
*	Check #3 -> Occlusion check			* 
*-------------------------------------------------------*
*	Any nodes remaining in view are checked		*
*	against the occlusion table. Any nodes		*
*	completely occluded by walls are discarded.	*
*-------------------------------------------------------*
	txtlong
*-------------------------------------------------------*
*	This function is now completely DSP based	*
*-------------------------------------------------------*
nodeincone:
*-------------------------------------------------------*
	lea		DSPHostStat.w,a2
	lea		DSPHost16.w,a3
	move.l		a0,a4
	moveq		#nodeincone_command,d0
	dspwaitwrite	(a2)
	move.w		d0,(a3)
	move.w		(a4)+,d0
	dspwaitwrite	(a2)
	move.w		d0,(a3)
	move.w		(a4)+,d0
	dspwaitwrite	(a2)
	move.w		d0,(a3)
	move.w		(a4)+,d0
	dspwaitwrite	(a2)
	move.w		d0,(a3)
	move.w		(a4)+,d0
	dspwaitwrite	(a2)
	move.w		d0,(a3)
	dspwaitread	(a2)
	move.w		(a3),d0
	tst.b		d0
	rts

*-------------------------------------------------------*
			bsslong
*-------------------------------------------------------*

maxnode:		ds.l	1		; last node index
this_sector:		ds.l	1		; current sector ptr
bsp_return:		ds.l	1		; BSP stack base

floor_ht:		ds.w	1		; floor height (16.16)
ceiling_ht:		ds.w	1		; ceiling height (16.16)
ceiling_texture:	ds.w	1		; ceiling texture index
floor_texture:		ds.w	1		; floor texture index
uoff:			ds.w	1		; texture u-offset (xoff)
ourssector:		ds.w	1		; index of our sector

first_ssector:		ds.b	1		; sector first-hit flag
twosided_flag:		ds.b	1		; transparent wall flag
			
*-------------------------------------------------------*
			txtlong
*-------------------------------------------------------*
