*=======================================================*
*	Shards: latest update 23/02/96			*
*=======================================================*
*	Interface with DSP to retrieve floors & walls	*
*=======================================================*

*-------------------------------------------------------*
*	WARNING:					*
*-------------------------------------------------------*
*	This is the least finished module of the 3D	*
*	core, and the most volatile beside the DSP	*
*	module itself. Altering it could be a very	*
*	bad idea. Please wait until I have finished	*
*	writing it!					*
*-------------------------------------------------------*

sz1		=	64		; sample z1
sz2		=	128		; sample z2

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Generate a new wall, floor & ceiling chunk	*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
	txtlong
*-------------------------------------------------------*
add_wall_segment:
*-------------------------------------------------------*
	pea		(a3)
	pea		(a4)
*-------------------------------------------------------*
	lea		DSPHostStat.w,a4
	lea		DSPHost32.w,a5
*-------------------------------------------------------*
	move.l		addwall_z1(a6),d1
	move.l		addwall_z2(a6),d2
	move.l		d1,addwall_pz1(a6)
	move.l		d2,addwall_pz2(a6)

	sub.l		d1,d2
	bpl.s		.ak1
	neg.l		d2
.ak1:	lsr.l		#7,d1
	cmp.l		d1,d2
	bpl.s		.ak2

	move.l		addwall_pz2(a6),d1
	move.l		d1,addwall_pz2(a6)
	move.l		d1,addwall_rz1(a6)
	add.l		#2000<<16,d1
	move.l		d1,addwall_pz1(a6)
	move.l		d1,addwall_rz2(a6)

	dspwrite.b	#linear_command,(a4)
	bra.s		.lin
	
.ak2:	dspwrite.b	#perspected_command,(a4)
.lin:	move.l		addwall_pz1(a6),addwall_t2(a6)
	move.l		addwall_pz2(a6),addwall_t1(a6)
*-------------------------------------------------------*
	moveq		#0,d6
	move.w		addwall_hhig(a6),d6	; (h/2)
	moveq		#0,d0
	move.w		addwall_vscale(a6),d0	; vscale
	swap		d0
	swap		d6	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	Vertical (y) perspective projection		*
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*
*	y' = y * ( (w/2) / z ) + (h/2)			*
*-------------------------------------------------------*
	move.l		addwall_y1(a6),d1
	move.l		d0,d2
	muls.l		d1,d7:d2
	divs.l		addwall_z1(a6),d7:d2
	add.l		d6,d2
	move.l		d0,d5
	muls.l		d1,d7:d5
	divs.l		addwall_z2(a6),d7:d5
	move.l		addwall_y2(a6),d1
	add.l		d6,d5
	move.l		d0,d3
	muls.l		d1,d7:d3
	divs.l		addwall_z1(a6),d7:d3
	add.l		d6,d3
	move.l		d0,d4
	muls.l		d1,d7:d4
	divs.l		addwall_z2(a6),d7:d4
	add.l		d6,d4
*-------------------------------------------------------*
*	Calculate dy1 & dy2 gradients			*	
*-------------------------------------------------------*
	move.l		addwall_i2(a6),d0
	sub.l		addwall_i1(a6),d0
	sub.l		d2,d5
	swap		d5
	move.w		d5,d6
	ext.l		d6
	clr.w		d5
	divs.l		d0,d6:d5	; dy1 = (ry1-ly1) / (x2-x1)
	move.l		d4,d1
	sub.l		d3,d1
	swap		d1
	move.w		d1,d6
	ext.l		d6
	clr.w		d1
	divs.l		d0,d6:d1	; dy2 = (ry2-ly2) / (x2-x1)
*-------------------------------------------------------*
*	Calculate dz gradient				*
*-------------------------------------------------------*
	move.l		addwall_t2(a6),d4
	sub.l		addwall_t1(a6),d4
	swap		d4
	move.w		d4,d6
	clr.w		d4
	ext.l		d6
	divs.l		d0,d6:d4
	move.l		d4,addwall_ti(a6)
*-------------------------------------------------------*
*	Clip wall against left edge			*	
*-------------------------------------------------------*
	move.l		addwall_i1(a6),d7
	move.l		d7,d6
	swap		d6
	ext.l		d6
	bpl.s		.ok1
	moveq		#0,d6
.ok1:	move.l		d6,a3

	swap		d6
	sub.l		d6,d7	
	move.l		d7,a2

	move.l		a2,d6
	clr.w		d6
	muls.l		d5,d7:d6
	move.w		d7,d6
	swap		d6
	sub.l		d6,d2		; y1 = y1 - (x1*dy1)

	move.l		a2,d6
	clr.w		d6
	muls.l		d1,d7:d6
	move.w		d7,d6
	swap		d6
	sub.l		d6,d3		; y2 = y2 - (x1*dy2)

	move.l		addwall_t1(a6),d0
	move.l		a2,d6
	muls.l		d4,d7:d6
	move.w		d7,d6
	swap		d6
	sub.l		d6,d0		; z1 = z1 - (x1*dz)
	move.l		d0,addwall_t1(a6)

	move.l		a3,d7

*-------------------------------------------------------*
*	Load results into local loop registers		*	
*-------------------------------------------------------*
	move.l		d2,addwall_y1a(a6)
	move.l		d3,addwall_y2a(a6)
	move.l		d5,addwall_y1i(a6)
	move.l		d1,addwall_y2i(a6)
*-------------------------------------------------------*

	move.w		umag,d6
	swap		d6
	clr.w		d6

	move.l		addwall_rz2(a6),d1
	sub.l		addwall_rz1(a6),d1

	move.l		addwall_pz2(a6),d0
	sub.l		addwall_rz1(a6),d0

	
	muls.l		d6,d2:d0

	divs.l		d1,d2:d0
	move.l		d0,addwall_tu2(a6)

	move.l		addwall_pz1(a6),d0
	sub.l		addwall_rz1(a6),d0

	muls.l		d6,d2:d0

	divs.l		d1,d2:d0
	move.l		d0,addwall_tu1(a6)

*-------------------------------------------------------*
*	Clip wall against right edge			*
*-------------------------------------------------------*
	move.w		addwall_i2(a6),d6
	move.w		addwall_width(a6),d0
	cmp.w		d0,d6
	bmi.s		.x2in
	move.w		d0,d6
.x2in:	move.w		d6,addwall_ci2(a6)
*-------------------------------------------------------*
	cmp.b		#UPPER_TYPE,addwall_type(a6)
	beq.s		.upper
	cmp.b		#LOWER_TYPE,addwall_type(a6)
	beq.s		.lower
.wall:	moveq		#wall_command,d0
	bra.s		.go
.upper:	moveq		#upper_command,d0
	bra.s		.go
.lower:	moveq		#lower_command,d0
.go:	dspwrite.b	d0,(a4)

xxx:	lea		DSPHostStat.w,a2

	dspwrite.r	addwall_y1a(a6),(a4)
	dspwrite.r	addwall_y1i(a6),(a4)
	dspwrite.r	addwall_y2a(a6),(a4)
	dspwrite.r	addwall_y2i(a6),(a4)
	dspwrite.r	addwall_t1(a6),(a4)
	dspwrite.r	addwall_ti(a6),(a4)
	dspwrite.r	addwall_pz2(a6),(a4)
	dspwrite.r	addwall_pz1(a6),(a4)

	dspwrite.r	addwall_tu1(a6),(a4)
	move.l		addwall_tu2(a6),d0
	sub.l		addwall_tu1(a6),d0
	dspwrite.r	d0,(a4)


	move.l		addwall_y2(a6),d0
	sub.l		addwall_y1(a6),d0
	swap		d0
	ext.l		d0
	dspwrite.l	d0,(a4)
	
	dspwrite.l	#128,(a4)
	
	dspwrite.w	uoff,(a4)
	
	moveq		#0,d0
	dspwrite.l	d7,(a4)
	move.w		addwall_ci2(a6),d0
	dspwrite.l	d0,(a4)
	dspwrite.l	#0,(a4)
	move.w		columns,d0
	dspwrite.l	d0,(a4)

yyy:	pushall
	lea		DSPHost32.w,a3
	lea		DSPHost16.w,a1
	lea		DSPHostStat.w,a2
	move.w		brightness,d2
	move.w		addwall_tex(a6),d7
*-------------------------------------------------------*
	bsr		render_wall
*-------------------------------------------------------*
	moveq		#0,d5
	move.w		d5,wallruncount
*-------------------------------------------------------*
	dspread.w	columns
*-------------------------------------------------------*
	popall
*-------------------------------------------------------*
	pop.l		a4
	pop.l		a3
	rts

umag:	dc.w		128
	
cz1:	ds.l		1
cz2:	ds.l		1
fz1:	ds.l		1
fz2:	ds.l		1

*-------------------------------------------------------*
	txtlong
*-------------------------------------------------------*
get_ssector:
*-------------------------------------------------------*
	push.l		a6
*-------------------------------------------------------*
	lea		DSPHost16.w,a1
	lea		DSPHost32.w,a5
	lea		DSPHostStat.w,a2
*-------------------------------------------------------*
	moveq		#getssector_command,d0
	dspwaitwrite	(a2)
	move.w		d0,(a1)
	dspwaitwrite	(a2)
	move.w		ceiling_y,(a1)
	dspwaitwrite	(a2)
	move.w		floor_y,(a1)
*-------------------------------------------------------*
*	Set up luminance, texture indexes & horizon	*	
*-------------------------------------------------------*
	move.w		#256-1,d4
	move.l		zone_ptr,a4
	move.w		ceiling_texture,d0
	bsr		get_chunk
	move.w		floor_texture,d0
	bsr		get_chunk
	move.l		a4,zone_ptr
	clr.b		(a4)
*-------------------------------------------------------*
	dspwrite.b	#newssector_command,(a2)
*-------------------------------------------------------*
	pop.l		a6
*-------------------------------------------------------*
	rts

*-------------------------------------------------------*
*	Retrieve all scanlines for this ssector		*
*-------------------------------------------------------*
	txtlong
*-------------------------------------------------------*
get_chunk:
*-------------------------------------------------------*
	move.w		brightness,d6
	cmp.w		sky_index,d0
	bne.s		.no_sky_texture
	move.w		#sky_brightness,d6
*-------------------------------------------------------*
.no_sky_texture:
*-------------------------------------------------------*
*	Create zone header (skip null zones)	 	*
*-------------------------------------------------------*
	dspwaitread	(a2)
	move.w		(a1),d1
	dspwaitread	(a2)
	move.w		(a1),d7
	beq		.null_zone
	mulu.w		#(640/8),d1
	move.b		d7,(a4)+			; zone_lines
	subq.w		#1,d7
	move.b		d0,(a4)+			; zone_texture
	move.w		d1,(a4)+			; zone_start
*-------------------------------------------------------*
.line_loop:
*-------------------------------------------------------*
*	Create line header (null lines must be added)	*
*-------------------------------------------------------*
*	Calculate sector intensity & store with [z]	*	
*-------------------------------------------------------*
	dspwaitread	(a2)
	move.l		(a5),d3
	lsl.l		#8,d3
*-------------------------------------------------------*
	dspwaitread	(a2)
	move.w		(a1),d0
	move.w		d0,(a4)+			; line_runs
	subq.w		#1,d0
	bmi.s		.null_line
*-------------------------------------------------------*
	dspwaitread	(a2)
	move.b		1(a1),d3
	ror.l		#8,d3
*-------------------------------------------------------*
.run_loop:
*-------------------------------------------------------*
	move.w		(a1),d1
	subq.w		#1,d1
	move.l		d3,(a4)+
	swap		d1
	move.w		(a1),d1
	subq.w		#1,d1
	move.l		d1,(a4)+
*-------------------------------------------------------*
	dbra		d0,.run_loop
*-------------------------------------------------------*
.null_line:
*-------------------------------------------------------*
	dbra		d7,.line_loop	
*-------------------------------------------------------*
.null_zone:
*-------------------------------------------------------*
	rts
	
*-------------------------------------------------------*
kickstart_doomcore:
*-------------------------------------------------------*
	jsr		IsDspDrv
	dspexec		DoomCore
	rts

*-------------------------------------------------------*
	include		dsplib.s
*-------------------------------------------------------*

*-------------------------------------------------------*
			datlong
*-------------------------------------------------------*

DoomCore:		incbin	"doom.dsp'
DoomCore_e:

*-------------------------------------------------------*
			bsslong
*-------------------------------------------------------*

ceiling_y:		ds.l	1
floor_y:		ds.l	1
zone_ptr:		ds.l	1


maxy:			ds.w	320			; upper clipping buffer.
miny:			ds.w	320			; lower clipping buffer.
occlusion_list:		ds.b	320			; byte-per-column occlusion list.

addwall_struct:		ds.b	addwall_len		; local variables for AddWall.

columns:		ds.w	1			; counter for columns done.
wallruncount:		ds.w	1			; counter for total wall runs.

dummy_zone:		ds.b	16
zone_space:		ds.b	256000

*-------------------------------------------------------*
			txtlong
*-------------------------------------------------------*
