VLM_MODULE:	=	0
SHOWVBL:	=	0

******** OBJECT EQUS ********

	TEXT

	OPT	D-

	IFNE	VLM_MODULE
	OUTPUT	E:\WHIP!\VLM\FLARE.VLM
	ELSE
	OPT	ATARI
	COMMENT	HEAD=%101
	INCBIN	MINIWHIP.BIN
	ENDC

	DC.B	"VLM2"
	DC.L	infotext
	DC.L	settings
	DC.L	init
	DC.L	deinit
	DC.L	main

	INCLUDE	VLMSERV.S
	INCLUDE	FIMATH.I
	TEXT
	INCLUDE	FSCR.I
	TEXT

main:
.calc_field:
	tst.w	fieldtype+2
	beq.s	.calc_monofield
	bsr	CALC_SPECTRALFLOWTABLE
	bra.s	.end_calc_field
.calc_monofield:
	bsr	CALC_MONOSPECTRALFLOWTABLE
.end_calc_field:
	bsr	PAINT_FASTFLAREFIELD

	IFNE	SHOWVBL

	movea.l	scr,a3
	move.w	$4bc.w,d7
	move.w	.old4bc(pc),d6
	move.w	d7,.old4bc
	sub.w	d6,d7
	subq.w	#1,d7
	cmpi.w	#50,d7
	bhs.s	.end_showvbl

.vsl:	move.l	#$ffff0000,(a3)+
	dbra	d7,.vsl

.end_showvbl:
	moveq	#0,d0
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+

	ENDC

	lea	scr,a0
	move.l	(a0)+,d0
	move.l	(a0)+,-8(a0)
	move.l	(a0),-4(a0)
	move.l	d0,(a0)
	vlm_set_scradr	d0
	rts

.old4bc:
	DC.W	0

init:	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x100x16

	lea	fastcolor_tbl,a0
	move.w	color+2,d0
	jmp	colorjump_tbl(pc,d0.w*4)

	lea	scr1,a0
	bsr	CLEAR_320100TSCR
	lea	scr2,a0
	bsr	CLEAR_320100TSCR
	lea	scr3,a0
	bsr	CLEAR_320100TSCR
	rts

colorjump_tbl:
	bsr.w	CALC_BLUEFLAREPAL
	bsr.w	CALC_YELLOWFLAREPAL
	bsr.w	CALC_ORANGEFLAREPAL

deinit:	rts

* INPUT: a0: address of flaretable (512 words)
CALC_BLUEFLAREPAL:
	moveq	#$ffffffff,d0
	moveq	#$00000000,d0	
	move.w	#256-1,d7
.whiteloop:
;	move.w	d0,(a0)+
;	dbra	d7,.whiteloop
	move.w	#%0000011111111111,d0

	moveq	#32-1,d7
.yellowloop:
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100000,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100001,d0
	dbra	d7,.yellowloop
	rts

* INPUT: a0: address of flaretable (512 words)
CALC_YELLOWFLAREPAL:
	moveq	#$ffffffff,d0
	moveq	#$00000000,d0	
	move.w	#256-1,d7
.whiteloop:
;	move.w	d0,(a0)+
;	dbra	d7,.whiteloop
	move.w	#%1111111111100000,d0

	moveq	#32-1,d7
.loop:	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100000,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000100000100000,d0
	dbra	d7,.loop
	rts

* The smell of ether, an orange flare.
* Divine submission fills the air.
* INPUT: a0: address of flaretable (512 words)
CALC_ORANGEFLAREPAL:
	moveq	#$ffffffff,d0
	moveq	#$00000000,d0	
	move.w	#256-1,d7
.whiteloop:
;	move.w	d0,(a0)+
;	dbra	d7,.whiteloop

	move.w	#%1111111111100000,d0
	moveq	#16-1,d7
.loop1:	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100000,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100000,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100000,d0
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000000000100000,d0
	dbra	d7,.loop1

	andi.w	#%1111100000000000,d0
	moveq	#16-1,d7
.loop2:	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	move.w	d0,(a0)+
	subi.w	#%0000100000000000,d0
	dbra	d7,.loop2
	rts

* Calculates a 64K highcolor-word lookup table from two 256 truecolor
* palettes.
* INPUT: a1: truecolor palette 1
*        a2: truecolor palette 2
CALC_MIXTABLE:
	lea	colormix_tbl,a0
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d7

.palloop:
	moveq	#0,d6

.colorloop:
	move.b	(a1)+,d0
	move.b	(a1)+,d1
	move.w	(a1)+,d2
	move.b	(a2)+,d3
	move.b	(a2)+,d4
	move.w	(a2)+,d5
	mulu.w	d6,d0
	mulu.w	d6,d1
	mulu.w	d6,d2
	lsr.w	#8,d0
	lsr.w	#8,d1
	lsr.w	#8,d2
	subi.w	#256,d6
	neg.w	d6
	mulu.w	d6,d3
	mulu.w	d6,d4
	mulu.w	d6,d5
	subi.w	#256,d6
	neg.w	d6
	move.w	d0,(a0)+
	addq.b	#1,d6
	bne.s	.colorloop

	lea	-256*4(a1),a1
	lea	-256*4(a2),a2
	addq.b	#1,d7
	bne.s	.palloop

	rts

CALC_SPECTRALFLOWTABLE:
	vlm_get_left_spec	a2
	vlm_get_right_spec	a3
	lea	flowindex_tbl,a0
	move.w	$4bc.w,d4
	mulu.w	rotspeed+2,d4
	lsr.l	#4,d4
	move.l	#$00000ff,d5
	and.l	d5,d4
 	moveq	#128-1,d7

.leftindexloop:
	move.b	(a2),d0
	addq	#2,a2
	neg.b	d0
	move.b	d0,(a0,d4.l)
	addq.w	#1,d4
	and.w	d5,d4
	dbra	d7,.leftindexloop

 	moveq	#128-1,d7

.rightindexloop:
	move.b	(a3),d0
	addq	#2,a3
	neg.b	d0
	move.b	d0,(a0,d4.l)
	addq.w	#1,d4
	and.w	d5,d4
	dbra	d7,.rightindexloop
	rts

CALC_MONOSPECTRALFLOWTABLE:
	vlm_get_left_spec	a2
	vlm_get_right_spec	a3
	lea	flowindex_tbl,a0
 	moveq	#128-1,d7
	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	move.w	$4bc.w,d4
	mulu.w	rotspeed+2,d4
	lsr.l	#4,d4
	move.l	#$000000ff,d5
	and.l	d5,d4

.indexloop:
	move.b	(a2),d0
	move.b	(a3),d1
	addq	#2,a2
	addq	#2,a3
	move.b	(a2),d2
	move.b	(a3),d3
	add.l	d0,d1
	add.l	d2,d3
	add.l	d1,d3
	lsr.l	#2,d3
	lsr.l	#1,d1
	neg.b	d1
	neg.b	d3
	move.b	d1,(a0,d4.l)
	addq.w	#1,d4
	and.w	d5,d4
	move.b	d3,(a0,d4.l)
	addq.w	#1,d4
	and.w	d5,d4
	dbra	d7,.indexloop
	rts

PAINT_FASTFLAREFIELD:
	movea.l	scr,a0
	move.w	paintalgo+2,d5
	cmpi.w	#1,d5
	bne.s	.noshift
	move.w	.framecount(pc),d0
	addq.w	#2,d0
	move.w	d0,.framecount
	andi.w	#%10,d0
	add.w	d0,a0
.noshift:
	lea	flarefield_tbl,a1
	adda.l	#(256-160)+(256-100)*256,a1

	lea	sine_tbl,a2
	move.w	$4bc.w,d0
	move.w	d0,d1
	mulu.w	#5,d1
	lsr.w	#3,d1
	Do_SinModulo	d0
	Do_SinModulo	d1
	Get_Sin	a2,d0,d0
	Get_Cos	a2,d1,d1
	muls.w	#96,d0
	muls.w	#156,d1
	swap	d0
	swap	d1
	lsl.w	#8,d1
	add.w	d0,d1
	lea	(a1,d1.w*2),a1
	lea	fastcolor_tbl,a2
	lea	flowindex_tbl,a3
	moveq	#100-1,d7
	moveq	#0,d0
	move.l	#(256-160)*2,d1

	cmpi.w	#2,d5
	beq.s	.solid

.yloop:	moveq	#20-1,d6
.xloop:	REPT	8
	move.b	(a1)+,d0
	move.b	(a3,d0.l),d0
	add.b	(a1)+,d0
	move.w	(a2,d0.l*2),(a0)
	addq	#4,a0
	ENDR
	dbra	d6,.xloop
	adda.l	d1,a1
	dbra	d7,.yloop
	rts
.solid:
.syloop:
	moveq	#20-1,d6
.sxloop:
	REPT	8
	move.b	(a1)+,d0
	move.b	(a3,d0.l),d0
	add.b	(a1)+,d0
	move.w	(a2,d0.l*2),d2
	move.w	d2,(a0)+
	move.w	d2,(a0)+
	ENDR
	dbra	d6,.sxloop
	adda.l	d1,a1
	dbra	d7,.syloop
	rts

.framecount:
	DC.W	0

	DATA

sine_tbl:
	INCBIN	SINUS.DAT
flarefield_tbl:
	INCBIN	FIELD.DAT

scr:	DC.L	scr1,scr2,scr3

settings:
	DC.L	4

	DC.L	painttype_txt
	DC.L	2
paintalgo:
	DC.L	2
	DC.L	painttype_tbl

	DC.L	fieldtype_txt
	DC.L	2
fieldtype:
	DC.L	0
	DC.L	fieldtype_tbl

	DC.L	rotspeed_txt
	DC.L	3
rotspeed:
	DC.L	0
	DC.L	rotspeed_tbl

	DC.L	color_txt
	DC.L	2
color:	DC.L	1
	DC.L	color_tbl

painttype_tbl:
	DC.L	3
	DC.B	"RASTER",0
	DC.B	"RASTER-BLUR",0
	DC.B	"SOLID",0
	EVEN
fieldtype_tbl:
	DC.L	2
	DC.B	"MONO-SNAIL",0
	DC.B	"SPLIT-STEREO",0
	EVEN
rotspeed_tbl:
	DC.L	0,128
color_tbl:
	DC.L	3
	DC.B	"BLACK AND BLUE",0
	DC.B	"BLACK AND YELLOW",0
	DC.B	"ORANGE AND YELLOW",0

painttype_txt:
	DC.B	"PAINTING ALGORITHM",0
fieldtype_txt:
	DC.B	"FIELDTYPE",0
rotspeed_txt:
	DC.B	"ROTATION SPEED",0
color_txt:
	DC.B	"COLOR PALETTE",0

infotext:
	DC.B	"HIGH VOLTAGE flare",0
	DC.B	"Author:  eARx/fUN InD.",0
	DC.B	"Version: 1.0",0
	DC.B	"Date:    22-12-1999",0
	DC.B	0
	EVEN
	
	BSS

service_struct:
	DS.L	1
	
leftvol:
	DS.L	1
rightvol:
	DS.L	1

fastcolor_tbl:
	DS.W	512
flowindex_tbl:
	DS.W	256
flowcolor_tbl:
	DS.W	256*256
colormix_tbl:
	DS.W	256*256

	DS.W	1

scr1:	DS.W	320*100
scr2:	DS.W	320*100
scr3:	DS.W	320*100