VLM_MODULE:	=	1
SHOWVBL:	=	0

******** OBJECT EQUS ********

	TEXT

	IFNE	VLM_MODULE
	OPT	D-
	OUTPUT	E:\WHIP!\VLM\LANDBLUR.VLM
	ELSE
	OPT	ATARI
	COMMENT	HEAD=%101
	INCBIN	MINIWHIP.BIN
	ENDC

	DC.B	"VLM2"
	DC.L	infotext
	DC.L	settings
	DC.L	init
	DC.L	deinit
	DC.L	main

	INCLUDE	VLMSERV.S
	INCLUDE	FIMATH.I
	TEXT
	INCLUDE	FSCR.I
	TEXT

main:
* Calculate left, right, center and accumulative volume
	vlm_get_left_volume	leftvol
	vlm_get_right_volume	rightvol
	move.l	leftvol,d0
	add.l	rightvol,d0
	lsr.l	#1,d0
	move.l	d0,midvol
	move.l	accuvol,d1
	mulu.w	#$fe00,d1
	sub.w	d1,d1
	swap	d1
	lsr.l	#7,d0
	cmpi.w	#$0030,d0
	blt.s	.noadd
	add.l	d0,d1
.noadd:	move.l	d1,accuvol

	bsr	UPDATE_TEXTURE
	bsr	PLOT_LAND
;	bsr	PLOT_PAL

	addq.w	#1,framecount

	IFNE	SHOWVBL

	movea.l	scr,a3
	move.w	$4bc.w,d7
	move.w	.old4bc(pc),d6
	move.w	d7,.old4bc
	sub.w	d6,d7
	subq.w	#1,d7
	cmpi.w	#50,d7
	bhs.s	.end_showvbl

.vsl:	move.l	#$ffff0000,(a3)+
	dbra	d7,.vsl

.end_showvbl:
	moveq	#0,d0
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+

	ENDC

	lea	scr,a0
	move.l	(a0)+,d0
	tst.w	blurtype+2
	beq.s	.skip
	move.l	(a0)+,-8(a0)
	move.l	(a0),-4(a0)
	move.l	d0,(a0)
.skip:	vlm_set_scradr	d0
	rts

.old4bc:
	DC.W	0

init:	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x240x16

	move.l	$4ba.w,random

	bsr	INIT_PALETTETABLES

	move.l	#$4000,peak
	move.l	$4ba.w,peaktime
	rts

deinit:	rts

INIT_PALETTETABLES:
	lea	palinstr_tbl+2,a1
	lea	pal_tbl,a2
	moveq	#0,d7

.loop:	lea	temppal_tbl,a0
	move.w	d7,-(sp)
	move.l	a2,-(sp)
	move.w	(a1),d0
	pea	8(a1,d0.w*4)
	bsr	MAKE_COLORFLOW
	movea.l	(sp)+,a1
	movea.l	(sp)+,a2
	move.w	(sp)+,d7
	lea	256*2(a2),a2
	addq.w	#1,d7
	cmp.w	palinstr_tbl,d7
	bne.s	.loop
	rts

* <UNIT><GRaDiaToR><UNIT>
* INPUT: a0: 32 bitch output palette
*        a1: colorflow instruction table
*        a2: 16bitch output palette
MAKE_COLORFLOW:
	movea.l	a0,a3
	move.w	(a1)+,d7
	moveq	#0,d0
	move.w	(a1)+,d0
	moveq	#1,d6
	lsl.w	d0,d6
	move.w	d7,d5
	mulu.w	d6,d5
	move.w	d5,(a0)+
	subq.w	#1,d6
	move.w	d6,d5
	subq.w	#1,d7

.biglop:
	move.l	(a1)+,d1
	move.l	(a1),d2
	moveq.l	#0,d3
	move.l	d3,d4
	move.b	d1,d3
	move.b	d2,d4
	swap	d3
	swap	d4
	sub.l	d3,d4
	asr.l	d0,d4
	move.l	a0,a6
.lop1:	swap	d3
	move.b	d3,3(a0)
	addq	#4,a0
	swap	d3
	add.l	d4,d3
	dbra	d6,.lop1
	move.w	d5,d6
	move.l	a6,a0
	moveq	#0,d3
	move.l	d3,d4
	swap	d1
	swap	d2
	move.b	d1,d3
	move.b	d2,d4
	swap	d3
	swap	d4
	sub.l	d3,d4
	asr.l	d0,d4
.lop2:	swap	d3
	move.b	d3,1(a0)
	addq	#4,a0
	swap	d3
	add.l	d4,d3
	dbra	d6,.lop2
	move.l	a6,a0
	move.w	d5,d6
	moveq.l	#0,d3
	move.l	d3,d4
	swap	d1
	swap	d2
	rol.l	#8,d1
	rol.l	#8,d2
	move.b	d1,d3
	move.b	d2,d4
	swap	d3
	swap	d4
	sub.l	d3,d4
	asr.l	d0,d4
.lop3:	swap	d3
	move.b	d3,(a0)
	addq	#4,a0
	swap	d3
	add.l	d4,d3
	dbra	d6,.lop3
	move.w	d5,d6
	dbra	d7,.biglop

	movea.l	a3,a1			* truepal (32 bit)
	movea.l	a2,a0			* realpal (16 bit)
	move.w	(a1)+,d7

.loop:	moveq	#0,d0
	move.b	(a1)+,d0
	andi.b	#%11111000,d0
	lsl.w	#8,d0
	moveq	#0,d1
	move.b	(a1)+,d1
	andi.b	#%11111100,d1
	lsl.w	#3,d1
	moveq	#0,d2
	addq.l	#1,a1
	move.b	(a1)+,d2
	lsr.w	#3,d2
	or.w	d2,d0
	or.w	d1,d0
	move.w	d0,(a0)+
	dbra	d7,.loop
	rts

UPDATE_TEXTURE:
	lea	texture_dat,a0
	moveq	#0,d7
	move.w	.line(pc),d7

	bne.s	.palettes_set
	move.l	random,d0
	move.l	d0,d1
	mulu.w	d0,d0
	eor.l	d1,d0
	addq.l	#7,d0
	move.l	d0,random
	move.b	d0,.landdisplacement
	move.b	d1,.clouddisplacement
	move.l	#$0000ffff,d2
	and.l	d2,d0
	and.l	d2,d1
	divu.w	palinstr_tbl,d0
	divu.w	palinstr_tbl,d1
	swap	d0
	swap	d1
	and.l	d2,d0
	and.l	d2,d1
	lsl.l	#8,d0
	lsl.l	#8,d1
	lea	pal_tbl,a1
	lea	(a1,d0.l*2),a2
	move.l	a2,.landpaladr
	lea	(a1,d1.l*2),a2
	move.l	a2,.cloudpaladr
.palettes_set:

	lea	(a0,d7.l*2),a0
	addq.b	#1,.line
	lea	(land_dat,d7.l),a1
	lea	(cloud_dat,d7.l),a2
	move.l	.landpaladr(pc),a3
	move.l	.cloudpaladr(pc),a4
	moveq	#0,d0
	moveq	#0,d1
	move.b	.landdisplacement(pc),d0
	move.b	.clouddisplacement(pc),d1
	bra.s	INIT_NEXTTXTLINE

.line:	DC.W	0
.landpaladr:
	DC.L	pal_tbl
.cloudpaladr:
	DC.L	pal_tbl
.landdisplacement:
	DC.B	0
.clouddisplacement:
	DC.B	0

* INPUT: d0.w: heightfield 1 line displacement
*        d1.w: heightfield 2 line displacement
*        a0: output textureline (256 words)
*        a1: heightfield 1 line (256 bytes)
*        a2: heightfield 2 line (256 bytes)
*        a3: palette 1 (256 words)
*        a4: palette 2 (256 words)
INIT_NEXTTXTLINE:
	moveq	#0,d4
	move.w	#256-1,d7

.loop:	move.b	(a1,d0.w),d4
	move.w	(a3,d4.l*2),d2
	lsr.w	#1,d2
	andi.w	#%0111101111101111,d2
	move.b	(a2,d1.w),d4
	move.w	(a4,d4.l*2),d3
	lsr.w	#1,d3
	andi.w	#%0111101111101111,d3
	add.w	d2,d3
	move.w	d3,(a0)+
	addq.b	#1,d0
	addq.b	#1,d1
	dbra	d7,.loop
	rts

PLOT_PAL:
	movea.l	scr,a0
	lea	pal_tbl,a1
	move.w	palinstr_tbl,d7
	subq.w	#1,d7

.yloop:	moveq	#128-1,d6

.xloop:	move.l	(a1)+,(a0)+
	dbra	d6,.xloop

	lea	640*2-512(a0),a0
	dbra	d7,.yloop

	rts

* INPUT: d2.l: spline_y
*        d3.w: spline_x
gen_rotdist:
.w4	swap	d2
	moveq	#0,D1
	move.w	d3,d1
	move.l	#10<<16<<4,D0
	ext.l	D1
	bmi.s	.m
	cmpi.w	#0100,d1
	ble.s	.w0
	move.w	#$0100,D1
.w0:	lsl.l	#8,d1
	lsl.l	#3,d1
	lea	rotdist,A0
	lea	tan_tbl,A1
	moveq	#100-1,D3
.l0:	move.l	D2,D4
	move.l	D0,D5
	swap	D5
	divu.w	2(A1,D5.w*4),D4
	move.w	D4,(A0)+
	add.l	D1,D0
	dbra	D3,.l0
	rts
.m:	neg.l	D1
	cmpi.w	#$0100,d1
	ble.s	.w1
	move.w	#$0100,d1
.w1:	lsl.l	#8,d1
	lsl.l	#3,d1
	lea	rotdist,a0
	lea	tan_tbl,A1
	moveq	#100-1,D3
.l1:	move.l	D2,D4
	move.l	D0,D5
	swap	D5
	divu.w	2(A1,D5.w*4),D4
	move.w	d4,(a0)+
	add.l	D1,D0
	dbra	d3,.l1
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; a0.l  Zeiger auf Spline-Block
; d0.l  t (0-$ffff)
; Rckgabe: d1.w
spline:	move.l	d2,-(sp)
	move.l	(a0),d1
	muls.l	d0,d2:d1
	move.w	d2,d1
	swap	d1
	add.l	4(a0),d1
	muls.l	d0,d2:d1
	move.w	d2,d1
	swap	d1
	add.l	8(a0),d1
	muls.l	d0,d2:d1
	move.w	d2,d1
	swap	d1
	add.l	12(a0),d1
	swap	d1
	move.l	(sp)+,d2
	rts

PLOT_LAND:
* Calculate camera tilt.
	move.l	.spline_timer,d0
	move.l	midvol,d1
	lsr.l	#4,d1
	add.l	d1,d0
;	moveq	#0,d0
	move.l	d0,.spline_timer
	tst.w	.spline_timer(pc)
	beq.s	.ws0
	clr.w	.spline_timer
	subq.w	#1,.spline_counter
	bpl.s	.ws1
	move.w	.spline_anz_pts(pc),.spline_counter
	subq.w	#1,.spline_counter
	lea	.spline_pts(pc),a0
	bra.s	.ws2
.ws1:	move.l	.spline_adr(pc),a0
	lea	32(a0),a0
.ws2:	move.l	a0,.spline_adr
.ws0:	move.l	.spline_adr(pc),a0
	moveq	#0,d0
	move.w	.spline_timer+2(pc),d0
	bsr	spline
	neg.w	d1
	asr.w	#1,d1
	tst.w	perspective+2
	bne.s	.perspective
	moveq	#0,d1
.perspective:
	move.w	d1,.spline_x
;	lea	16(a0),a0
;	bsr	spline
;	neg.w	d1
;	asr.w	#1,d1
;	move.w	d1,.spline_y

* Calculate stretch factor
	move.l	.mspline_timer,d0
	move.l	midvol,d1
	mulu.w	stretchspeed+2,d1
	sub.w	d1,d1
	swap	d1
	add.l	d1,d0
;	moveq	#0,d0
	move.l	d0,.mspline_timer
	tst.w	.mspline_timer(pc)
	beq.s	.wms0
	clr.w	.mspline_timer
	subq.w	#1,.mspline_counter
	bpl.s	.wms1
	move.w	.mspline_anz_pts(pc),.mspline_counter
	subq.w	#1,.mspline_counter
	lea	.mspline_pts(pc),a0
	bra.s	.wms2
.wms1:	move.l	.mspline_adr(pc),a0
	lea	32(a0),a0
.wms2:	move.l	a0,.mspline_adr
.wms0	move.l	.mspline_adr(pc),a0
	moveq	#0,d0
	move.w	.mspline_timer+2(pc),d0
	bsr	spline
	neg.w	d1
	move.w	d1,.mspline_x
	lea	16(a0),a0
	bsr	spline
	neg.w	d1
	move.w	d1,.mspline_y

* Calculate startline and z-step.
	lea	sine_tbl,a6
	move.w	$4bc.w,d0
	mulu.w	zoomspeed+2,d0
	lsr.l	#8,d0
	Do_SinModulo	d0
	moveq	#0,d2
	Get_Sin	a6,d0,d2
	addi.w	#$8000,d2
	ror.l	#8,d2
	ror.l	#3,d2
	addq.w	#1,d2
	move.w	.spline_x(pc),d3
	;moveq	#100,d3
	;moveq	#30,d2
	;move.l	rightvol,d3
	;lsr.l	#8,d3
	bsr	gen_rotdist

* Calculate land roll.
	moveq	#0,d7
	move.l	$4ba.w,d0
	move.l	peak,d2
	move.l	d0,d1
	sub.l	peaktime,d1
	mulu.w	peakresp+2,d1
	sub.l	d1,d2
	bpl.s	.ok
	moveq	#0,d2
.ok:	move.l	d0,d1
	sub.l	peaktime,d1
	tst.w	rotswitch+2
	beq.s	.nosave
	tst.w	direction
	beq.s	.noinv
	neg.l	d1
.noinv:	move.l	midvol,d3
	cmp.l	peaktreshold,d3
	blt.s	.nopeak
	cmp.l	d3,d2
	bhs.s	.nopeak
	moveq	#1,d7
	move.l	midvol,peak
	move.l	d0,peaktime
	not.w	direction
.nopeak:
	add.w	oldrot,d1
	move.l	d7,d7
	beq.s	.nosave
	move.w	d1,oldrot
.nosave:
	mulu.w	rotspeed+2,d1
	lsr.l	#1,d1
;	moveq	#0,d1
	Do_SinModulo	d1
	Get_SinCos	a6,d1,d0,d2
	move.w	d0,.si
	move.w	d2,.co
	lea	texture_dat,a0
	movea.l scr,a1

	lea	640*20(a1),a1
	move.w	framecount,d0
	move.w	d0,d1
	andi.w	#%01,d0
	add.w	d0,d0
	add.w	d0,a1
	andi.w	#%10,d1
	beq.s	.skipadd
	lea	640(a1),a1
.skipadd:

	move.w	$4bc.w,d0
	Do_SinModulo	d0
	Get_SinCos	a6,d0,d0,d1
	move.l	accuvol,d2
	mulu.w	trajectstrength+2,d2
	swap	d2
	muls.w	d2,d0
	muls.w	d2,d1
	move.l	d0,.sine
	move.l	d1,.cosi

	lea	rotdist,a4
	moveq	#0,d5				* / for 
	movea.l	#$80000007,a6			* \ distorsion
	move.w	#-100/2,a5

.rotator_next_y:
	move.w	(a4)+,d6
;xstart%=(-50*faktor%) DIV 256
	moveq	#-80,D3
	muls.w	D6,D3
	asr.l	#8,D3
;ystart%=(y%*faktor%) DIV 256
	move.w	a5,D4
;	addi.w	#70-20,D4
	add.w	.mspline_x(pc),d4
	muls.w	D6,D4
	asr.l	#8,D4
;xpos%=xstart%*si%+ystart%*co%
;ypos%=ystart%*si%-xstart%*co%
	move.l	D3,D0
	move.l	D4,D1
	muls.w	.si(pc),D0
	muls.w	.co(pc),D4
	add.l	D4,D0
	muls.w	.si(pc),D1
	muls.w	.co(pc),D3
	sub.l	D3,D1
	add.l	.sine(pc),d0
	add.l	.cosi(pc),d1
;xofs%=(si%*faktor%) DIV 256
	move.w	.si(pc),D2
	muls.w	D6,D2
	eor.w	D2,d2
	swap	D2
;yofs%=-(co%*faktor%) DIV 256
	move.w	.co(pc),D3
	muls.w	D6,D3
	asr.l	#8,D3
	neg.l	D3
	lsr.l	#8,D0
	swap	D1
	swap	D3
	move.l	D1,D7
	sub.w	d7,d7
	add.l	D7,D0
	move.l	D3,D7
	sub.w	d7,d7
	add.l	D7,D2
	moveq	#160/8-1,D7
	moveq	#0,d4
.rotator_next_x:
;WORD{scrcntr%+(ypos% DIV 65536)*640+(xpos% DIV 65536)*2}=-1
* d0 xpos  yn|00|xv|xn
* d1 ypos  00|00|00|yv
* d2 xofs  yn|00|xv|xn
* d3 yofs  00|00|00|yv
	REPT	8
	move.w	d0,d4
	move.b	d1,d4
	move.w	(a0,d4.l*2),(a1)
	addq	#4,a1
	add.l	d2,d0
	addx.b	d3,d1
	ENDR
* Distort it up!! 
;	add.l	a6,d2
;	addx.b	d5,d3
	dbra	D7,.rotator_next_x

	lea	640(a1),a1
	addq.w	#1,a5
	cmpa.w	#50,a5
	bne	.rotator_next_y
	rts

.si:	DS.W	1
.co:	DS.W	1
.sine:	DS.L	1
.cosi:	DS.L	1

.spline_x:
	DS.W	1
.spline_y:
	DS.W	1
.spline_timer:
	DC.L	$10000
.spline_adr:
	DC.L	.spline_pts-32
.spline_counter:
	DC.W	0
.spline_pts=*+2
.spline_anz_pts:
	INCBIN	RSPLINE1.DAT

.mspline_x:
	DS.W	1
.mspline_y:
	DS.W	1
.mspline_timer:
	DC.L	$10000
.mspline_adr:
	DC.L	.mspline_pts-32
.mspline_counter:
	DC.W	0
.mspline_pts=*+2
.mspline_anz_pts:
	INCBIN	RSPLINE2.DAT

	DATA

land_dat:
	INCBIN	LAND.RAW
cloud_dat:
	INCBIN	CLOUD.RAW
tan_tbl:
	INCBIN	TAN.BIN
	EVEN

tiet_dat:
	INCBIN	TIET.RAW
tietr_dat:
	INCBIN	TIETR.RAW
sine_tbl:
	INCBIN	SINUS.DAT

scr:	DC.L	scr1,scr2,scr3

settings:
	DC.L	9

	DC.L	parname0_txt
	DC.L	2
blurtype:
	DC.L	0
	DC.L	blurselect_tbl

	DC.L	parname1_txt
	DC.L	1
perspective:
	DC.L	0
	DC.L	0

	DC.L	parname2_txt
	DC.L	3
trajectstrength:
	DC.L	3000
	DC.L	trajectslider_tbl

	DC.L	parname3_txt
	DC.L	3				* parameter type = slider
zoomspeed:
	DC.L	200				* parametervalue
	DC.L	zoomslider_tbl

	DC.L	parname4_txt
	DC.L	3
rotspeed:
	DC.L	3
	DC.L	spedslider_tbl

	DC.L	parname5_txt
	DC.L	3
stretchspeed:
	DC.L	500
	DC.L	stretchslider_tbl

	DC.L	parname6_txt
	DC.L	1
rotswitch:
	DC.L	0
	DC.L	0

	DC.L	parname7_txt
	DC.L	3
peaktreshold:
	DC.L	10000
	DC.L	peakslider_tbl

	DC.L	parname8_txt
	DC.L	3
peakresp:
	DC.L	20
	DC.L	respslider_tbl

blurselect_tbl:
	DC.L	2
	DC.B	"LITTLE STICKY",0
	DC.B	"BIG FAT JOINT",0
trajectslider_tbl:
	DC.L	0
	DC.L	10000
zoomslider_tbl:
	DC.L	0
	DC.L	2000
spedslider_tbl:
	DC.L	0
	DC.L	15
stretchslider_tbl:
	DC.L	0
	DC.L	2000
peakslider_tbl:
	DC.L	0
	DC.L	32768
respslider_tbl:
	DC.L	0
	DC.L	64

parname0_txt:
	DC.B	"BLUR TYPE",0
parname1_txt:
	DC.B	"PERSPECTIVE",0
parname2_txt:
	DC.B	"TRAJECTORY RADIUS",0
parname3_txt:
	DC.B	"ZOOM SPEED",0
parname4_txt:
	DC.B	"ROTATION SPEED",0
parname5_txt:
	DC.B	"STRETCH RESPONSE",0
parname6_txt:
	DC.B	"ROTATIONSWITCH",0
parname7_txt:
	DC.B	"ROTATIONSWITCH TRESHOLD",0
parname8_txt:
	DC.B	"ROTATIONSWITCH RESPONSE",0

infotext:
	DC.B	"LandBlur (Lustmord)",0
	DC.B	"Author:  eARx/fUN InD.",0
	DC.B	"Version: 1.1",0
	DC.B	"Date:    04-01-2000",0
	DC.B	0
	EVEN

palinstr_tbl:
	DC.W	3

redflowinstr_tbl:
	DC.W	(.end-.start)/4
	DC.W	4

.start:	DC.L	$00000000
	DC.L	$1f000000
	DC.L	$3f000000
	DC.L	$5f000000
	DC.L	$7f000000
	DC.L	$9f000000
	DC.L	$bf000000
	DC.L	$df000000
	DC.L	$ff00003f
	DC.L	$ff00007f
	DC.L	$ff0000bf
	DC.L	$ff0000ff
	DC.L	$ff3f00ff
	DC.L	$ff7f00ff
	DC.L	$ffbf00ff
	DC.L	$ffff00ff
.end:	DC.L	$ffff00ff

greenflowinstr_tbl:
	DC.W	(.end-.start)/4
	DC.W	4

.start:	DC.L	$00000000
	DC.L	$003f0000
	DC.L	$007f0000
	DC.L	$3fdf0000
	DC.L	$7fff0000
	DC.L	$dfff0000
	DC.L	$ffff0000
	DC.L	$ffff003f
	DC.L	$ffff007f
	DC.L	$ffff00bf
	DC.L	$ffff00ff
	DC.L	$ffff00ff
	DC.L	$ffff00ff
	DC.L	$ffff00ff
	DC.L	$ffff00ff
	DC.L	$ffff00ff
.end:	DC.L	$ffff00ff

fireflowinstr_tbl:
	dc.w	16
	dc.w	4

.start:	dc.l	$00000000
	dc.l	$3f000000
	dc.l	$7f000000
	dc.l	$ff1f0000
	dc.l	$ff3f0000
	dc.l	$ff7f0000
	dc.l	$ffbf0000
	dc.l	$ffff0000
	dc.l	$ffff0000
	dc.l	$ffff003f
	dc.l	$ffff007f
	dc.l	$ffff00bf
	dc.l	$ffff00ff
	dc.l	$ffff00ff
	dc.l	$ffff00ff
	dc.l	$ffff00ff
.end:	dc.l	$ffff00ff

	BSS

;	DS.W	1

texture_dat:
	DS.W	256*256

rotdist:
	DS.W	100
temppal_tbl:
	DS.L	272
pal_tbl:
	DS.W	256*8

framecount:
	DS.L	1

service_struct:
	DS.L	1
	
direction:
	DS.L	1
peak:	DS.L	1
peaktime:
	DS.L	1
oldrot:
	DS.L	1
leftvol:
	DS.L	1
rightvol:
	DS.L	1
midvol:	DS.L	1
accuvol:
	DS.L	1
leftspec_tbl:
	DS.L	128
rightspec_tbl:
	DS.L	128

	DS.W	1
scr1:	DS.W	320*240
scr2:	DS.W	320*240
scr3:	DS.W	320*240