  	include	colours.s
	include	vlmserv.s

TESTVLM	=	1
SHOWVBL	=	0
USE_OR	=	1

DEFAULT_THRESHOLD	=	38033
DEFAULT_BLUR	=	1
DEFAULT_MORE	=	1
DEFAULT_BLUEENDS	=	1
DEFAULT_MAXSPLITS	=	10
DEFAULT_SPLITDIST	=	10
DEFAULT_SPLITLEVEL	=	3000
DEFAULT_SLOWDOWN	=	2
DEFAULT_SPARKLE	=	256

XRES	=	320
YRES	=	240

	ifeq	TESTVLM
	opt	nodebug
	output	d:\sound\whip!\vlm\lightnin.vlm
	endc

	text

	ifne	TESTVLM
	incbin	miniwhip.bin
	endc

	dc.b	"VLM2"
	dc.l	infotext
	dc.l	settings
	dc.l	init
	dc.l	deinit
	dc.l	main

;	nop
main
	bsr	scrswap

	ifne	SHOWVBL
	move.l	scrp,a3
	move.w	$468.w,d6
	subq.w	#1,d6
.vsl
	move.l	#$ffffffff,(a3)+
	move.l	#$00000000,(a3)+
	dbra	d6,.vsl

	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	move.l	#$00000000,(a3)+
	endc

	move.w	option_slowdown+2,d7
.wvl
	vlm_wait_vbl
	dbra	d7,.wvl

	bsr	clear


	move.l	savedp,a2

	vlm_get_left_osci	a3
	move.l	a3,a0
	lea	old_left_osci,a1
	bsr	calc_avg_osci

	vlm_get_left_spec	a3
	lea	128*2(a3),a4
	move.l	a4,l_specp
	bsr	calc_avg_spec
	move.w	d0,l_avg_spec
	move.w	l_avg_spec,avg_spec
	
	lea	old_left_osci,a3
	
	lea	greenscale,a4
	move.w	l_angle,angle
	move.w	#64,length
	move.l	l_specp,tmpspecp
	bsr	lightning

	tst.l	option_more
	lea	old_left_osci+64*2,a3
	beq.s	.nomore_l
	move.w	l_angle,angle
	addq.w	#5,angle
	move.w	#32,length
	lea	greenscale+2*3,a4
	move.l	l_specp,tmpspecp
	bsr	lightning
	move.w	l_angle,angle
	addq.w	#1,angle
	move.w	#32,length
	lea	greenscale+2*3,a4
	move.l	l_specp,tmpspecp
	bsr	lightning

.nomore_l
	moveq	#0,d7
	vlm_get_left_volume	d7
	cmp.l	option_threshold,d7
	blt.s	.nomovel
	addq.w	#1,l_angle
	cmp.w	#6,l_angle
	blt.s	.nomovel
	subq.w	#6,l_angle
.nomovel

	vlm_get_right_osci	a3
	move.l	a3,a0
	lea	old_right_osci,a1
	bsr	calc_avg_osci

	vlm_get_right_spec	a3
	lea	128*2(a3),a4
	move.l	a4,r_specp
	bsr	calc_avg_spec
	move.w	d0,r_avg_spec
	move.w	r_avg_spec,avg_spec

	lea	old_right_osci,a3

	lea	redscale,a4
	move.w	r_angle,angle
	move.w	#64,length
	move.l	r_specp,tmpspecp
	bsr	lightning

	tst.l	option_more
	beq.s	.nomore_r
	lea	old_right_osci+64*2,a3
	move.w	r_angle,angle
	addq.w	#5,angle
	move.w	#32,length
	lea	redscale+2*3,a4
	move.l	r_specp,tmpspecp
	bsr	lightning
	move.w	r_angle,angle
	addq.w	#1,angle
	move.w	#32,length
	lea	redscale+2*3,a4
	move.l	r_specp,tmpspecp
	bsr	lightning

.nomore_r
	moveq	#0,d7
	vlm_get_right_volume	d7
	cmp.l	option_threshold,d7
	blt.s	.nomover
	subq.w	#1,r_angle
	bpl.s	.nomover
	addq.w	#6,r_angle
.nomover

	
	move.l	#0,(a2)+	
		

	tst.l	option_blur
	beq.s	.noblur
	bsr	blur
.noblur
	
	rts

lightning
	move.l	scrp,a0
	move.l	a0,d5
	add.l	#(XRES*YRES/2+XRES/2)*2,a0
	lea	moves,a1
	move.w	63*2(a4),d0
	or.w	d0,(a0)
	or.w	d0,640(a0)
	clr.w	nr_sub
	lea	bolts,a5
	move.w	angle,(a5)+
	move.l	a0,(a5)+
	moveq	#0,d3

	move.w	length,d7
	subq.w	#1,d7
.ll
	lea	bolts,a5
	move.w	nr_sub,d6
.sl	
	move.w	(a5)+,d0
	move.w	d0,d1
	move.l	(a5),a0
	move.w	(a3)+,d2
	cmp.w	neg_option_sparkle+2,d2
	bgt.s	.nolow
	subq.w	#1,d1
	bra.s	.goon
.nolow	cmp.w	option_sparkle+2,d2
	blt.s	.nohigh
	addq.w	#1,d1
.nohigh
.goon
	ifne	USE_OR
	move.w	(a4,d7.w*2),d2
	add.l	(a1,d1.w*8),a0
	or.w	d2,(a0)
	move.l	a0,(a2)
	sub.l	d5,(a2)+
	add.l	4(a1,d1.w*8),a0
	or.w	d2,(a0)
	move.l	a0,(a2)
	sub.l	d5,(a2)+
	or.w	d2,640(a0)
	else
	move.w	(a4,d7.w*2),d2
	add.l	(a1,d1.w*8),a0
	move.w	d2,(a0)
	move.l	a0,(a2)
	sub.l	d5,(a2)+
	add.l	4(a1,d1.w*8),a0
	move.w	d2,(a0)
	move.l	a0,(a2)
	sub.l	d5,(a2)+
	move.w	d2,640(a0)
	endc

	move.l	a0,(a5)+

	dbra	d6,.sl

; old static splits	
;	cmp.w	#48,d7
;	beq.s	.split
;	cmp.w	#24,d7
;	beq.s	.split
;	cmp.w	#16,d7
;	bne.s	.nosplit

	cmp.w	option_splitdist+2,d3
	blt.s	.nosplit
	move.w	nr_sub,d6
	cmp.w	option_maxsplits+2,d6
	bge.s	.nosplit
	
	move.l	a4,d2
	move.l	tmpspecp,a4
	move.w	-(a4),d6
	move.l	a4,tmpspecp
	move.l	d2,a4
	cmp.w	avg_spec,d6
	blo.s	.nosplit

.split
	moveq	#0,d3
	sub.w	d1,d0
	add.w	d0,d0
	add.w	d0,d1
	bpl.s	.pos
	addq.w	#6,d1
.pos
	move.w	d1,(a5)+
	move.l	a0,(a5)+
	addq.w	#1,nr_sub
.nosplit
	addq.w	#1,d3
	dbra	d7,.ll

	rts

calc_avg_osci
	move.w	#256-1,d7
.cal
	move.w	(a0)+,d0
	ext.l	d0
	move.w	(a1),d1
	ext.l	d1
	add.l	d1,d0
	asr.l	d0
	move.w	d0,(a1)+
	dbra	d7,.cal
	rts

calc_avg_spec
	moveq	#0,d0
	move.w	#128-1,d7
.cal
	moveq	#0,d1
	move.w	(a3)+,d1
	add.l	d1,d0
	dbra	d7,.cal
	asr.l	#7,d0
	add.l	option_splitlevel,d0
	cmp.l	#65535,d0
	ble.s	.notmax
	move.l	#65535,d0
.notmax
	rts

blur
	lea	scrp,a1
	move.l	(a1)+,a0
	move.w	#%0111101111101111,d1
	moveq	#1,d7
.cl1
	move.l	(a1)+,a2
	move.l	savedp,a4
.cl2
	tst.l	(a4)
	beq.s	.nomore
	move.l	(a4)+,d2
	move.l	a0,a3
	add.l	d2,a3
	move.w	(a3),d0
	lsr.w	d7,d0
	and.w	d1,d0
	move.l	a2,a5
	add.l	d2,a5
	move.w	d0,(a5)

	move.l	(a4)+,d2
	move.l	a0,a3
	add.l	d2,a3
	move.w	(a3),d0
	lsr.w	d7,d0
	and.w	d1,d0
	move.l	a2,a5
	add.l	d2,a5
	move.w	d0,(a5)

	move.w	640(a3),d0
	lsr.w	d7,d0
	and.w	d1,d0
	move.w	d0,640(a5)
	
	bra.s	.cl2
.nomore	
	move.w	d1,d2
	lsr.w	#1,d1
	and.w	d2,d1

	addq.w	#1,d7
	cmp.w	#6,d7
	bls.s	.cl1
	rts

clear
	lea	scrp,a1
	moveq	#6-1,d7
.cl1
	move.l	savedp,a2
	move.l	(a1)+,a3
.cl
	tst.l	(a2)
	beq.s	.noclear
	move.l	a3,a0
	add.l	(a2)+,a0
	clr.w	(a0)
	move.l	a3,a0
	add.l	(a2)+,a0
	clr.w	(a0)
	clr.w	640(a0)
	bra.s	.cl
.noclear	
	dbra	d7,.cl1
	rts

init	
	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x240x16

	lea	scr0,a0
	moveq	#0,d0
	move.w	#XRES*(YRES+16)/2-1,d7
.cl
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	move.l	d0,(a0)+
	dbra	d7,.cl

	lea	old_left_osci,a0
	lea	old_right_osci,a1
	move.w	#256-1,d7
.cl2
	move.w	d0,(a0)+
	move.w	d0,(a1)+
	dbra	d7,.cl2

	move.l	d0,saved0
	move.l	d0,saved1
	move.l	d0,saved2
	move.l	d0,saved3
	move.l	d0,saved4
	move.l	d0,saved5
	move.l	d0,saved6

	tst.l	option_blueends
	beq.s	.noblue
	lea	blueendscale,a0
	lea	redscale,a1
	lea	greenscale,a2
.bl
	move.w	(a0)+,d0
	beq.s	.noblue
	or.w	d0,(a1)+
	or.w	d0,(a2)+
	bra.s	.bl
.noblue
	move.l	option_sparkle,neg_option_sparkle
	neg.l	neg_option_sparkle

	rts

deinit
	rts

scrswap
	move.l	scrp+4*0,tmpscrp
	move.l	scrp+4*1,scrp+4*0
	move.l	scrp+4*2,scrp+4*1
	move.l	scrp+4*3,scrp+4*2
	move.l	scrp+4*4,scrp+4*3
	move.l	scrp+4*5,scrp+4*4
	move.l	scrp+4*6,scrp+4*5
	move.l	tmpscrp,scrp+4*6
	vlm_set_scradr	tmpscrp

	move.l	savedp+4*0,-(sp)
	move.l	savedp+4*1,savedp+4*0
	move.l	savedp+4*2,savedp+4*1
	move.l	savedp+4*3,savedp+4*2
	move.l	savedp+4*4,savedp+4*3
	move.l	savedp+4*5,savedp+4*4
	move.l	savedp+4*6,savedp+4*5
	move.l	(sp)+,savedp+4*6

	rts

	data

l_angle	dc.w	0
r_angle	dc.w	3
nr_sub	dc.w	0

scrp	dc.l	scr0,scr1,scr2,scr3,scr4,scr5,scr6
savedp	dc.l	saved0
	dc.l	saved1
	dc.l	saved2
	dc.l	saved3
	dc.l	saved4
	dc.l	saved5
	dc.l	saved6

Y	=	2*XRES
X	=	2
	dc.l	-X,-Y-X	; up/left
moves	dc.l	0,-2*Y	; up
	dc.l	X,-Y+X	; up/right
	dc.l	Y+X,X	; down/right
	dc.l	0,2*Y	; down
	dc.l	Y-X,-X	; down/left
	dc.l	-X,-Y-X	; up/left
	dc.l	0,-2*Y	; up
	dc.l	X,-Y+X	; up/right
	dc.l	Y+X,X	; down/right
	dc.l	0,2*Y	; down
	dc.l	Y-X,-X	; down/left
	dc.l	-X,-Y-X	; up/left
	dc.l	0,-2*Y	; up
	dc.l	X,-Y+X	; up/right
	dc.l	Y+X,X	; down/right
	dc.l	0,2*Y	; down
	dc.l	Y-X,-X	; down/left

	dc.l	0,-Y-X	; up/left
;moves	dc.l	0,-2*Y	; up
	dc.l	0,-Y+X	; up/right
	dc.l	0,Y+X	; down/right
	dc.l	0,2*Y	; down
	dc.l	0,Y-X	; down/left
	dc.l	0,-Y-X	; up/left
	dc.l	0,-2*Y	; up
	dc.l	0,-Y+X	; up/right
	dc.l	0,Y+X	; down/right
	dc.l	0,2*Y	; down
	dc.l	0,Y-X	; down/left

blueendscale	dc.w	B20,B15,B10,B06,B01,0

	ds.w	64
redscale	dc.w	R01,R01,R01,R02,R02,R02,R03,R03
	dc.w	R04,R04,R05,R05,R06,R06,R07,R07
	dc.w	R08,R08,R09,R09,R10,R10,R11,R11
	dc.w	R12,R12,R13,R13,R14,R14,R15,R15
	dc.w	R16,R16,R17,R17,R18,R18,R19,R19
	dc.w	R20,R20,R21,R21,R22,R22,R23,R23
	dc.w	R24,R24,R25,R25,R26,R26,R27,R27
	dc.w	R28,R28,R29,R29,R30,R30,R31,R31

	ds.w	64
greenscale	dc.w	G02,G03,G04,G05,G05,G06,G06,G07
	dc.w	G08,G09,G10,G11,G12,G13,G14,G15
	dc.w	G16,G17,G18,G19,G20,G21,G22,G23
	dc.w	G24,G25,G26,G27,G28,G29,G30,G31
	dc.w	G32,G33,G34,G35,G36,G37,G38,G39
	dc.w	G40,G41,G42,G43,G44,G45,G46,G47
	dc.w	G48,G49,G50,G51,G52,G53,G54,G55
	dc.w	G56,G57,G58,G59,G60,G61,G62,G63


infotext	dc.b	'LIGHTNING DISC',0
	dc.b	'Author:  NoBrain/NoCrew',0
	dc.b	'Version: 0.42',0
	dc.b	'Date:    1999-10-09',0
	dc.b	0
	even
	
settings	dc.l	9

	dc.l	par0name
	dc.l	3
option_threshold	dc.l	DEFAULT_THRESHOLD
	dc.l	threshold_struct

	dc.l	par1name
	dc.l	1
option_blur	dc.l	DEFAULT_BLUR
	dc.l	0

	dc.l	par2name
	dc.l	1
option_more	dc.l	DEFAULT_MORE
	dc.l	0

	dc.l	par3name
	dc.l	1
option_blueends	dc.l	DEFAULT_BLUEENDS
	dc.l	0

	dc.l	par4name
	dc.l	3
option_splitlevel	dc.l	DEFAULT_SPLITLEVEL
	dc.l	splitlevel_struct

	dc.l	par5name
	dc.l	3
option_maxsplits	dc.l	DEFAULT_MAXSPLITS
	dc.l	maxsplits_struct

	dc.l	par6name
	dc.l	3
option_splitdist	dc.l	DEFAULT_SPLITDIST
	dc.l	splitdist_struct

	dc.l	par7name
	dc.l	3
option_slowdown	dc.l	DEFAULT_SLOWDOWN
	dc.l	slowdown_struct

	dc.l	par8name
	dc.l	3
option_sparkle	dc.l	DEFAULT_SPARKLE
	dc.l	sparkle_struct

threshold_struct
	dc.l	0,65535
splitlevel_struct
	dc.l	0,16383
maxsplits_struct
	dc.l	0,15
splitdist_struct
	dc.l	0,63
slowdown_struct
	dc.l	0,10
sparkle_struct
	dc.l	1,2048

par0name	dc.b	'JUMP THRESHOLD',0
par1name	dc.b	'MOTION BLUR',0
par2name	dc.b	'MORE BOLTS',0
par3name	dc.b	'BLUE ENDS',0
par4name	dc.b	'BOLT SPLIT LEVEL',0
par5name	dc.b	'MAXIMUM SPLITS',0
par6name	dc.b	'MINIMUM SPLIT DISTANCE',0
par7name	dc.b	'SLOWDOWN VALUE',0
par8name	dc.b	'SPARKLE THRESHOLD',0
	even
		
	bss

service_struct ds.l	1

length	ds.w	1
angle	ds.w	1
avg_spec	ds.w	1
l_avg_spec	ds.w	1
r_avg_spec	ds.w	1
l_specp	ds.l	1
r_specp	ds.l	1
tmpscrp	ds.l	1
tmpspecp	ds.l	1
neg_option_sparkle	ds.l	1

old_left_osci	ds.w	256
old_right_osci	ds.w	256
bolts	ds.l	2*64*16*2
	
saved0	ds.l	2*3*64*16*2
saved1	ds.l	2*3*64*16*2
saved2	ds.l	2*3*64*16*2
saved3	ds.l	2*3*64*16*2
saved4	ds.l	2*3*64*16*2
saved5	ds.l	2*3*64*16*2
saved6	ds.l	2*3*64*16*2
scr0	ds.w	XRES*(YRES+16)
scr1	ds.w	XRES*(YRES+16)
scr2	ds.w	XRES*(YRES+16)
scr3	ds.w	XRES*(YRES+16)
scr4	ds.w	XRES*(YRES+16)
scr5	ds.w	XRES*(YRES+16)
scr6	ds.w	XRES*(YRES+16)
