; Copyright 1999 Tomas Berndtsson <tomas@nocrew.org>
* Updates by Earx/Fun

  	include	macros.s

VLM_MODULE:		=	1
SHOWVBL:		=	0

XRES:			=	320
YRES:			=	256
SCRXRES:		=	320
SCRYRES:		=	240

; estimated values
MAXDOTSPERLINE:		=	500
NRLINES:		=	256

DEFAULT_ROT:		=	80
DEFAULT_LINES:		=	0
DEFAULT_LEFT_TYPE:  	=	0
DEFAULT_RIGHT_TYPE: 	=	0

	IFNE	VLM_MODULE
	comment	head=%101
	opt	d-
	output	e:\whip!\vlm\sparkle.vlm
	include	vlmserv.s
	ELSE
	include	vlmserv.s
	ENDC

	text

	IFEQ	VLM_MODULE
	incbin	miniwhip.bin
	ENDC

	dc.b	"VLM2"
	dc.l	infotext
	dc.l	settings
	dc.l	init
	dc.l	deinit
	dc.l	main

main:	bsr	scrswap

	IFNE	SHOWVBL

	movea.l	scrp,a3
	move.w	$4bc.w,d7
	move.w	old468(pc),d6
	move.w	d7,old468
	sub.w	d6,d7
	subq.w	#1,d7
	cmpi.w	#50,d7
	bhs.s	.end_showvbl

.vsl:	move.l	#$ffff0000,(a3)+
	dbra	d7,.vsl

.end_showvbl:
	moveq	#0,d0
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+
	move.l	d0,(a3)+

	ENDC

	tst.w	drawtype+2
	bne	blur

	bsr	clrspark

	move.l	scrp,a0
	lea	pal,a4
	moveq	#0,d0
	move.w	$4bc.w,d0
	lsr.w	#3,d0
	andi.w	#$01ff,d0
	lea	(a4,d0.l*2),a4

	move.w	$4bc.w,d0
	mulu.w	option_rot+2,d0
	lsr.l	#8,d0
	andi.w	#$00ff,d0
	lea	(sincos,d0.w*4),a2

left:	tst.l	option_left_type
	bne.w	.not_spectrum
	vlm_get_left_spec a5
	sub.w	#12042,2(a5)
	bpl.s	.nonegspec
	clr.w	2(a5)
.nonegspec
	bra.s	.go_on
.not_spectrum
	vlm_get_left_osci a5
	lea	fake_left_spec,a3
	bsr	fixosci
	lea	fake_left_spec,a5

.go_on:	move.w	#128,d7
	move.w	option_lines+2,d2
	asr.w	d2,d7
	subq.w	#1,d7
	moveq	#1,d3
	asl.w	d2,d3
	subq.w	#1,d3
	add.w	d3,d3

.ll:	move.w	(a5)+,d2
	add.w	d3,a5
	lsr.w	#8,d2
	move.w	(a2)+,d1
	muls.w	d2,d1
	swap	d1
	move.w	(a2)+,d0
	muls.w	d2,d0
	swap	d0
	add.w	d3,a2
	add.w	d3,a2
	add.w	x1(pc),d0
	add.w	y1(pc),d1
	move.w	d0,x2
	move.w	d1,y2
	move.w	(a4,d2.w*2),a3
	bsr	drawline
	dbra	d7,.ll

right:	tst.l	option_right_type
	bne.w	.not_spectrum
	vlm_get_right_spec a5
	bra.s	.go_on
.not_spectrum:
	vlm_get_right_osci a5
	lea	fake_right_spec,a3
	bsr	fixosci
	lea	fake_right_spec,a5

.go_on:	move.w	#128,d7
	move.w	option_lines+2,d2
	asr.w	d2,d7
	subq.w	#1,d7
	moveq	#1,d3
	asl.w	d2,d3
	subq.w	#1,d3
	add.w	d3,d3

.rl:	move.w	(a5)+,d2
	add.w	d3,a5
	lsr.w	#8,d2
	move.w	(a2)+,d1
	muls.w	d2,d1
	swap	d1
	move.w	(a2)+,d0
	muls.w	d2,d0
	swap	d0
	add.w	d3,a2
	add.w	d3,a2
	add.w	x1(pc),d0
	add.w	y1(pc),d1
	move.w	d0,x2
	move.w	d1,y2
	move.w	(a4,d2.w*2),a3
	bsr	drawline
	dbra	d7,.rl
	rts

blur:	bsr	blurspark

	move.l	scrp,a0
	lea	pal,a4
	moveq	#0,d0
	move.w	$4bc.w,d0
	lsr.w	#3,d0
	andi.w	#$01ff,d0
	lea	(a4,d0.l*2),a4

	move.w	$4bc.w,d0
	mulu.w	option_rot+2,d0
	lsr.l	#8,d0
	andi.w	#$00ff,d0
	lea	(sincos,d0.w*4),a2

.left:	tst.l	option_left_type
	bne.w	.not_spectrum
	vlm_get_left_spec a5
	sub.w	#12042,2(a5)
	bpl.s	.nonegspec
	clr.w	2(a5)
.nonegspec:
	bra.s	.go_on
.not_spectrum:
	vlm_get_left_osci a5
	lea	fake_left_spec,a3
	bsr	fixosci
	lea	fake_left_spec,a5

.go_on:	move.w	#128,d7
	move.w	option_lines+2,d2
	asr.w	d2,d7
	subq.w	#1,d7
	moveq	#1,d3
	asl.w	d2,d3
	subq.w	#1,d3
	add.w	d3,d3

.ll:	move.w	(a5)+,d2
	add.w	d3,a5
	lsr.w	#8,d2
	move.w	(a2)+,d1
	muls.w	d2,d1
	swap	d1
	move.w	(a2)+,d0
	muls.w	d2,d0
	swap	d0
	add.w	d3,a2
	add.w	d3,a2
	add.w	x1(pc),d0
	add.w	y1(pc),d1
	move.w	d0,x2
	move.w	d1,y2
	move.w	(a4,d2.w*2),a3
	bsr	drawblurline
	dbra	d7,.ll

.right:	tst.l	option_right_type
	bne.w	.r_not_spectrum
	vlm_get_right_spec a5
	bra.s	.r_go_on
.r_not_spectrum:
	vlm_get_right_osci a5
	lea	fake_right_spec,a3
	bsr	fixosci
	lea	fake_right_spec,a5

.r_go_on:
	move.w	#128,d7
	move.w	option_lines+2,d2
	asr.w	d2,d7
	subq.w	#1,d7
	moveq	#1,d3
	asl.w	d2,d3
	subq.w	#1,d3
	add.w	d3,d3

.rl:	move.w	(a5)+,d2
	add.w	d3,a5
	lsr.w	#8,d2
	move.w	(a2)+,d1
	muls.w	d2,d1
	swap	d1
	move.w	(a2)+,d0
	muls.w	d2,d0
	swap	d0
	add.w	d3,a2
	add.w	d3,a2
	add.w	x1(pc),d0
	add.w	y1(pc),d1
	move.w	d0,x2
	move.w	d1,y2
	move.w	(a4,d2.w*2),a3
	bsr	drawblurline
	dbra	d7,.rl
	rts

old468:
	DC.W	0

init:	move.l	a0,service_struct
	vlm_set_resolution #VLM_320x240x16
	
	lea	pal,a1
	lea	512*2(a1),a0
	moveq	#128-1,d7
.loop:	move.w	(a1)+,-(a0)
	move.w	(a1)+,-(a0)
	dbra	d7,.loop
	lea	-256*2(a1),a1
	lea	256*2(a0),a0
	moveq	#128-1,d7
.loop2:	move.l	(a1)+,(a0)+
	dbra	d7,.loop2

	lea	scr1,a0
	bsr	clrscr
	lea	scr2,a0
	bsr	clrscr
	lea	scr3,a0
	bsr	clrscr

	move.l	#-1,saved1
	move.l	#-1,saved2
	move.l	#-1,saved3
	rts

deinit:	rts

scrswap:
	lea	savedp,a0
	move.l	(a0)+,d0
	move.l	(a0)+,-8(a0)
	move.l	(a0),-4(a0)
	move.l	d0,(a0)
	
	lea	scrp,a0
	move.l	(a0)+,d0
	move.l	(a0)+,-8(a0)
	move.l	(a0),-4(a0)
	move.l	d0,(a0)
	vlm_set_scradr	d0
	rts

* ORred line (RGB overlay)
drawline:
	movem.l	d3/d7/a2,-(sp)

	movem.w	x1(pc),d0-d3
	cmp.w	d0,d1
	bge.s	.x_ok
	exg	d0,d1
.x_ok:	cmp.w	d2,d3
	bge.s	.y_ok
	exg	d2,d3
.y_ok:

* d0=minx, d1=maxx, d2=miny, d3=maxy

	move.w	d1,d4
	sub.w	d0,d4	; dx
	move.w	d3,d5
	sub.w	d2,d5	; dy
	
	cmp.w	d4,d5
	bgt	yslope
xslope
	move.l	#640,d6
	cmp.w	x1,d0
	bne.s	.x1notmin
	move.w	y1,d1
	cmp.w	y2,d1
	blt.s	.nonegstep1
	neg.l	d6
.nonegstep1
	bra.s	.consts
.x1notmin
	move.w	y2,d1
	cmp.w	y1,d1
	blt.s	.nonegstep2
	neg.l	d6
.nonegstep2

.consts
	add.w	d5,d5	; d5 = c1=2*dy
	move.w	d5,d3
	sub.w	d4,d3	; d3 = p=2*dy-dx
	move.w	d4,d7
	add.w	d7,d7	; d7 = 2*dx

	mulu.w	#640,d1
	ext.l	d0
	add.l	d0,d1
	add.l	d0,d1
	lea	(a0,d1.l),a2

	move.w	a3,d0
	
	tst.w	d3
.linel
	bpl.s	.pneg
	
	or.w	d0,(a2)+
	add.w	d5,d3
	dbra	d4,.linel

	bra	linedone
.pneg
	or.w	d0,(a2)+
	add.l	d6,a2
	sub.w	d7,d3
	add.w	d5,d3
	dbra	d4,.linel

	bra	linedone

yslope
	moveq	#2,d6
	cmp.w	y1,d2
	bne.s	.x1notmin
	move.w	x1,d0
	cmp.w	x2,d0
	blt.s	.nonegstep1
	neg.l	d6
.nonegstep1
	bra.s	.consts
.x1notmin
	move.w	x2,d0
	cmp.w	x1,d0
	blt.s	.nonegstep2
	neg.l	d6
.nonegstep2

.consts
	add.w	d4,d4	; d4 = c1=2*dx
	move.w	d4,d3
	sub.w	d5,d3	; d3 = p=2*dx-dy
	move.w	d5,d7
	add.w	d7,d7	; d7 = 2*dy

	move.w	d2,d1
	mulu.w	#640,d1
	ext.l	d0
	add.l	d0,d1
	add.l	d0,d1
	lea	(a0,d1.l),a2

	move.w	a3,d0
	movea.w	#640,a6
	tst.w	d3
.linel
	bpl.s	.pneg

	or.w	d0,(a2)
	adda.l	a6,a2
	add.w	d4,d3
	dbra	d5,.linel

	bra	linedone
.pneg
	or.w	d0,(a2)
	adda.l	a6,a2
	add.l	d6,a2
	sub.w	d7,d3
	add.w	d4,d3
	dbra	d5,.linel

linedone:
	movem.l	(sp)+,d3/d7/a2
	rts

* ADDed line (voor motionblur beweegbrul)
drawblurline:
	movem.l	d3/d7/a2,-(sp)

	movem.w	x1(pc),d0-d3
	cmp.w	d0,d1
	bge.s	.x_ok
	exg	d0,d1
.x_ok:	cmp.w	d2,d3
	bge.s	.y_ok
	exg	d2,d3
.y_ok:

* d0=minx, d1=maxx, d2=miny, d3=maxy

	move.w	d1,d4
	sub.w	d0,d4	; dx
	move.w	d3,d5
	sub.w	d2,d5	; dy
	
	cmp.w	d4,d5
	bgt	.yslope
.xslope:
	move.l	#640,d6
	cmp.w	x1,d0
	bne.s	.x1notmin
	move.w	y1,d1
	cmp.w	y2,d1
	blt.s	.nonegstep1
	neg.l	d6
.nonegstep1
	bra.s	.consts
.x1notmin
	move.w	y2,d1
	cmp.w	y1,d1
	blt.s	.nonegstep2
	neg.l	d6
.nonegstep2

.consts:
	add.w	d5,d5	; d5 = c1=2*dy
	move.w	d5,d3
	sub.w	d4,d3	; d3 = p=2*dy-dx
	move.w	d4,d7
	add.w	d7,d7	; d7 = 2*dx

	mulu.w	#640,d1
	ext.l	d0
	add.l	d0,d1
	add.l	d0,d1
	lea	(a0,d1.l),a2

	move.w	a3,d0
	move.w	#%0111101111101111,d1
	lsr.w	#1,d0
	and.w	d1,d0
	
	move.w	d3,d3

.linel:	bpl.s	.pneg
	move.w	(a2),d2
	lsr.w	#1,d2
	and.w	d1,d2
	add.w	d0,d2
	move.w	d2,(a2)+
	add.w	d5,d3
	dbra	d4,.linel

	bra	.linedone

.pneg:	move.w	(a2),d2
	lsr.w	#1,d2
	and.w	d1,d2
	add.w	d0,d2
	move.w	d2,(a2)+
	add.l	d6,a2
	sub.w	d7,d3
	add.w	d5,d3
	dbra	d4,.linel

	bra	.linedone

.yslope:
	moveq	#2,d6
	cmp.w	y1,d2
	bne.s	.yx1notmin
	move.w	x1,d0
	cmp.w	x2,d0
	blt.s	.ynonegstep1
	neg.l	d6
.ynonegstep1:
	bra.s	.yconsts
.yx1notmin:
	move.w	x2,d0
	cmp.w	x1,d0
	blt.s	.ynonegstep2
	neg.l	d6
.ynonegstep2:

.yconsts:
	add.w	d4,d4	; d4 = c1=2*dx
	move.w	d4,d3
	sub.w	d5,d3	; d3 = p=2*dx-dy
	move.w	d5,d7
	add.w	d7,d7	; d7 = 2*dy

	move.w	d2,d1
	mulu.w	#640,d1
	ext.l	d0
	add.l	d0,d1
	add.l	d0,d1
	lea	(a0,d1.l),a2

	move.w	a3,d0
	movea.w	#640,a6
	move.w	#%0111101111101111,d1
	lsr.w	#1,d0
	and.w	d1,d0
	move.w	d3,d3

.ylinel:
	bpl.s	.ypneg
	move.w	(a2),d2
	lsr.w	#1,d2
	and.w	d1,d2
	add.w	d0,d2
	move.w	d2,(a2)
	adda.l	a6,a2
	add.w	d4,d3
	dbra	d5,.ylinel

	bra.s	.linedone

.ypneg:	move.w	(a2),d2
	lsr.w	#1,d2
	and.w	d1,d2
	add.w	d0,d2
	move.w	d2,(a2)
	adda.l	a6,a2
	adda.l	d6,a2
	sub.w	d7,d3
	add.w	d4,d3
	dbra	d5,.ylinel

.linedone:
	movem.l	(sp)+,d3/d7/a2
	rts

fixosci:
	moveq	#128-1,d7
	move.w	#$8000,d2

.fol:	movem.w	(a5)+,d0-d1
	add.l	d0,d1
	asr.l	#2,d1
	add.w	d2,d1
	move.w	d1,(a3)+
	dbra	d7,.fol

	rts

clrscr:	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	sub.l	a1,a1
	sub.l	a2,a2
	sub.l	a3,a3
	sub.l	a4,a4
	sub.l	a5,a5
	add.l	#SCRXRES*SCRYRES*2+24*2,a0
	move.w	#SCRXRES*SCRYRES/24-1,d7

.cl:	movem.l	d0-6/a1-5,-(a0)
	dbra	d7,.cl
	rts

clrspark:
	movea.l	scrp,a0
	lea	640*7+92(a0),a0
	move.w	#226-1,d7

	moveq	#0,d0
	moveq	#0,d1
	moveq	#0,d2
	moveq	#0,d3
	moveq	#0,d4
	moveq	#0,d5
	moveq	#0,d6
	movea.l	d0,a1
	movea.l	d0,a2
	movea.l	d0,a3
	movea.l	d0,a4
	movea.l	d0,a5
	movea.l	d0,a6

.loop:	movem.l	d0-d6/a1-a6,(a0)
	movem.l	d0-d6/a1-a6,52*1(a0)
	movem.l	d0-d6/a1-a6,52*2(a0)
	movem.l	d0-d6/a1-a6,52*3(a0)
	movem.l	d0-d6/a1-a6,52*4(a0)
	movem.l	d0-d6/a1-a6,52*5(a0)
	movem.l	d0-d6/a1-a6,52*6(a0)
	movem.l	d0-d6/a1-a6,52*7(a0)
	movem.l	d0-d6/a1-a6,52*8(a0)
	lea	640(a0),a0
	dbra	d7,.loop

	rts

blurspark:
	movea.l	scrp,a0
	lea	640*7+92(a0),a0
	move.w	#226-1,d7
	movea.l	scrp+8,a1
	lea	640*7+92(a1),a1
	move.l	#%01111011111011110111101111101111,d1
	move.l	#640-224*2,d2

.yloop:	moveq	#224/8-1,d6

.xloop:
	REPT	4
	move.l	(a1)+,d0
	lsr.l	#1,d0
	and.l	d1,d0
	move.l	d0,(a0)+
	ENDR
	dbra	d6,.xloop

	adda.l	d2,a0
	adda.l	d2,a1
	dbra	d7,.yloop

	rts

	data

scrp:	dc.l	scr1+16*SCRXRES,scr2+16*SCRXRES,scr3+16*SCRXRES
savedp:	dc.l	saved1,saved2,saved3

infotext:
	dc.b	"SPARKLING LINES II",0
	dc.b	"Author:  NoBrain and eARx",0
	dc.b	"Version: 1.1",0
	dc.b	"Date:    04-01-2000",0
	dc.b	0
	even
	
settings:
	dc.l	5

	dc.l	drawtype_txt
	dc.l	2
drawtype:
	dc.l	0
	dc.l	drawtype_tbl

	dc.l	parrotname
	dc.l	3
option_rot:
	dc.l	DEFAULT_ROT
	dc.l	parrotstruct

	dc.l	parlinesname
	dc.l	3
option_lines:
	dc.l	DEFAULT_LINES
	dc.l	parlinesstruct

	dc.l	parltypename
	dc.l	2
option_left_type:
	dc.l	DEFAULT_LEFT_TYPE
	dc.l	type_struct

	dc.l	parrtypename
	dc.l	2
option_right_type:
	dc.l	DEFAULT_RIGHT_TYPE
	dc.l	type_struct

drawtype_txt:
	dc.b	"DRAWING TYPE",0
parrotname:
	dc.b	'ROTATION SPEED',0
parlinesname:
	dc.b	'GRANULARITY',0
parltypename:
	dc.b	'LEFT CHANNEL TYPE',0
parrtypename:
	dc.b	'RIGHT CHANNEL TYPE',0
	even

parrotstruct:
	dc.l	0,255
parlinesstruct:
	dc.l	0,3
type_struct:
	dc.l	2
	dc.b	'SPECTRUM',0
	dc.b	'OSCILLOSCOPE',0
drawtype_tbl:
	dc.l	2
	dc.b	"Clear/Or",0
	dc.b	"Blur (ZZzz)",0
	even
		
x1:	dc.w	160
x2:	dc.w	319
y1:	dc.w	120
y2:	dc.w	199

sincos:	incbin	sico256.tab
	incbin	sico256.tab
pal:	incbin	line256.pal
	ds.w	256*2

	bss

tmpscrp:
	ds.l	1
service_struct:
	ds.l	1
	
fake_left_spec:
	ds.w	128
fake_right_spec:
	ds.w	128
saved1:	ds.l	1+NRLINES*MAXDOTSPERLINE
saved2:	ds.l	1+NRLINES*MAXDOTSPERLINE
saved3:	ds.l	1+NRLINES*MAXDOTSPERLINE

scr1:	ds.w	XRES*YRES
scr2:	ds.w	XRES*YRES
scr3:	ds.w	XRES*YRES