/* libshoe.h
 *
 * COPYRIGHT (c) 1998 by Fredrik Noring.
 */

#include "types.h"

#ifndef _LIBSHOE_H_
#define _LIBSHOE_H_

#define ONE_K   1024L
#define ONE_MEG (ONE_K*ONE_K)

#define HEAP_SIZE   (100*ONE_K)
#define GC_MINIMUM  (4*ONE_K)
#define MAX_SYMBOLS (9999)

#define T                memdup("#t")
#define F                memdup("#f")
/*#define ERR              (trace?panic("#ERR."):memdup("#ERR.")) */
#define ERR              memdup("#ERR.")
#define FP(x)            MATCH((x), F)
#define TP(x)            (!FP(x))
#define NILP(x)          MATCH((x), "()")
#define LISTP(x)         ((x)[0] == '(')
#define MATCH(a, b)      (strcmp((a), (b)) == 0)
#define DIGITP(c)        ((c) >= '0' && (c) <= '9')
#define EVAL(x)          eval(car(x))
#define EVALARG(x)       EVAL(cdr(x))
#define DUAL_EVAL(s, op) \
  Byte *a, *b; \
  s = push_stack(s); a = push_stack(EVAL(s)); \
  b = push_stack(EVALARG(s)); op; pop_n_elems(3); return s;

extern Byte *eval(Byte *s);
extern Int inquire_balance(void);
extern Byte *parse_eval(Byte *input);
extern void bootstrap();
extern void bif(Byte *symbol, void *f);
extern Byte *mem(Int amount);
extern Byte *memdup(Byte *s);
extern Byte *car(Byte *s);
extern Byte *cdr(Byte *s);

extern Byte *push_stack(Byte *s);
extern Byte *pop_n_elems(Int n);

#endif /* _LIBSHOE_H_ */
