#include <tos.h>
#include <aes.h>
#include <ext.h>
#include <stdio.h>

#include "mp2info.h"

/* global variable */
MP2INFO mp2info;

static long bitrates[2][3][16] = { /* [id][layer][bitrate] */
	{ /* ID_LOWER */
		{ 0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L }, /* dummy layer */
		{ 0L,32000L,48000L,56000L,64000L,80000L,96000L,112000L,128000L,
			144000L,160000L,176000L,192000L,224000L,256000L,-1L }, /* Layer I */
		{ 0L,8000L,16000L,24000L,32000L,40000L,48000L,56000L,64000L,
			80000L,96000L,112000L,128000L,144000L,160000L,-1L }  /* Layer II */
	},
	{ /* ID_NORMAL */
		{ 0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L,0L }, /* dummy layer */
		{ 0L,32000L,64000L,96000L,128000L,160000L,192000L,224000L,
			256000L,288000L,320000L,352000L,384000L,416000L,448000L,-1L }, /* Layer I */
		{ 0L,32000L,48000L,56000L,64000L,80000L,96000L,112000L,128000L,
			160000L,192000L,224000L,256000L,320000L,384000L,-1L }  /* Layer II */
	}
};
static long frequencies[2][4] = { /* [id][frequency] */
	{ 22050L , 24000L , 16000L , 0L }, /* ID_LOWER */
	{ 44100L , 48000L , 32000L , 0L }  /* ID_NORMAL */
};


static int checkmp2info(FRAME_HEADER *header)
{
	if(header->sync!=0xfff)
		return -MP2ERR_SYNC;

	if(bitrates[header->id][header->layer][header->bitrate]<=0)
		return -MP2ERR_OTHER;

	return MP2_NOERR;
}

int getmp2info(int file)
{	
	int ret;
	FRAME_HEADER header;

	Fread(file,sizeof(FRAME_HEADER),(void *)&header);
	Fseek(-(long)sizeof(FRAME_HEADER),file,1);

	if((ret=checkmp2info(&header)) != MP2_NOERR)
		return ret;

	mp2info.bitrate=bitrates[header.id][header.layer][header.bitrate];
	mp2info.sample_frequency=frequencies[header.id][header.frequency];
	mp2info.filelength=filelength(file);
	
	mp2info.timelength=(mp2info.filelength*8)/mp2info.bitrate;

	return MP2_NOERR;
}


void show_mp2_error(int error)
{
	switch(error)
	{
		case -MP2ERR_SYNC:
			form_alert(1,"[3][Not a valid MPEG file!|No sync!][Ok]");
			break;
		case -MP2ERR_MONO:
			form_alert(1,"[3][No support for mono, yet!][Ok]");
			break;
		case -MP2ERR_CRC:
			form_alert(1,"[3][No support for CRC, yet!][Ok]");
			break;
		case -MP2ERR_OTHER:
			form_alert(1,"[3][Not a valid MPEG file!][Ok]");
			break;
		default:
			break;
	}
}

