#include <tos.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "mp2info.h"
#include "libshoe.h"
#include "decoder.h"
#include "stream.h"

static int fd = -1, state_saved = 0;
static long block, file_position, buffer_position = 0;
static char *buffer_mem = 0, stream_name[1024] = "\0";
char path[512] = "\0", filename[512] = "\0";

/* Function from mp2info.c */
extern int getmp2info(int);

/* Function from mp2event.c */
extern void update_time(void);

extern int stream_loadedp(void)
{
	return fd>=0;
}

void stream_free_buffer(void)
{
	if(buffer_mem)
		Mfree(buffer_mem);
}

int stream_set_buffer(long size)
{
	stream_free_buffer();
	buffer_mem = Mxalloc(size, 0);
	if(!buffer_mem) {
		size = block;
		buffer_mem = Mxalloc(size, 0);
	}
	block = size;
	
	return buffer_mem?1:0;
}

void *stream_get_buffer(void)
{
	return buffer_mem;
}

void *stream_get_buffer_end(void)
{
	return buffer_mem + block;
}

void stream_close(void)
{
	if(fd >= 0) {
		Fclose(fd);
		fd = -1;
	}
}

int stream_open(char *name)
{
	char *filep;

	/* Make sure that the old file is
	 * closed and then open the new one. */
	stream_close();
	fd = (int) Fopen(name, FO_READ);
	if(fd < 0)
		return 0;

	/* Move this to someplace else. */
	if(getmp2info(fd) != MP2_NOERR) {
		Fclose(fd);
		fd = -1;
		return 0;
	}

	strcpy(stream_name, name);

	/* Set filename and path, if there is one. */
	if((filep = strrchr(name, '\\')) != NULL) {
		strcpy(filename, filep+1);
		filep[1] = '\0';
		strcpy(path, name);
	} else {
		strcpy(filename, name);
	}

	file_position = buffer_position = 0;
	update_time();
	eval("(mp2-hook-loaditum)");
	return 1;
}

int stream_save_state(void)
{
	return state_saved = 1;
}

int stream_restore_state(void)
{
	if(!state_saved)
		return 0;
	
	stream_open(stream_name);
	Fseek(file_position, fd, 0);
	state_saved = 0;
	return 1;
}

void stream_reset(void)
{
	Fseek(0, fd, 0);
	file_position = buffer_position = 0;
}

long stream_position(void)
{
	return buffer_position;
}

int stream_load(int initialize)
{
	long available_stream;
	static int state, sent_hook;

	if(initialize) {
		state = sent_hook = 0;
		buffer_position = file_position = 0;
	}
	if(sent_hook)
		return 0;

	stream_restore_state();
	available_stream = decoder_stream_available();
	buffer_position = file_position - available_stream;
	if(available_stream < block/2) {
		long length = -1;
		
		if(fd >= 0 && buffer_mem)
			length = Fread(fd, block/2, buffer_mem + (state?block/2:0));

		if(length > 0) {
			decoder_add_available(initialize?length-8:length);
			file_position += length;
			state = !state;
		} else if(!sent_hook && available_stream < 0) {
			sent_hook = 1;
			eval("(mp2-hook-finitum)");
			return 0;
		}
	}
	
	return 1;
}
