*****
*
* This include file defines structures involved in
* the programming of a module for The Removers' Animator.
*
* Every detail about the signification of fields
* is given in the documentation 'modules.txt'
*


*****
*
* init_module :
* Structure of the table given in parameter through a0.l
*

* common part for AVC and AAC
info_init_codec		rsstruct
modules_path		rs.l	1
find_precalc_adr	rs.l	1	; \
mem_alloc_adr		rs.l	1	; |-> memory manager
free_precalc_adr	rs.l	1	; /
type			rs.b	4
sizeof			rs	0

* specific part for AVCs :
			rsset	info_init_codec.sizeof
compression		rs.b	4	; compression type
bits_per_pixel		rs.w	1	; 2, 4, 8, 16, 24, 32 ...
palette_adr		rs.l	1
width			rs.w	1	; video stream dimensions
height			rs.w	1
centered_screen_adr	rs.l	1	; screen address
screen_x		rs.w	1	; size of the screen
screen_y		rs.w	1
nb_bits_out		rs.w	1	; 16 or 24 (with restrictions)
output_type		rs.w	1
video_sizeof		rs	0

ATARI_OUTPUT		equ	0
GRAPHIC_CARD_OUTPUT	equ	1

* specific part for AACs :
			rsset	info_init_codec.sizeof
format			rs.w	1	; 0=unknown, 1=PCM, 2=ADPCM, ....
nb_chanels		rs.b	1	; 1=mono, 2=stereo
bits_per_sample		rs.b	1	; usually 4, 8 or 16.
frequency		rs.l	1	; usually 11025, 22050 ou 44100
block_align		rs.w	1
output_format		rs.w	1	; \
output_nb_chanels	rs.b	1	; | output parameters
output_bits		rs.b	1	; |
output_frequency	rs.l	1	; /
audio_sizeof		rs	0
			rsend

*****
*
* init_module :
* Structure of memory bloc descriptors to fill when
* you create a precalcul
*

precalc_descriptor	rsstruct
identifier		rs.b	4
block_adsress		rs.l	1
nb_users		rs.w	1
sizeof			rs	0
			rsend

*****
*
* init_module :
* Return values through d0.l
*

INIT_MOD_OK			equ	0
INIT_MOD_BAD_COMP		equ	-1
INIT_MOD_TOO_FEW_ARGS		equ	-2
INIT_MOD_MEMORY_ERROR		equ	-3
INIT_MOD_USER_DEFINED_ERROR	equ	-4
INIT_MOD_UNEXP_ERROR		equ	-5
INIT_MOD_BAD_FORMAT		equ	-6

*****
*
* init_module :
* Table structure returned through a0.l if d0.l=INIT_MOD_OK
*

modul_information	rsstruct
decoder_adr		rs.l	1
encoder_adr		rs.l	1
free_modul_adr		rs.l	1
author			rs.l	1
description		rs.l	1
version			rs.b	4
sizeof			rs	0

* specific part for AVCs :
			rsset	info_init_codec.sizeof
adr_MFBD		rs.l	1
video_sizeof		rs	0

* specific part for AACs :
			rsset	info_init_codec.sizeof
min_bit_rate		rs.l	1
audio_sizeof		rs	0
			rsend

*****
*
* Structure of MFDB (VDI structure)
*

		IFND	MFDB.fd_addr
MFDB		rsstruct
fd_addr		rs.l	1	; memory address (NULL = current screen)
fd_width	rs.w	1	; form width in pixels
fd_height	rs.w	1	; form height in pixels
fd_wdwidth	rs.w	1	; form width in words (fdwisth +15)/16
fd_stand	rs.w	1	; format (0 = device specific, 1 = VDI format)
fd_planes	rs.w	1	; number of memory planes
reserved1	rs.w	1	; \
reserved2	rs.w	1	; | (set to 0)
reserved3	rs.w	1	; /
sizeof		rs	0
		rsend
		ENDC
