PD HELP FILE FOR CBREEZE                               BIOS
based on A Hitchhiker's Guide to the BIOS 

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNT & SHFT & CLK   Find previous

Suggest return to menu by macro  - (,),/ - of  CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only


BIOS

Getmpb,    Bconstat,  Bconin,   Bconout,  Rwabs,     Setexc,    Tickcal,
Getbpb,    Bcostat,   Mediach,  Drvmap,   Getshift,  Kbshift,

/*

BIOS Summary
0  Getmpb,     Get copy of the Memory Parameter Block
1  Bconstat,   Return character-device input status 
2  Bconin,     Input character, return when done
3  Bconout,    Write character, return when done
4  Rwabs,      Read or write logical sectors on a device.
5  Setexc,     set or get vector. 
6  Tickcal,    Returns a system-timer calibration value  
7  Getbpb,     Returns pointer to the BIOS Parameter Block 
8  Bcostat,    Returns character output status:
9  Mediach,    Media /might/ have changed 
10 Drvmap,     returns drives available, 0 to 31 
11 Getshift,   sets the keyboard shift  
   Kbshift,    dlibs extra, getshift(-1)

 */


BIOS


(0) getmpb
VOID Getmpb(p_mpb)
LONG p_mpb;
{
/*  Upon entry, 'p_mpb' points to a 'sizeof(MPB)' block to
be filled in with the system initial Memory Parameter Block. 
Upon return, the MPB is filled in.

Structures are:

#define MPB     struct mpb 
#define MD      struct md 
#define PD      struct pd 

MPB   
MD *mp_mfl;         /* memory free list */ 
MD *mp_mal;         /* memory allocated list */ 
MD *mp_rover;       /* roving ptr */ 
;

MD   
MD *m_link;         /* next MD (or NULL) */ 
long m_start;       /* saddr of block */ 
long m_length;      /* #bytes in block */ 
PD *m_own;          /* owner's process descriptor */ 
;
 */
}


(1) bconstat 
WORD Bconstat(dev)
WORD dev;
{
/*  Return character-device input status,   D0.L  will be  $0000 
if no characters available, or $ffff if (at least one) character 
is available.  'dev' can be one of:

     0   PRT: (printer, the parallel port) 
     1   AUX: (aux device, the RS232 port) 
     2   CON: (console, the screen) 
     3   MIDI port (Atari extension) 
     4   Keyboard port (Atari extension) 

Legal operations on character devices are:

                (0)     (1)     (2)     (3)     (4) 
Operation       PRT     AUX     CON     MIDI    KBD 
---------       ----    ----    ----    ----    ---- 
bconstat()      no      yes     yes     yes     no 
bconin()        yes     yes     yes     yes     no 
bconout()       yes     yes     yes     yes     yes 
bcostat()       yes     yes     yes     yes     yes 
 */
}


(2) bconin 
WORD Bconin(dev) 
WORD dev;
{
/*  'dev' is the character device number described in function 1.

Does  not  return until a character has been   input  (busy-
wait).    It  returns the character value in D0.L,  with the 
high word zero.

For  the console (CON:,  device 2) it  returns   the  IBM-PC 
compatible scancode in the low byte of the upper  word,  and 
the Ascii character  in  the  low byte of the low word.

If bit 3 in the system variable 'conterm' is set,  then  the 
high  byte of the upper word will contain the value  of  the 
system   variable  'kbshift'  for  that   ke9stroke.    [The  
default  state for 'con- term%%3' is OFF.]  
 */
}


(3) bconout 
VOID Bconout(dev, c) 
WORD dev, c;
{
/*  'dev' is the character device number described in function 1.
Output character 'c' to the device.
Does not return until the character has been written.
 */
}


(4) rwabs 
LONG Rwabs(rwflag, buf, count, recno, dev) 
WORD rwflag;
LONG buf;
WORD count, recno, dev;
{
/*  Read  or  write  logical  sectors  on  a device.
'rwflag' is one of:
     0   read 
     1   write 
     2   read, do not affect media-change 
     3   write, do not affect media-change 

'buf'  points  to a buffer  to  read  or   write   to  (unaligned  
transfers  -- on odd boundaries -- are permitted,  but  they  are 
slow).    'count'   is   the number  of   sectors   to  transfer.  
'recno' is the logical sector number to start the  transfer  at.
'dev'  is the device number, and on the ST is one of:

     0   Floppy drive A:
     1   Floppy drive B: (or "logical" drive A:
         on single-disk systems).
     2+  Hard disks, networks, etc.

On return,  0L indicates a  successful  operation. Any negative
number indicates an error condition.  (It is the responsibility
of  the BIOS  to  detect media  changes,   and  return  the 
appropriate error code).

Modes 2 and 3 force  a  physical  disk  operation that  will 
NOT  affect  media change,  nor result in one  (this  allows  the 
GEMDOS disk  formatter,   for instance, to read and write logical 
sectors after formatting a disk,  and still allow  the  BIOS   to 
recognize  a media change on the volume just formatted).
 */
}


(5) setexc 
LONG Setexc(vecnum, vec) 
WORD vecnum;
LONG vec;
{
/*  'vecnum' is the number of the vector  to  get  or set. 
'vec' is the address to setup in the vector slot; no set  is 
done  if  'vec'  is  -1L.   The vector's previous value is 
returned. Vectors $00 through  $FF  are  reserved  for  the 
68000.

Logical vectors $100 through  $1FF  are  reserved for GEMDOS. 
Vectors currently implemented are:

$100  System timer interrupt 
$101  Critical error handler 
$102  Process terminate hook 
$103..$107:  Currently unused, reserved 

Logical vectors $200 through $FFFF  are  reserved for  OEM use. 
The ST BIOS makes no provision for these.
 */
}


(6) tickcal 
LONG Tickcal() 
{
/*  Returns a system-timer calibration value,  to the nearest 
millisecond.

This  is a silly function,   since  the  number  of  elapsed  
milliseconds is passed on the stack during a  system-timer trap.
 */
}


(7) *getbpb 
BPB *Getbpb(dev) 
WORD dev;
{
/*  'dev' is a device number (0 for  drive  A,   etc.)
Returns a pointer to the BIOS Parameter Block for the specified 
drive,  or  0L if (for some reason) the BPB cannot be determined.
 */
}


(8) bcostat 
LONG Bcostat(dev) 
{
/*  'dev' is a character device number, as  in  function 1.
Returns character output status:

    -1   Device is ready to send (no waiting on 
         next device-output call).
     0   Device is not ready to send.
 */
}


(9) mediach 
LONG Mediach(dev) 
WORD dev;
{
/*  'dev' is a drive number.  Returns one of:

     0   Media definitely has not changed 
     1   Media /might/ have changed 
     2   Media definitely has changed 

GEMDOS  will respond to a return value of '1' with a read operation.
If the BIOS detects an absolute media change, it will return a
"media change" error at that time.
 */
}


(10) drvmap 
LONG Drvmap() 
{
/*  Returns a bit-vector that contains a '1' in a bit position  
(0 ..  31) when a drive is available for that bit,  or a  0 if 
there is no  drive  available for the bit.   Installable  disk 
drivers  must  correctly  maintain the  longword  '_drvbits' 
 */
}


(11) kbshift 
LONG Kbshift(mode) 
WORD mode;
{
/*  If 'mode' is non-negative,  sets  the   keyboard  shift  
bits accordingly and returns the old shift bits.   If 'mode' 
is less than zero,  returns  the IBM-PC  compatible state of 
the shift keys on the keyboard,  as a bit-vector in the  low 
byte of D0.

Bit assignments are:

     0     Right shift key 
     1     Left shift key 
     2     Control key 
     3     ALT key 
     4     Caps-lock        
     5     Right mouse button (CLR/HOME) 
     6     Left mouse button (INSERT) 
     7     (reserved, currently zero)
 */
}

     getshift 
LONG Getshift( -1) 
WORD mode;
{
/*  A dlibs extra.
kbshift with a negative parameter.
When 'mode' is less than zero,  returns the IBM-PC compatible state of
the shift keys on the keyboard,  as a bit-vector in the low by