PD HELP FILE FOR CBREEZE                         DLIBS MISC FUNCTIONS
based on dlibs v1.2 manual

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNT & SHFT & CLK   Find previous

Suggest return to menu by macro  - (,),/ - of  CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only

/*    HEADER FILES:

( ar,)    assert,  basepage,  ctype,   errno,   fcntl,
limits,   macros,  malloc,    osbind,  setjmp,  stat,
stdarg,   stddef,  stdio,     string,  time,    types,
minimum,  until,   ar,
 */


/*  MISCELLANEOUS FUNCTIONS: */

getopt,  rand,  srand,  swab,  abs,  max,
min,     swap,  assert,


/*  MEMORY MANAGEMENT: */

/*   variable  _BLKSIZ */
malloc,  calloc,  lalloc,  realloc,   free,   msize,   memavail,
alloca,  sbrk,    brk,


/*  DATE/TIME FUNCTIONS: */

time,   ctime,  localtime,  mtime,        asctime,      mktime,
stime,  utime,  clock,      start_timer,  time_since,   sleep,   usleep,


/*  SEARCHING AND SORTING: */

qsort,  hsort,  bsearch,    lsearch,      lfind,  


/*  ERROR HANDLING FUNCTIONS: */

/*   errno,  */
perror,  perrorf,  strerror,



HEADER FILES:

ar.h
/*  This header defines the library archive header used by 'ar'. */

assert.h
/*  This header defines the assert() run-time condition checking macro. */

basepage.h
/*  The BASEPAGE struct and the _base variable, which is initialized */
/*  to point to the current process basepage, are defined in this file */

ctype.h
/*  The isxxxx() macros and toxxxx() macros are define in this file. */

errno.h
/*  This file defines the error code constants, the errno variable */
/*  and related error handling functions. */

fcntl.h
/*  This file defines the O_xxxx constants used by open(). */

limits.h
/*  Various maximum and minimum values are defined by this file. */
/*  Among these are PATHSIZE and MAXINT. */

macros.h
/*  This file contains a few useful macros including min(), max(), */
/*  abs() and swap(). */

malloc.h
/*  This file is defines the return values for the dynamic memory */
/*  managment functions, malloc(), et. al. */

osbind.h
/*  Mnemonics for bios(), xbios() and gemdos() calls are defined */
/*  in this file. */

setjmp.h
/*  This file defines the buffer needed to save your context when */
/*  using setjmp()/longjmp() or catch()/throw(). */

stat.h
/*  The struct stat and the file mode flag constants are defined */
/*  in this file. */

stdarg.h
/*  This header defines the type and macros needed for variable */
/*  argument list processing. */

stddef.h
/*  This is the root header file which should be included in all */
/*  programs.  It defines dLibs, NULL, size_t, ptrdiff_t and the */
/*  offsetof() macro. */

stdio.h
/*  This header file should be present in nearly all C programs. */
/*  It contains defines the FILE struct, EOF and contains extern */
/*  declarations for standard i/o and other commonly used functions. */
/*  For convenience, the constants TRUE, FALSE and ERROR are also */
/*  defined in this file, although this is somewhat non-standard. */

string.h
/*  This file defines aliases for string function names (since some */
/*  string functions have various names on different systems) and */
/*  extern declarations for all string functions. */

time.h
/*  This file defines time related constants and structures, and */
/*  extern declarations for the time functions. */

types.h
/*  This file contains typedefs for many special and/or non-standard */
/*  type names.  Many of the typedefs in this file define type names */
/*  which are ANSI and/or System V standard.  This file is included */
/*  by several other header files, and includes <stddef.h>. */

sys\minimum.h
/*  This file contains C code for new _main() and _initargs() functions. */
/*  It is used as a non-portable hack to make very small programs when */
/*  no standard i/o or argv/argc is needed. */

sys\until.h
/*  This file is provided just for fun.  It defines macros needed to */
/*  implement a "repeat { ... } until(HELL_FREEZES_OVER);" construct. */




MISCELLANEOUS FUNCTIONS:

int getopt(int argc, char **argv, char *optstring)
{
/*  This function eases the processing of the command line.  Each call
	returns a character from <optstring>, with optarg set to a parameter
	if one is required; or a '?' indicating that an invalid option was
	found; or EOF indicating that all options have been processed.  The
	<argc> and <argv> parameters are (of course) the argc and argv values
	passed to main().  The <opstring> is a string of option characters.
	If an option takes a parameter, it is followed by a ':' in <optstring>,
	and the char *optarg variable (global) will be set to point to the
	parameter string from the command line.  For example, "bno:v" defines
	the valid option characters as 'b', 'n', 'o' and 'v', and 'o' takes
	a parameter.  All options must be preceeded (in the command line) by
	a '-' character.  A single '-' character is taken to indicate stdin
	as a file, and terminates the argument processing.  A "--" string
	indicated the end of options, and is skipped over.  When option
	processing is successfully completed, the global variable optind will
	contain the index into argv[] of the next argument to be processed.
	Subsequent arguments should be processed with a loop like this:
		while(optind < argc)
			process(argv[optind++]);
	If an error occurs during argument process, an error message is
	written to stderr and '?' is returned by getopt().  Your program
	should then give a usage message and abort.  If the global variable
	opterr is set to zero, no error message will be given, but '?' will
	still be returned.  Note that command lines accepted by getopt() are
	quite flexible.  The command lines "-b -v -o filename -- - file",
	"-vbofilename - file",  and "-ofilename -bv - file" all will return
	the 'b', 'v', and 'o' options with the parameter to 'o' set to
	"filename" and leave the arguments "-" and "file2" for further
	processing.  Please examine the sample program "echo.c" for !n
	example of getopt() usage.
 */
}
int rand()
{
/*  Return a pseudorandom number in the range 0..32767.  This
	function uses the system random number generator, but grabs
	it's value out of the middle to avoid the exactly 50%
	behavior of the lowest order bit.  Source code is also provided,
	though commented out, showing how to generate your own
	random number sequence if the system random numbers aren't
	sufficient or for porting these routines to another machine.
 */
}
void srand(unsigned int seed)
{
/*  Seed the random number generator.  This function is #defined as
	a comment, since no seeding is possible for this implementation
	of rand().
 */
}
void swab(int *src, int *dst, int n)
{
/*  Swap adjacent bytes while copying <n> bytes from <src> to <dst>.
	This allows bulk translation to/from Intel byte ordering.  Please
	note the backward order of the <src> and <dst> parameters.  Don't
	blame me... this is how Microsoft specifies it.
 */
}
 MACRO abs(x)
{
/*  Return the absolute value of <x>.  This macro evalutes it's
	argument twice.	((x)<0?(-(x)):(x))
 */
}
MACRO max(x,y)
{
/*  Return the larger of <x> and <y>.  This macro evaluates the
	larger argument twice and the smaller argument once.
 */
}
MACRO min(x,y)
{
/*  Return the smaller of <x> and <y>.  This macro evaluates the
	smaller argument twice and the larger argument once.
 */
}
MACRO swap(a,b)
{
/*  Exchange <a> and <b> by chained XORs.  The macro evaluates
	each argument several times.
 */
}
MACRO assert(condition)
{
/*  If <condition> is not true at run-time, this macro causes an
	assert failure message to be written to stderr, displaying the
	line number and source file name, and aborts the program.  If
	the symbol NDEBUG is #defined (usually with a -D option to cc),
	all assert() calls are disabled.
 */
}


MEMORY MANAGEMENT:

/*  You should include <malloc.h> in your program if you use functions */
/*  in this section. */

long _BLKSIZ = 65536;
/*  This variable controls the granularity of system memory allocation */
/*  used by malloc(), et. al.  This is the amount of memory that is */
/*  requested from the system each time a new "heap" is needed to fill */
/*  dynamic memory requests.  To help avoid a GEMDOS bug, only 16 */
/*  heaps can be active at a time.  Therefore, (16 * _BLKSIZ) defines */
/*  the maximum amount of memory which can be managed by these routines */
/*  under normal circumstances.  The exception is if any single request */
/*  for memory exceeds _BLKSIZ.  In this case, a heap will be allocated */
/*  larger than _BLKSIZ. */

#include <malloc.h>
char *malloc(unsigned int size)
{
/*  Allocate at least <size> bytes of memory.  A pointer to the
	requested block is returned, or NULL if there is not enough
	free memory available.
 */
}
#include <malloc.h>
char *calloc(unsigned int n, size_t size)
{
/*  Allocate space for an array of <n> element of <size> bytes each.
	If the storage can be allocated, it is initialized to all zero.
	NULL is returned is there is not enough free memory.
 */
}
#include <malloc.h>
char *lalloc(long size)
{
/*  Allocate at least <size> bytes of memory.  A pointer to the
	requested block is returned, or NULL if there is not enough
	free memory available.
 */
}
#include <malloc.h>
char *realloc(char *addr, unsigned int size)
{
/*  Attempt to change the memory block at <addr> to the new <size>.
	Making a block smaller will always work, but making it larger
	may fail if there is not enough free memory.  If there is not
	enough memory, NULL is returned and the block will still reside
	at <addr>.  If realloc() succeeds, a pointer to the (possibly
	moved) new block will be returned.  If <addr> is NULL, realloc()
	will simply act like malloc().  If <size> is 0, and <addr> is
	not NULL, realloc() will work like free().
 */
}
#include <malloc.h>
void free(char *addr)
{
/*  Release the memory block at <addr> back into the free memory pool.
	WARNING: Unlike some implementations, you may not realloc() a block
	which has been free()ed.
 */
}
#include <malloc.h>
long msize(char *addr)
{
/*  Return the size, in bytes, of the memory block at <addr>.  Note
	that the size is a long value, since the block may have been
	allocated by lalloc().
 */
}
#include <malloc.h>
long memavail()
{
/*  Return the size, in bytes, of the largest block of free memory
	available for allocation.  Note that this value is a long.
 */
}
#include <malloc.h>
char *alloca(unsigned int size)
{
/*  Allocate at least <size> bytes of memory from the stack.  This
	is "automatic" variable space and will be freed when the function
	which called alloca() exits.  DO NOT use the other dynamic memory
	functions like free(), realloc() and msize() on the block returned
	by this function.  A pointer to the requested block is returned,
	or NULL if there is not enough stack space available.
 */
}
#include <malloc.h>
char *sbrk(int amount)
{
/*  Move the "break" by <amount>.  The break is the line between the
	top of the heap and the bottom of the stack.  The size of the
	stack/heap area is defined by _STKSIZ.  Initially, the heap uses
	zero bytes.  Since malloc() doesn't use the heap, often the heap
	will stay that way.  This function moves the location of the break
	by <amount> bytes, positive or negative, and returns the old value
	of the break.  If this causes a collision with the stack, or a
	negative value reduces the heap below zero bytes, NULL is returned
	and the break is not moved.  Note that the heap pointer is moved by
	EXACTLY the <amount> specified.  If you want to ensure that sbrk()
	will return word-aligned memory segments, you must make sure that
	<amount> is always even, since the heap is initially aligned properly.
 */
}
#include <malloc.h>
int brk(char *address)
{
/*  Set the "break" to <address>.  Return 0 for success.  If <address>
	is not a valid break value, return -1 and don't move the break.
 */
}


DATE/TIME FUNCTIONS:

	To use the functions in this section, you must include <time.h>
	in your source file.

#include <time.h>
time_t time(time_t *rawtime)
{
/*  Get the current system clock date/time value.  Altough the value
	of this function is compatible with the ANSI proposed standard,
	on some systems (notably System V), this function returns the
	number of seconds elapsed since 00:00:00 GMT on Jan 1, 1970.
	This implementation returns an encoded date/time value instead.
	Therefore any programs which depend on this value being a number
	of seconds will not work properly.  However, other functions in
	this section which make use of the raw time value returned by
	time() are implemented to be compatible with this encoding, and
	will work properly.  In addition to returning the raw time value,
	if the <rawtime> pointer is not NULL, the value is stored in
	the time_t variable <rawtime> points to.
 */
}
#include <time.h>
char *ctime(time_t *rawtime)
{
/*  Convert <rawtime> to a string.  A 26 character fixed field string
	is created from the raw time value.  The following is an example
	of what this string might look like:
		"Wed Jul 08 18:43:07 1987\n\0"
	A 24-hour clock is used, and due to a limitation in the ST system
	clock value, only a resolution of 2 seconds is possible.  A pointer
	to the formatted string, which is held in an internal buffer, is
	returned.
 */
}
#include <time.h>
struct tm *localtime(time_t *rawtime)
{
/*  Convert <rawtime> to fill time structure fields.  A pointer to an
	internal structure is returned.  Refer to <time.h> for the values
	of the various structure fields.
 */
}
#include <time.h>
struct tm *gmtime(time_t *rawtime)
{
/*  Since there is not concept of "time zone" on the ST, this function
	returns NULL, as specified by the proposed ANSI standard.
 */
}
#include <time.h>
char *asctime(struct tm *time)
{
/*  Convert <time> structure value to a string.  The same format, and
	the same internal buffer, as for ctime() is used for this function.
 */
}
#include <time.h>
time_t mktime(struct tm *time)
{
/*  Convert <time> structure value to raw time format.
 */
}
#include <time.h>
void stime(long *rawtime)
{
/*  Set the system clock to <rawtime>.
 */
}
#include <time.h>
int utime(char *pathname, long *rawtime)
{
/*  Set the modification date of <pathname> to <rawtime>.  Returns zero
	for success, or a negative error code.
 */
}
#include <time.h>
clock_t clock()
{
/*  Returns the current value of the system clock.  The difference
	of two clock() times, divded by CLK_TCK, will give you elapsed
	seconds.
 */
}
#include <time.h>
clock_t start_timer(clock_t *t)
{
/*  Start a 200Hz timer.  This timer value can later be checked with
	time_since() to determine elapsed time.  These functions provide
	a very low-overhead way of timing events.
 */
}
#include <time.h>
clock_t time_since(clock_t *t)
{
/*  Returns the number of 200Hz ticks since start_timer() was called
	for timer <t>.
 */
}
#include <time.h>
void sleep(int dt)
{
/*  Suspend operation for <dt> seconds.  This is implemented as a
	start_timer()/time_since() tight loop waiting for the specified
	amount of time to pass.  In a multi-tasking environment, this
	function should be replaced by a call which will de-activate
	this task for a period of time, allowing other tasks to run.
 */
}
#include <time.h>
void usleep(int dt)
{
/*  Suspend operation for <dt> microseconds.  Works like sleep().
 */
}


SEARCHING AND SORTING:

void qsort(char *base, int num, int size, int (*cmp)())
{
/*  Perform a recursive quick-sort on an array starting at <base>
	containing <num> elements of <size> bytes each.  The function
	pointed to by <cmp> is used to compare elements.  Pointers to
	two items in the array are passed to the function, which must
	return a number representing their relationship as follows:
		negative	item1 < item2
		0		item1 == item2
		positive	item1 > item2
	The qsort() function requires the use of a temporary data area
	that is large enough to hold <size> bytes.  The default space
	provided is 128 bytes large.  If your record size is larger than
	128 bytes, YOU MUST provide an alternative storage area.  The
	global variable "_qbuf" points to the storage qsort() will use.
	Setting "_qbuf" to NULL restores use of the internal buffer.
	This routine is optimized to avoid N*N sort times for ordered data.
	In fact, performance on sorted or reverse-sorted data is actually
	"best case" with this algorithm, rather than "worst case" as with
	most qsort() implementations.
 */
}
void hsort(ch!r *base, int num, int size, int (*cmp)())
{
/*  Perform an N*log(N) heap-sort on an array 3tarting at <base>
	containing <num> elements of <size> bytes each.  The function
	pointed to by <cmp> is used to compare elements.  Pointers to
	two items in the array are passed to the function, which must
	return a number representing their relationship as follows:
		negative	item1 < item2
		0		item1 == item2
		positive	item1 > item2
	The hsort() function requires no extra storage, is not recursive,
	and has an almost constant N*log(N) sort time.  In the average
	case, it is about half as fast as qsort() on random data.  If
	portability is a concern, it should be noted that qsort() is
	almost always available, but hsort() is not.
 */
}
char *bsearch(char *key, char *base, int num, int size, int (*cmp)())
{
/*  Perform a binary search for <key> on the sorted data at <base>.
	<num>, <size> and <cmp> are like the corresponding parameters
	to qsort().  A pointer to the matching element is returned for
	success, or NULL for failure.  The global variable "_bsearch"
	will contain the index of either the matching element, or the
	index of the element that the <key> value should be inserted
	after.  The use of "_bsearch" is not supported by most
	implementations of bsearch().
 */
}
char *lsearch(char *key, char *base, int *num, int size, int (*cmp)())
{
/*  Perform a linear search for <key> on the data at <base>. The
	<num>, <size> and <cmp> parameters are like the corresponding
	parameters to qsort().  A pointer to the first matching element
	is returned for success, or NULL for failure.  If <key> is not
	found, it will be added to the end of the array and <num> will
	be incremented.  Note that, unlike bsearch() and qsort(), the
	<num> parameter is a POINTER to a location which holds the
	number of elements to sort.
 */
}
char *lfind(char *key, char *base, int *num, int size, int (*cmp)())
{
/*  Like lsearch(), but do not add elements which are not found.
	Note that <num> is a POINTER, even though it is not modified.
 */
}



ERROR HANDLING FUNCTIONS:

int errno;
/*  This variable is set to zero when the program is loaded.  It is
	not zeroed by any library functions, but may be set to a non-zero
	error number by many of them (particularly the standard i/o and
	system service functions).  The meaning of this error number may
	be found in the symbolic #defines in <errno.h>, or by calling the
	seterror() functions as described below.  (cf: seterror)
 */

void perror(char *msg)
{
/*  Write, to stderr, <msg> (if non-null and non-empty), followed by
	": " and a system error messaged derived from the value of errno.
 */
}
void perrorf(char *fmt[, arg1, ..., argN])
{
/*  Write, to stderr, the name of the program, followed by ": ",
	followed by a message formatted as by printf() from <fmt> and
	the optional arguments, followed by ": " and a system error
	message derived from the value of errno.  This is a non-standard
	extended version of perror().  (cf: printf, perror)
 */
}
char *strerror(errnum)
{
/*  Return the system error message for error <errnum>.  If <errnum>
	is outside the range of valid error numbers, NULL is returned.
 */
}

see also pts 1 and 3
