PD HELP FILE FOR CBREEZE                         DLIBS STRING FUNCTIONS
based on dlibs v1.2 manual

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNT & SHFT & CLK   Find previous

Suggest return to menu by macro  - (,),/ - of  CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only



/*  VARIABLE ARGUMENT LISTS: */

/*   typedef	... va_list; */
va_start,  va_arg,  va_end,


/*  STRING MANIPULATION: */

memmove,  lmemmove,  memcpy,   lmemcpy,   memset,   memcmp,
memicmp,  memccpy,   memchr,   bzero,     strlen,   strcpy,
strncpy,  strpcpy,   strdup,   strset,    strnset,  substr,
subnstr,  strcat,    strncat,  strupr,    strlwr,   strrev,
strcmp,   strncmp,   stricmp,  strnicmp,  strstr,   stristr,
strchr,   strrchr,   strpos,   strrpos,   strspn,   strcspn,
strpbrk,  strrpbrk,  strtok,   strtrim,   stradj,   strrpl,
strirpl,


/*  CHARACTER FUNCTIONS: */

toupper,  tolower,  _toupper,  _tolower,  toascii,   isalnum,
isalpha,  isascii,  iscntrl,   isdigit,   isgraph,   islower,
isprint,  ispunct,  isspace,   isupper,   isxdigit,


/*  FORMATTING/TYPE CONVERSION: */

_printf,  ltoa,     ultoa,   itoa,    atol,    atoi,
strtol,   strtoul,  _scanf,  ctlcnv,




VARIABLE ARGUMENT LISTS:

/*  The macros in this section are defined in the <stdarg.h> header file. */


typedef	... va_list;

/*  This is the type for a variable argument list traversal variable. */


#include <stdarg.h>
MACRO va_start(list, param)
{
/*  This macro initializes the va_list variable <list> to begin
	traversing variable argument lists.  <param> is the last parameter
	in the function call before the variable arguments begin.  This
	parameter MUST NOT be a register variable.
 */
}
#include <stdarg.h>
MACRO va_arg(list, type)
{
/*  This macro retrieves a variable argument of type <type>, updates
	the va_list variable <list>, and returns the value of the retrieved
	argument.  The <type> should not be parenthesised.
 */
}
#include <stdarg.h>
MACRO va_end(list)
{
/*  This macro must be called after all desired variable arguments have
	been retrieved, to reset the context of the va_list variable <list>.
 */
}

/*
STRING MANIPULATION:

	You should include <string.h> in your program if you use functions
	in this section.
 */
#include <string.h>
char *memmove(char *dest, char *source, int len)
{
/*  Copies the <source> block to the <dest>.  <len> bytes are
	always copied.  No terminator is added to <dest>.  A pointer
	to <dest> is returned.  Overlap checking IS done.
 */
}
#include <string.h>
char *lmemmove(char *dest, char *source, long len)
{
/*  Same as memmove() except a long value is used for <len>.
 */
}
#include <string.h>
char *memcpy(char *dest, char *source, int len)
{
/*  Copies the <source> block to the <dest>.  <len> bytes are
	always copied.  No terminator is added to <dest>.  A pointer
	to <dest> is returned.  Overlap checking IS NOT done.
 */
}
#include <string.h>
char *lmemcpy(char *dest, char *source, long len)
{
/*  Same as memcpy() except a long value is used for <len>.
 */
}
#include <string.h>
char *memset(char *dest, char data, int len)
{
/*  Set <len> bytes of <dest> to <data>.  A pointer to <dest>
	is returned.
 */
}
#include <string.h>
int memcmp(char *blk1, char *blk2, int len)
{
/*  Lexicographically compare the two blocks.  Return a value
	indicating the relationship between the blocks.  Possible
	return values are:
		negative	blk1 < blk2
		0		blk1 == blk2
		positive	blk1 > blk2
	<len> bytes are always compared.
 */
}
#include <string.h>
int memicmp(char *blk1, char *blk2, int len)
{
/*  Compare blocks as with memcmp(), but ignore the case of any
	alphabetic characters.
 */
}
#include <string.h>
char *memccpy(char *dst, char *src, char c, int cnt)
{
/*  Copy bytes from <src> to <dst> until either <cnt> bytes have been
	copied, or the character <c> has been copied.  If <c> is found,
	a pointer to the character following <c> in <dst> is returned, or
	NULL is <cnt> reaches 0 before <c> is found.
 */
}
#include <string.h>
char *memchr(char *buf, char c, int cnt)
{
/*  Search the first <cnt> bytes of <buf> for <c>.  Returns a pointer to
	the matching character, or NULL if not found.
 */
}
#include <string.h>
char *bzero(char *buf, int cnt)
{
/*  Zero <cnt> characters in <buf>.  Returns <buf>.
 */
}
#include <string.h>
int strlen(char *string)
{
/*  Returns the number of characters in a string, not including the
	terminating '\0'.
 */
}
#include <string.h>
char *strcpy(char *dest, char *source)
{
/*  Copies the <source> string to the <dest> including the '\0'.  A
	pointer to the start of <dest> is returned.
 */
}
#include <string.h>
char *strncpy(char *dest, char *source, int limit)
{
/*  Copies the <source> string to the <dest>.  At most, <limit>
	characters are copied.  If <source> ends before <limit> characters
	have been copied, the '\0' is copied, otherwise <dest> is not
	terminated by the copy.
 */
}
#include <string.h>
char *strpcpy(char *dest, char *start, char *stop)
{
/*  Copies characters from <start> up to <stop> into <dest>.  The
	character pointed to by <stop> is not copied, and MUST be in the
	same string as <start>.  The <dest> pointer is returned.
 */
}
#include <string.h>
char *strdup(char *string)
{
/*  Create a copy of <string> and return a pointer to the copy.
	Storage for the copy is obtained from malloc().
 */
}
#include <string.h>
char *strset(char *string, char c)
{
/*  Fill <string> with <c> up the the terminating '\0' of <string>.
 */
}
#include <string.h>
char *strnset(char *string, char c, int n)
{
/*  Fill at most <n> characters of <string> with <c>, up the the
	terminating '\0' of <string>.
 */
}
#include <string.h>
char *substr(char *dest, char *source, int start, int end)
{
/*  Copy characters from <source> to <dest> starting with character
	<start> and ending with <end>.  A pointer to <dest>, which will
	be '\0' terminated, is returned.
 */
}
#include <string.h>
char *subnstr(char *dest, char *source, int start, int length)
{
/*  Copy <length> characters from <source> to <dest> starting with
	character <start>.  A pointer to <dest>, which will be '\0'
	terminated, is returned.
 */
}
#include <string.h>
char *strcat(char *dest, char *source)
{
/*  Concatenate <source> on the end of <dest>.  The terminator of
	<dest> will be overwritten by the first character of <source>.
	The termintor from <source> will be copied.  A pointer to
	the modified <dest> is returned.
 */
}
#include <string.h>
char *strncat(char *dest, char *source, int limit)
{
/*  Concatenate <limit> characters from <source> onto <dest>.  If
	<source> contains less than <limit> characters, the length of
	source is used for <limit>.  The terminating '\0' is always
	added.  A pointer to <dest> is returned.
 */
}
#include <string.h>
char *strupr(char *string)
{
/*  Convert all alphabetic characters in <string> to upper case.
 */
}
#include <string.h>
char *strlwr(char *string)
{
/*  Convert all alphabetic characters in <string> to lower case.
 */
}
#include <string.h>
char *strrev(char *string)
{
/*  Reverse the order of the characters in <string> in place.
 */
}
#include <string.h>
int strcmp(char *str1, char *str2)
{
/*  Lexicographically compare the two strings.  Return a value
	indicating the relationship between the strings.  Possible
	return values are:
		negative	str1 < str2
		0		str1 == str2
		positive	str1 > str2
 */
}
#include <string.h>
int strncmp(char *str1, char *str2, int limit)
{
/*  Compare strings as with strcmp(), but limit comparison to the
	<limit> characters.
 */
}
#include <string.h>
int stricmp(char *str1, char *str2)
{
/*  Compare strings as with strcmp(), but ignore the case of any
	alphabetic characters.
 */
}
#include <string.h>
int strnicmp(char *str1, char *str2, int limit)
{
/*  Compare strings as with strncmp(), but ignore the case of any
	alphabetic characters.
 */
}
#include <string.h>
char *strstr(char *string, char *pattern)  {  /*  Return a pointer to the first occurance of <pattern> in <string>.
	NULL is returned if <pattern> is not found.
 */
}
#include <string.h>
char *stristr(char *string, char *pattern)
{
/*  Same as strstr(), but ignore the case of any alphabetic characters.
 */
}
#include <string.h>
char *strchr(char *string, char symbol)
{
/*  Return a pointer to the first occurance of <symbol> in <string>.
	NULL is returned if <symbol> is not found.  '\0' is included in
	the search.
 */
}
#include <string.h>
char *strrchr(char *string, char symbol)
{
/*  Return a pointer to the last occurance of <symbol> in <string>.
	NULL is returned if <symbol> is not found.  '\0' is included in
	the search.
 */
}
#include <string.h>
int strpos(char *string, char symbol)
{
/*  Return the index of the first occurance of <symbol> in <string>.
	-1 is returned if <symbol> is not found.
 */
}
#include <string.h>
int strrpos(char *string, char symbol)
{
/*  Return the index of the last occurance of <symbol> in <string>.
	-1 is returned if <symbol> is not found.
 */
}
#include <string.h>
int strspn(char *string, char *set)
{
/*  Return the length of the sub-string of <string> that consists
	entirely of characters found in <set>.  The terminating '\0'
	in <set> is not considered part of the match set.  If the first
	character if <string> is not in <set>, 0 is returned.
 */
}
#include <string.h>
int strcspn(char *string, char *set)
{
/*  Return the length of the sub-string of <string> that consists
	entirel9 of characters not found in <set>.  The terminating '\0'
	in <set> is not considered part of the match set.  If the first
	character if <string> is in <set>, 0 is returned.
 */
}
#include <string.h>
char *strpbrk(char *string, char *set)
{
/*  Return a pointer to the first occurance in <string> of any
	character in <set>.
 */
}
#include <string.h>
char *strrpbrk(char *string, char *set)
{
/*  Return a pointer to the last occurance in <string> of any
	character in <set>.
 */
}
#include <string.h>
char *strtok(char *string, char *delim)
{
/*  Return a token from <string>.  If <string> is not NULL, it is
	the beginning of a string from which tokens are to be extracted.
	Characters found in <delim> are skipped over to find the start
	of a token, characters are then accumulated until a character in
	<delim> is found, or the terminator of <string> is reached.
	A pointer to the '\0' terminated token is then returned.  Note
	that this function modifies <string> (by inserting '\0's) in
	the process.  Subsequent calls to strtok() may specify NULL as
	the <string> argument, in which case subsequent tokens are
	returned, or NULL if there are no more tokens.
 */
}
#include <string.h>
char *strtrim(char *string, char *junk)
{
/*  Remove leading and trailing characters found in <junk>
	from <string>.  Return a pointer to the modified <string>.
 */
}
#include <string.h>
char *stradj(char *string, int dir)
{
/*  Adjust <string> by adding space if <dir> is positive, or removing
	space if <dir> is negative.  The magnitude of <dir> is the number
	of character positions to add or remove.  Characters are added or
	removed at the beginning of <string>.  A pointer to the modified
	<string> is returned.
 */
}
#include <string.h>
int strrpl(char *string, char *ptrn, char *rpl, int n)
{
/*  Replace at most <n> occurances of <ptrn> in <string> with <rpl>.
	If <n> is -1, replace all.  Return the number of replacments.
 */
}
#include <string.h>
int strirpl(char *string, char *ptrn, char *rpl, int n)
{
/*  Same as strrpl() except ignore the case of alphabetic characters.
 */
}

/*
CHARACTER FUNCTIONS:

	To use the functions in this section, you must include <ctype.h>
	in your source file.  Please note that the isxxxx() functions,
	except isascii(), only have defined results if isascii() is true.
	(ie. they only work properly on values 0x00 through 0x7F)
 */
#include <ctype.h>
int toupper(int c)
{
/*  Convert <c> to upper case, if alphabetic.  This is implemeted
	as a macro and also as a function.  You may force use of the
	function version rather than the macro (which evaluates its
	argument twice) by using the "#undef toupper" directive.
 */
}
#include <ctype.h>
int tolower(int c)
{
/*  Convert <c> to lower case, if alphabetic.  This is implemeted
	as a macro and also as a function.  You may force use of the
	function version rather than the macro (which evaluates its
	argument twice) by using the "#undef tolower" directive.
 */
}
#include <ctype.h>
MACRO _toupper(int c)
{
/*  This macro should be used only if <c> is known to be lower case.
	It converts <c> to upper case.  Results are undefined if converting
	a character which is not lower case.
 */
}
#include <ctype.h>
MACRO _tolower(int c)
{
/*  This macro should be used only if <c> is known to be upper case.
	It converts <c> to lower case.  Results are undefined if converting
	a character which is not upper case.
 */
}
#include <ctype.h>
MACRO toascii(int c)
{
/*  Convert <c> to 7-bit ascii, putting it into the range 0x00..0x7F.
 */
}
#include <ctype.h>
MACRO isalnum(int c)
{
/*  Return non-zero if <c> is '0'..'9','A'..'Z','a'..'z'.
 */
}
#include <ctype.h>
MACRO isalpha(int c)
{
/*  Return non-zero if <c> is 'A'..'Z','a'..'z'.
 */
}
#include <ctype.h>
MACRO isascii(int c)
{
/*  Return non-zero if <c> is 0x00..0x7F.
 */
}
#include <ctype.h>
MACRO iscntrl(int c)
{
/*  Return non-zero if <c> is 0x00..0x1F,0x7F.
 */
}
#include <ctype.h>
MACRO isdigit(int c)
{
/*  Return non-zero if <c> is '0'..'9'.
 */
}
#include <ctype.h>
MACRO isgraph(int c)
{
/*  Return non-zero if <c> is 0x21..0x7E.
 */
}
#include <ctype.h>
MACRO islower(int c)
{
/*  Return non-zero if <c> is 'a'..'z'.
 */
}
#include <ctype.h>
MACRO isprint(int c)
{
/*  Return non-zero if <c> is 0x20..0x7E.
 */
}
#include <ctype.h>
MACRO ispunct(int c)
{
/*  Return non-zero if <c> is not iscntrl(), isalnum() or isspace().
 */
}
#include <ctype.h>
MACRO isspace(int c)
{
/*  Return non-zero if <c> is 0x09..0x0D,0x20.
 */
}
#include <ctype.h>
MACRO isupper(int c)
{
/*  Return non-zero if <c> is 'A'..'Z'.
 */
}
#include <ctype.h>
MACRO isxdigit(int c)
{
/*  Return non-zero if <c> is '0'..'9','A'..'F','a'..'f'.
 */
}



/*
FORMATTING/TYPE CONVERSION:
 */
int _printf(char *op, int (*put)(), char *fmt, int *args)
{
/*  This function does all the work for printf(), et al.  Many systems
	don't provide direct access to this function (or it's equivalent),
	but it is useful for writing your own printf()-like functions.
	Since this is a non-standard interface, and v[sf]print() is now
	available, you should probably use the stdarg functions instead.
	<fmt> points to a format control string.  <args> pointers to a
	list of arguments.  The format string is used to create and output
	stream with the arguments.  The <put> function is used to output
	each character.  The <op> parameter is given to the <put> function
	to specify the output stream.  Calls to <put> are of the form:
	"(*put)(c, op);" where <c> is the character to output.  The format
	string is composed of characters and format specifications.  The
	'%' character introduces a format specifier.  The general form of
	a format specifier is:
	  %[-][ |+][0][<width>|*][.[<precision>|*]][l]{d|i|u|o|x|p|b|c|s
	The '-' specifies left justification.  The ' ' or '+' specifies
	the character which preceeds positive numeric values.  The '0'
	specifies that numeric fields will be padded with '0' rather than
	' '.  The <width> field is a numeric value specifying a minimum
	field width.  The <precision> field is a numeric value specifying
	the maximum number of data characters to display.  If '*' is
	specified for the width or the precision, an "int" value is taken
	from the argument list and used for that value.  If no width is
	specified, the field width varies according to the data width.  If
	no precision is specified, all data characters are included in the
	data width.  If the data width exceeds the field width, the field
	width will expand to allow all data characters to be printed.
	Including the 'l' or capitalizing the trailing character specifies
	that the associated value is a "long" type.  The trailing character
	specifies the format type, as follows:
		d	Signed decimal integer
		i	same as 'd'
		u	Unsigned decimal integer
		o	Unsigned octal integer
		x	Unsigned hexadecimal integer
		b	Unsigned binary integer
		p	Pointer (displayed in %06.8lX format)
		c	Character
		s	String
	If the character following the '%' is not recognized, it is
	simply passed along to the output stream, thus "%%" is used to
	print a single '%' character
 */
}



char *ltoa(long n, char *buffer, int radix)
{
/*  Convert the long value <n> to a string in <buf> using <radix>
	as the number base.  If <n> is negative, '-' will be the first
	character in <buf>.  A pointer to <buf> is returned.
 */
 */
}
char *ultoa(unsigned long n, char *buffer, int radix)
{
/*  Convert the unsigned long value <n> to a string in <buf> using
	<radix>	as the number base.  A pointer to <buf> is returned.
 */
}
char *itoa(int n, char *buffer, int radix)
{
/*  Convert the integer value <n> to a string in <buf> using <radix>
	as the number base.  If <n> is negative, '-' will be the first
	character in <buf>.  A pointer to <buf> is returned.
 */
}
long atol(char *number)
{
/*  Convert the string <number> to a long value.  Leading whitespace
	is ignored, a leading +/- is optional.  Characters are processed
	until a non-digit is reached.  Return value is undefined in an
	overflow situation.
 */
}
int atoi(char *number)
{
/*  Convert the string <number> to an int value.  Leading whitespace
	is ignored, a leading +/- is optional.  Characters are processed
	until a non-digit is reached.  Return value is undefined in an
	overflow situation.
 */
}
long strtol(char *number, char **nptr, int base) 
{
/*  Convert the string <number> to a long value of base <base>.  Bases
	from 0 to 36 are allowed.  Leading whitespace is ignored, and a
	leading +/- is optional.  If the <base> is 0, a leading '0'
	indicates base 8 and a leading "0x" or "0X" indicates base 16.
	Characters are processed until a character is found which is not in
	the specified base.  If <nptr> is non-NULL, it will be set to point
	to the character which terminated the translation in <number>.
	Return value is undefined in an overflow situation.
 */
}
unsigned long strtoul(char *number, char **nptr, int base)
{
/*  Convert the string <number> to an unsigned long value of base
	<base>.  Bases from 0 to 36 are allowed.  Leading whitespace is
	ignored.  If the <base> is 0, a leading '0' indicates base 8 and a
	leading "0x" or "0X" indicates base 16.  Characters are processed
	until a character is found which is not in the specified base.  If
	<nptr> is non-NULL, it will be set to point to the character which
	terminated the translation in <number>.  Return value is undefined
	in an overflow situation.
 */
}
int _scanf(char *ip, int (*get)(), int (*unget)(), char *fmt, char **args)
{
/*  This function does all the work for scanf(), et al.  Many systems
	don't provide direct access to this function (or it's equivalent),
	but it is useful for writing your own scanf()-like functions.
	<fmt> points to a format control string.  <args> pointers to a
	list of arguments, each of which is the address of a variable in
	which input data may be stored.  The format string is used to
	control reading of characters from the <get> function.  As each
	character is needed <get> is called in the form "c = (*get)(ip);"
	where <c> is the character read (negative for errors) and <ip> is
	the auxiliary pointer specified by the <ip> parameter.  If a
	character needs to be un-gotten, a call to <unget> of the form
	"(*unget)(c, ip);" is made.  The format string is composed of
	characters and format specifications.  Any characters in <fmt>,
	except whitespace characters, which are not part of a format
	specifier are expected to be matched one-to-one by characters in
	the input stream.  Scanning terminates if a mismatch occurs or if
	any call to <get> results in an error.  Whitespace characters
	match 0 or more whitespace characters in the input stream.  The
	'%' character introduces a format specifier.  The general form of
	a format specifier is:
		  
		  %[*][<width>][l|h]{d|u|o|x|b|i|c|s
	The '*' specifies that a field is to be scanned by not stored.
	No variable pointer should be provided for non-stored format
	specs.  The <width> field specifies that maximum number of
	characters to be process to fill the given format type.  Less
	than <width> characters will be processed if the field ends
	before <width> characters have been processed.  A field ends when
	either a whitespace character, or a character which does not fit
	the specified format, is read.  The preceding 'l' (or
	capitalizing the conversion character) specifies that the
	associated variable is a "long" type.  The trailing character
	specifies the format type, as follows:
		d Signed decimal integer
		u Unsigned decimal integer
		o Unsigned octal integer
		x Unsigned hexadecimal integer
		b Unsigned binary integer
		i Unsigned decimal/octal/hexadecimal/binary integer
		c Character
		s String
	If a <width> is specified with the 'c' format, exactly <width>
	characters (including whitespace) are read from the input stream,
	and written to a string.  No '\0' character is added If the
	character following the '%' is not recognized, it is expected to
	match the input stream as a non-format character, thus "%%" is
	used to match a single '%' character.
	One additional conversion is the brace-format.  Shown as "%[...]",
	the '...' represent a list of characters.  If the first character
	in the list is a '^', the field contains any characters -not- in
	the list (starting with the 1st character after the '^').  If the
	first character of the list is not a '^', then the field will
	only contain those characters found in the list.  A right brace 
	character (']') can be included as one of the list of characters
	by placing it as the first character in the list.  If the '^'
	negation character is the first character, the included brace
	should be the next character after the '^'.  For maximum
	portability, a range should be explicitly given (a good example
	would be "%[0123456789]"), but to allow for porting from
	systems with smarter scanf functions, this version of scanf
	also supports ranges represented using a <first>-<last>
	form (eg: "%[0-9]").  To use the first-last form, the
	character <first> must be lexically less than or equal to
	the character <last>.  If this rule is violated, or if the
	hyphen is the first or last character of the list, the
	hyphen will be assumed to be just another character in the
	list and no range expansion will be done.  The resulting
	string containing the characters in (or not in) the list
	will be null terminated.  It should be noted that, unlike
	most of the other formats, this conversion does allow the
	programmer to specify that whitespace characters will be
	included in the resulting string.
 */
}
char *ctlcnv(char *string)
{
/*  Convert \<char> notation in <string> to actual characters.  This
	is useful for reading strings from a stream when you want to allow
	insertion of control character or other characters that may have
	special meaning otherwise, or may not otherwise be allowed.  The
	following formats are supported:
		\n		newline or linefeed
		\r		carriage return
		\0		null character ( value 0 )
		\b		backspace
		\t		horizontal tab
		\v		vertical tab
		\f		form feed
		\a		alarm (bell)
		\\		backslash
		\'		single quote
		\"		double quote
		\NNN		octal constant
		\xNN		hexadecimal constant
		\<nl>		"folded" line ( both characters removed )
	A pointer to the modified <string> is returned.
 */
}



----- REVISION RECORD -----

This is an attempt to record changes to dLibs from past versions.
I make no promises about it's completeness.

v1.2
	October 1988.

	This release corresponds to the release of the Sozobon C
	compiler for the ST, and includes quite a bit of general code
	cleanup as dictated by the stricter (and more correct)
	requirements of the Sozobon compiler.  This code IS still
	compatible with Alcyon C, but now it is also compatible
	with Sozobon C.

	This release fixes many bugs, most minor, some major.  Some
	of the functions that were improved are:  mktime(), stime(),
	strtrim(), ctlcnv(), realloc(), fullpath(), findfile(),
	lsearch(), tell(), putenv(), exec(), _initargs(), main(),
	qsort(), memccpy() and swab().

	The header files were somewhat restuctured, and <stddef.h> and
	<stdarg.h> were added, for more ANSI X3J11 compatibility.  Also
	<sys\minimum.h> was added as a non-portable hack to make very
	small programs when no standard i/o or argv/argc is needed.

	The blkXXX() functions have now all been renames to their X3J11
	memXXX() names and some were recoded in assembly language.

	The stream i/o functions were overhauled, resulting in changes
	to the FILE structure and nearly all associated functions.  The
	new functions handle interactive i/o with the console much more
	nicely, emulating (partly) a tty driver which gives essentially
	line-oriented operation for standard input on a character device.
	You can now backspace to edit, ^U to retype a line, and ^C to
	interrupt a program (sorry, only during input) and none of these
	characters will appear in the input read by the program.  Since
	there is never agreement about how such a driver should work, all
	the code is encapsulated in the _tttty() function, which is in
	a separate object module.

	The pfindfile() function now has a path parameter, but the PATH
	environment variable will still be used if NULL is specified.
	The wildcard() function has also changed slightly in that is
	no longer expands the filenames with fullpath().

	Some new functions in this release are: mktime(), usleep(),
	alloca(), _splitpath(), _makepath(), bzero(), memcpy(), lmemcpy(),
	strpcpy(), strtol(), strtoul(), perror(), perrorf(), strerror(),
	fgetpos(), fsetpos(), vprintf(), vfprintf(), vsprintf() and getopt().

v1.1
	December 1987.

	Process control functions, spawn(), spawne(), spawnp() and
	spawnpe() removed.  New functions forkl(), forklp(), forkle(),
	forklpe(), forkv(), forkvp(), forkve(), forkvpe() and wait()
	now handle creation of child processes.

	XARG format extended argument passing is supported by all the
	process control functions and _initargs().

	Many functions which were previously #defined in <stdio.h> to
	gemdos() calls are now real functions.  This allows you to pass
	the address of these functions in function pointer.

	Added brk() and sbrk() functions for managing the heap.  This
	is not typically a good way to allocate memory.  The normal
	malloc() functions are much better in most cases.

	printf() and scanf() now process capital format characters.
	This feature is provided to support old programs which use
	capital characters to indicate long values.  It is NOT*
	recommended for use in current code and is not supported
	by the ANSI proposed standard.  The scanf() function has
	been upgraded to support hyphenated ranges and returns what
	we think are correct values for various end-cases like end-
	of-input and early format conflicts.

	findfile() and pfindfile() have been improved and fopenp()
	had been added to support use of the PATH.  The extension
	list given for findfile() and pfindfile() has been changed
	slightly.  You must now include the '.' portion of the
	%xtension.  This is to allow searching for the empty extension.

	The header files have been changed and extended to conform
	more closely to ANSI and Unix System V.  As a result, some
	of the structures and actual values for certain flags have
	changed.  The stat structure and related functions like
	access(), stat(), creat(), open(), etc. have been significantly
	changed in implementation.  The open() function supports
	many more mode flags like O_CREAT, O_APPEND, O_TRUNC and O_EXCL.

	A few new functions like swab(), tmpnam(), tempnam(), getcwd()
	and wildcard() have been added.  Only wildcard() is non-standard,
	but I think it's useful to have around.  

v1.0
	Original release.  October 1987.

----- END OF FILE -----
