PD HELP FILE FOR CBREEZE                         DLIBS FILE FUNCTIONS
based on dlibs v1.2 manual

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNT & SHFT & CLK   Find previous

Suggest return to menu by macro  - (,),/ - of  CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only

/*  INPUT/OUTPUT FUNCTIONS: */

read,      lread,       write,     lwrite,    fread,     fwrite,
getc,      fgetc,       ungetc,    fungetc,   putc,      fputc,
fflush,    getw,        putw,      getl,      putl,      getch,
getchar,   ungetchar,   putchar,   cfg_ch,    getche,    putch,
kbhit,     getln,       gets,      puts,      fgets,     fputs,
cputs,     printf,      fprintf,   sprintf,   cprintf,   vfprintf,
vprintf,   vsprintf,    scanf,     fscanf,    sscanf,    _tttty,


/*  FILE HANDLING: */

chdir,      mkdir,      rmdir,      fullpath,    getcwd,      access,
findfile,   pfindfile,  wildcard,   _splitpath,  _makepath,   tmpnam,
tempnam,    stat,       fsize,      isatty,      creat,       chmod,
open,       close,      dup,        dup2,        remove,      rename,
lseek,      tell,       fopen,      freopen,     fdopen,      fopenp,
fclose,     setbuf,     setvbuf,    fseek,       rewind,      ftell,
fgetpos,    fsetpos,    fileno,     feof,        ferror,      clearerr,
sync,




INPUT/OUTPUT FUNCTIONS:

int read(int h, char *data, int length)
{
/*  Read <length> bytes from the file reference by file handle <h>.
	Data is stored in the buffer pointed to by <data>.  The number
	of bytes actually read is returned, 0 for end of file, or a
	negative error code.  Note that the maximum number of bytes
	that can be read by this function is MAXINT.
 */
}
long lread(int h, char *data, long length)
{
/*  Same as read(), but uses a long value for number of bytes to read.
 */
}
int write(int h, char *data, int length)
{
/*  Write <length> bytes to the file reference by file handle <h>.
	Data is written from the buffer pointed to by <data>.  The number
	of bytes actually written is returned, or a negative error code.
	Note that the maximum number of bytes that can be written by
	this function is MAXINT.
 */
}
long lwrite(int h, char *data, long length)
{
/*  Same as write(), but uses a long value for number of bytes to write.
 */
}
int fread(char *data, int size, int count, FILE *fp)
{
/*  Read <count> items of <size> characters each from stream <fp>.
	Data is stored in the buffer pointed to by <data>.  The number of
	full items actually read is returned, or a negative error code.
	This call DOES NOT translate characters, even if the stream is
	opened in translate mode.
 */
}
int fwrite(char *data, int size, int count, FILE *fp)
{
/*  Write <count> items of <size> characters each to stream <fp>.
	Data is read from the buffer pointed to by <data>.  The number of
	full items actually written is returned, or a negative error code.
	This call DOES NOT translate characters, even if the stream is
	opened in translate mode.
 */
}
int getc(FILE *fp)
{
/*  Same as fgetc() but implemented as a macro.
 */
}
int fgetc(FILE *fp)
{
/*  Get a character from <fp>.  Returns the character or EOF.
 */
}
int ungetc(char c, FILE *fp)
{
/*  Same as fungetc() but implemented as a macro.
 */
}
int fungetc(char c, FILE *fp)
{
/*  Push the character <c> back to be gotten by the next fgetc()
	call on <fp>.  Only 1 character may be ungotten at a time on
	each stream.  Subsequent calls to fungetc() will write over
	the currently saved character.
 */
}
int putc(char c, FILE *fp)
{
/*  Same as fputc() but implemented as a macro.
 */
}
int fputc(char c, FILE *fp)
{
/*  Put the character <c> to the stream <fp>.
 */
}
int fflush(FILE *fp)
{
/*  Flush the file i/o buffer of the stream <fp>.  The buffer is
	automatically flushed when it is full, the stream is closed,
	or the program terminates through exit().  This function has
	no effect if the stream in unbuffered.  Call this function
	before switching between reading and writing on a stream which
	is opened for both.
 */
}
int getw(FILE *fp)
{
/*  Get a 2-byte value from the stream <fp>.  The high-order byte is
	read first.  Use feof() to test for end-of-file.
 */
}
int putw(int n, FILE *fp)
{
/*  Put the 2-byte value <n> to the stream <fp>.  The high-order byte
	is written first.
 */
}
int getl(FILE *fp)
{
/*  Get a 4-byte value from the stream <fp>.  The high-order byte is
	read first.  Use feof() to test for end-of-file.
 */
}
int putl(long n, FILE *fp)
{
/*  Put the 4-byte value <n> to the stream <fp>.  The high-order byte
	is written first.
 */
}
int getch()
{
/*  Machine dependent console input function.  This function normally
	gets a character from the keyboard by calling the GEMDOS "Cconin"
	function.  If cfg_ch() is given the _CIOB option, input is gotten
	from the BIOS "Bconin" function instead.  The BIOS level functions
	don't process ^C, ^S or ^Q, while the GEMDOS functions do.  The
	most common use for getch() is when keyboard scan codes are needed
	to process special function keys.  The return value from getch()
	consists of the scan code in the high-order byte, and the ascii
	character code in the low-order byte.  If cfg_ch() is given the
	_CIOCH option, the return value is always an 8-bit quantity,
	either the scan code with the 8th bit set, or the ascii code with
	the 8th bit clear.  This is somewhat less informative, since the
	scan code form is returned only if the ascii value is 0, but is the
	default configuration value for compatability with Microsoft C.
	In any case, the global unsigned long variable "_getch" will contain
	the full character code value returned by the OS.
 */
}
int getchar()
{
/*  Same as "fgetc(stdin)".
 */
}
int ungetchar(char c)
{
/*  Same as "fungetc(c, stdin)".  Note that this name will conflict
	with any function beginning "ungetch..." due to having only 7
	significant characters in external identifiers.
 */
}
int putchar(char c)
{
/*  Same as "fputc(c, stdin)".
 */
}
int cfg_ch(int cfg)
{
/*  Configure getch()/putch() operation.  The following are legal
	values for <cfg> and may be combined with the | operator:
		_CIOB		Use BIOS level i/o calls
		_CIOCH		8-bit character codes only (cf:getch)
		_CIOVT		Enable VT-52 escape sequence proc%ssing
	The initial configuration value at run time is _CIOCH.  This
	function returns the previous configuration value, and if <cfg>
	is -1 the value is not set.
 */
}
int getche()
{
/*  Same as getch() but calls putch() to echo the character.
 */
}
char putch(char c)
{
/*  Machine dependent (typically quite fast) console output function.
	This function normally puts a character to the console by calling
	the GEMDOS "Cconout" function.  If cfg_ch() is given the _CIOB
	option, output is sent to the BIOS "Bconout" function instead.
	The BIOS level functions don't process ^C, ^S or ^Q, while the
	GEMDOS functions do.  At the BIOS level, the _CIOVT option to
	cfg_ch() allows VT-52 escape code processing on output.  The
	GEMDOS function always does VT-52 emulation.  The BIOS function
	defaults to skipping this overhead, but if VT-52 emulation is
	desired, it can still be used through the faster BIOS level
	routine	by using the _CIOVT option.  Control codes, like '\b'
	and '\r', are supported even without VT-52 emulation.  The return
	value of this function is simply the character sent.
 */
}
int kbhit()
{
/*  Machine dependent function to detect if input is waiting for the
	getch() function.  Returns non-zero if the console has data ready.
 */
}
char *getln(char *ip, int (*get)(), int (*put)(), char *buffer, int limit)
{
/*  Get a line of input from the user.  Allow simple editing of the line
	with BS/DEL, ESC, and CR/LF to terminate input.  Characters are
	retreived by a (*get)(ip) and echoed with (*put)(c).  A pointer to
	<buffer> is returned in any case.  This function is no longer
	needed to handle editable i/o from stdin, since the pseduo-tty
	driver code built into fgetc() now handles line editing, but this
	function is still useful if you want to supply your own get/put
	functions (like curses?).
 */
}
char *gets(char *data)
{
/*  Get data from stdin and puts it in the <data> buffer.  Input is
	terminated when a newline is read.  The	newline will be replaced
	by a '\0' to terminate the string.  A backspace character will
	remove the preceeding character from the buffer, but will not
	backspace past the start of the buffer.  A pointer to the start
	of <data> is returned, or NULL for EOF.
 */
}
void puts(char *data)
{
/*  Write the characters in <data> to stdout.  A newline WILL be
	written after the data.
 */
}
char *fgets(char *data, int limit, FILE *fp)
{
/*  Get data from <fp> and puts it in the <data> buffer.  At most,
	<limit>-1 characters will be read.  Input will also be terminated
	when a newline is read.  <data> will be '\0' terminated and the
	newline, if read, will be included.  A pointer to the start of
	<data> is returned, or NULL for EOF.
 */
}
void fputs(char *data, FILE *fp)
{
/*  Write the characters in <data> to the stream <fp>.  A newline
	WILL NOT be added.
 */
}
void cputs(char *data)
{
/*  Write the characters in <data> directly to the console using the
	system dependent putch() function.  A newline WILL NOT be written
	after the data.
 */
}
int printf(char *fmt[, arg1, ..., argN])
{
/*  Formatted output to the stdout stream.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int fprintf(FILE *fp, char *fmt[, arg1, ..., argN])
{
/*  Formatted output to the stream <fp>.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int sprintf(char *buf, *fmt[, arg1, ..., argN])
{
/*  Formatted output to the string <buf>.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int cprintf(char *fmt[, arg1, ..., argN])
{
/*  Formatted output directly to the console.  This functions uses the
	system dependent putch() for output.  See the _printf() function
	for a description of the <fmt> formatting string.
 */
}
int vfprintf(FILE *fp, char *fmt, va_list ap)
{
/*  Formatted output to the stream <fp> with a variable argument list.
	See _printf() for formatting and va_start() for stdarg explaination.
 */
}
int vprintf(FILE *fp, va_list ap)
{
/*  Formatted output to the stdout stream with a variable argument list.
	See _printf() for formatting and va_start() for stdarg explaination.
 */
}
int vsprintf(char *buf, *fmt, va_list ap)
{
/*  Formatted outout to the string <buf> with a variable argument list.
	See _printf() for formatting and va_start() for stdarg explaination.
 */
}
int scanf(char *fmt[, arg1, ..., argN])
{
/*  Formatted input from the stdin stream.  See the _scanf() function
	for a description of the <fmt> formatting string.
 */
}
int fscanf(FILE *fp, char *fmt[, arg1, ..., argN])
{
/*  Formatted input from the stream <fp>.  See the _scanf() function
	for a description of the <fmt> formatting string.
 */
}
int sscanf(char *buf, *fmt[, arg1, ..., argN])
{
/*  Formatted input from the string <s>.  See the _scanf() function
	for a description of the <fmt> formatting string.
 */
}
int _tttty(FILE *fp)
{
/*  "Teeny Tiny TTY" driver function.  This function is internal to
	dLibs, but it's name is documented to allow you to replace it with
	a tty driver of your own.  It's operation can be best understood
	by reading and UNDERSTANDING the code in the routine provided.  In
	brief, this function is supposed to read from <fp>, up to a newline
	character, putting the character in the FILE buffer, and return the
	number of characters read (similar to _fillbuf() in some systems).
	If the stream is in binary mode, a full buffer is to be read, with
	no translation.  If the stream is unbuffered, characters are also
	untranslated, but ^C on input is checked for, however, the code
	which calls this function will translate carriage return characters
	into newlines and ^Z will cause EOF.  Effectively, this means that
	line editing is not allowed if the stream in unbuffered, but most
	translation is done.  Note that this mode of operation is the least
	likely to produce unix-like results, particularly in the way some
	control characters are echoed.  It is recommended that either binary
	mode, or buffered and translated mode be used.
 */
}



FILE HANDLING:

int chdir(char *pathname)
{
/*  Changes the current working directory to <pathname>.  If a
	drive letter is specified in <pathname>, the current working
	directory for that drive is set.  Returns 0 for success, or
	a negative error code.
 */
}
int mkdir(char *pathname)
{
/*  Creates a new directory called <pathname>.  A drive letter may
	be specified.  Returns 0 for success, or a negative error code.
 */
}
int rmdir(char *pathname)
{
/*  Removes an existing directory called <pathname>.  A drive letter may
	be specified.  Returns 0 for success, or a negative error code.
 */
}
char *fullpath(char *full, *part)
{
/*  <part> is a (possibly) ambiguous file/path specification.  A
	non-ambiguous file/path spec is created which includes a drive
	letter and all intermediate sub-directories.  If the partial
	specification is not valid, NULL is returned, otherwise a
	pointer to <full> is returned.  If NULL is specified for <full>,
	an internal buffer is used and a pointer to it is returned.
 */
}
char *getcwd(char *buffer, int size)
{
/*  Get the full pathname of the current working directory.  This
	value will ALWAYS end with a '\\' character.  <pathbuf> is a
	pointer to a buffer of <size> bytes that will be used to store
	the current working directory.  If <buffer> is NULL, a buffer
	of <size> bytes will be malloc()ed.  The function returns a
	pointer to the buffer for success, or NULL for failure, either
	because malloc() failed, or the value is larger than <size>.
	This function uses fullpath() to get the pathname, therefore
	the buffer internal to fullpath() is overwritten.
 */
}
int access(char *name, int amode)
{
/*  Return non-zero if a file with the given <name> can be accessed
	in the given <amode>.  Possible <amode> values are:
		0x00		file exists
		0x02		file can be written
		0x04		file can be read
		0x06		file can be read and written
 */
}
char *findfile(char *afn[, *ext])
{
/*  Return full file spec for <afn> if found. If <afn> has no extension,
	extensions from <ext> are tried until a match is found, or the list
	ends.  <ext> is a list of extensions separated by '\0' characters
	and ending with an additional '\0', ie. ".ttp\0.tos\0.prg\0" (note
	that the final null is added by the compiler to any string constant.
	If <afn> already has an extension, <ext> is not used.  If no matching
	files are found, NULL is returned.  The pointer returned when a match
	is found points to a buffer which is internal to fullpath().  If you
	want to save the value returned, you must make a copy before the
	buffer is overwritten by subsequent calls.  Note: several dLibs
	functions call filefind(), so don't make too many assumptions about
	how long the internal buffer is going to stay valid.
 */
}
char *pfindfile(char *path, *afn[, *ext])
{
/*  Like findfile() but search all directories (separated by ',' or ';')
	in <path>.  If <path> is NULL, the "PATH" environment variable is
	used instead.  If <afn> specifies a drive or directory, <path> is
	not used.  The internal buffer for findfile() is used by pfindfile().
 */
}
char *wildcard(char *pathname)
{
/*  Return matches for a wildcard filename.  If <pathname> is not
	NULL, the first file which matches <pathname> will be returned.
	The <pathname> may contain wildcards only in the filename portion,
	not in any sub-directories.  Subsequent calls to wildcard() with
	a NULL argument return the next matching filename.  NULL is
	returned when no more files match.  Note: the pointer returned
	points to an internal buffer which is overwritten with each
	call.  It should not be modified, and should be copied into a
	safe place if you want to save the value.
 */
}
char *_splitpath(char *src, *drive, *path, *file, *ext)
{
/*  Parse the <src> filename into component parts. Returns <src>.
	If any of the component pointers is NULL, that component will
	be parsed, but not saved.  If a given component does not exists
	int the <src> string, the component will be empty, (ie.: "").
	The <drive> component will be a drive letter followed by a colon,
	(ie.: "a:").  The <path> component will be the subdirectory names
	leading up to the filename, but will not include a trailing '\'
	unless the path the simply the root path "\", and there will only
	be a leading '\' if the path is fully qualified, or "rooted", ie.:
	"\this\is\a\path\name".  The <file> component is the base filename
	without any extension, ie.: "filename".  The <ext> component is
	the file extention with no leading '.', ie.: "txt".  Recommended
	sizes for the components is Drive[4], Path[128], File[10], Ext[4].
 */
}
char *_makepath(char *dst, *drive, *path, *file, *ext)
{
/*  Build the <dst> filename from component parts. Returns <dst>.
	This function is basically in inverse of _splitpath(), and will
	accept the components parsed by _splitpath() as input.  It will
	also allow a little more flexibility in that it will treat any
	component which is a NULL pointer as an empty field, and the
	<path> component may optionally have a trailing '\'.
 */
}
char *tmpnam(char *s)
{
/*  Generate a unique filename to be used for a temporary file.
	The filename will have the form "TEMP$nnn.TMP" where "nnn" is a
	sequence of numeric digits.  The name will unique in the current
	working directory.  If <s> is NULL, space will be obtained from
	malloc() to store the filename and thus must be free()'d by the
	caller.  If <s> is not NULL, the filename will be copied into the
	buffer provided.  This function returns NULL for failure, or a
	pointer to the filename for success.
 */
}
char *tempnam(char *dir, *pfx)
{
/*  This function is similar to tmpnam(), but is somewhat more flexible.
	<dir> specifies the directory part of the filename.  If <dir> is
	NULL, the TMPDIR environment variable will be used.  If TMPDIR is
	not found, the current directory is used.  <pfx> specifies the
	filename prefix (up to 5 characters).  The form of the filename
	will be "dir\pfxnnn.TMP", similar to tmpnam().  The storage for
	the filename is always obtained from malloc(), so the caller must
	free() it after use.  This function returns NULL for failure, or a
	pointer to the fully expanded filename for success.
 */
}
int stat(char *name, struct stat *statbuf)
{
/*  Search for file <name> and load <statbuf> with information
	about that file, if it is found.  Return 0 if found, or
	ERROR (-1) if no file/directory matched <name>.  Volume
	labels are not included in the search.  The file <stat.h>
	must be included if you 5se this functions, since it defines
	struct stat.
 */
}
long fsize(char *name)
{
/*  Return the size of the file <name> in bytes.  Note that this
	is a long value.  Return -1L if the file is not found.
 */
}
int isatty(int handle)
{
/*  Return non-zero if <handle> refers to a character device.
	Negative handles always refer to character devices.
 */
}
int creat(char *filename, int pmode)
{
/*  Create a new file with the given <filename>.  If a file with
	the name already exists, it will be truncated to zero bytes.
	Since the OS doesn't do this properly, the file is actually
	deleted and then re-created.  <pmode> specifies the attributes
	initially given to the file.  Valid <pmode> values are:
		0x00			normal, read/write
		S_ISRO			read only
		S_IFHID			hidden file
		S_IFSYS			system file
		S_ISVOL			volume label
	If S_ISVOL mode is specified, it must be the only mode given.
	Other modes may be combined with the | operator.  The <stat.h>
	file contains information useful with this function.
 */
}
int chmod(char *filename, int pmode)
{
/*  Change the mode attribute of <filename> to <pmode>.  Values for
	<pmode> are the same as for the creat() function.  Returns 0 for
	success, or a negative error code.
 */
}
int open(char *filename, int iomode[, pmode])
{
/*  Attempt to open <filename> with the given <iomode>.  A file handle
	is returned if the open succeeds.  A negative error code is returned
	for errors.  Valid <iomode> values are:
		O_RDONLY	read mode
		O_WRONLY	write mode
		O_RDWR		read/write mode
	In addition to the (mutually exclusive) modes above, one or more
	of the following options may be |-ed with <iomode>:
		O_APPEND	start file pointer at end of file
		O_TRUNC		if file exists, truncate to 0 length
		O_CREAT		creat() file if none exists (uses <pmode>)
		O_EXCL		return EEXIST if file exists and
				O_CREAT is specified (exclusive mode).
	Note: It is possible to open the character devices "con:", "aux:",
	and "prn:" with this call, and negative handles (-1..-3) will be
	returned.  Error returns are always < -3.  The <fcntl.h> file
	contains iomode constants.  The <stat.h> file contains pmode
	constants.
 */
}
int close(int h)
{
/*  Close file referenced by the file handle <h>.  Return 0 for
	success, or a negative error code.
 */
}
int dup(int handle)
{
/*  Return a second file handle which refers to the same file as
	the given <handle>. (cf: dup2)
 */
}
int dup2(int handle1, int handle2)
{
/*  Force <handle2> to refer to the same file as <handle1>.  Return
	0 for success, or a negative error code.  Both dup() and dup2()
	are direct calls to Fdup() and Fforce() GEMDOS calls.  Refer to
	your GEMDOS documentation for further information.
 */
}
int remove(char *filename)
{
/*  Delete <filename>, if it exists.  Return 0 for success, or a
	negative error code.
 */
}
int rename(char *oldname, *newname)
{
/*  Change the name of file <oldname> to <newname>.  You may use this
	function to move files from one directory (pathname) to another,
	but not from one drive to another.  Return 0 for success, or a
	negative error code.
 */
}
long lseek(int h, long offset, int origin)
{
/*  Move file pointer for file <h> to specified location.  <origin>
	specifies the starting point for the <offset> distance.  Valid
	<origin> values are:
		SEEK_SET	from beginning of file	(0)
		SEEK_CUR	from current location	(1)
		SEEK_END	from end of file	(2)
	The <offset> value is the distance in bytes from the origin.
	The final file position, or a negative error code, is returned.
 */
}
long tell(int h)
{
/*  Return the current file position for the file <h>.
 */
}
FILE *fopen(char *filename, char *mode)
{
/*  Open <filename> as a stream file.  This is the normal open way
	to open a file.  The <mode> is a string specifying the mode(s)
	that are relevent to the file open.  Valid <mode> characters are:
		r		read mode
		w		write mode
		a		append mode
		b		binary mode
		t		text (translated) mode
	At least one of "r", "w" or "a" must be specified.  "t" is assumed
	and indicates that <nl> is translated to <cr><lf> on output and
	vica-versa on input.  If the stream is a character device, the
	translation is slightly different.  The output translation is the
	same, but on input <cr> and <lf> both become <nl> in all cases.
	The "b", for binary mode, overides "t" and indicated that characters
	are not translated during i/o operations.  "a" represents append
	mode and means that the file pointer will initially be placed at
	the end of the file.  "w" mode will create a file if it doesn't
	exists, or zero an existing file.  If "r" is the only mode specified,
	the file must already exist.  A (FILE *) is returned if the open
	succeeds, or NULL if it fails.
 */
}
FILE *freopen(char *filename, char *mode, FILE *fp)
{
/*  Closes the file associated with <fp> and opens the new file as with
	fopen(), except that a new FILE structure is not created.  The
	existing FILE structure pointed to by <fp> is re-initialized with
	the new file information.  This is typically used to redirect i/o
	to standard streams stdin, stdout, stderr, stdprn, stdaux.  <fp>
	is returned for success, or NULL for failure.
 */
}
FILE *fdopen(int h, char *mode)
{
/*  Associates a stream with the already open file <h>.  The <mode>
	values are the same as for fopen(), but MUST be compatible with
	the mode in which <h> was open()ed.  This functions allows a file
	opened with the low level open()/creat() calls to be used as a
	buffered/translated stream.  A pointer to a FILE struct is returned,
	or NULL for errors.
 */
}
FILE *fopenp(char *filename, char *mode)
{
/*  Find <filename> somewhere on the PATH and open it with <mode>.
	Refer to the fopen() function for valid <mode> values.  If you
	want to use a search path other than the PATH environment
	variable, use the pfindfile() function to locate the file, and
	pass that filename to fopen().  (cf: pfindfile, fopen)
 */
}
int fclose(FILE *fp)
{
/*  Close the stream <fp>, flushing the buffer.  Returns 0 on success.
 */
}
void setbuf(FILE *fp, char *buf)
{
/*  If <buf> is NULL, make <fp> unbuffered; else <buf> points to a buffer
	of BUFSIZ characters to be used as the stream buffer for <fp>.
 */
}
void setvbuf(FILE *fp, char *buf, int bmode, int size)
{
/*  If <buf> is NULL or <bmode> is _IONBF, make <fp> unbuffered;
	otherwise <buf> points to a buffer of <size> characters to be
	used as the stream buffer for <fp>.  The <bmode> variable
	indicates the type of buffering desired, as follows:
		_IONBF		No buffering
		_IOFBF		Full buffering (normal)
		_IOLBF		Line buffering (not supported, same as _IOFBF)
 */
}
int fseek(FILE *fp, long offset, int origin)
{
/*  Operates like lseek(), except it works on streams.  Note that
	stream file positions may be misleading due to translation of
	<nl> characters during i/o.  ftell() may be used reliably with
	fseek() to reposition a file to a prior location.  WARNING:
	fseek() returns 0 for success, non-zero for failure, according
	to the ANSI standard.  Some implementations use 0 for failure.
	This function is maintained for compatibility with old programs.
	fsetpos() should be used in new code.  (cf: fsetpos)
 */
}
void rewind(FILE *fp)
{
/*  Operates like fseek(fp, 0L, SEEK_SET), except it also clears the
	end-of-file and error flags for <fp>.  There is no return value.
 */
}
long ftell(FILE *fp)
{
/*  Operates like tell(), except it works on streams.  Note that
	stream file positions may be misleading due to translation of
	<nl> characters during i/o.  This function is maintained for
	compatibility with old programs.  fsetpos() should be used in
	new code.  (cf: fsetpos)
 */
}
int fgetpos(FILE *fp, fpos_t *pos)
{
/*  Get the position of the stream <fp> and store it at the location
	pointed to be <pos>.  This is the new X3J11 function to replace
	ftell().  Returns 0 for success and ERROR for failure.
 */
}
int fsetpos(FILE *fp, fpos_t *pos)
{
/*  Set the position of the stream <fp> to the valued stored at the
	location pointed to be <pos>.  Note that this function is only
	required to work properly for a <pos> value which was previously
	obtained by fgetpos() on the s!me stream.  This is the new X3J11
	function to replace fseek().  Returns 0 for success and ERROR for
	failure.
 */
}
int fileno(FILE *fp)
{
/*  Return the file handle associated with the stream <fp>.
 */
}
int feof(FILE *fp)
{
/*  Return non-zero if <fp>	is at end of file.
 */
}
int ferror(FILE *fp)
{
/*  Return non-zero if and error has occurred on <fp>.
 */
}
void clearerr(FILE *fp)
{
/*  Clear the error flag on <fp>.
 */
}
sync()
{
/*  Provided for compatibility.  #define'ed as a comment.
 */
}


 Other functions in files 2 and 3
 
 

