PD HELP FILE FOR CBREEZE                               ESC and LINEA
based on A Hitchhiker's Guide to the BIOS 

LINE A ROUTINES

$A000  Initialisation    $A005  Filled Rectangle  
$A001  Put Pixel         $A006  Filled Polygon    
$A002  Get Pixel         $A00F  Seed Fill         
$A003  Line              $A009  Show Mouse        
$A004  Horizontal Line   $A00A  Hide Mouse        
$A007  BitBlt            $A00B  Transform Mouse   
$A00E  Copy Raster       $A00C  Undraw Sprite     
$A008  TextBlt           $A00D  Draw Sprite       

ESC ( \033 ) CODES         word search valid here

\033A    Cursor Up ( without scroll )    \033B    Cursor Down 
\033C    Cursor Forward                  \033D    Cursor Backward 
\033E    Clear Screen (and Home Cursor)  \033H    Home Cursor 
\033e    Enable Cursor                   \033f    Disable Cursor
\033j    Save Cursor Position            \033k    Restore Cursor Position
\033Y    Position Cursor                 \033I    Cursor Up ( with scroll )
\033b    Set Foreground Color            \033c    Set Background Color 
\033p    Enter Reverse Video Mode        \033q    Exit Reverse Video Mode
\033v    Wrap at End of Line             \033w    Discard at End of Line
\033L    Insert Line                     \033M    Delete Line
\033l    Erase Entire Line               \033o    Erase Beginning of Line
\033J    Erase to End of Page            \033K    Clear to End of Line
\033d    Erase


CONOUT Escape Sequences  

These are the escape functions interpreted by the BIOS Bconout() function.
For the most part they emulate a VT-52 terminal [ that's the easy one
to do ]. There are extensions to hack screen colors, control screen wrap,
and a few other simple functions. Also responds to backspace, tab,
linefeed, carriage return.

       
\033A 
Cursor Up 
     This  sequence  moves the cursor up  one   line.    If   the 
     cursor   is   already on the top line of  the  screen,  this 
     sequence has no effect.
       
\033B 
Cursor Down 
     This  moves  the cursor down one line.   If the  cursor   is 
     already   on   the  last  line of the  screen,  this  escape 
     sequence has no effect.
       
\033C 
Cursor Forward 
     This moves the cursor one position to  the  right.   If this  
     function   would   move  the cursor  off  the  screen,  this 
     sequence has no effect.
       
\033D 
Cursor Backward 
     This  move the cursor one position to the left.   This is  a  
     non-   destructive  move  because  the character over  which 
     the cursor now rests is not replaced by a  blank.
     If   the   cursor  is  already  in  column  O,  this  escape 
     sequence has no effect.
       
\033E 
Clear Screen (and Home Cursor) 
     This  moves  the cursor to  column  O,   row  I   (the   top 
     left-hand corner of the screen), and clears all charac- ters 
     from the screen.
       
\033H 
Home Cursor 
     This move the cursor to column O,  row O.  The screen is NOT 
     cleared.
       
\033I 
Cursor Up
     If the cursor is on the top line, a scroll down is performed.
       
\033J 
Erase to End of Page 
     Erases  all the information from cursor  (including   cursor 
     position) to the end of the page.
       
\033K 
Clear to End of Line 
     This  sequence  clears the line from  the   current   cursor 
     position to the end of the line.
       
\033L 
Insert Line 
     Inserts  a new blank line by moving the line that cursor  is  
     on,   end all following lines,  down one  line.   Then,  the 
     cursor is moved to the beginning of the  new  blank line.
       
\033M 
Delete Line 
     Deletes  the  contents of the line that the  cursor  is  on, 
     places  the  cursor at the beginning of the line,  moves all 
     the following lines up one line,  and adds  a  blank line at 
     the bottom.
       
\033 Y 
Position Cursor
     The two characters that follow the "Y" specify the  row  and  
     column   to  which  the cursor is to be  moved.   The  first 
     character specifies the row, the second specifies the colum.  
     Rows and columns number from 1 ( 0 ? ) up.    
       
\033b 
Set Foreground Color 
     The Foreground Color is the color in which the  character is 
     displayed.
       
     Escape-b must be followed by a color selection  charac- ter.  
     Only the four least significant bits of the color  character 
     are used:
       
     Bit Pattern of Control Byte:
       
                  7     6     5     4     3     2     1     0 
               +-----+-----+-----+-----+-----+-----+-----+-----+ 
               |     |     |     |     |                       | 
               |  X  |  X  |  X  |  X  |    color index        | 
               |     |     |     |     |                       | 
               +-----+-----+-----+-----+-----+-----+-----+-----+ 
               (X = "don't care") 
       
\033c 
Set Background Color 
     This function selects Background Color,   the  color  of the 
     cell that contains the characters.
       
     Escape-c must be followed by a color selection  charac- ter.  
     Only the four least significant bits of the color  character 
     are  used.   (See diagram for ESC-b function)  

\033 d  
Erase 
     Beginning of Display This sequence erases from beginning  of 
     the  display  to the  cursor  position.    The  cursor posi
     tion is erased also.
       
\033e 
Enable Cursor 
     This  sequence  causes the cursor to  be   invisible.    The 
     cursor   may   still be moved about on  the  display,  using 
     escape sequence defined in this appendix.
       
\033f 
Disable Cursor 
     This  sequence  causes the cursor to  be   invisible.    The 
     cursor   may   still be moved about on  the  display,  using 
     escape sequences defined in this appendix.
       
\033j 
Save Cursor Position 
     This sequence preserves the  current  cursor  position.  You  
     can  restore  the  cursor  to the previously saved  position 
     with ESC-k.
       
\033k 
Restore Cursor Position 
     This  sequence  restores the cursor to  a  previously  saved 
     position.   If  you  use this sequence without  having  pre- 
     viously  saved  the cursor position,  then the   cursor   is 
     moved to the home position,  the top left-hand corner of the 
     screen.
       
\033l 
Erase Entire Line 
     This sequence erases an entire line and moves the  cursor to 
     the leftmost column.
       
\033o 
Erase Beginning of Line 
     Erases  from  the beginning of the line to  the  cursor  and 
     includes the cursor position.
       
\033p 
Enter Reverse Video Mode 
     Enters  the  reverse video mode so   that   characters   are 
     displayed   as   background  color  characters  on  a  fore- 
     ground colored cell.
       
\033q 
Exit Reverse Video Mode 
     Exits the reverse video mode.
       
\033v 
Wrap at End of Line 
     This  sequence  causes the first character  past  the   last 
     displayable   position   on  a  line   to  be  automatically 
     placed  in  the first  character  position   on   the   next 
     line.  The page scrolls up if necessary.
       
\033w 
Discard at End of Line 
     Following  invocation  of this sequence,  after   the   last 
     displayable   character   on a line has  been  reached,  the 
     characters overprint.   Therefore, only the last charac- ter 
     received is displayed in the last column position.
       



