PD HELP FILE FOR CBREEZE                               GEMDOS
based on ATARI GEMDOS REFERENCE MANUAL  version  April 4, 1986 

Intended for use with the mouse     ALT & CLICK        Function search
orientated search commands shown    CONTROL & CLICK    Word search
to the right.                       ALT & >            Go to next occurance
                                    CNT & SHFT & CLK   Find previous

Suggest return to menu by macro  - (,),/ - of  CNTRL ALT UP, SHIFT DOWNS
Items in /* comment marks */ available by word search only


GEMDOS  all require #include <osbind.h>

Pterm0,     Cconin,     Cconout,     Cauxin,     Cauxout,    Cprnout,
Crawio,     Crawcin,    Cnecin,      Cconws,     Cconrs,     Cconis,
Dsetdrv,    Cconos,     Cprnos,      Cauxis,     Cauxos,     Dgetdrv,
Fsetdta,    Super,      Tgetdate,    Tsetdate,   Tgettime,   Tsettime,
Fgetdta,    Sversion,   Ptermres,    Dfree,      Dcreate,    Ddelete,
Dsetpath,   Fcreate,    Fopen,       Fclose,     Fread,      Fwrite,
Fdelete,    Fseek,      Fattrib,     Fdup,       Fforce,     Dgetpath,
Malloc,     Mfree,      Mshrink,     Pexec,      Pterm,      Fsfirst,
Fsnext,     Frename,    Fdatime,



void Pterm0() 
{
/*

0x00 Pterm0 - Terminate Process



Terminate   this  process,   closing  all  files  it  opened 
and  releasing any memory it allocated.   Return an exit code of 
0x0000 to the parent process.
 */
}

LONG Cconin() 
{
/*

0x01 Cconin - Read character from Standard Input

Read character from the standard input - handle 0 -.    If the 
standard  input device is the console,  the longword returned 
in D0 contains both the ASCII and the  console  scancode:
          ___________________________________________________ 
         |  31..24       23..16       15..8        7..0     | 
         |  0x00 or  |   scancode |     0x00   |    ASCII   | 
         | shift bits|   or 0x00  |            |     char   | 
         |___________|____________|____________|____________| 

The  function keys - F1 through  F10,   HELP,   UNDO,   etc.- 
return   the   ASCII  code  0x00,   with   appropriate   scancode 
values;  see  the  GEM/VDI manual for keyboard  scancode  assign- 
ments.    The   ST   BIOS  is  capable  of placing  the  keyboard 
shift-key  status  in bits 24..31;  see the   BIOS   Programmer's 
Guide for further details.

BUGS 
Does not return any indication of end of file.
Control-C is not recognized.
There is no way to tell if standard  input  is  a  character 
device or a file.
There should be some way to type all possible 256 codes from 
the keyboard.
 */
}

void Cconout(c) 
WORD c;
{
/*

0x02 Cconout - Write Character to Standard Output

Write the character  c' to the standard output  -handle  0-. 
The   high   eight  bits of  c' are reserved and  must  be  zero. 
Tabs are not expanded.  
*/
}


WORD Cauxin()
{
/*

0x03 Cauxin - Read Character from Standard AUX:

Read  character  from handle 1, normally  the  serial  port, AUX:

BUGS 
This function causes RS232 flow-control  to  fail;  applica- 
tions  should  use  the BIOS character device calls to avoid 
losing received characters.
*/
}


void Cauxout(c) 
WORD c;
{
/*

0x04 Cauxout - Write Character to Standard AUX:

Write   c'  to standard  handle  1   -normally   AUX:,   the 
serial  port-.   The high eight bits of  c' are reserved and must 
be zero.  Tabs are not expanded.

BUGS 

This  function  causes RS232 flow-control  to  fail;
applications  should use the BIOS character device calls to avoid 
losing transmitted characters.
*/
}


void Cprnout(c) 
WORD c;
{
/*

0x05 Cprnout - Write Character to Standard PRN:

Write   c'  to  handle  2  - normally   PRN:,   the   printer port -
The  high  eight bits of  c' are reserved and  must  be zero.
Tabs are not expanded    
*/
}

 
LONG  Crawio(w) 
WORD w;
{
/*

0x06 Crawio  - Raw I/O to Standard Input/Output

If  w' is not 0x00FF,  write it to the standard  output.Tabs 
are  not  expanded  Otherwise,  if   w'  equals  0x00ff,  read  a 
character  from the  standard  input.   0x0000 is returned if  no 
character is available.

BUGS 
Because of the way this function is defined,   0xff'  cannot 
be written to the standard output with this function. Cannot 
distinguish between 0x00 and the end of the file.
*/
}


LONG Crawcin()
{
/*

0x07 Crawcin - Raw Input from Standard Input

Read a character from the standard  input  - handle   0 -.  If 
the input device is CON: no control character processing is done 
and the character is not echoed.

BUGS 
No end of file indication.
 */
}


LONG Cnecin()
{
/*

0x08 Cnecin - Read Character from Standard Input, No Echo

Read  character  from the standard input.   If   the   input 
device is CON:, no echoing is done, although control characters 
are interpreted.
 */
}


void Cconws(str)
char *str;
{
/*

0x09 Cconws - Write String to Standard Output

Write a null-terminated string,  starting at   str',  to the 
standard output.
 */
}
  
  
  
void Cconrs(buf) 
char *buf;
{
/*

0x0A Cconrs - Read Edited String from Standard Input

Read string from the standard  input,  handling  common line 
editing characters.  The editing characters are:
                 ______________________________________ 
                |  Char          Function             | 
                | <return>, ^J   End the line         | 
                |    ^H, <rub>   Kill last character  | 
                |       ^U, ^X   Kill entire line     | 
                |           ^R   Retype line          | 
                |           ^C   Terminate the process| 
                |_____________________________________| 
  
The first character of  buf' indicates the size of  the data 
part  of  the  buffer.    On return,  the second byte of buf' is 
set  to  the  number of characters  read,  and  locations  buf+2' 
through 'buf+2+buf[1]' contain the characters.  The string is not 
guaranteed to be null-terminated.
  
BUGS 
Hangs on end-of-file.
 */
}


WORD Cconis()
{
/*

0x0B Cconis - Check Status of Standard Input 

Return  0xFFFF if a character is available on the   standard 
input, 0x0000 otherwise.
 */
}
  
  
  
LONG Dsetdrv(drv) 
WORD drv;
{
/*

0x0E Dsetdrv - Set Default Drive

Set the default drive to the  zero-based  drive  number drv' 
- ranging from 0 to 15,  A:  to P: -.  Return a bit-string of known 
drives - bit 0 = A,  bit 1 = B,  etc. -  A "known drive" is one  on 
which a  directory  has  been used.

BUGS 
GEMDOS only supports 16 drives  - bits  0  through  15 -.
Future systems will support 32 drives.

 */
}


WORD Cconos()
{
/*

0x10 Cconos - Check Status of Standard Output

Return  0xFFFF  if the console  is  ready   to   receive   a 
character.  Return 0x0000 if the console is NOT ready.

BUGS 
CON: and files are always ready, so why check?
 */
}


WORD Cprnos()
{
/*

0x11 Cprnos - Check Status of Standard PRN:

Return  0xFFFF  if PRN:  is ready to receive  a   character, 
0x0000 if it isn't.
 */
}

WORD Cauxis()
{
/*

0x12 Cauxis - Check Status of Standard AUX: Input

Return 0xFFFF if a character is available on AUX:  - handle 1 -,
0x0000 if not.
 */
}
  
  
  
WORD Cauxos()
{
/*

0x13 Cauxos - Check Status of Standard AUX: Output

Return  0xFFFF  if AUX:  -s tandard handle 1 - is   ready   to 
accept a character, 0x0000 if not.
 */
}


WORD Dgetdrv()
{
/*

0x19 Dgetdrv - Get Default Drive

Return the current drive number, 0 through 15.
 */
}


void Fsetdta(addr) 
char *addr;
{
/*

0x1A Fsetdta - Set DTA - Disk Transfer Address -

Set  the  DTA to  addr'.  The DTA is used  only   by   the 
functions Fsfirst() and Fsnext().   
 */
}


LONG Super(stack) 
WORD *stack;
{
/*

0x20  Super - Get/Set/Inquire Supervisor Mode

If   stack'  is -1L - 0xFFFFFFFF -  return   0x0000   if   the 
processor   is  in user mode,  or 0x0001 if the processor  is  in 
supervisor mode.

Otherwise, if the processor is  in  user  mode,  return with 
the processor switched to supervisor mode.   If  stack' is  NULL 
- 0x00000000 -  then  the supervisor stack will  be  the  same   as 
the  user  stack before the call.   Otherwise the  supervisor 
stack will be set to  stack'.

If  the  processor is in supervisor mode,  return  with  the 
processor  switched  back to user mode.    stack' should  be  the 
value of the supervisor stack that was returned by the first call 
to the function.

NOTE 
The  original supervisor stack value  MUST  be restored 
before the process terminates.  Failure to do so will result 
in a system crash.
 */
}


WORD Tgetdate()
{
/*

0x2A Tgetdate - Get Date

Return the current date, in DOS format:

RETURNS
Bits:
0..4 contain the day, ranging 1..31.
5..8 contain the month ranging 1..12.
9..15 contain the year -since 1980- ranging 0..119.
 */
}
  
WORD Tsetdate(date) 
WORD date;
{
/*

0x2B Tsetdate - Set Date

Set  the  current date to  date',  which is in  the   format 
described in Tgetdate().

RETURNS 
0 on valid date;
ERROR on an obviously screwed-up date.

BUGS 
GEMDOS is not picky about date parameters;
for instance, it likes Feb 31st ....
GEMDOS does NOT let the BIOS know  that  the  date  has been 
changed.
 */
}


WORD Tgettime()
{
/*

0x2C Tgettime - Get Time
  
Return the current time in DOS format:
  
RETURNS 
Bits 0..4 contain the second divided by 2, 0..29.
Bits 5..10 contain the minute, 0..59.
Bits 11..15 contain the hour, 0..23.
 */
}


WORD Tsettime(time) 
WORD time;
{
/*

0x2D Tsettime - Set Time

Set  the  current time to  time',  which is in  the   format 
described in Tgettime().
  
RETURNS 
0 if GEMDOS liked the time;
ERROR if it didn't.

BUGS 
GEMDOS does NOT let the BIOS know  that  the  time  has been 
changed.
 */
}


LONG Fgetdta()
{
/*
________________________________________________ 
|0x2F Fgetdta - Get DTA -Disk Transfer Address-| 
 
  
     Returns the value of the current DTA,  a pointer used by the 
functions Fsfirst() and Fsnext().

 */
}
  
  
WORD Sversion()
{
/*
____________________________________ 
|0x30 Sversion - Get Version Number| 
 
  
     Return  GEMDOS's  version number  -in   byte-reversed   for- 
mat-.    The high byte contains the minor version number, the low 
byte contains the major version number.
  
NOTE 
     The 5/29/85 -first disk-based- and the 11/20/85  -first ROM-
based- release of GEMDOS had the version number 0x1300.
  
     GEMDOS version numbers and TOS versions numbers are not  one 
and  the  same.    See the ST BIOS REFERENCE MANUAL for about TOS 
version numbers.

 */
}
  
   
void Ptermres(keepcnt, retcode) 
     LONG keepcnt;
     WORD retcode;
{
/*
_____________________________________________ 
|0x31 Ptermres - Terminate and Stay Resident| 
 
  
     Terminate  the  current process,  keeping some  of   it   in 
memory.     keepcnt' is the amount of the memory belonging to the 
process  to keep,  including and starting at the  256-byte  base
page.   retcode' is the exit code that is returned to the  parent 
process.
  
     Memory the process has allocated -in  addition  to  the TPA- 
will NOT be released. Ptermres() will never return.
  
  
BUGS 
      Open files are closed as part of termination.

 */
}
  
  
void Dfree(buf, driveno) 
     LONG *buf;
     WORD driveno;
{
/*
___________________________________ 
|0x36 Dfree - Get Drive Free Space| 
  
  
     Get   disk   allocation  information   about    the    drive 
driveno'  and  store  it  into  four  longwords starting at buf':
                          ___________________________ 
                  buf + 0|     # of free clusters    | 
                         |___________________________| 
                  buf + 4|     total # of clusters   | 
                         |___________________________| 
                  buf + 8|   sector size -in bytes-  | 
                         |___________________________| 
                 buf + 12|  cluster size -in sectors-| 
                         |___________________________| 
  
BUGS 
      Incredibly slow -5-10 seconds- on a hard disk.

 */
}
  
  
WORD Dcreate(pathname) 
      char *pathname;
{
/*
_________________________________
|0x39 Dcreate - Create Directory| 

  
           Create a  directory.    pathname'  points  to  a  null- 
      terminated  string specifying the pathname of the new direc- 
      tory.
  
      RETURNS 
           0 on success;
           ERROR or appropriate error number on failure.

 */
}
  
  
  
      WORD Ddelete(pathname) 
      char *pathname;
{
/*
 _________________________________ 
 |0x3A Ddelete - Delete Directory| 
 _ | |________________________________ | | 
  
     Delete  a  directory -it must be empty,   except   for   the 
special   directories   "." and ".."-.    pathname' points  to  a 
null-terminated string specifying the pathname of the direc- tory 
to remove.
  
RETURNS 
     0 on success;
     ERROR or appropriate error number on failure.

 */
}
  
  
  
WORD Dsetpath(path) 
     char *path;
{
/*
_______________________________________ 
|0x3B Dsetpath - Set Current Directory| 

  
     Set the current to  path',   a  null-terminated  string.  If 
 the path begins with a drive letter and a colon, set the current 
directory on the specified drive. A current directory is kept for 
each drive in the  sys- tem.
  
RETURNS 
           0 for success;
           ERROR or an appropriate error number.

 */
}
  
 
WORD Fcreate(fname, attribs) 
      char *fname;
      WORD attribs;
{
/*
____________________________ 
|0x3C Fcreate - Create File| 

  
     Create  a  file  fname'  and  return   a   write-only   non- 
standard   handle  to it.   The attribute word is stored  in  the 
directory entry; its bit assignments are:
              ___________________________________________ 
             | mask               description           | 
             | 0x01|  file set to read-only             | 
             | 0x02|  file hidden from directory search | 
             | 0x04|  file set to "system"              | 
             | 0x08|  file contains 11-byte volume label| 
             |_____|____________________________________| 
  
RETURNS 
     a positive number,  a handle,  or:  ERROR or an  appropriate 
error number.
  
BUGS 

     Useless feature department: If the  read-only'  bit  is set, 
      a  write-only handle is returned,  and the handle can't  be 
     written to.
  
     Ideally,  only  one  volume  label  is  permitted   in   the 
     volume's  root  directory.   GEMDOS  doesn't  enforce  this, 
     though, which could cause confusion.

 */
}
  
    
WORD Fopen(fname, mode) 
      char *fname;
      WORD mode;
{
/*
 ________________________ 
 |0x3D Fopen - Open File| 
 
  
     Open the  fname' according  to   mode',  and  return  a non-
standard handle to it.  The open mode can be:
                         ______________________ 
                        |mode | description   | 
                        |    0|  read only    | 
                        |    1|  write only   | 
                        |    2|  read or write| 
                        |_____|_______________| 
  
RETURNS 
           a positive number, a handle, or:
           a negative error number.

 */
}
  
WORD Fclose(handle) 
      WORD handle;
{
/*
__________________________ 
|0x3E Fclose - Close File| 

  
     Close the file associated with the handle.
  
RETURNS 
           0 on success;
           ERROR or an appropriate error number.
 */
}


 
      LONG Fread(handle, count, buffer) 
      WORD handle;
      LONG count;
      char *buffer;
{
/*
 ________________________________ 
 |0x3F Fread - Read From File   | 
 
  
     Read from a file.  From the file referred to  by   han- dle' 
read  count' bytes into memory starting at  buffer'.
  
RETURNS 
           the number of bytes actually read, or:
           0 on end of file, or:
           a negative error number.

 */
}
  
  
LONG Fwrite(handle, count, buffer) 
      WORD handle;
      LONG count;
      char *buffer;
{
/*
 _____________________________ 
 |0x40 Fwrite - Write To File| 
  
  
     Write  to  a file.    Write   count'  bytes   from   memory, 
starting at  buffer', to the file referred to by  handle'.
  
RETURNS 
           the number of bytes actually written, or:
           a negative error number.

 */
}
  
WORD Fdelete(fname) 
      char *fname;
{
/*
____________________________ 
|0x41 Fdelete - Delete File| 
 
  
           Delete the file  fname'.
  
RETURNS 
           0, success, or:
           a negative error number.

 */
}
  
  

LONG Fseek(offset, handle, seekmode) 
      LONG offset;
      WORD handle;
      WORD seekmode;
{
/*
________________________________ 
|0x42 Fseek - Seek File Pointer| 

  
     Set the current position  within  the  file  associated with 
 handle'.    offset'  is a signed number;  positive  values  move 
toward  the end of the file,  and  negative  values  move  toward 
its beginning.   seekmode' can be:
               _________________________________________ 
              |seekmode |  moves  offset'bytes...      | 
              |    0    |  from beginning of file      | 
              |    1    |  relative to current position| 
              |    2    |  from end of file            | 
              |_________|______________________________| 
  
RETURNS 
           The current, absolute position in the file.

 */
}
  
  
WORD Fattrib(fname, wflag, attribs) 
      char *fname;
      WORD wflag;
      WORD attribs;
{
/*
________________________________________ 
|0x43 Fattrib - Get/Set File Attributes| 
 
  
     Get  or set a file's attribute bits.    fname' points  to  a 
null-terminated  pathname.   If   wflag' is  1,  set  the  file's 
attributes from  attribs' -no return value-.   If  wflag'  is  0, 
return the file's attributes.
  
           The attribute bits are:
             _____________________________________________ 
            | mask   description                         | 
            | 0x01|  file is read-only                   | 
            | 0x02|  file hidden from directory search   | 
            | 0x04|  file set to "system"                | 
            | 0x08|  file contains 11-byte volume label  | 
            | 0x10|  file is a subdirectory              | 
            | 0x20|  file has been written to and closed.| 
            |_____|______________________________________| 
  
BUGS 
     The "archive" bit, 0x20, doesn't seem to work as advertised.

 */
}
  
 
WORD Fdup(handle) 
      WORD handle;
{
/*
___________________________________ 
|0x45 Fdup - Duplicate File Handle| 

  
     The  handle   handle' must be a  standard   handle   -0..5-; 
Fdup()   returns a non-standard handle -greater than or equal  to 
6- that refers to the same file.
  
RETURNS 
           a handle, or:
           EIHNDL - not a standard handle 
           ENHNDL - no more standard handles available 

 */
}
  
  
Fforce(stdh, nonstdh) 
      WORD stdh;
      WORD nonstdh;
{
/*
_________________________________ 
|0x46 Fforce - Force File Handle| 
 
  
     Force the standard handle  stdh' to point to  the  same file 
or device as the non-standard handle  nonstdh.'  

RETURNS   OK, or:
           EIHNDL - invalid handle 

 */
}
  
  
  
void Dgetpath(buf, driveno) 
      char *buf;
      WORD driveno;
{
/*
_______________________________________ 
|0x47 Dgetpath - Get Current Directory| 
 
  
     The  current directory for the specified drive  driveno'  is 
copied into  buf'.   The drive number is 1-based:  0 speci-  fies 
the default drive, 1 specifies A:, and so on.
  
BUGS 
     The  maximum  size of a pathname is not   limited   by   the 
     system; it is up to the application to provide enough buffer 
     space.  128 bytes should be enough for 8 or 9 levels of sub- 
     directories.

 */
}
  
LONG Malloc(amount) 
      LONG amount;
{
/*
_______________________________ 
|0x48 Malloc - Allocate Memory| 
 
  
     If   amount'  is -1L ($FFFFFFFF) return the  size   of   the 
largest free block in the system.
  
     Otherwise,  if   amount' is not -1L,  attempt  to   allocate 
amount' bytes for the current process.   Return a pointer to  the 
beginning  of the block or NULL if there is no free  block  large 
enough to meet the request.
  
BUGS           WARNING 
           
     A  process may not have,   at  any  time,   more   than   20 
     blocks of Malloc()'d memory.  Exceeding this limit may crip- 
     ple GEMDOS.  [It is OK to do many Malloc() calls if they are 
     followed  by  matching  Mfree() calls; the limit of 20 is to 
     the   number   of  fragments  a   process   may   generate.]    

 */
}
     
 WORD Mfree(saddr) 
     LONG saddr;
{
/*
_____________________________ 
|0x49 Mfree - Release  Memory| 
     
  
     Free the block of memory starting at  saddr'; the block must 
be one that was returned by Malloc().
  
RETURNS 
           0 if the release was successful, or:
           ERROR or an appropriate error number.

 */
}
  
  

WORD Mshrink(0, block, newsiz) 
      WORD 0;
      LONG block;
      LONG newsiz;
{
/*
_______________________________________________ 
|0x4A Mshrink - Shrink Size of Allocated Block| 
  

     Shrink  the   size  of  an  allocated   block   of   memory; 
block'   points   to   a 0rocess basepage or a  piece  of  memory 
allocated  by  Malloc(),   newsiz'  is  the  new  size   of   the 
block. The first argument must be a WORD of zero.
  
 RETURNS 
           0 if the size adjustment was successful, or:
           EIMBA - invalid memory block address 
           EGSBF - setblock failure due to growth restrictions 
  
BUGS 
     A block can only be shrunk;   newsiz' must be less  than  or 
     equal to the current block size.

 */
}
  
  
WORD Pexec(mode, ptr1, ptr2, ptr3) 
      WORD mode;
      char *ptr1;
      char *ptr2;
      char *ptr3;
{
/*
 ___________________________________ 
 |0x4B Pexec - Load/Execute Process| 
 
  
     This  function  wears several hats,  according to  the  flag 
mode':
          ____________________________________________________ 
         |                |                                  | 
         |    mode        | ptr1         ptr2      ptr3      | 
         |   0 = load & go|    file  |  command |  enviroment| 
         |                |  to exec |    tail  |    string  | 
         |________________|__________|__________|____________| 
         | 3 = load, no go|    file  |  command |  enviroment| 
         |                |  to load |    tail  |    string  | 
         |________________|__________|__________|____________| 
         |     4 = just go|  -unused-|  -unused-|   basepage | 
         |                |          |          |   address  | 
         |________________|__________|__________|____________| 
         |      5 = create|  -unused-|  command |  enviroment| 
         |        basepage|          |    tail  |    string  | 
         |________________|__________|__________|_____________| 
  
     The  file to load or exec,   ptr1',  and the  command  tail, 
ptr2',     are   null-terminated   pathnames.    The   enviroment 
string,   ptr3',  is  either NULL  -0L-,   or  a  pointer  to   a 
string structure of the form:
  
                              "string1\0" 
                              "string2\0" 
                              ... etc. ...
                              "stringN\0" 
                                 "\0" 
  
     The  enviroment  string is any  number  of   null-terminated 
strings,   with  an  empty string -a single null- at the end.  If 
 ptr3'  is  NULL,  then  the process inherits  a  copy   of   the 
parent's enviroment string.
  
     Load-and-go -mode 0- will load the specified file,  set-  up 
 its  basepage,  and  execute it.  Pexec()'s return value will be 
the child process's  exit  code  -see  Pterm0()  and Pterm()-.
  
     Load-nogo  will   load  the  specified   file,   setup   its 
basepage,   and return a pointer to the basepage;  the process is 
not executed.
  
     Just-go  is  passed a pointer to a  basepage.   The  process 
starts  executing at the base of its text segment, as speci- fied 
in the basepage.
  
     Create-basepage  will  allocate the largest  free  block  of 
memory and create most of a basepage for it.  (Some entries, most 
significantly the text/data/bss size and  base  values,  are  NOT 
 setup -- the caller is responsible for maintaining them-.
  
     A  child  process inherits  the   parent's   standard   file 
descriptors;  effectively  doing  an  Fdup() and an Fforce() call 
on handles 0 through 5.
  
     Since  system  resources are allocated when  a  basepage  is 
created,   the  spawned  process MUST be terminated in  order  to 
release  them.   This  is especially important when  using  over- 
lays;   see   the   [Pexec cookbook] for details on use  of  Pex- 
ec().

 */
}
  

void Pterm(retcode) 
      WORD retcode;
{
/*
________________________________ 
|0x4C Pterm - Terminate Process| 
 
  
     Terminate the current process,  closing all  open  files and 
releasing any allocated memory.   Return  retcode' to the  parent 
process.

 */
}
  

WORD Fsfirst(fspec, attribs) 
      char *fspec;
      WORD attribs;
{
/*
_____________________________ 
|0x4E Fsfirst - Search First| 
 
  
     Search for the first occurrence of  the  file   fspec'.  The 
 file   specification may contain wildcards - ?' and  *'- in  the 
simple filename,  but not in the  path   specification.   attrib' 
 controls   which files are returned by Fsfirst;  its  format  is 
described in the documentation on   Fattrib()'.
  
     If    attrib'   is  zero,   then  only  normal   files   are 
searched for -no volume labels,  hidden files,  subdirectories or 
system files are returned-.  If  attrib' is set for  hid- den  or 
 system  files,  they are included in the search set. If  attrib' 
is set for volume labels, only volume labels are returned.
  
     When a file is found,  a 44-byte structure is written to the 
location pointed to by the DTA:
              ___________________________________________ 
             | offset     size           contents       | 
             |__________________________________________| 
             |   0-20|          |  -reserved-           | 
             |     21|  byte    |  file attribute bits  | 
             |     22|  word    |  time stamp           | 
             |     24|  word    |  date stamp           | 
             |     26|  long    |  file size            | 
             |     30|  14 bytes|  file name + extension| 
             |_______|__________|_______________________| 
 
           The filename and extension is null-terminated, and con- 
      tains no spaces.
  
RETURNS 
           0, if a file was found, or:
           EFILNF - file not found -no matches-, or:
           an appropriate error number.

 */
}
  
   
WORD Fsnext()
{
/*
___________________________ 
|0x4F Fsnext - Search Next| 

  
     Search  for  the next occurrence of a  file.    -The   first 
occurrence  should  be  searched for with Fsfirst()-.  Bytes 0-20 
of  the DTA must remain unmodified  from  the  Fsfirst() call  or 
the most recent Fsnext() call.
  
RETURNS 
           0 if a file was found, or:
           ENMFIL - no more files were found, or:
           an appropriate error number.

 */
}
  
WORD Frename(0, oldname, newname) 
      WORD 0;
      char *oldname;
      char *newname;
{
/*
 ____________________________ 
|0x56 Frename - Rename File| 
 
  
     Rename  a  file from  oldname' to   newname'.   The   desti- 
nation   file  must not exist.   The new file may be  in  another 
directory. The first argument must be a zero WORD.
  
RETURNS 
           EACCDN - destination file already exists;
           EPTHNF -  oldname' not found;
           ENSAME -  newname' not on save drive;
           or an appropriate error.

 */
}
  
 
void Fdatime(timeptr, handle, wflag) 
      LONG timeptr;
      WORD handle;
      WORD wflag;
{
/*
_______________________________________ 
|0x57 Fdatime - Get/Set File Timestamp|  
      
  
     The file is referred to by  handle'.    timeptr'  points  to 
 two   words  containing  the DOS formatted timestamp  -the  time 
word is first,  the date word is second-.   If  wflag' is 1,  set 
 the file's timestamp from  timeptr',  otherwise read the  file's 
timestamp into  timeptr'.

 */
}

